/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.editor.graph.plot;

import info.novatec.inspectit.cmr.model.JmxDefinitionDataIdent;
import info.novatec.inspectit.cmr.service.ICachedDataService;
import info.novatec.inspectit.cmr.service.IGlobalDataAccessService;
import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.communication.data.JmxSensorValueData;
import info.novatec.inspectit.indexing.aggregation.IAggregator;
import info.novatec.inspectit.indexing.aggregation.impl.JmxSensorValueDataAggregator;
import info.novatec.inspectit.rcp.editor.graph.plot.AbstractPlotController;
import info.novatec.inspectit.rcp.editor.graph.plot.YIntervalSeriesImproved;
import info.novatec.inspectit.rcp.editor.graph.plot.datasolver.AbstractPlotDataSolver;
import info.novatec.inspectit.rcp.editor.graph.plot.datasolver.PlotDataSolver;
import info.novatec.inspectit.rcp.editor.graph.plot.datasolver.impl.PlotDataSolverFactory;
import info.novatec.inspectit.rcp.editor.inputdefinition.InputDefinition;
import info.novatec.inspectit.rcp.editor.preferences.PreferenceEventCallback;
import info.novatec.inspectit.rcp.editor.preferences.PreferenceId;
import info.novatec.inspectit.rcp.preferences.PreferencesUtils;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.eclipse.swt.widgets.Display;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.DeviationRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.YIntervalSeries;
import org.jfree.data.xy.YIntervalSeriesCollection;
import org.jfree.ui.RectangleInsets;

public class JmxPlotController
extends AbstractPlotController {
    private YIntervalSeriesImproved jmxChart;
    private JmxSensorValueData template;
    private Date loadedFromDate = new Date(Long.MAX_VALUE);
    private Date loadedToDate = new Date(0L);
    private Date plottedFrom;
    private Date plottedTo;
    private List<JmxSensorValueData> loadedData;
    private ICachedDataService cachedDataService;
    private AbstractPlotDataSolver plotDataSolver;
    private XYPlot subplot;
    private JmxDefinitionDataIdent currentJmxIdent;
    private IGlobalDataAccessService globalDataAccessService;
    private IAggregator<JmxSensorValueData> aggregator = new JmxSensorValueDataAggregator();

    @Override
    public void setInputDefinition(InputDefinition inputDefinition) {
        super.setInputDefinition(inputDefinition);
        this.template = new JmxSensorValueData();
        this.template.setPlatformIdent(inputDefinition.getIdDefinition().getPlatformId());
        this.template.setSensorTypeIdent(inputDefinition.getIdDefinition().getSensorTypeId());
        this.template.setJmxSensorDefinitionDataIdentId(inputDefinition.getIdDefinition().getJmxDefinitionId());
        this.cachedDataService = inputDefinition.getRepositoryDefinition().getCachedDataService();
        this.globalDataAccessService = inputDefinition.getRepositoryDefinition().getGlobalDataAccessService();
        this.currentJmxIdent = this.cachedDataService.getJmxDefinitionDataIdentForId(inputDefinition.getIdDefinition().getJmxDefinitionId());
        this.plotDataSolver = this.getCurrentDataSolver();
    }

    private AbstractPlotDataSolver getCurrentDataSolver() {
        Map map = (Map)PreferencesUtils.getObject("JMX_PLOT_DATA_SOLVER");
        if (map.containsKey(this.currentJmxIdent.getDerivedFullName())) {
            String string = (String)map.get(this.currentJmxIdent.getDerivedFullName());
            return PlotDataSolverFactory.getDataSolver(PlotDataSolver.valueOf(string));
        }
        return PlotDataSolverFactory.getDefaultDataSolver();
    }

    private XYPlot initializePlot() {
        this.jmxChart = new YIntervalSeriesImproved((Comparable<?>)((Object)"jmx value"));
        YIntervalSeriesCollection yIntervalSeriesCollection = new YIntervalSeriesCollection();
        yIntervalSeriesCollection.addSeries((YIntervalSeries)this.jmxChart);
        DeviationRenderer deviationRenderer = new DeviationRenderer(true, false);
        deviationRenderer.setBaseShapesVisible(true);
        deviationRenderer.setSeriesStroke(0, (Stroke)new BasicStroke(3.0f, 1, 1));
        deviationRenderer.setSeriesFillPaint(0, (Paint)new Color(255, 200, 200));
        deviationRenderer.setSeriesOutlineStroke(0, (Stroke)new BasicStroke(2.0f));
        deviationRenderer.setSeriesShape(0, (Shape)new Ellipse2D.Double(-2.5, -2.5, 5.0, 5.0));
        deviationRenderer.setBaseToolTipGenerator((XYToolTipGenerator)new StandardXYToolTipGenerator("{0}: ({1}, {2})", DateFormat.getDateTimeInstance(), NumberFormat.getNumberInstance()));
        NumberAxis numberAxis = this.plotDataSolver.getAxis();
        this.subplot = new XYPlot((XYDataset)yIntervalSeriesCollection, null, (ValueAxis)numberAxis, (XYItemRenderer)deviationRenderer);
        this.subplot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        this.subplot.setRangeAxisLocation(AxisLocation.TOP_OR_LEFT);
        this.subplot.setRangeCrosshairVisible(true);
        return this.subplot;
    }

    @Override
    public List<XYPlot> getPlots() {
        ArrayList<XYPlot> arrayList = new ArrayList<XYPlot>();
        arrayList.add(this.initializePlot());
        return arrayList;
    }

    @Override
    public int getWeight(XYPlot xYPlot) {
        return 2;
    }

    private List<JmxSensorValueData> loadJmxData(Date date, Date date2) {
        return this.globalDataAccessService.getDataObjectsFromToDate((DefaultData)this.template, date, date2);
    }

    private Date getLatestLoadedElementDate() {
        if (CollectionUtils.isEmpty(this.loadedData)) {
            return null;
        }
        long l = Long.MIN_VALUE;
        for (JmxSensorValueData jmxSensorValueData : this.loadedData) {
            if (jmxSensorValueData.getTimeStamp().getTime() <= l) continue;
            l = jmxSensorValueData.getTimeStamp().getTime();
        }
        return new Date(l);
    }

    @Override
    public void update(Date date, Date date2) {
        Date date3 = new Date(Math.min(System.currentTimeMillis(), date2.getTime()));
        if (this.loadedData == null || this.loadedData.isEmpty()) {
            this.loadedData = this.loadJmxData(date, date3);
            this.loadedFromDate = date;
            this.loadedToDate = this.getLatestLoadedElementDate();
        } else {
            boolean bl = date.before(this.loadedFromDate);
            boolean bl2 = date3.after(this.loadedToDate);
            if (bl && bl2) {
                this.loadedData.addAll(this.loadJmxData(date, this.loadedFromDate));
                this.loadedData.addAll(this.loadJmxData(new Date(this.loadedToDate.getTime() + 1L), date3));
                this.loadedFromDate = date;
                this.loadedToDate = this.getLatestLoadedElementDate();
            } else if (bl) {
                if (date3.before(this.loadedFromDate)) {
                    this.loadedData.clear();
                    this.loadedData.addAll(this.loadJmxData(date, date3));
                } else {
                    this.loadedData.addAll(this.loadJmxData(date, this.loadedFromDate));
                }
                this.loadedFromDate = date;
            } else if (bl2) {
                if (date.after(this.loadedToDate)) {
                    this.loadedData.clear();
                    this.loadedFromDate = date;
                    this.loadedData.addAll(this.loadJmxData(date, date3));
                } else {
                    this.loadedData.addAll(this.loadJmxData(new Date(this.loadedToDate.getTime() + 1L), date3));
                }
                this.loadedToDate = this.getLatestLoadedElementDate();
            }
        }
        this.plottedFrom = date;
        this.plottedTo = date3;
        final List<JmxSensorValueData> list = this.selectChartingData(date, date3);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                JmxPlotController.this.jmxChart.clear();
                for (JmxSensorValueData jmxSensorValueData : list) {
                    double d = JmxPlotController.this.plotDataSolver.valueConvert(jmxSensorValueData.getAverageValue());
                    double d2 = JmxPlotController.this.plotDataSolver.valueConvert(jmxSensorValueData.getMinValue());
                    double d3 = JmxPlotController.this.plotDataSolver.valueConvert(jmxSensorValueData.getMaxValue());
                    JmxPlotController.this.jmxChart.add(jmxSensorValueData.getTimeStamp().getTime(), d, d2, d3);
                }
                JmxPlotController.this.jmxChart.fireSeriesChanged();
                if (list.isEmpty()) {
                    JmxPlotController.this.getRootEditor().setDataInput(Collections.emptyList());
                } else {
                    JmxPlotController.this.getRootEditor().setDataInput(list);
                }
            }
        });
    }

    private List<JmxSensorValueData> selectChartingData(Date date, Date date2) {
        ArrayList<JmxSensorValueData> arrayList = new ArrayList<JmxSensorValueData>();
        Date date3 = new Date(date.getTime() - 1L);
        Date date4 = new Date(date2.getTime() + 1L);
        for (JmxSensorValueData jmxSensorValueData : this.loadedData) {
            if (!jmxSensorValueData.getTimeStamp().after(date3) || !jmxSensorValueData.getTimeStamp().before(date4)) continue;
            arrayList.add(jmxSensorValueData);
        }
        return this.adjustSamplingRate(arrayList, date3, date4, this.aggregator);
    }

    @Override
    public Set<PreferenceId> getPreferenceIds() {
        EnumSet<PreferenceId> enumSet = EnumSet.noneOf(PreferenceId.class);
        if (this.getInputDefinition().getRepositoryDefinition() instanceof CmrRepositoryDefinition) {
            enumSet.add(PreferenceId.LIVEMODE);
        }
        enumSet.add(PreferenceId.UPDATE);
        enumSet.add(PreferenceId.TIMELINE);
        enumSet.add(PreferenceId.SAMPLINGRATE);
        enumSet.add(PreferenceId.JMX_PLOTDATASOLVER);
        return enumSet;
    }

    @Override
    public void preferenceEventFired(PreferenceEventCallback.PreferenceEvent preferenceEvent) {
        super.preferenceEventFired(preferenceEvent);
        switch (preferenceEvent.getPreferenceId()) {
            case JMX_PLOTDATASOLVER: {
                this.processJmxPlotDataSolverEvent(preferenceEvent);
                break;
            }
        }
    }

    private void processJmxPlotDataSolverEvent(PreferenceEventCallback.PreferenceEvent preferenceEvent) {
        PlotDataSolver plotDataSolver = (PlotDataSolver)((Object)preferenceEvent.getPreferenceMap().get(PreferenceId.JmxPlotDataSolver.DATA_SOLVER));
        this.plotDataSolver = PlotDataSolverFactory.getDataSolver(plotDataSolver);
        this.subplot.setRangeAxis((ValueAxis)this.plotDataSolver.getAxis());
        Map map = (Map)PreferencesUtils.getObject("JMX_PLOT_DATA_SOLVER");
        map.put(this.currentJmxIdent.getDerivedFullName(), plotDataSolver.toString());
        PreferencesUtils.saveObject("JMX_PLOT_DATA_SOLVER", map, false);
    }

    public Date getPlottedFrom() {
        return this.plottedFrom;
    }

    public Date getPlottedTo() {
        return this.plottedTo;
    }
}

