/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.editor.graph.plot;

import info.novatec.inspectit.cmr.service.IGlobalDataAccessService;
import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.communication.data.MemoryInformationData;
import info.novatec.inspectit.communication.data.SystemInformationData;
import info.novatec.inspectit.indexing.aggregation.IAggregator;
import info.novatec.inspectit.indexing.aggregation.impl.MemoryInformationDataAggregator;
import info.novatec.inspectit.rcp.editor.graph.plot.AbstractPlotController;
import info.novatec.inspectit.rcp.editor.graph.plot.YIntervalSeriesImproved;
import info.novatec.inspectit.rcp.editor.inputdefinition.InputDefinition;
import info.novatec.inspectit.rcp.editor.preferences.PreferenceId;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.widgets.Display;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.DeviationRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.RangeType;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.YIntervalSeries;
import org.jfree.data.xy.YIntervalSeriesCollection;
import org.jfree.ui.RectangleInsets;

public class DefaultMemoryPlotController
extends AbstractPlotController {
    public static final String ID = "inspectit.subview.graph.memory";
    private MemoryInformationData memoryTemplate;
    private SystemInformationData systemTemplate;
    private static final int WEIGHT_UPPER_PLOT = 1;
    private static final int WEIGHT_LOWER_PLOT = 1;
    private XYPlot upperPlot;
    private XYPlot lowerPlot;
    private Map<XYPlot, Integer> weights = new HashMap<XYPlot, Integer>();
    private YIntervalSeriesImproved heapMemory;
    private YIntervalSeriesImproved nonHeapMemory;
    private IGlobalDataAccessService dataAccessService;
    private List<MemoryInformationData> oldData = Collections.emptyList();
    private Date oldFromDate = new Date(Long.MAX_VALUE);
    private Date oldToDate = new Date(0L);
    private Date newestDate = new Date(0L);
    private IAggregator<MemoryInformationData> aggregator = new MemoryInformationDataAggregator();

    @Override
    public void setInputDefinition(InputDefinition inputDefinition) {
        super.setInputDefinition(inputDefinition);
        this.memoryTemplate = new MemoryInformationData();
        this.memoryTemplate.setPlatformIdent(inputDefinition.getIdDefinition().getPlatformId());
        this.memoryTemplate.setSensorTypeIdent(inputDefinition.getIdDefinition().getSensorTypeId());
        this.memoryTemplate.setId(-1L);
        this.systemTemplate = new SystemInformationData();
        this.systemTemplate.setPlatformIdent(inputDefinition.getIdDefinition().getPlatformId());
        this.systemTemplate.setSensorTypeIdent(inputDefinition.getIdDefinition().getSensorTypeId());
        this.dataAccessService = inputDefinition.getRepositoryDefinition().getGlobalDataAccessService();
    }

    @Override
    public List<XYPlot> getPlots() {
        this.upperPlot = this.initializeUpperPlot();
        this.lowerPlot = this.initializeLowerPlot();
        ArrayList<XYPlot> arrayList = new ArrayList<XYPlot>(2);
        arrayList.add(this.upperPlot);
        arrayList.add(this.lowerPlot);
        this.weights.put(this.upperPlot, 1);
        this.weights.put(this.lowerPlot, 1);
        return arrayList;
    }

    private XYPlot initializeUpperPlot() {
        this.heapMemory = new YIntervalSeriesImproved((Comparable<?>)((Object)"heap memory"));
        YIntervalSeriesCollection yIntervalSeriesCollection = new YIntervalSeriesCollection();
        yIntervalSeriesCollection.addSeries((YIntervalSeries)this.heapMemory);
        DeviationRenderer deviationRenderer = new DeviationRenderer(true, false);
        deviationRenderer.setBaseShapesVisible(true);
        deviationRenderer.setSeriesStroke(0, (Stroke)new BasicStroke(3.0f, 1, 1));
        deviationRenderer.setSeriesFillPaint(0, (Paint)new Color(255, 200, 200));
        deviationRenderer.setSeriesOutlineStroke(0, (Stroke)new BasicStroke(2.0f));
        deviationRenderer.setSeriesShape(0, (Shape)new Ellipse2D.Double(-2.5, -2.5, 5.0, 5.0));
        deviationRenderer.setBaseToolTipGenerator((XYToolTipGenerator)new StandardXYToolTipGenerator("{0}: ({1}, {2})", DateFormat.getDateTimeInstance(), NumberFormat.getNumberInstance()));
        NumberAxis numberAxis = new NumberAxis("Heap / kbytes");
        numberAxis.setRangeType(RangeType.POSITIVE);
        SystemInformationData systemInformationData = (SystemInformationData)this.dataAccessService.getLastDataObject((DefaultData)this.systemTemplate);
        if (systemInformationData != null) {
            double d = systemInformationData.getMaxHeapMemorySize() != -1L ? (double)systemInformationData.getMaxHeapMemorySize() / 1024.0 : (systemInformationData.getInitHeapMemorySize() != -1L ? (double)(systemInformationData.getInitHeapMemorySize() * 2L) / 1024.0 : 7.63363328E8);
            numberAxis.setRange(0.0, d);
            numberAxis.setAutoRangeMinimumSize(d);
        }
        XYPlot xYPlot = new XYPlot((XYDataset)yIntervalSeriesCollection, null, (ValueAxis)numberAxis, (XYItemRenderer)deviationRenderer);
        xYPlot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        xYPlot.setRangeAxisLocation(AxisLocation.TOP_OR_LEFT);
        xYPlot.setRangeCrosshairVisible(true);
        return xYPlot;
    }

    private void addUpperPlotData(List<MemoryInformationData> list) {
        for (MemoryInformationData memoryInformationData : list) {
            long l = memoryInformationData.getTotalUsedHeapMemorySize() / (long)memoryInformationData.getCount() / 1024L;
            this.heapMemory.add(memoryInformationData.getTimeStamp().getTime(), l, (double)memoryInformationData.getMinUsedHeapMemorySize() / 1024.0, (double)memoryInformationData.getMaxUsedHeapMemorySize() / 1024.0, false);
        }
        this.heapMemory.fireSeriesChanged();
    }

    private void setUpperPlotData(List<MemoryInformationData> list) {
        this.heapMemory.clear();
        this.addUpperPlotData(list);
    }

    private XYPlot initializeLowerPlot() {
        double d;
        this.nonHeapMemory = new YIntervalSeriesImproved((Comparable<?>)((Object)"non-heap memory"));
        YIntervalSeriesCollection yIntervalSeriesCollection = new YIntervalSeriesCollection();
        yIntervalSeriesCollection.addSeries((YIntervalSeries)this.nonHeapMemory);
        DeviationRenderer deviationRenderer = new DeviationRenderer(true, false);
        deviationRenderer.setBaseShapesVisible(true);
        deviationRenderer.setSeriesStroke(0, (Stroke)new BasicStroke(3.0f));
        deviationRenderer.setSeriesOutlineStroke(0, (Stroke)new BasicStroke(2.0f));
        deviationRenderer.setSeriesShape(0, (Shape)new Ellipse2D.Double(-2.5, -2.5, 5.0, 5.0));
        deviationRenderer.setBaseToolTipGenerator((XYToolTipGenerator)new StandardXYToolTipGenerator("{0}: ({1}, {2})", DateFormat.getDateTimeInstance(), NumberFormat.getNumberInstance()));
        NumberAxis numberAxis = new NumberAxis("Non-heap / kbytes");
        numberAxis.setRangeType(RangeType.POSITIVE);
        SystemInformationData systemInformationData = (SystemInformationData)this.dataAccessService.getLastDataObject((DefaultData)this.systemTemplate);
        if (systemInformationData != null && (d = systemInformationData.getMaxNonHeapMemorySize() != -1L ? (double)systemInformationData.getMaxNonHeapMemorySize() / 1024.0 : (systemInformationData.getInitNonHeapMemorySize() != -1L ? (double)(systemInformationData.getInitNonHeapMemorySize() * 2L) / 1024.0 : 1.34217728E8)) > 0.0) {
            numberAxis.setRange(0.0, d);
            numberAxis.setAutoRangeMinimumSize(d);
        }
        XYPlot xYPlot = new XYPlot((XYDataset)yIntervalSeriesCollection, null, (ValueAxis)numberAxis, (XYItemRenderer)deviationRenderer);
        xYPlot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        xYPlot.setRangeAxisLocation(AxisLocation.TOP_OR_LEFT);
        xYPlot.setRangeCrosshairVisible(true);
        return xYPlot;
    }

    private void addLowerPlotData(List<MemoryInformationData> list) {
        for (MemoryInformationData memoryInformationData : list) {
            long l = memoryInformationData.getTotalUsedNonHeapMemorySize() / (long)memoryInformationData.getCount() / 1024L;
            this.nonHeapMemory.add(memoryInformationData.getTimeStamp().getTime(), l, (double)memoryInformationData.getMinUsedNonHeapMemorySize() / 1024.0, (double)memoryInformationData.getMaxUsedNonHeapMemorySize() / 1024.0, false);
        }
        this.nonHeapMemory.fireSeriesChanged();
    }

    private void setLowerPlotData(List<MemoryInformationData> list) {
        this.nonHeapMemory.clear();
        this.addLowerPlotData(list);
    }

    @Override
    public void update(Date date, Date date2) {
        Object object;
        Date date3 = new Date(0L);
        if (!this.oldData.isEmpty()) {
            date3 = this.oldData.get(this.oldData.size() - 1).getTimeStamp();
        }
        boolean bl = date.before(this.oldFromDate);
        boolean bl2 = date2.after(this.newestDate) || this.oldToDate.before(date2);
        List<Object> list = Collections.emptyList();
        if (this.oldData.isEmpty() || date2.before(this.oldFromDate) || date.after(date3)) {
            object = this.dataAccessService.getDataObjectsFromToDate((DefaultData)this.memoryTemplate, date, date2);
            if (!object.isEmpty()) {
                list = this.adjustSamplingRate(object, date, date2, this.aggregator);
                this.oldFromDate = (Date)date.clone();
                this.oldToDate = (Date)date2.clone();
                if (this.newestDate.before(((MemoryInformationData)object.get(object.size() - 1)).getTimeStamp())) {
                    this.newestDate = new Date(((MemoryInformationData)object.get(object.size() - 1)).getTimeStamp().getTime());
                }
            }
            this.oldData = object;
        } else if (bl && bl2) {
            object = new Date(this.newestDate.getTime() + 1L);
            Date date4 = new Date(this.oldFromDate.getTime() - 1L);
            List list2 = this.dataAccessService.getDataObjectsFromToDate((DefaultData)this.memoryTemplate, (Date)object, date2);
            List list3 = this.dataAccessService.getDataObjectsFromToDate((DefaultData)this.memoryTemplate, date, date4);
            if (!list3.isEmpty()) {
                this.oldData.addAll(0, list3);
                this.oldFromDate = (Date)date.clone();
            }
            if (!list2.isEmpty()) {
                this.oldData.addAll(list2);
                this.oldToDate = (Date)date2.clone();
                if (this.newestDate.before(((MemoryInformationData)list2.get(list2.size() - 1)).getTimeStamp())) {
                    this.newestDate = new Date(((MemoryInformationData)list2.get(list2.size() - 1)).getTimeStamp().getTime());
                }
            }
            list = this.adjustSamplingRate(this.oldData, date, date2, this.aggregator);
        } else if (bl2) {
            object = new Date(this.newestDate.getTime() + 1L);
            List list4 = this.dataAccessService.getDataObjectsFromToDate((DefaultData)this.memoryTemplate, (Date)object, date2);
            if (!list4.isEmpty()) {
                this.oldData.addAll(list4);
                this.oldToDate = (Date)date2.clone();
                if (this.newestDate.before(((MemoryInformationData)list4.get(list4.size() - 1)).getTimeStamp())) {
                    this.newestDate = new Date(((MemoryInformationData)list4.get(list4.size() - 1)).getTimeStamp().getTime());
                }
            }
            list = this.adjustSamplingRate(this.oldData, date, date2, this.aggregator);
        } else if (bl) {
            object = new Date(this.oldFromDate.getTime() - 1L);
            List list5 = this.dataAccessService.getDataObjectsFromToDate((DefaultData)this.memoryTemplate, date, (Date)object);
            if (!list5.isEmpty()) {
                this.oldData.addAll(list5);
                this.oldFromDate = (Date)date.clone();
            }
            list = this.adjustSamplingRate(this.oldData, date, date2, this.aggregator);
        } else {
            list = this.adjustSamplingRate(this.oldData, date, date2, this.aggregator);
        }
        object = list;
        Display.getDefault().asyncExec(new Runnable((List)object){
            private final /* synthetic */ List val$finalAdjustedMemoryInformationData;
            {
                this.val$finalAdjustedMemoryInformationData = list;
            }

            @Override
            public void run() {
                DefaultMemoryPlotController.this.setUpperPlotData(this.val$finalAdjustedMemoryInformationData);
                DefaultMemoryPlotController.this.setLowerPlotData(this.val$finalAdjustedMemoryInformationData);
            }
        });
    }

    @Override
    public int getWeight(XYPlot xYPlot) {
        return this.weights.get(xYPlot);
    }

    @Override
    public Set<PreferenceId> getPreferenceIds() {
        EnumSet<PreferenceId> enumSet = EnumSet.noneOf(PreferenceId.class);
        if (this.getInputDefinition().getRepositoryDefinition() instanceof CmrRepositoryDefinition) {
            enumSet.add(PreferenceId.LIVEMODE);
        }
        enumSet.add(PreferenceId.TIMELINE);
        enumSet.add(PreferenceId.SAMPLINGRATE);
        enumSet.add(PreferenceId.UPDATE);
        return enumSet;
    }

    @Override
    public void dispose() {
    }
}

