/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.documentation;

import info.novatec.inspectit.version.InvalidVersionException;
import info.novatec.inspectit.version.Version;
import info.novatec.inspectit.version.VersionService;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class DocumentationService {
    public static final String DOCUMENTATION_ENDUSER_HOME = "https://inspectit-performance.atlassian.net/wiki/display/DOC/End+User+Documentation+Home";
    public static final String DOCUMENTATION_ENDUSER_SPECIFICVERSION = "https://inspectit-performance.atlassian.net/wiki/display/DOC";
    protected static final String DOCUMENTATION_SEARCH_URL = "https://inspectit-performance.atlassian.net/wiki/dosearchsite.action?queryString=";
    private VersionService versionService;

    public String getDocumentationUrl() {
        try {
            Version version = this.versionService.getVersion();
            return DOCUMENTATION_ENDUSER_SPECIFICVERSION + this.getSpaceKey(version) + "/Home";
        }
        catch (InvalidVersionException invalidVersionException) {
            return DOCUMENTATION_ENDUSER_HOME;
        }
    }

    public String getSearchUrlFor(String string) {
        if (StringUtils.isNotEmpty((String)string)) {
            StringBuilder stringBuilder = new StringBuilder(DOCUMENTATION_SEARCH_URL);
            String[] stringArray = StringUtils.split((String)string);
            int n = 0;
            while (n < stringArray.length) {
                stringBuilder.append(stringArray[n]);
                if (n < stringArray.length - 1) {
                    stringBuilder.append('+');
                }
                ++n;
            }
            try {
                Version version = this.versionService.getVersion();
                stringBuilder.append("&where=DOC");
                stringBuilder.append(this.getSpaceKey(version));
            }
            catch (InvalidVersionException invalidVersionException) {}
            return stringBuilder.toString();
        }
        return this.getDocumentationUrl();
    }

    private String getSpaceKey(Version version) {
        return "" + version.getMajor() + version.getMinor();
    }

    public void setVersionService(VersionService versionService) {
        this.versionService = versionService;
    }
}

