/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.dialog;

import info.novatec.inspectit.exception.RemoteException;
import info.novatec.inspectit.rcp.InspectIT;
import java.util.Objects;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.handlers.IHandlerService;

public class ThrowableDialog
extends TitleAreaDialog {
    private static final String DIALOG_TITLE = "Error occurred";
    private String message;
    private Throwable throwable;
    private Composite detailsComposite;
    private FormToolkit toolkit;

    public ThrowableDialog(Shell shell, String string, Throwable throwable) {
        super(shell);
        Assert.isNotNull((Object)throwable, (String)"Throwable to show in the dialog must not be null.");
        this.throwable = throwable;
        this.message = string;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public void create() {
        super.create();
        this.setTitle(DIALOG_TITLE);
        this.setTitleImage(InspectIT.getDefault().getImage("/icons/eclipse/wizban/error_wiz.png"));
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(DIALOG_TITLE);
        shell.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                if (ThrowableDialog.this.areDetailsDisplayed()) {
                    ((GridData)((ThrowableDialog)ThrowableDialog.this).detailsComposite.getLayoutData()).widthHint = ThrowableDialog.this.getShell().getSize().x;
                }
            }
        });
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.createButton(composite, 13, IDialogConstants.SHOW_DETAILS_LABEL, false);
        this.createButton(composite, 1024, "Send Error Report", false);
        this.createButton(composite, 1, IDialogConstants.CLOSE_LABEL, true).setFocus();
    }

    protected Control createDialogArea(Composite composite) {
        this.toolkit = new FormToolkit(composite.getDisplay());
        Composite composite2 = this.toolkit.createComposite(composite);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.widthHint = 400;
        gridData.heightHint = 200;
        composite2.setLayoutData((Object)gridData);
        TableWrapLayout tableWrapLayout = new TableWrapLayout();
        tableWrapLayout.topMargin = 0;
        tableWrapLayout.leftMargin = 0;
        tableWrapLayout.bottomMargin = 0;
        tableWrapLayout.rightMargin = 0;
        composite2.setLayout((Layout)tableWrapLayout);
        Composite composite3 = this.toolkit.createCompositeSeparator(composite2);
        TableWrapData tableWrapData = new TableWrapData(256);
        tableWrapData.heightHint = 2;
        composite3.setLayoutData((Object)tableWrapData);
        Composite composite4 = this.toolkit.createComposite(composite2);
        composite4.setLayout((Layout)new TableWrapLayout());
        composite4.setLayoutData((Object)new TableWrapData(256));
        FormText formText = this.toolkit.createFormText(composite4, false);
        StringBuilder stringBuilder = new StringBuilder("<form><p>");
        if (this.throwable instanceof RemoteException) {
            String string = ((RemoteException)this.throwable).getServiceMethodSignature();
            stringBuilder.append("The error occurred while invoking the service method <span color=\"info\">" + string + "</span>.");
        } else {
            stringBuilder.append("The unexpected error occurred in the <span color=\"info\">inspectIT User interface</span>.");
        }
        stringBuilder.append("<br/><br/><span color=\"header\" font=\"header\">Error Message</span><br/>");
        if (this.message != null) {
            stringBuilder.append(this.message);
        } else if (this.throwable.getMessage() != null) {
            stringBuilder.append(this.throwable.getMessage());
        } else {
            stringBuilder.append('-');
        }
        stringBuilder.append("<br/><br/><span color=\"header\" font=\"header\">Send Error Report</span><br/>Please send us the error report to help fix the problem and improve this software.<br/><br/><a href=\"errorReport\">What data does the error report contain?</a></p></form>");
        formText.setText(stringBuilder.toString(), true, false);
        formText.setColor("info", this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        formText.setColor("header", this.getShell().getDisplay().getSystemColor(3));
        formText.setFont("header", JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
        formText.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent hyperlinkEvent) {
                ThrowableDialog.this.showErrorReportDescription();
            }
        });
        return composite2;
    }

    protected void buttonPressed(int n) {
        super.buttonPressed(n);
        if (n == 13) {
            Composite composite = (Composite)this.getButtonBar();
            Button button = this.getButton(n);
            if (this.areDetailsDisplayed()) {
                this.detailsComposite.dispose();
                button.setText(IDialogConstants.SHOW_DETAILS_LABEL);
            } else {
                this.createDetails(composite);
                button.setText(IDialogConstants.HIDE_DETAILS_LABEL);
            }
            this.fixShellSize();
        } else if (n == 1024) {
            try {
                IHandlerService iHandlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
                ICommandService iCommandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                Command command = iCommandService.getCommand("info.novatec.inspectit.rcp.sendErrorReport");
                ExecutionEvent executionEvent = iHandlerService.createExecutionEvent(command, new Event());
                IEvaluationContext iEvaluationContext = (IEvaluationContext)executionEvent.getApplicationContext();
                iEvaluationContext.addVariable("info.novatec.inspectit.rcp.sendErrorReport.throwable", (Object)this.throwable);
                command.executeWithChecks(executionEvent);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    private boolean areDetailsDisplayed() {
        return this.detailsComposite != null && !this.detailsComposite.isDisposed();
    }

    private void fixShellSize() {
        int n = this.getShell().getSize().y - this.getContents().getSize().y;
        ((Composite)this.getContents()).layout(true, true);
        Point point = this.getShell().getSize();
        this.getShell().setSize(point.x, this.getContents().computeSize((int)point.x, (int)-1).y + n);
    }

    private void createDetails(Composite composite) {
        if (!this.areDetailsDisplayed()) {
            this.detailsComposite = this.toolkit.createComposite(composite);
            TableWrapLayout tableWrapLayout = new TableWrapLayout();
            tableWrapLayout.numColumns = 2;
            this.detailsComposite.setLayout((Layout)tableWrapLayout);
            GridData gridData = new GridData(4, 4, true, true, ((GridLayout)composite.getLayout()).numColumns, 1);
            gridData.widthHint = this.getShell().getSize().x;
            this.detailsComposite.setLayoutData((Object)gridData);
            Label label = this.toolkit.createLabel(this.detailsComposite, "Additional Information", 0);
            label.setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
            label.setFont(JFaceResources.getFont((String)"org.eclipse.jface.headerfont"));
            TableWrapData tableWrapData = new TableWrapData(256);
            tableWrapData.colspan = 2;
            label.setLayoutData((Object)tableWrapData);
            Label label2 = this.toolkit.createLabel(this.detailsComposite, "Exception:", 0);
            label2.setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
            Label label3 = this.toolkit.createLabel(this.detailsComposite, "", 64);
            label3.setLayoutData((Object)new TableWrapData(128));
            label2 = this.toolkit.createLabel(this.detailsComposite, "Message:", 0);
            label2.setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
            Label label4 = this.toolkit.createLabel(this.detailsComposite, "", 64);
            label4.setLayoutData((Object)new TableWrapData(128));
            label2 = this.toolkit.createLabel(this.detailsComposite, "Cause:", 0);
            label2.setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
            Label label5 = this.toolkit.createLabel(this.detailsComposite, "", 64);
            label5.setLayoutData((Object)new TableWrapData(128));
            label2 = this.toolkit.createLabel(this.detailsComposite, "Stack trace:", 64);
            label2.setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
            Text text = this.toolkit.createText(this.detailsComposite, "", 2826);
            tableWrapData = new TableWrapData(128);
            tableWrapData.heightHint = 150;
            tableWrapData.maxWidth = 0;
            text.setLayoutData((Object)tableWrapData);
            if (this.throwable instanceof RemoteException) {
                label3.setText(((RemoteException)this.throwable).getOriginalExceptionClass());
            } else {
                label3.setText(this.throwable.getClass().getName());
            }
            if (this.throwable.getMessage() != null) {
                label4.setText(this.throwable.getMessage());
            } else {
                label4.setText("-");
            }
            if (this.throwable.getCause() != null && !Objects.equals(this.throwable, this.throwable.getCause())) {
                label5.setText(String.valueOf(this.throwable.getCause().getClass().getName()) + ": " + this.throwable.getCause().getMessage());
            } else {
                label5.setText("-");
            }
            text.setText(ExceptionUtils.getFullStackTrace((Throwable)this.throwable));
        }
    }

    private void showErrorReportDescription() {
        int n = 67696;
        PopupDialog popupDialog = new PopupDialog(this.getShell(), n, true, false, false, false, false, "What data does the error report contain?", "What data does the error report contain?"){
            private static final int CURSOR_SIZE = 15;

            protected Control createDialogArea(Composite composite) {
                Composite composite2 = (Composite)super.createDialogArea(composite);
                Text text = ThrowableDialog.this.toolkit.createText(composite, null, 842);
                GridData gridData = new GridData(1809);
                gridData.horizontalIndent = 3;
                gridData.verticalIndent = 3;
                text.setLayoutData((Object)gridData);
                text.setText("The error report to send to the inspectIT Team contains the following information:\n\n - inspectIT version you are using\n - Your operating system information and used Java version\n - Exception type, message and stack trace\n\nThe sending of the error report is only available via Send-To mail option. After clicking to the 'Send Error Report' button your e-mail client will open with new predefined e-mail message to send to support.inspectit@novatec-gmbh.de. The e-mail used to send the error report will be kept private.\n\nWe thank you in advance for helping us to fix this problem and improve our software.");
                return composite2;
            }

            protected Point getInitialLocation(Point point) {
                Display display = this.getShell().getDisplay();
                Point point2 = display.getCursorLocation();
                point2.x += 15;
                point2.y += 15;
                return point2;
            }

            protected Point getInitialSize() {
                return new Point(600, 300);
            }
        };
        popupDialog.open();
    }
}

