/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.dialog;

import info.novatec.inspectit.cmr.model.PlatformIdent;
import info.novatec.inspectit.cmr.model.SensorTypeIdent;
import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.composite.BreadcrumbTitleComposite;
import info.novatec.inspectit.rcp.details.DetailsGenerationFactory;
import info.novatec.inspectit.rcp.details.DetailsTable;
import info.novatec.inspectit.rcp.formatter.TextFormatter;
import info.novatec.inspectit.rcp.model.SensorTypeEnum;
import info.novatec.inspectit.rcp.repository.RepositoryDefinition;
import info.novatec.inspectit.rcp.util.AccessibleArrowImage;
import info.novatec.inspectit.rcp.util.ClipboardUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.eclipse.core.commands.Command;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.ManagedForm;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class DetailsDialog
extends Dialog {
    private static final Map<String, String> NAVIGATE_COMMANDS_IDS = new HashMap<String, String>();
    private static final Map<String, String> ACTION_COMMANDS_IDS = new HashMap<String, String>();
    private DefaultData defaultData;
    private RepositoryDefinition repositoryDefinition;
    private ICommandService commandService;
    private Command commandOnClose;
    private Image arrow;
    private BreadcrumbTitleComposite breadcrumbTitleComposite;
    private List<DetailsTable> detailTables;

    static {
        NAVIGATE_COMMANDS_IDS.put("info.novatec.inspectit.rcp.commands.navigateToAggregatedSqlData", "Aggregated SQL Data");
        NAVIGATE_COMMANDS_IDS.put("info.novatec.inspectit.rcp.commands.navigateToAggregatedTimerData", "Aggregated Timer Data");
        NAVIGATE_COMMANDS_IDS.put("info.novatec.inspectit.rcp.commands.navigateToInvocations", "Invocation(s)");
        NAVIGATE_COMMANDS_IDS.put("info.novatec.inspectit.rcp.commands.navigateToStartMethodInvocations", "Only This Method Invocation(s)");
        NAVIGATE_COMMANDS_IDS.put("info.novatec.inspectit.rcp.commands.navigateToSingleExceptionType", "Exception Type");
        NAVIGATE_COMMANDS_IDS.put("info.novatec.inspectit.rcp.commands.navigateToGroupedExceptionType", "Grouped Exception View");
        ACTION_COMMANDS_IDS.put("info.novatec.inspectit.rcp.commands.copySqlQuery", "Copy SQL Query");
        ACTION_COMMANDS_IDS.put("info.novatec.inspectit.rcp.commands.copyLogMessage", "Copy Log Message");
        ACTION_COMMANDS_IDS.put("info.novatec.inspectit.rcp.commands.displayInChart", "Display in Chart");
        ACTION_COMMANDS_IDS.put("org.eclipse.ui.file.save", "Save to Server");
    }

    public DetailsDialog(Shell shell, DefaultData defaultData, RepositoryDefinition repositoryDefinition) {
        super(shell);
        this.defaultData = defaultData;
        this.repositoryDefinition = repositoryDefinition;
        this.commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        this.arrow = new AccessibleArrowImage(true).createImage();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Details");
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.createButton(composite, 0, IDialogConstants.OK_LABEL, true);
    }

    protected void setShellStyle(int n) {
        super.setShellStyle(2160);
        this.setBlockOnOpen(false);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        composite2.setLayout((Layout)new FillLayout());
        ((GridData)composite2.getLayoutData()).widthHint = 1050;
        ManagedForm managedForm = new ManagedForm(composite2);
        FormToolkit formToolkit = managedForm.getToolkit();
        ScrolledForm scrolledForm = managedForm.getForm();
        managedForm.getToolkit().decorateFormHeading(scrolledForm.getForm());
        this.breadcrumbTitleComposite = new BreadcrumbTitleComposite(scrolledForm.getForm().getHead(), 0);
        this.setDataForBreadcrumbTitleComposite();
        scrolledForm.setHeadClient((Control)this.breadcrumbTitleComposite);
        Composite composite3 = scrolledForm.getBody();
        TableWrapLayout tableWrapLayout = new TableWrapLayout();
        tableWrapLayout.numColumns = 2;
        composite3.setLayout((Layout)tableWrapLayout);
        Composite composite4 = formToolkit.createComposite(composite3);
        composite4.setLayoutData((Object)new TableWrapData(256));
        TableWrapLayout tableWrapLayout2 = new TableWrapLayout();
        tableWrapLayout2.verticalSpacing = 20;
        composite4.setLayout((Layout)tableWrapLayout2);
        DetailsGenerationFactory detailsGenerationFactory = InspectIT.getService(DetailsGenerationFactory.class);
        this.detailTables = detailsGenerationFactory.createDetailComposites(this.defaultData, this.repositoryDefinition, composite4, formToolkit);
        if (CollectionUtils.isNotEmpty(this.detailTables)) {
            for (DetailsTable object2 : this.detailTables) {
                object2.getSection().setLayoutData((Object)new TableWrapData(256));
                managedForm.addPart((IFormPart)object2);
            }
        }
        Composite composite5 = formToolkit.createComposite(composite3);
        composite5.setData((Object)this.defaultData);
        composite5.setLayoutData((Object)new TableWrapData(128));
        composite5.setLayout((Layout)new GridLayout(1, false));
        Section section = formToolkit.createSection(composite5, 256);
        section.setText("Navigate To");
        section.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite composite6 = formToolkit.createComposite((Composite)section);
        composite6.setLayout((Layout)new GridLayout(2, false));
        section.setClient((Control)composite6);
        this.createLinks(composite6, formToolkit, NAVIGATE_COMMANDS_IDS);
        Section section2 = formToolkit.createSection(composite5, 256);
        section2.setText("Actions");
        section2.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite composite7 = formToolkit.createComposite((Composite)section2);
        composite7.setLayout((Layout)new GridLayout(2, false));
        section2.setClient((Control)composite7);
        formToolkit.createLabel(composite7, "", 0).setImage(this.arrow);
        Hyperlink hyperlink = formToolkit.createHyperlink(composite7, "Copy", 64);
        hyperlink.addHyperlinkListener((IHyperlinkListener)new CopyHyperlinkListener());
        hyperlink.setLayoutData((Object)new GridData(4, 4, true, false));
        this.createLinks(composite7, formToolkit, ACTION_COMMANDS_IDS);
        return composite;
    }

    private void createLinks(Composite composite, FormToolkit formToolkit, Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            Command command = this.commandService.getCommand(entry.getKey());
            if (!command.isDefined() || command.getHandler() == null || !command.getHandler().isEnabled()) continue;
            formToolkit.createLabel(composite, "", 0).setImage(this.arrow);
            Hyperlink hyperlink = formToolkit.createHyperlink(composite, entry.getValue(), 64);
            hyperlink.addHyperlinkListener((IHyperlinkListener)new CommandHyperlinkListener(command));
            hyperlink.setLayoutData((Object)new GridData(4, 4, true, false));
        }
    }

    private void setDataForBreadcrumbTitleComposite() {
        SensorTypeIdent sensorTypeIdent;
        String string;
        SensorTypeEnum sensorTypeEnum;
        this.breadcrumbTitleComposite.setRepositoryDefinition(this.repositoryDefinition);
        PlatformIdent platformIdent = this.repositoryDefinition.getCachedDataService().getPlatformIdentForId(this.defaultData.getPlatformIdent());
        this.breadcrumbTitleComposite.setAgent(TextFormatter.getAgentDescription(platformIdent), InspectIT.getDefault().getImage("/icons/eclipse/agent.gif"));
        if (0L != this.defaultData.getSensorTypeIdent() && (sensorTypeEnum = SensorTypeEnum.get(string = (sensorTypeIdent = this.repositoryDefinition.getCachedDataService().getSensorTypeIdentForId(this.defaultData.getSensorTypeIdent())).getFullyQualifiedClassName())) != null) {
            this.breadcrumbTitleComposite.setGroup(sensorTypeEnum.getDisplayName(), sensorTypeEnum.getImage());
        }
        this.breadcrumbTitleComposite.setView("Details", null);
    }

    public boolean close() {
        this.arrow.dispose();
        this.breadcrumbTitleComposite.dispose();
        return super.close();
    }

    public Command getCommandOnClose() {
        return this.commandOnClose;
    }

    private class CommandHyperlinkListener
    extends HyperlinkAdapter {
        private Command command;

        public CommandHyperlinkListener(Command command) {
            this.command = command;
        }

        public void linkActivated(HyperlinkEvent hyperlinkEvent) {
            DetailsDialog.this.commandOnClose = this.command;
            DetailsDialog.this.close();
        }
    }

    private class CopyHyperlinkListener
    extends HyperlinkAdapter {
        private CopyHyperlinkListener() {
        }

        public void linkActivated(HyperlinkEvent hyperlinkEvent) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(DetailsDialog.this.breadcrumbTitleComposite.getCopyString());
            stringBuilder.append("\n\n");
            for (DetailsTable detailsTable : DetailsDialog.this.detailTables) {
                stringBuilder.append(detailsTable.getCopyString());
                stringBuilder.append('\n');
            }
            ClipboardUtil.textToClipboard(DetailsDialog.this.getShell().getDisplay(), stringBuilder.toString());
        }
    }
}

