/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.details.generator.impl;

import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.communication.MethodSensorData;
import info.novatec.inspectit.communication.data.ParameterContentData;
import info.novatec.inspectit.communication.data.ParameterContentType;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.details.DetailsTable;
import info.novatec.inspectit.rcp.details.generator.IDetailsGenerator;
import info.novatec.inspectit.rcp.repository.RepositoryDefinition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ParameterContentDetailsGenerator
implements IDetailsGenerator {
    @Override
    public boolean canGenerateFor(DefaultData defaultData) {
        return defaultData instanceof MethodSensorData && CollectionUtils.isNotEmpty((Collection)((MethodSensorData)defaultData).getParameterContentData());
    }

    @Override
    public DetailsTable generate(DefaultData defaultData, RepositoryDefinition repositoryDefinition, Composite composite, FormToolkit formToolkit) {
        Map<ParameterContentType, List<ParameterContentData>> map = this.getContentTypeMap(((MethodSensorData)defaultData).getParameterContentData());
        DetailsTable detailsTable = new DetailsTable(composite, formToolkit, "Parameter Content Data", 1);
        for (Map.Entry<ParameterContentType, List<ParameterContentData>> entry : map.entrySet()) {
            Object object2;
            ArrayList<String[]> arrayList = new ArrayList<String[]>();
            for (Object object2 : entry.getValue()) {
                arrayList.add(new String[]{object2.getName(), object2.getContent()});
            }
            object2 = String.valueOf(StringUtils.capitalize((String)entry.getKey().toString().toLowerCase())) + ":";
            detailsTable.addContentTable((String)object2, this.getImageForParameterContentType(entry.getKey()), 2, new String[]{"Name", "Value"}, arrayList);
        }
        return detailsTable;
    }

    private Map<ParameterContentType, List<ParameterContentData>> getContentTypeMap(Collection<ParameterContentData> collection) {
        if (CollectionUtils.isEmpty(collection)) {
            return Collections.emptyMap();
        }
        HashMap<ParameterContentType, List<ParameterContentData>> hashMap = new HashMap<ParameterContentType, List<ParameterContentData>>();
        for (Object object : collection) {
            ArrayList<ParameterContentData> arrayList = (ArrayList<ParameterContentData>)hashMap.get(object.getContentType());
            if (arrayList == null) {
                arrayList = new ArrayList<ParameterContentData>(1);
                hashMap.put(object.getContentType(), arrayList);
            }
            arrayList.add((ParameterContentData)object);
        }
        for (Object object : hashMap.values()) {
            Collections.sort(object);
        }
        return hashMap;
    }

    private Image getImageForParameterContentType(ParameterContentType parameterContentType) {
        if (parameterContentType == ParameterContentType.FIELD) {
            return InspectIT.getDefault().getImage("/icons/selfmade/field.png");
        }
        if (parameterContentType == ParameterContentType.PARAM) {
            return InspectIT.getDefault().getImage("/icons/selfmade/parameter.png");
        }
        if (parameterContentType == ParameterContentType.RETURN) {
            return InspectIT.getDefault().getImage("/icons/selfmade/return.png");
        }
        return null;
    }
}

