/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.details.generator.impl;

import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.communication.data.HttpTimerData;
import info.novatec.inspectit.rcp.details.DetailsCellContent;
import info.novatec.inspectit.rcp.details.DetailsTable;
import info.novatec.inspectit.rcp.details.generator.IDetailsGenerator;
import info.novatec.inspectit.rcp.repository.RepositoryDefinition;
import info.novatec.inspectit.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class HttpDetailsGenerator
implements IDetailsGenerator {
    private static final Comparator<String[]> ROW_COMPARATOR = new Comparator<String[]>(){

        @Override
        public int compare(String[] stringArray, String[] stringArray2) {
            return ObjectUtils.compare((Comparable)((Object)stringArray[0]), (Object)stringArray2[0]);
        }
    };

    @Override
    public boolean canGenerateFor(DefaultData defaultData) {
        return defaultData instanceof HttpTimerData;
    }

    @Override
    public DetailsTable generate(DefaultData defaultData, RepositoryDefinition repositoryDefinition, Composite composite, FormToolkit formToolkit) {
        ArrayList<String[]> arrayList;
        HttpTimerData httpTimerData = (HttpTimerData)defaultData;
        DetailsTable detailsTable = new DetailsTable(composite, formToolkit, "HTTP Info", 1);
        detailsTable.addContentRow("Method:", null, new DetailsCellContent(httpTimerData.getHttpInfo().getRequestMethod()));
        detailsTable.addContentRow("URI:", null, new DetailsCellContent(httpTimerData.getHttpInfo().getUri()));
        if (httpTimerData.getHttpInfo().hasInspectItTaggingHeader()) {
            detailsTable.addContentRow("Tag Value:", null, new DetailsCellContent(httpTimerData.getHttpInfo().getInspectItTaggingHeaderValue()));
        }
        if (MapUtils.isNotEmpty((Map)httpTimerData.getParameters())) {
            arrayList = new ArrayList<String[]>();
            for (Map.Entry entry : httpTimerData.getParameters().entrySet()) {
                arrayList.add(new String[]{(String)entry.getKey(), Arrays.toString((Object[])entry.getValue())});
            }
            Collections.sort(arrayList, ROW_COMPARATOR);
            detailsTable.addContentTable("Parameters:", null, 2, new String[]{"Parameter", "Value"}, arrayList);
        }
        if (MapUtils.isNotEmpty((Map)httpTimerData.getAttributes())) {
            arrayList = new ArrayList();
            for (Map.Entry entry : httpTimerData.getAttributes().entrySet()) {
                arrayList.add(new String[]{(String)entry.getKey(), (String)entry.getValue()});
            }
            Collections.sort(arrayList, ROW_COMPARATOR);
            detailsTable.addContentTable("Attributes:", null, 2, new String[]{"Attribute", "Value"}, arrayList);
        }
        if (MapUtils.isNotEmpty((Map)httpTimerData.getHeaders())) {
            arrayList = new ArrayList();
            for (Map.Entry entry : httpTimerData.getHeaders().entrySet()) {
                arrayList.add(new String[]{(String)entry.getKey(), (String)entry.getValue()});
            }
            Collections.sort(arrayList, ROW_COMPARATOR);
            detailsTable.addContentTable("Headers:", null, 2, new String[]{"Header", "Value"}, arrayList);
        }
        if (MapUtils.isNotEmpty((Map)httpTimerData.getSessionAttributes())) {
            arrayList = new ArrayList();
            for (Map.Entry entry : httpTimerData.getSessionAttributes().entrySet()) {
                arrayList.add(new String[]{(String)entry.getKey(), (String)entry.getValue()});
            }
            Collections.sort(arrayList, ROW_COMPARATOR);
            detailsTable.addContentTable("Session Attributes:", null, 2, new String[]{"Session Attribute", "Value"}, arrayList);
        }
        return detailsTable;
    }
}

