/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.details.generator.impl;

import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.communication.IAggregatedData;
import info.novatec.inspectit.communication.data.TimerData;
import info.novatec.inspectit.rcp.details.DetailsCellContent;
import info.novatec.inspectit.rcp.details.DetailsTable;
import info.novatec.inspectit.rcp.details.generator.IDetailsGenerator;
import info.novatec.inspectit.rcp.formatter.NumberFormatter;
import info.novatec.inspectit.rcp.repository.RepositoryDefinition;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class DurationDetailsGenerator
implements IDetailsGenerator {
    @Override
    public boolean canGenerateFor(DefaultData defaultData) {
        return defaultData instanceof TimerData && !(defaultData instanceof IAggregatedData);
    }

    @Override
    public DetailsTable generate(DefaultData defaultData, RepositoryDefinition repositoryDefinition, Composite composite, FormToolkit formToolkit) {
        DetailsCellContent[] detailsCellContentArray;
        TimerData timerData = (TimerData)defaultData;
        DetailsTable detailsTable = new DetailsTable(composite, formToolkit, "Duration Info", 1);
        DetailsCellContent[] detailsCellContentArray2 = new DetailsCellContent[]{new DetailsCellContent(NumberFormatter.formatDouble(timerData.getDuration()))};
        detailsTable.addContentRow("Total (ms):", null, detailsCellContentArray2);
        if (timerData.isCpuMetricDataAvailable()) {
            detailsCellContentArray = new DetailsCellContent[]{new DetailsCellContent(NumberFormatter.formatDouble(timerData.getCpuDuration()))};
            detailsTable.addContentRow("CPU (ms):", null, detailsCellContentArray);
        }
        if (timerData.isExclusiveTimeDataAvailable()) {
            detailsCellContentArray = new DetailsCellContent[]{new DetailsCellContent(NumberFormatter.formatDouble(timerData.getExclusiveDuration()))};
            detailsTable.addContentRow("Exclusive (ms):", null, detailsCellContentArray);
        }
        return detailsTable;
    }
}

