/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.details;

import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.communication.data.InvocationSequenceData;
import info.novatec.inspectit.communication.data.TimerData;
import info.novatec.inspectit.rcp.details.DetailsTable;
import info.novatec.inspectit.rcp.details.generator.IDetailsGenerator;
import info.novatec.inspectit.rcp.repository.RepositoryDefinition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public final class DetailsGenerationFactory {
    private List<IDetailsGenerator> generators;

    public List<DetailsTable> createDetailComposites(DefaultData defaultData, RepositoryDefinition repositoryDefinition, Composite composite, FormToolkit formToolkit) {
        Object object;
        TimerData timerData = null;
        if (defaultData instanceof InvocationSequenceData) {
            object = (InvocationSequenceData)defaultData;
            if (object.getTimerData() != null) {
                timerData = object.getTimerData();
            }
            if (object.getSqlStatementData() != null) {
                timerData = object.getSqlStatementData();
            }
            if (CollectionUtils.isNotEmpty((Collection)object.getExceptionSensorDataObjects())) {
                timerData = (DefaultData)object.getExceptionSensorDataObjects().get(0);
            }
            if (object.getLoggingData() != null) {
                timerData = object.getLoggingData();
            }
        }
        object = new ArrayList();
        for (IDetailsGenerator iDetailsGenerator : this.generators) {
            if (iDetailsGenerator.canGenerateFor(defaultData)) {
                object.add(iDetailsGenerator.generate(defaultData, repositoryDefinition, composite, formToolkit));
                continue;
            }
            if (timerData == null || !iDetailsGenerator.canGenerateFor((DefaultData)timerData)) continue;
            object.add(iDetailsGenerator.generate((DefaultData)timerData, repositoryDefinition, composite, formToolkit));
        }
        return object;
    }

    public void setGenerators(List<IDetailsGenerator> list) {
        this.generators = list;
    }
}

