/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.ci.wizard;

import info.novatec.inspectit.ci.Environment;
import info.novatec.inspectit.exception.BusinessException;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.ci.job.OpenEnvironmentJob;
import info.novatec.inspectit.rcp.ci.wizard.page.DefineNameAndDescriptionWizardPage;
import info.novatec.inspectit.rcp.provider.ICmrRepositoryProvider;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class CreateEnvironmentWizard
extends Wizard
implements INewWizard {
    private static final String TITLE = "Create New Environment";
    private static final String MESSAGE = "Define the information for the new Environment";
    private CmrRepositoryDefinition cmrRepositoryDefinition;
    private DefineNameAndDescriptionWizardPage defineNameAndDescriptionWizardPage;
    private IWorkbench workbench;

    public CreateEnvironmentWizard() {
        this.setWindowTitle(TITLE);
    }

    public void addPages() {
        this.defineNameAndDescriptionWizardPage = new DefineNameAndDescriptionWizardPage(TITLE, MESSAGE);
        this.addPage((IWizardPage)this.defineNameAndDescriptionWizardPage);
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        this.workbench = iWorkbench;
        StructuredSelection structuredSelection = (StructuredSelection)iStructuredSelection;
        if (structuredSelection.getFirstElement() instanceof ICmrRepositoryProvider) {
            this.cmrRepositoryDefinition = ((ICmrRepositoryProvider)structuredSelection.getFirstElement()).getCmrRepositoryDefinition();
        }
    }

    public boolean performFinish() {
        String string = this.defineNameAndDescriptionWizardPage.getName();
        String string2 = this.defineNameAndDescriptionWizardPage.getDescription();
        Environment environment = new Environment();
        environment.setName(string);
        if (StringUtils.isNotBlank((String)string2)) {
            environment.setDescription(string2);
        }
        if (this.cmrRepositoryDefinition.getOnlineStatus() != CmrRepositoryDefinition.OnlineStatus.OFFLINE) {
            try {
                Environment environment2 = this.cmrRepositoryDefinition.getConfigurationInterfaceService().createEnvironment(environment);
                new OpenEnvironmentJob(this.cmrRepositoryDefinition, environment2.getId(), this.workbench.getActiveWorkbenchWindow().getActivePage()).schedule();
                InspectIT.getDefault().getInspectITConfigurationInterfaceManager().environmentCreated(environment2, this.cmrRepositoryDefinition);
            }
            catch (BusinessException businessException) {
                InspectIT.getDefault().createErrorDialog("Environment can not be created.", businessException, -1);
                return false;
            }
        } else {
            InspectIT.getDefault().createErrorDialog("Environment can not be created. Selected CMR repository is currently not available.", -1);
            return false;
        }
        return true;
    }
}

