/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.ci.widget;

import info.novatec.inspectit.ci.assignment.AbstractClassSensorAssignment;
import info.novatec.inspectit.ci.assignment.impl.MethodSensorAssignment;
import info.novatec.inspectit.ci.assignment.impl.TimerMethodSensorAssignment;
import info.novatec.inspectit.ci.context.AbstractContextCapture;
import info.novatec.inspectit.ci.context.impl.FieldContextCapture;
import info.novatec.inspectit.ci.context.impl.ParameterContextCapture;
import info.novatec.inspectit.ci.context.impl.ReturnContextCapture;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.ci.form.part.SensorAssignmentMasterBlock;
import info.novatec.inspectit.rcp.editor.tooltip.ColumnAwareToolTipSupport;
import info.novatec.inspectit.rcp.editor.viewers.ImageFixStyledCellIndexLabelProvider;
import info.novatec.inspectit.rcp.formatter.ImageFormatter;
import info.novatec.inspectit.rcp.formatter.TextFormatter;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;

public class SensorAssignmentTableProvider {
    private TableViewer tableViewer;

    public SensorAssignmentTableProvider(SensorAssignmentMasterBlock sensorAssignmentMasterBlock, Composite composite) {
        this.init(composite, sensorAssignmentMasterBlock);
    }

    private void init(Composite composite, ISelectionChangedListener iSelectionChangedListener) {
        Table table = new Table(composite, 66306);
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.tableViewer = new TableViewer(table);
        this.tableViewer.setUseHashlookup(false);
        this.createColumns(this.tableViewer);
        this.tableViewer.setContentProvider(this.getContentProvider());
        this.tableViewer.setLabelProvider(this.getLabelProvider());
        ColumnAwareToolTipSupport.enableFor((ColumnViewer)this.tableViewer);
        if (iSelectionChangedListener != null) {
            this.tableViewer.addSelectionChangedListener(iSelectionChangedListener);
        }
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    public void setInput(List<AbstractClassSensorAssignment<?>> list) {
        this.tableViewer.setInput(list);
        this.tableViewer.setSelection((ISelection)StructuredSelection.EMPTY);
    }

    private void createColumns(TableViewer tableViewer) {
        TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, 0);
        tableViewerColumn.getColumn().setResizable(true);
        tableViewerColumn.getColumn().setWidth(350);
        tableViewerColumn.getColumn().setText("Class");
        tableViewerColumn.getColumn().setImage(InspectIT.getDefault().getImage("/icons/eclipse/class_obj.gif"));
        tableViewerColumn.getColumn().setToolTipText("Fully qualified name of the class or interface.");
        TableViewerColumn tableViewerColumn2 = new TableViewerColumn(tableViewer, 0);
        tableViewerColumn2.getColumn().setResizable(true);
        tableViewerColumn2.getColumn().setWidth(450);
        tableViewerColumn2.getColumn().setText("Method");
        tableViewerColumn2.getColumn().setImage(InspectIT.getDefault().getImage("/icons/eclipse/methpub_obj.gif"));
        tableViewerColumn2.getColumn().setToolTipText("Method name with parameters. Note that constructors are displayed as '<init>' methods.");
        TableViewerColumn tableViewerColumn3 = new TableViewerColumn(tableViewer, 0);
        tableViewerColumn3.getColumn().setResizable(true);
        tableViewerColumn3.getColumn().setWidth(200);
        tableViewerColumn3.getColumn().setText("Options");
        tableViewerColumn3.getColumn().setToolTipText("Additional options that are defined for the sensor assignment.");
    }

    private IContentProvider getContentProvider() {
        return new ArrayContentProvider();
    }

    private IBaseLabelProvider getLabelProvider() {
        return new ImageFixStyledCellIndexLabelProvider(){
            private LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());
            private final StyledString empty = new StyledString("");

            @Override
            protected StyledString getStyledText(Object object, int n) {
                if (n == 0 && object instanceof AbstractClassSensorAssignment) {
                    AbstractClassSensorAssignment abstractClassSensorAssignment = (AbstractClassSensorAssignment)object;
                    if (abstractClassSensorAssignment.getClassName() != null) {
                        return new StyledString(abstractClassSensorAssignment.getClassName());
                    }
                } else if (1 == n && object instanceof MethodSensorAssignment) {
                    MethodSensorAssignment methodSensorAssignment = (MethodSensorAssignment)object;
                    return new StyledString(TextFormatter.getMethodWithParameters(methodSensorAssignment));
                }
                return this.empty;
            }

            @Override
            protected Image getColumnImage(Object object, int n) {
                if (n == 0 && object instanceof AbstractClassSensorAssignment) {
                    AbstractClassSensorAssignment abstractClassSensorAssignment = (AbstractClassSensorAssignment)object;
                    if (abstractClassSensorAssignment.isSuperclass()) {
                        return InspectIT.getDefault().getImage("/icons/eclipse/class_hierarchy.gif");
                    }
                    if (abstractClassSensorAssignment.isInterf()) {
                        return InspectIT.getDefault().getImage("/icons/eclipse/int_obj.gif");
                    }
                    return InspectIT.getDefault().getImage("/icons/eclipse/class_obj.gif");
                }
                if (1 == n && object instanceof MethodSensorAssignment) {
                    MethodSensorAssignment methodSensorAssignment = (MethodSensorAssignment)object;
                    return ImageFormatter.getMethodVisibilityImage((ResourceManager)this.resourceManager, methodSensorAssignment);
                }
                if (2 == n && object instanceof AbstractClassSensorAssignment) {
                    AbstractClassSensorAssignment abstractClassSensorAssignment = (AbstractClassSensorAssignment)object;
                    return ImageFormatter.getSensorAssignmentOptionsImage((ResourceManager)this.resourceManager, abstractClassSensorAssignment);
                }
                return super.getColumnImage(object, n);
            }

            @Override
            public String getToolTipText(Object object, int n) {
                if (n == 0 && object instanceof AbstractClassSensorAssignment) {
                    AbstractClassSensorAssignment abstractClassSensorAssignment = (AbstractClassSensorAssignment)object;
                    if (abstractClassSensorAssignment.isSuperclass()) {
                        return "Superclass instrumentation";
                    }
                    if (abstractClassSensorAssignment.isInterf()) {
                        return "Interface instrumentation";
                    }
                } else {
                    if (1 == n && object instanceof MethodSensorAssignment) {
                        MethodSensorAssignment methodSensorAssignment = (MethodSensorAssignment)object;
                        StringBuilder stringBuilder = new StringBuilder("Method visibility:");
                        if (methodSensorAssignment.isPublicModifier()) {
                            stringBuilder.append(" public,");
                        }
                        if (methodSensorAssignment.isProtectedModifier()) {
                            stringBuilder.append(" protected,");
                        }
                        if (methodSensorAssignment.isDefaultModifier()) {
                            stringBuilder.append(" default,");
                        }
                        if (methodSensorAssignment.isPrivateModifier()) {
                            stringBuilder.append(" private,");
                        }
                        return stringBuilder.deleteCharAt(stringBuilder.length() - 1).toString();
                    }
                    if (2 == n) {
                        AbstractClassSensorAssignment abstractClassSensorAssignment;
                        StringBuilder stringBuilder = new StringBuilder();
                        if (object instanceof AbstractClassSensorAssignment && StringUtils.isNotEmpty((String)(abstractClassSensorAssignment = (AbstractClassSensorAssignment)object).getAnnotation())) {
                            stringBuilder.append("Annotation filtering = " + abstractClassSensorAssignment.getAnnotation() + "\n");
                        }
                        if (object instanceof TimerMethodSensorAssignment) {
                            abstractClassSensorAssignment = (TimerMethodSensorAssignment)object;
                            if (abstractClassSensorAssignment.isStartsInvocation()) {
                                stringBuilder.append("Starts invocation = ON\n");
                            }
                            if (abstractClassSensorAssignment.isCharting()) {
                                stringBuilder.append("Charting = ON\n");
                            }
                            if (CollectionUtils.isNotEmpty((Collection)abstractClassSensorAssignment.getContextCaptures())) {
                                for (AbstractContextCapture abstractContextCapture : abstractClassSensorAssignment.getContextCaptures()) {
                                    if (abstractContextCapture instanceof ReturnContextCapture) {
                                        stringBuilder.append("Capture return value");
                                    } else if (abstractContextCapture instanceof ParameterContextCapture) {
                                        stringBuilder.append("Capture parameter (index " + ((ParameterContextCapture)abstractContextCapture).getIndex() + ")");
                                    } else if (abstractContextCapture instanceof FieldContextCapture) {
                                        stringBuilder.append("Capture field (named '" + ((FieldContextCapture)abstractContextCapture).getFieldName() + "')");
                                    }
                                    stringBuilder.append(" as '" + abstractContextCapture.getDisplayName() + "'");
                                    if (CollectionUtils.isNotEmpty((Collection)abstractContextCapture.getPaths())) {
                                        stringBuilder.append(" and follow path ");
                                        for (String string : abstractContextCapture.getPaths()) {
                                            stringBuilder.append(" -> ");
                                            stringBuilder.append(string);
                                        }
                                    }
                                    stringBuilder.append('\n');
                                }
                            }
                        }
                        if (stringBuilder.length() > 0) {
                            return stringBuilder.substring(0, stringBuilder.length() - 1);
                        }
                    }
                }
                return super.getToolTipText(object, n);
            }

            public void dispose() {
                this.resourceManager.dispose();
                super.dispose();
            }
        };
    }
}

