/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.ci.handler;

import info.novatec.inspectit.ci.Environment;
import info.novatec.inspectit.exception.BusinessException;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.dialog.EditNameDescriptionDialog;
import info.novatec.inspectit.rcp.provider.IEnvironmentProvider;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class EditEnvironmentHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        StructuredSelection structuredSelection = (StructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)executionEvent);
        if (structuredSelection.isEmpty()) {
            return null;
        }
        Object object = structuredSelection.getFirstElement();
        if (object instanceof IEnvironmentProvider) {
            IEnvironmentProvider iEnvironmentProvider = (IEnvironmentProvider)object;
            Environment environment = iEnvironmentProvider.getEnvironment();
            CmrRepositoryDefinition cmrRepositoryDefinition = iEnvironmentProvider.getCmrRepositoryDefinition();
            EditNameDescriptionDialog editNameDescriptionDialog = new EditNameDescriptionDialog(HandlerUtil.getActiveShell((ExecutionEvent)executionEvent), environment.getName(), environment.getDescription(), "Edit Environment", "Enter new environment name and/or description");
            if (editNameDescriptionDialog.open() == 0) {
                environment.setName(editNameDescriptionDialog.getName());
                if (StringUtils.isNotBlank((String)editNameDescriptionDialog.getDescription())) {
                    environment.setDescription(editNameDescriptionDialog.getDescription());
                }
                try {
                    Environment environment2 = cmrRepositoryDefinition.getConfigurationInterfaceService().updateEnvironment(environment);
                    InspectIT.getDefault().getInspectITConfigurationInterfaceManager().environmentUpdated(environment2, cmrRepositoryDefinition);
                }
                catch (BusinessException businessException) {
                    throw new ExecutionException("Update of the environment state failed.", (Throwable)businessException);
                }
            }
        }
        return null;
    }
}

