/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.ci.form.part;

import info.novatec.inspectit.ci.Environment;
import info.novatec.inspectit.ci.sensor.ISensorConfig;
import info.novatec.inspectit.ci.sensor.method.ILoggingSensorConfig;
import info.novatec.inspectit.ci.sensor.method.IMethodSensorConfig;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.ci.form.input.EnvironmentEditorInput;
import info.novatec.inspectit.rcp.formatter.ImageFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class LoggingSensorOptionsPart
extends SectionPart
implements IPropertyListener {
    private Environment environment;
    private final List<LoggingConfigurationComponent> logConfigComponents = new ArrayList<LoggingConfigurationComponent>();
    private final FormPage formPage;

    public LoggingSensorOptionsPart(FormPage formPage, Composite composite, FormToolkit formToolkit, int n) {
        super(composite, formToolkit, n);
        EnvironmentEditorInput environmentEditorInput = (EnvironmentEditorInput)formPage.getEditor().getEditorInput();
        this.environment = environmentEditorInput.getEnvironment();
        this.formPage = formPage;
        this.formPage.getEditor().addPropertyListener((IPropertyListener)this);
        this.createClient(this.getSection(), formToolkit);
        this.getSection().setText("Logging Sensor Options");
        Label label = formToolkit.createLabel((Composite)this.getSection(), "Define options for logging sensors");
        label.setForeground(formToolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.getSection().setDescriptionControl((Control)label);
    }

    private void createClient(Section section, FormToolkit formToolkit) {
        Object object2;
        Composite composite = formToolkit.createComposite((Composite)section);
        int n = 3;
        GridLayout gridLayout = new GridLayout(n, false);
        gridLayout.horizontalSpacing = 10;
        composite.setLayout((Layout)gridLayout);
        section.setClient((Control)composite);
        for (Object object2 : this.environment.getMethodSensorConfigs()) {
            if (!(object2 instanceof ILoggingSensorConfig)) continue;
            LoggingConfigurationComponent loggingConfigurationComponent = new LoggingConfigurationComponent((ILoggingSensorConfig)object2);
            this.logConfigComponents.add(loggingConfigurationComponent);
            loggingConfigurationComponent.createComponent(composite, formToolkit, "Select the minimum level that a logging needs to have in order to be captured. For example, when selecting WARN all log with FATAL, ERROR or WARN level will be captured by inspectIT.", n);
        }
        object2 = new Listener(){

            public void handleEvent(Event event) {
                if (!LoggingSensorOptionsPart.this.isDirty()) {
                    LoggingSensorOptionsPart.this.markDirty();
                }
            }
        };
        for (LoggingConfigurationComponent loggingConfigurationComponent : this.logConfigComponents) {
            loggingConfigurationComponent.addDirtyListener((Listener)object2);
        }
    }

    public void commit(boolean bl) {
        if (bl) {
            super.commit(bl);
            for (LoggingConfigurationComponent loggingConfigurationComponent : this.logConfigComponents) {
                loggingConfigurationComponent.update();
            }
        }
    }

    private static Object getIndentGridData() {
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalIndent = 20;
        return gridData;
    }

    private static void createInfoLabel(Composite composite, FormToolkit formToolkit, String string) {
        Label label = formToolkit.createLabel(composite, "");
        if (string != null) {
            label.setToolTipText(string);
            label.setImage(InspectIT.getDefault().getImage("/icons/eclipse/info_obj.gif"));
        }
    }

    public void propertyChanged(Object object, int n) {
        if (n == 258) {
            EnvironmentEditorInput environmentEditorInput = (EnvironmentEditorInput)this.formPage.getEditor().getEditorInput();
            this.environment = environmentEditorInput.getEnvironment();
            block0: for (LoggingConfigurationComponent loggingConfigurationComponent : this.logConfigComponents) {
                for (IMethodSensorConfig iMethodSensorConfig : this.environment.getMethodSensorConfigs()) {
                    if (iMethodSensorConfig instanceof ILoggingSensorConfig && loggingConfigurationComponent.updateSensorConfig((ILoggingSensorConfig)iMethodSensorConfig)) continue block0;
                }
            }
        }
    }

    public void dispose() {
        this.formPage.getEditor().removePropertyListener((IPropertyListener)this);
        super.dispose();
    }

    private static class LoggingConfigurationComponent {
        private ILoggingSensorConfig sensorConfig;
        private Combo levelCombo;

        LoggingConfigurationComponent(ILoggingSensorConfig iLoggingSensorConfig) {
            this.sensorConfig = iLoggingSensorConfig;
        }

        public void createComponent(Composite composite, FormToolkit formToolkit, String string, int n) {
            FormText formText = formToolkit.createFormText(composite, false);
            formText.setText("<form><p><img href=\"img\" /> <b>" + this.sensorConfig.getTechnologyName() + "</b></p></form>", true, false);
            formText.setImage("img", ImageFormatter.getSensorConfigImage((ISensorConfig)this.sensorConfig));
            formText.setLayoutData((Object)new GridData(4, 4, true, false, n, 1));
            formToolkit.createLabel(composite, "Minimum level:").setLayoutData(LoggingSensorOptionsPart.getIndentGridData());
            this.levelCombo = new Combo(composite, 8);
            formToolkit.adapt((Control)this.levelCombo, false, false);
            String[] stringArray = this.sensorConfig.getLogLevels();
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                String string2 = stringArray[n3];
                this.levelCombo.add(string2);
                ++n3;
            }
            LoggingSensorOptionsPart.createInfoLabel(composite, formToolkit, string);
            this.fillValue();
        }

        public void addDirtyListener(Listener listener) {
            this.levelCombo.addListener(13, listener);
        }

        public void update() {
            this.sensorConfig.setMinLevel(this.levelCombo.getText());
        }

        private void fillValue() {
            String string = this.sensorConfig.getMinLevel();
            this.levelCombo.select(this.levelCombo.indexOf(string));
        }

        public boolean updateSensorConfig(ILoggingSensorConfig iLoggingSensorConfig) {
            if (Objects.equals(this.sensorConfig.getClassName(), iLoggingSensorConfig.getClassName())) {
                this.sensorConfig = iLoggingSensorConfig;
                return true;
            }
            return false;
        }
    }
}

