/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.ci.form.part;

import info.novatec.inspectit.ci.Environment;
import info.novatec.inspectit.ci.strategy.IStrategyConfig;
import info.novatec.inspectit.ci.strategy.impl.ListSendingStrategyConfig;
import info.novatec.inspectit.ci.strategy.impl.SimpleBufferStrategyConfig;
import info.novatec.inspectit.ci.strategy.impl.SizeBufferStrategyConfig;
import info.novatec.inspectit.ci.strategy.impl.TimeSendingStrategyConfig;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.ci.form.input.EnvironmentEditorInput;
import info.novatec.inspectit.rcp.validation.ValidationControlDecoration;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class EnvironmentSettingsPart
extends SectionPart
implements IPropertyListener {
    private static final String SIZE_BUFFER_STRATEGY = "Size buffer";
    private static final String SIMPLE_BUFFER_STRATEGY = "Simple buffer";
    private static final String LIST_SENDING_STRATEGY = "List size strategy";
    private static final String TIME_SENDING_STRATEGY = "Time strategy";
    private FormPage formPage;
    private Environment environment;
    private ValidationControlDecoration<Text> sendingValueDecoration;
    private ValidationControlDecoration<Text> bufferValueDecoration;
    private Text sendingValue;
    private Text bufferValue;
    private Combo sendingCombo;
    private Combo bufferCombo;
    private Button classDelegationButton;

    public EnvironmentSettingsPart(FormPage formPage, Composite composite, FormToolkit formToolkit, int n) {
        super(composite, formToolkit, n);
        EnvironmentEditorInput environmentEditorInput = (EnvironmentEditorInput)formPage.getEditor().getEditorInput();
        this.environment = environmentEditorInput.getEnvironment();
        this.formPage = formPage;
        this.formPage.getEditor().addPropertyListener((IPropertyListener)this);
        this.createPart(this.getSection(), formToolkit);
        this.getSection().setText("Strategies");
        Label label = formToolkit.createLabel((Composite)this.getSection(), "Define sending and buffer strategies");
        label.setForeground(formToolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.getSection().setDescriptionControl((Control)label);
    }

    private void createPart(Section section, FormToolkit formToolkit) {
        Composite composite = formToolkit.createComposite((Composite)section);
        GridLayout gridLayout = new GridLayout(4, false);
        gridLayout.horizontalSpacing = 10;
        composite.setLayout((Layout)gridLayout);
        section.setClient((Control)composite);
        formToolkit.createLabel(composite, "Sending strategy:").setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.sendingCombo = new Combo(composite, 12);
        this.sendingCombo.setLayoutData((Object)new GridData(4, 4, true, false));
        formToolkit.adapt((Control)this.sendingCombo, false, false);
        this.sendingValue = formToolkit.createText(composite, "", 133120);
        GridData gridData = new GridData(4, 4, false, false);
        gridData.widthHint = 50;
        this.sendingValue.setLayoutData((Object)gridData);
        this.createInfoLabel(composite, formToolkit, "The time strategy will cause the Agent to send its measurements after a specified interval in milliseconds.\nThe list size strategy will cause the Agent to send its measurements after a specified size of value objects is reached.");
        formToolkit.createLabel(composite, "Buffer strategy:").setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.bufferCombo = new Combo(composite, 12);
        this.bufferCombo.setLayoutData((Object)new GridData(4, 4, true, false));
        formToolkit.adapt((Control)this.bufferCombo, false, false);
        this.bufferValue = formToolkit.createText(composite, "", 133120);
        gridData = new GridData(4, 4, false, false);
        gridData.widthHint = 50;
        this.bufferValue.setLayoutData((Object)gridData);
        this.createInfoLabel(composite, formToolkit, "The simple version of a buffer is apparently no buffer at all. It contains exactly one element. This is useful if old data isn't necessary or maybe the memory of the application is very limited.\nThe Size buffer strategy needs specification of the size of this buffer. This buffer works as a FILO stack, so last added elements will be sent first (as they are more important), and old ones are thrown away if this buffer is full");
        this.sendingCombo.add(TIME_SENDING_STRATEGY);
        this.sendingCombo.add(LIST_SENDING_STRATEGY);
        IStrategyConfig iStrategyConfig = this.environment.getSendingStrategyConfig();
        if (iStrategyConfig instanceof TimeSendingStrategyConfig) {
            this.sendingCombo.setData(TIME_SENDING_STRATEGY, (Object)iStrategyConfig);
            this.sendingCombo.setData(LIST_SENDING_STRATEGY, (Object)new ListSendingStrategyConfig());
            this.sendingCombo.select(0);
            this.sendingValue.setText(String.valueOf(((TimeSendingStrategyConfig)iStrategyConfig).getTime()));
        } else if (iStrategyConfig instanceof ListSendingStrategyConfig) {
            this.sendingCombo.setData(TIME_SENDING_STRATEGY, (Object)new TimeSendingStrategyConfig());
            this.sendingCombo.setData(LIST_SENDING_STRATEGY, (Object)iStrategyConfig);
            this.sendingCombo.select(1);
            this.sendingValue.setText(String.valueOf(((ListSendingStrategyConfig)iStrategyConfig).getListSize()));
        }
        this.bufferCombo.add(SIMPLE_BUFFER_STRATEGY);
        this.bufferCombo.add(SIZE_BUFFER_STRATEGY);
        IStrategyConfig iStrategyConfig2 = this.environment.getBufferStrategyConfig();
        if (iStrategyConfig2 instanceof SimpleBufferStrategyConfig) {
            this.bufferCombo.setData(SIMPLE_BUFFER_STRATEGY, (Object)iStrategyConfig2);
            this.bufferCombo.setData(SIZE_BUFFER_STRATEGY, (Object)new SizeBufferStrategyConfig());
            this.bufferCombo.select(0);
            this.bufferValue.setEnabled(false);
        } else if (iStrategyConfig2 instanceof SizeBufferStrategyConfig) {
            this.bufferCombo.setData(SIMPLE_BUFFER_STRATEGY, (Object)new SimpleBufferStrategyConfig());
            this.bufferCombo.setData(SIZE_BUFFER_STRATEGY, (Object)iStrategyConfig2);
            this.bufferCombo.select(1);
            this.bufferValue.setText(String.valueOf(((SizeBufferStrategyConfig)iStrategyConfig2).getSize()));
        }
        this.sendingCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Object object = EnvironmentSettingsPart.this.sendingCombo.getData(EnvironmentSettingsPart.this.sendingCombo.getItem(EnvironmentSettingsPart.this.sendingCombo.getSelectionIndex()));
                if (object instanceof TimeSendingStrategyConfig) {
                    EnvironmentSettingsPart.this.sendingValue.setText(String.valueOf(((TimeSendingStrategyConfig)object).getTime()));
                } else if (object instanceof ListSendingStrategyConfig) {
                    EnvironmentSettingsPart.this.sendingValue.setText(String.valueOf(((ListSendingStrategyConfig)object).getListSize()));
                }
            }
        });
        this.bufferCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Object object = EnvironmentSettingsPart.this.bufferCombo.getData(EnvironmentSettingsPart.this.bufferCombo.getItem(EnvironmentSettingsPart.this.bufferCombo.getSelectionIndex()));
                if (object instanceof SimpleBufferStrategyConfig) {
                    EnvironmentSettingsPart.this.bufferValue.setEnabled(false);
                    EnvironmentSettingsPart.this.bufferValue.setText("");
                } else if (object instanceof SizeBufferStrategyConfig) {
                    EnvironmentSettingsPart.this.bufferValue.setEnabled(true);
                    EnvironmentSettingsPart.this.bufferValue.setText(String.valueOf(((SizeBufferStrategyConfig)object).getSize()));
                }
            }
        });
        this.sendingValueDecoration = new ValidationControlDecoration<Text>(this.sendingValue, this.formPage.getManagedForm().getMessageManager()){

            @Override
            protected boolean validate(Text text) {
                return EnvironmentSettingsPart.this.validateUpdateSendingStrategy(false);
            }
        };
        this.sendingValueDecoration.registerListener(24);
        this.bufferValueDecoration = new ValidationControlDecoration<Text>(this.bufferValue, this.formPage.getManagedForm().getMessageManager()){

            @Override
            protected boolean validate(Text text) {
                return EnvironmentSettingsPart.this.validateUpdateBufferStrategy(false);
            }
        };
        this.bufferValueDecoration.registerListener(24);
        formToolkit.createLabel(composite, "Class loading delegation:").setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.classDelegationButton = formToolkit.createButton(composite, "Active", 32);
        this.classDelegationButton.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.classDelegationButton.setSelection(this.environment.isClassLoadingDelegation());
        this.createInfoLabel(composite, formToolkit, "If activated all sub-classes of java.lang.ClassLoader will be instrumented so that loading of the inspectIT classes is delegated to the inspectIT class loader. Should only be changed to false in rare cases and is expert user level option.");
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                if (!EnvironmentSettingsPart.this.isDirty()) {
                    EnvironmentSettingsPart.this.markDirty();
                }
            }
        };
        this.sendingCombo.addListener(13, listener);
        this.bufferCombo.addListener(13, listener);
        this.sendingValue.addListener(24, listener);
        this.bufferValue.addListener(24, listener);
        this.classDelegationButton.addListener(13, listener);
    }

    public void commit(boolean bl) {
        if (bl) {
            super.commit(bl);
            this.validateUpdateSendingStrategy(true);
            this.validateUpdateBufferStrategy(true);
            this.environment.setClassLoadingDelegation(this.classDelegationButton.getSelection());
            this.getManagedForm().dirtyStateChanged();
        }
    }

    private boolean validateUpdateSendingStrategy(boolean bl) {
        boolean bl2 = true;
        IStrategyConfig iStrategyConfig = (IStrategyConfig)this.sendingCombo.getData(this.sendingCombo.getItem(this.sendingCombo.getSelectionIndex()));
        if (iStrategyConfig instanceof TimeSendingStrategyConfig) {
            try {
                long l = Long.parseLong(this.sendingValue.getText());
                if (l <= 0L) {
                    this.showTimeSendingStrategyValidationMessage();
                    bl2 = false;
                } else if (bl) {
                    ((TimeSendingStrategyConfig)iStrategyConfig).setTime(l);
                    this.environment.setSendingStrategyConfig(iStrategyConfig);
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.showTimeSendingStrategyValidationMessage();
                bl2 = false;
            }
        } else if (iStrategyConfig instanceof ListSendingStrategyConfig) {
            try {
                int n = Integer.parseInt(this.sendingValue.getText());
                if (n <= 0) {
                    this.showListSendingStrategyValidationMessage();
                    bl2 = false;
                } else if (bl) {
                    ((ListSendingStrategyConfig)iStrategyConfig).setListSize(n);
                    this.environment.setSendingStrategyConfig(iStrategyConfig);
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.showListSendingStrategyValidationMessage();
                bl2 = false;
            }
        }
        return bl2;
    }

    private boolean validateUpdateBufferStrategy(boolean bl) {
        boolean bl2 = true;
        IStrategyConfig iStrategyConfig = (IStrategyConfig)this.bufferCombo.getData(this.bufferCombo.getItem(this.bufferCombo.getSelectionIndex()));
        if (iStrategyConfig instanceof SizeBufferStrategyConfig) {
            try {
                int n = Integer.parseInt(this.bufferValue.getText());
                if (n <= 0) {
                    this.showSizeBufferStrategyValidationMessage();
                    bl2 = false;
                } else if (bl) {
                    ((SizeBufferStrategyConfig)iStrategyConfig).setSize(n);
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.showSizeBufferStrategyValidationMessage();
                bl2 = false;
            }
        }
        if (bl) {
            this.environment.setBufferStrategyConfig(iStrategyConfig);
        }
        return bl2;
    }

    private void showTimeSendingStrategyValidationMessage() {
        this.sendingValueDecoration.setDescriptionText("Time sending strategy must define a positive number of milliseconds.");
    }

    private void showListSendingStrategyValidationMessage() {
        this.sendingValueDecoration.setDescriptionText("List sending strategy must define a list size greater than zero.");
    }

    private void showSizeBufferStrategyValidationMessage() {
        this.bufferValueDecoration.setDescriptionText("Size buffer strategy must define a buffer size greater than zero.");
    }

    protected void createInfoLabel(Composite composite, FormToolkit formToolkit, String string) {
        Label label = formToolkit.createLabel(composite, "");
        label.setToolTipText(string);
        label.setImage(InspectIT.getDefault().getImage("/icons/eclipse/info_obj.gif"));
    }

    public void propertyChanged(Object object, int n) {
        if (n == 258) {
            EnvironmentEditorInput environmentEditorInput = (EnvironmentEditorInput)this.formPage.getEditor().getEditorInput();
            this.environment = environmentEditorInput.getEnvironment();
        }
    }

    public void dispose() {
        this.formPage.getEditor().removePropertyListener((IPropertyListener)this);
        super.dispose();
    }
}

