/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.wizard.page;

import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import info.novatec.inspectit.storage.StorageData;
import info.novatec.inspectit.storage.recording.RecordingState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class SelectExistingStorageWizardPage
extends WizardPage {
    private static final String DEFAULT_MESSAGE = "Select storage and repository where data will be stored";
    private List<CmrRepositoryDefinition> cmrRepositories;
    private CmrRepositoryDefinition proposedCmrRepositoryDefinition;
    private List<StorageData> storageList = new ArrayList<StorageData>();
    private Combo cmrRepositoryCombo;
    private org.eclipse.swt.widgets.List storageSelection;
    private boolean checkRecording;
    private Button autoFinalize;

    public SelectExistingStorageWizardPage() {
        super("Select Storage");
        this.setTitle("Select Storage");
        this.setMessage(DEFAULT_MESSAGE);
        this.cmrRepositories = new ArrayList<CmrRepositoryDefinition>();
        this.cmrRepositories.addAll(InspectIT.getDefault().getCmrRepositoryManager().getCmrRepositoryDefinitions());
    }

    public SelectExistingStorageWizardPage(boolean bl) {
        this();
        this.checkRecording = bl;
    }

    public SelectExistingStorageWizardPage(CmrRepositoryDefinition cmrRepositoryDefinition, boolean bl) {
        this();
        this.proposedCmrRepositoryDefinition = cmrRepositoryDefinition;
        this.checkRecording = bl;
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(composite2, 16384);
        label.setText("Repository:");
        this.cmrRepositoryCombo = new Combo(composite2, 8);
        this.cmrRepositoryCombo.setLayoutData((Object)new GridData(4, 4, true, false));
        Label label2 = new Label(composite2, 128);
        label2.setText("Storage:");
        label2.setLayoutData((Object)new GridData(4, 128, false, false));
        this.storageSelection = new org.eclipse.swt.widgets.List(composite2, 2820);
        this.storageSelection.setEnabled(false);
        this.storageSelection.setLayoutData((Object)new GridData(4, 4, true, true));
        new Label(composite2, 16384);
        this.autoFinalize = new Button(composite2, 32);
        this.autoFinalize.setLayoutData((Object)new GridData(4, 4, true, false));
        this.autoFinalize.setText("Auto-finalize storage");
        this.autoFinalize.setToolTipText("If selected the storage will be automatically finalized after the action completes");
        this.autoFinalize.setSelection(true);
        final Listener listener = new Listener(){

            public void handleEvent(Event event) {
                SelectExistingStorageWizardPage.this.setPageComplete(SelectExistingStorageWizardPage.this.isPageComplete());
                if (SelectExistingStorageWizardPage.this.getSelectedRepository() == null) {
                    SelectExistingStorageWizardPage.this.setMessage("Repository must be selected.", 3);
                } else if (SelectExistingStorageWizardPage.this.getSelectedRepository().getOnlineStatus() == CmrRepositoryDefinition.OnlineStatus.OFFLINE) {
                    SelectExistingStorageWizardPage.this.setMessage("Selected repository is currently offline.", 3);
                } else if (SelectExistingStorageWizardPage.this.checkRecording && SelectExistingStorageWizardPage.this.getSelectedRepository().getStorageService().getRecordingState() != RecordingState.OFF) {
                    SelectExistingStorageWizardPage.this.setMessage("Recording is already active on selected repository.", 3);
                } else if (SelectExistingStorageWizardPage.this.getSelectedStorageData() == null) {
                    SelectExistingStorageWizardPage.this.setMessage("Storage must be selected.", 3);
                } else {
                    SelectExistingStorageWizardPage.this.setMessage(SelectExistingStorageWizardPage.DEFAULT_MESSAGE);
                }
            }
        };
        this.cmrRepositoryCombo.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SelectExistingStorageWizardPage.this.updateStorageList();
                listener.handleEvent(event);
            }
        });
        this.storageSelection.addListener(13, listener);
        int n = 0;
        int n2 = -1;
        for (CmrRepositoryDefinition cmrRepositoryDefinition : this.cmrRepositories) {
            this.cmrRepositoryCombo.add(String.valueOf(cmrRepositoryDefinition.getName()) + " (" + cmrRepositoryDefinition.getIp() + ":" + cmrRepositoryDefinition.getName() + ")");
            if (cmrRepositoryDefinition.equals(this.proposedCmrRepositoryDefinition)) {
                n2 = n;
            }
            ++n;
        }
        if (n2 != -1) {
            this.cmrRepositoryCombo.select(n2);
            this.cmrRepositoryCombo.setEnabled(false);
            this.updateStorageList();
        }
        this.setControl((Control)composite2);
    }

    public CmrRepositoryDefinition getSelectedRepository() {
        if (this.cmrRepositoryCombo.getSelectionIndex() != -1) {
            return this.cmrRepositories.get(this.cmrRepositoryCombo.getSelectionIndex());
        }
        return null;
    }

    public StorageData getSelectedStorageData() {
        if (this.storageSelection.getSelectionIndex() != -1) {
            return this.storageList.get(this.storageSelection.getSelectionIndex());
        }
        return null;
    }

    public boolean isAutoFinalize() {
        return this.autoFinalize.getSelection();
    }

    public boolean isPageComplete() {
        if (this.getSelectedRepository() == null) {
            return false;
        }
        if (this.getSelectedRepository().getOnlineStatus() == CmrRepositoryDefinition.OnlineStatus.OFFLINE) {
            return false;
        }
        if (this.checkRecording && this.getSelectedRepository().getStorageService().getRecordingState() != RecordingState.OFF) {
            return false;
        }
        return this.getSelectedStorageData() != null;
    }

    private void updateStorageList() {
        final CmrRepositoryDefinition cmrRepositoryDefinition = this.getSelectedRepository();
        Job job = new Job("Updating Storages"){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                if (cmrRepositoryDefinition != null && cmrRepositoryDefinition.getOnlineStatus() != CmrRepositoryDefinition.OnlineStatus.OFFLINE) {
                    SelectExistingStorageWizardPage.this.storageList = cmrRepositoryDefinition.getStorageService().getOpenedStorages();
                } else {
                    SelectExistingStorageWizardPage.this.storageList = Collections.emptyList();
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        SelectExistingStorageWizardPage.this.storageSelection.removeAll();
                        if (cmrRepositoryDefinition != null && cmrRepositoryDefinition.getOnlineStatus() != CmrRepositoryDefinition.OnlineStatus.OFFLINE) {
                            if (SelectExistingStorageWizardPage.this.storageList.isEmpty()) {
                                SelectExistingStorageWizardPage.this.storageSelection.add("No open storage available for writing");
                                SelectExistingStorageWizardPage.this.storageSelection.setEnabled(false);
                            } else {
                                for (StorageData storageData : SelectExistingStorageWizardPage.this.storageList) {
                                    SelectExistingStorageWizardPage.this.storageSelection.add(storageData.getName());
                                }
                                SelectExistingStorageWizardPage.this.storageSelection.setEnabled(true);
                            }
                        } else {
                            SelectExistingStorageWizardPage.this.storageSelection.setEnabled(false);
                        }
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }
}

