/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.wizard.page;

import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import info.novatec.inspectit.storage.StorageFileType;
import java.util.List;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class ImportStorageSelectPage
extends WizardPage {
    private static final String DEFAULT_MESSAGE = "Select a file to import and a destination";
    private List<CmrRepositoryDefinition> cmrRepositoryList;
    private Button locallyButton;
    private Combo cmrCombo;
    private Text fileText;

    public ImportStorageSelectPage() {
        super("Import Storage");
        this.setTitle("Import Storage");
        this.setMessage(DEFAULT_MESSAGE);
        this.cmrRepositoryList = InspectIT.getDefault().getCmrRepositoryManager().getCmrRepositoryDefinitions();
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(3, false));
        new Label(composite2, 0).setText("File:");
        this.fileText = new Text(composite2, 2056);
        this.fileText.setLayoutData((Object)new GridData(4, 4, true, false));
        Button button = new Button(composite2, 8);
        button.setText("Select");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileDialog fileDialog = new FileDialog(ImportStorageSelectPage.this.getShell(), 4096);
                fileDialog.setText("Select File to Import");
                fileDialog.setFilterExtensions(new String[]{"*" + StorageFileType.ZIP_STORAGE_FILE.getExtension()});
                String string = fileDialog.open();
                if (string != null) {
                    ImportStorageSelectPage.this.fileText.setText(string);
                }
            }
        });
        Label label = new Label(composite2, 0);
        label.setText("Import to:");
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.locallyButton = new Button(composite2, 16);
        this.locallyButton.setSelection(true);
        this.locallyButton.setText("Local machine");
        this.locallyButton.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.locallyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ImportStorageSelectPage.this.cmrCombo.setEnabled(!ImportStorageSelectPage.this.locallyButton.getSelection());
            }
        });
        new Label(composite2, 0);
        Button button2 = new Button(composite2, 16);
        button2.setText("CMR Repository");
        button2.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        new Label(composite2, 0);
        this.cmrCombo = new Combo(composite2, 12);
        for (CmrRepositoryDefinition object2 : this.cmrRepositoryList) {
            this.cmrCombo.add(object2.getName());
        }
        this.cmrCombo.setEnabled(false);
        this.cmrCombo.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                ImportStorageSelectPage.this.setPageComplete(ImportStorageSelectPage.this.isPageComplete());
                if (ImportStorageSelectPage.this.fileText.getText().isEmpty()) {
                    ImportStorageSelectPage.this.setMessage("No file selected", 3);
                    return;
                }
                if (!ImportStorageSelectPage.this.locallyButton.getSelection()) {
                    if (ImportStorageSelectPage.this.cmrCombo.getSelectionIndex() == -1) {
                        ImportStorageSelectPage.this.setMessage("No CMR Repository selected", 3);
                        return;
                    }
                    CmrRepositoryDefinition cmrRepositoryDefinition = (CmrRepositoryDefinition)ImportStorageSelectPage.this.cmrRepositoryList.get(ImportStorageSelectPage.this.cmrCombo.getSelectionIndex());
                    if (cmrRepositoryDefinition.getOnlineStatus() == CmrRepositoryDefinition.OnlineStatus.OFFLINE) {
                        ImportStorageSelectPage.this.setMessage("Selected CMR Repository is offline.", 3);
                        return;
                    }
                }
                ImportStorageSelectPage.this.setMessage(ImportStorageSelectPage.DEFAULT_MESSAGE);
            }
        };
        button.addListener(13, listener);
        this.locallyButton.addListener(13, listener);
        this.cmrCombo.addListener(13, listener);
        button.forceFocus();
        this.setControl((Control)composite2);
    }

    public boolean isPageComplete() {
        if (this.fileText.getText().isEmpty()) {
            return false;
        }
        if (!this.locallyButton.getSelection()) {
            if (this.cmrCombo.getSelectionIndex() == -1) {
                return false;
            }
            CmrRepositoryDefinition cmrRepositoryDefinition = this.cmrRepositoryList.get(this.cmrCombo.getSelectionIndex());
            if (cmrRepositoryDefinition.getOnlineStatus() == CmrRepositoryDefinition.OnlineStatus.OFFLINE) {
                return false;
            }
        }
        return true;
    }

    public String getFileName() {
        return this.fileText.getText();
    }

    public boolean isImportLocally() {
        return this.locallyButton.getSelection();
    }

    public CmrRepositoryDefinition getCmrRepositoryDefinition() {
        if (-1 != this.cmrCombo.getSelectionIndex()) {
            return this.cmrRepositoryList.get(this.cmrCombo.getSelectionIndex());
        }
        return null;
    }
}

