/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.wizard.page;

import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.communication.data.ClassLoadingInformationData;
import info.novatec.inspectit.communication.data.CompilationInformationData;
import info.novatec.inspectit.communication.data.CpuInformationData;
import info.novatec.inspectit.communication.data.ExceptionSensorData;
import info.novatec.inspectit.communication.data.HttpTimerData;
import info.novatec.inspectit.communication.data.InvocationSequenceData;
import info.novatec.inspectit.communication.data.JmxSensorValueData;
import info.novatec.inspectit.communication.data.MemoryInformationData;
import info.novatec.inspectit.communication.data.SqlStatementData;
import info.novatec.inspectit.communication.data.SystemInformationData;
import info.novatec.inspectit.communication.data.ThreadInformationData;
import info.novatec.inspectit.communication.data.TimerData;
import info.novatec.inspectit.indexing.aggregation.IAggregator;
import info.novatec.inspectit.indexing.aggregation.impl.SqlStatementDataAggregator;
import info.novatec.inspectit.indexing.aggregation.impl.TimerDataAggregator;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.storage.processor.AbstractDataProcessor;
import info.novatec.inspectit.storage.processor.impl.DataAggregatorProcessor;
import info.novatec.inspectit.storage.processor.impl.DataSaverProcessor;
import info.novatec.inspectit.storage.processor.impl.InvocationClonerDataProcessor;
import info.novatec.inspectit.storage.processor.impl.InvocationExtractorDataProcessor;
import info.novatec.inspectit.util.ObjectUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class DefineDataProcessorsWizardPage
extends WizardPage {
    public static final int BUFFER_DATA = 1;
    public static final int SYSTEM_DATA = 2;
    public static final int EXTRACT_INVOCATIONS = 4;
    public static final int ONLY_INVOCATIONS = 8;
    public static final int ONLY_TIMERS = 16;
    public static final int ONLY_SQL_STATEMENTS = 32;
    public static final int ONLY_HTTP_TIMERS = 64;
    public static final int ONLY_EXCEPTIONS = 128;
    private static final String DEFAULT_MESSAGE = "Define the data that should be stored in the storage and additional options";
    private Set<Class<?>> inputList = new HashSet();
    private int selectionStyle;
    private Table table;
    private Spinner aggregationPeriodSpiner;
    private Listener pageCompleteListener = new Listener(){

        public void handleEvent(Event event) {
            DefineDataProcessorsWizardPage.this.setPageComplete(DefineDataProcessorsWizardPage.this.isPageComplete());
        }
    };

    public DefineDataProcessorsWizardPage(int n) {
        super("Define Data");
        this.setTitle("Define Data");
        this.setDescription(DEFAULT_MESSAGE);
        this.selectionStyle = n;
        if (this.isStyleApplied(1) || this.isStyleApplied(8)) {
            this.inputList.add(TimerData.class);
            this.inputList.add(HttpTimerData.class);
            this.inputList.add(SqlStatementData.class);
            this.inputList.add(InvocationSequenceData.class);
            this.inputList.add(ExceptionSensorData.class);
        }
        if (this.isStyleApplied(16)) {
            this.inputList.add(TimerData.class);
            this.inputList.add(InvocationSequenceData.class);
        }
        if (this.isStyleApplied(32)) {
            this.inputList.add(SqlStatementData.class);
            this.inputList.add(InvocationSequenceData.class);
        }
        if (this.isStyleApplied(64)) {
            this.inputList.add(HttpTimerData.class);
            this.inputList.add(InvocationSequenceData.class);
        }
        if (this.isStyleApplied(128)) {
            this.inputList.add(ExceptionSensorData.class);
            this.inputList.add(InvocationSequenceData.class);
        }
        if (this.isStyleApplied(2)) {
            this.inputList.add(MemoryInformationData.class);
            this.inputList.add(CpuInformationData.class);
            this.inputList.add(ClassLoadingInformationData.class);
            this.inputList.add(CompilationInformationData.class);
            this.inputList.add(ThreadInformationData.class);
            this.inputList.add(SystemInformationData.class);
            this.inputList.add(JmxSensorValueData.class);
        }
    }

    public void createControl(Composite composite) {
        TableItem tableItem;
        int n;
        int n2;
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(4, false));
        this.table = new Table(composite2, 68128);
        this.table.setHeaderVisible(false);
        this.table.setLinesVisible(false);
        this.table.setLayoutData((Object)new GridData(4, 4, true, true, 3, 2));
        TableViewer tableViewer = new TableViewer(this.table);
        TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, 16384);
        tableViewerColumn.getColumn().setWidth(300);
        tableViewerColumn.getColumn().setMoveable(false);
        tableViewerColumn.getColumn().setResizable(false);
        tableViewerColumn.setLabelProvider((CellLabelProvider)new DataColumnLabelProvider());
        tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        tableViewer.setInput(this.inputList);
        tableViewer.refresh();
        if (this.isStyleApplied(1) || this.isStyleApplied(2)) {
            TableItem[] tableItemArray = this.table.getItems();
            n2 = tableItemArray.length;
            n = 0;
            while (n < n2) {
                tableItem = tableItemArray[n];
                tableItem.setChecked(true);
                ++n;
            }
        } else {
            TableItem[] tableItemArray = this.table.getItems();
            n2 = tableItemArray.length;
            n = 0;
            while (n < n2) {
                tableItem = tableItemArray[n];
                if (ObjectUtils.equals((Object)tableItem.getData(), InvocationSequenceData.class) && this.isStyleApplied(8)) {
                    tableItem.setChecked(true);
                } else if (ObjectUtils.equals((Object)tableItem.getData(), TimerData.class) && this.isStyleApplied(16)) {
                    tableItem.setChecked(true);
                } else if (ObjectUtils.equals((Object)tableItem.getData(), SqlStatementData.class) && this.isStyleApplied(32)) {
                    tableItem.setChecked(true);
                } else if (ObjectUtils.equals((Object)tableItem.getData(), ExceptionSensorData.class) && this.isStyleApplied(128)) {
                    tableItem.setChecked(true);
                } else if (ObjectUtils.equals((Object)tableItem.getData(), HttpTimerData.class) && this.isStyleApplied(64)) {
                    tableItem.setChecked(true);
                } else {
                    tableItem.setChecked(false);
                }
                ++n;
            }
        }
        tableItem = new Button(composite2, 8);
        tableItem.setText("Select All");
        tableItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TableItem[] tableItemArray = DefineDataProcessorsWizardPage.this.table.getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem tableItem = tableItemArray[n2];
                    tableItem.setChecked(true);
                    DefineDataProcessorsWizardPage.this.aggregationPeriodSpiner.setEnabled(true);
                    ++n2;
                }
            }
        });
        tableItem.setLayoutData((Object)new GridData(4, 128, true, false));
        Button button = new Button(composite2, 8);
        button.setText("Deselect All");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TableItem[] tableItemArray = DefineDataProcessorsWizardPage.this.table.getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem tableItem = tableItemArray[n2];
                    tableItem.setChecked(false);
                    DefineDataProcessorsWizardPage.this.aggregationPeriodSpiner.setEnabled(false);
                    ++n2;
                }
            }
        });
        button.setLayoutData((Object)new GridData(4, 128, true, false));
        Label label = new Label(composite2, 64);
        label.setImage(JFaceResources.getImage((String)"dialog_messasge_info_image"));
        label.setToolTipText("All Timer and SQL Statement Data objects need to be aggregated before saved to the storage, because the amount of objects to be saved is in most cases too high and can impose performance problems while writing to disk. Thus, please select the aggregation period for these two data types.");
        new Label(composite2, 0).setText("Aggregation period for Timer and SQL Statement Data:");
        this.aggregationPeriodSpiner = new Spinner(composite2, 2048);
        this.aggregationPeriodSpiner.setMinimum(5);
        this.aggregationPeriodSpiner.setIncrement(5);
        this.aggregationPeriodSpiner.setSelection(5);
        new Label(composite2, 0).setText("seconds");
        this.table.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 32) {
                    DefineDataProcessorsWizardPage.this.aggregationPeriodSpiner.setEnabled(DefineDataProcessorsWizardPage.this.isSelected(TimerData.class) || DefineDataProcessorsWizardPage.this.isSelected(SqlStatementData.class));
                }
            }
        });
        this.table.addListener(13, this.pageCompleteListener);
        tableItem.addListener(13, this.pageCompleteListener);
        button.addListener(13, this.pageCompleteListener);
        this.setControl((Control)composite2);
    }

    public boolean isPageComplete() {
        if (!this.atLeastOneTypeSelected()) {
            this.setMessage("At least one data type has to be selected", 3);
            return false;
        }
        if (this.isStyleApplied(8) && !this.getSelectedClassesFromTable().contains(InvocationSequenceData.class)) {
            this.setMessage("Invocation Sequence Data type has to be selected because it is source of data", 3);
            return false;
        }
        if (this.isStyleApplied(16) && !this.getSelectedClassesFromTable().contains(TimerData.class)) {
            this.setMessage("Timer Data type has to be selected because it is source of data", 3);
            return false;
        }
        if (this.isStyleApplied(32) && !this.getSelectedClassesFromTable().contains(SqlStatementData.class)) {
            this.setMessage("SQL Statement Data type has to be selected because it is source of data", 3);
            return false;
        }
        if (this.isStyleApplied(128) && !this.getSelectedClassesFromTable().contains(ExceptionSensorData.class)) {
            this.setMessage("Exception Sensor Data type has to be selected because it is source of data", 3);
            return false;
        }
        if (this.isStyleApplied(64) && !this.getSelectedClassesFromTable().contains(HttpTimerData.class)) {
            this.setMessage("HTTP Timer Data type has to be selected because it is source of data", 3);
            return false;
        }
        this.setMessage(DEFAULT_MESSAGE);
        return true;
    }

    public List<AbstractDataProcessor> getProcessorList() {
        Object object;
        ArrayList<AbstractDataProcessor> arrayList = new ArrayList<AbstractDataProcessor>();
        List<Class<? extends DefaultData>> list = this.getSelectedClassesFromTable();
        boolean bl = list.contains(InvocationSequenceData.class);
        if (!list.isEmpty()) {
            arrayList.add((AbstractDataProcessor)new DataSaverProcessor(list, bl));
        }
        int n = this.aggregationPeriodSpiner.getSelection() * 1000;
        if (list.contains(TimerData.class)) {
            list.remove(TimerData.class);
            object = new DataAggregatorProcessor(TimerData.class, (long)n, (IAggregator)new TimerDataAggregator(), bl);
            arrayList.add((AbstractDataProcessor)object);
        }
        if (list.contains(SqlStatementData.class)) {
            list.remove(SqlStatementData.class);
            object = new DataAggregatorProcessor(SqlStatementData.class, (long)n, (IAggregator)new SqlStatementDataAggregator(true), bl);
            arrayList.add((AbstractDataProcessor)object);
        }
        if (list.contains(InvocationSequenceData.class)) {
            if (this.isStyleApplied(4)) {
                object = new ArrayList();
                object.addAll(arrayList);
                InvocationExtractorDataProcessor invocationExtractorDataProcessor = new InvocationExtractorDataProcessor((List)object);
                arrayList.add((AbstractDataProcessor)invocationExtractorDataProcessor);
            }
            arrayList.add((AbstractDataProcessor)new InvocationClonerDataProcessor());
        }
        return arrayList;
    }

    private boolean isStyleApplied(int n) {
        return (this.selectionStyle & n) != 0;
    }

    private boolean atLeastOneTypeSelected() {
        TableItem[] tableItemArray = this.table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem tableItem = tableItemArray[n2];
            if (tableItem.getChecked()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private List<Class<? extends DefaultData>> getSelectedClassesFromTable() {
        ArrayList<Class<? extends DefaultData>> arrayList = new ArrayList<Class<? extends DefaultData>>();
        TableItem[] tableItemArray = this.table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem tableItem = tableItemArray[n2];
            if (tableItem.getChecked()) {
                arrayList.add((Class)tableItem.getData());
            }
            ++n2;
        }
        return arrayList;
    }

    private boolean isSelected(Class<? extends DefaultData> clazz) {
        TableItem[] tableItemArray = this.table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem tableItem = tableItemArray[n2];
            if (ObjectUtils.equals((Object)tableItem.getData(), clazz)) {
                return tableItem.getChecked();
            }
            ++n2;
        }
        return false;
    }

    private static class DataColumnLabelProvider
    extends ColumnLabelProvider {
        private DataColumnLabelProvider() {
        }

        public String getText(Object object) {
            if (ObjectUtils.equals((Object)object, TimerData.class)) {
                return "Timer Data";
            }
            if (ObjectUtils.equals((Object)object, HttpTimerData.class)) {
                return "HTTP Timer Data";
            }
            if (ObjectUtils.equals((Object)object, SqlStatementData.class)) {
                return "SQL Statement Data";
            }
            if (ObjectUtils.equals((Object)object, InvocationSequenceData.class)) {
                return "Invocation Sequence Data";
            }
            if (ObjectUtils.equals((Object)object, ExceptionSensorData.class)) {
                return "Exception Sensor Data";
            }
            if (ObjectUtils.equals((Object)object, MemoryInformationData.class)) {
                return "Memory Information Data";
            }
            if (ObjectUtils.equals((Object)object, CpuInformationData.class)) {
                return "CPU Information Data";
            }
            if (ObjectUtils.equals((Object)object, ClassLoadingInformationData.class)) {
                return "Class Loading Information Data";
            }
            if (ObjectUtils.equals((Object)object, ThreadInformationData.class)) {
                return "Thread Informartion Data";
            }
            if (ObjectUtils.equals((Object)object, SystemInformationData.class)) {
                return "System Information Data";
            }
            if (ObjectUtils.equals((Object)object, CompilationInformationData.class)) {
                return "Compilation Information Data";
            }
            if (ObjectUtils.equals((Object)object, JmxSensorValueData.class)) {
                return "JMX Data";
            }
            return super.getText(object);
        }

        public Image getImage(Object object) {
            if (ObjectUtils.equals((Object)object, TimerData.class)) {
                return InspectIT.getDefault().getImage("/icons/eclipse/method_time.gif");
            }
            if (ObjectUtils.equals((Object)object, HttpTimerData.class)) {
                return InspectIT.getDefault().getImage("/icons/eclipse/discovery.gif");
            }
            if (ObjectUtils.equals((Object)object, SqlStatementData.class)) {
                return InspectIT.getDefault().getImage("/icons/fugue/database-sql.png");
            }
            if (ObjectUtils.equals((Object)object, InvocationSequenceData.class)) {
                return InspectIT.getDefault().getImage("/icons/fugue/arrow-switch.png");
            }
            if (ObjectUtils.equals((Object)object, ExceptionSensorData.class)) {
                return InspectIT.getDefault().getImage("/icons/eclipse/exceptiontracer.gif");
            }
            if (ObjectUtils.equals((Object)object, MemoryInformationData.class)) {
                return InspectIT.getDefault().getImage("/icons/fugue/memory.png");
            }
            if (ObjectUtils.equals((Object)object, CpuInformationData.class)) {
                return InspectIT.getDefault().getImage("/icons/fugue/processor.png");
            }
            if (ObjectUtils.equals((Object)object, ClassLoadingInformationData.class)) {
                return InspectIT.getDefault().getImage("/icons/eclipse/class_obj.gif");
            }
            if (ObjectUtils.equals((Object)object, ThreadInformationData.class)) {
                return InspectIT.getDefault().getImage("/icons/eclipse/debugt_obj.gif");
            }
            if (ObjectUtils.equals((Object)object, SystemInformationData.class)) {
                return InspectIT.getDefault().getImage("/icons/fugue/system-monitor.png");
            }
            if (ObjectUtils.equals((Object)object, CompilationInformationData.class)) {
                return InspectIT.getDefault().getImage("/icons/eclipse/workset.gif");
            }
            if (ObjectUtils.equals((Object)object, JmxSensorValueData.class)) {
                return InspectIT.getDefault().getImage("/icons/fugue/bean.png");
            }
            return super.getImage(object);
        }
    }
}

