/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.wizard;

import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.provider.ILocalStorageDataProvider;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import info.novatec.inspectit.rcp.storage.InspectITStorageManager;
import info.novatec.inspectit.rcp.view.impl.StorageManagerView;
import info.novatec.inspectit.rcp.wizard.page.UploadStorageWizardPage;
import info.novatec.inspectit.storage.IStorageData;
import info.novatec.inspectit.storage.LocalStorageData;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressConstants;

public class UploadStorageWizard
extends Wizard
implements INewWizard {
    private LocalStorageData localStorageData;
    private UploadStorageWizardPage uploadStorageWizardPage;

    public UploadStorageWizard(ILocalStorageDataProvider iLocalStorageDataProvider) {
        this.localStorageData = iLocalStorageDataProvider.getLocalStorageData();
        this.setWindowTitle("Upload Storage to CMR (Central Management Repository)");
        this.setDefaultPageImageDescriptor(InspectIT.getDefault().getImageDescriptor("/icons/eclipse/wizban/upload_wiz.png"));
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
    }

    public void addPages() {
        this.uploadStorageWizardPage = new UploadStorageWizardPage(this.localStorageData);
        this.addPage((IWizardPage)this.uploadStorageWizardPage);
    }

    public boolean performFinish() {
        final CmrRepositoryDefinition cmrRepositoryDefinition = this.uploadStorageWizardPage.getCmrRepositoryDefinition();
        Job job = new Job("Upload storage"){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor);
                InspectITStorageManager inspectITStorageManager = InspectIT.getDefault().getInspectITStorageManager();
                try {
                    inspectITStorageManager.uploadCompleteStorage(UploadStorageWizard.this.localStorageData, cmrRepositoryDefinition, subMonitor);
                    cmrRepositoryDefinition.getStorageService().createStorageFromUploadedDir((IStorageData)UploadStorageWizard.this.localStorageData);
                }
                catch (Exception exception) {
                    return new Status(4, "info.novatec.inspectit.rcp", "Exception occurred during storage upload", (Throwable)exception);
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        InspectIT.getDefault().createInfoDialog("Selected storage successfully uploaded.", -1);
                        IViewPart iViewPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("info.novatec.inspectit.rcp.view.storageManager");
                        if (iViewPart instanceof StorageManagerView) {
                            ((StorageManagerView)iViewPart).refresh(cmrRepositoryDefinition);
                        }
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.setProperty(IProgressConstants.ICON_PROPERTY, (Object)InspectIT.getDefault().getImageDescriptor("/icons/eclipse/storage_upload.gif"));
        job.schedule();
        return true;
    }
}

