/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.wizard;

import info.novatec.inspectit.cmr.model.PlatformIdent;
import info.novatec.inspectit.exception.BusinessException;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.provider.IStorageDataProvider;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import info.novatec.inspectit.rcp.wizard.page.AddStorageLabelWizardPage;
import info.novatec.inspectit.rcp.wizard.page.DefineDataProcessorsWizardPage;
import info.novatec.inspectit.rcp.wizard.page.DefineNewStorageWizzardPage;
import info.novatec.inspectit.rcp.wizard.page.DefineTimelineWizardPage;
import info.novatec.inspectit.rcp.wizard.page.NewOrExistsingStorageWizardPage;
import info.novatec.inspectit.rcp.wizard.page.SelectAgentsWizardPage;
import info.novatec.inspectit.rcp.wizard.page.SelectExistingStorageWizardPage;
import info.novatec.inspectit.storage.StorageData;
import info.novatec.inspectit.storage.processor.AbstractDataProcessor;
import info.novatec.inspectit.storage.processor.impl.AgentFilterDataProcessor;
import info.novatec.inspectit.storage.recording.RecordingProperties;
import info.novatec.inspectit.storage.recording.RecordingState;
import info.novatec.inspectit.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class StartRecordingWizard
extends Wizard
implements INewWizard {
    private NewOrExistsingStorageWizardPage newOrExistsingStorageWizardPage;
    private DefineDataProcessorsWizardPage defineDataPage;
    private SelectExistingStorageWizardPage selectStorageWizardPage;
    private DefineNewStorageWizzardPage defineNewStorageWizzardPage;
    private SelectAgentsWizardPage selectAgentsWizardPage;
    private DefineTimelineWizardPage timelineWizardPage;
    private AddStorageLabelWizardPage addLabelWizardPage;
    private CmrRepositoryDefinition selectedCmr;
    private Collection<PlatformIdent> autoSelectedAgents;
    private RecordingProperties recordingProperties;

    public StartRecordingWizard() {
        this.setWindowTitle("Start Recording Wizard");
        this.setDefaultPageImageDescriptor(InspectIT.getDefault().getImageDescriptor("/icons/eclipse/wizban/record_wiz.png"));
    }

    public StartRecordingWizard(IStorageDataProvider iStorageDataProvider) {
        this();
        this.selectedCmr = iStorageDataProvider.getCmrRepositoryDefinition();
    }

    public StartRecordingWizard(CmrRepositoryDefinition cmrRepositoryDefinition) {
        this(cmrRepositoryDefinition, Collections.emptyList());
    }

    public StartRecordingWizard(CmrRepositoryDefinition cmrRepositoryDefinition, Collection<PlatformIdent> collection) {
        this();
        this.selectedCmr = cmrRepositoryDefinition;
        this.autoSelectedAgents = collection;
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
    }

    public void addPages() {
        this.newOrExistsingStorageWizardPage = new NewOrExistsingStorageWizardPage();
        this.addPage((IWizardPage)this.newOrExistsingStorageWizardPage);
        this.defineNewStorageWizzardPage = new DefineNewStorageWizzardPage(this.selectedCmr);
        this.addPage((IWizardPage)this.defineNewStorageWizzardPage);
        this.selectStorageWizardPage = new SelectExistingStorageWizardPage(this.selectedCmr, true);
        this.addPage((IWizardPage)this.selectStorageWizardPage);
        this.selectAgentsWizardPage = new SelectAgentsWizardPage("Select Agent(s) that should participate in recording", this.autoSelectedAgents);
        this.addPage((IWizardPage)this.selectAgentsWizardPage);
        this.defineDataPage = new DefineDataProcessorsWizardPage(7);
        this.addPage((IWizardPage)this.defineDataPage);
        this.timelineWizardPage = new DefineTimelineWizardPage("Limit Recording", "Optionally select how long recording should last", 5);
        this.addPage((IWizardPage)this.timelineWizardPage);
        this.addLabelWizardPage = new AddStorageLabelWizardPage(this.selectedCmr);
        this.addPage((IWizardPage)this.addLabelWizardPage);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean performFinish() {
        Object object;
        Cloneable cloneable;
        boolean bl;
        CmrRepositoryDefinition cmrRepositoryDefinition;
        StorageData storageData;
        if (this.newOrExistsingStorageWizardPage.useNewStorage()) {
            storageData = this.defineNewStorageWizzardPage.getStorageData();
            cmrRepositoryDefinition = this.defineNewStorageWizzardPage.getSelectedRepository();
            bl = this.defineNewStorageWizzardPage.isAutoFinalize();
        } else {
            storageData = this.selectStorageWizardPage.getSelectedStorageData();
            cmrRepositoryDefinition = this.selectStorageWizardPage.getSelectedRepository();
            bl = this.selectStorageWizardPage.isAutoFinalize();
        }
        List<AbstractDataProcessor> list = this.defineDataPage.getProcessorList();
        if (!this.selectAgentsWizardPage.isAllAgents()) {
            cloneable = new HashSet<Long>(this.selectAgentsWizardPage.getSelectedAgents());
            object = new AgentFilterDataProcessor(list, cloneable);
            list = new ArrayList<AbstractDataProcessor>(1);
            list.add((AbstractDataProcessor)object);
        }
        if (cmrRepositoryDefinition.getOnlineStatus() != CmrRepositoryDefinition.OnlineStatus.OFFLINE) {
            Object object2;
            this.recordingProperties = new RecordingProperties();
            this.recordingProperties.setRecordingDataProcessors(list);
            this.recordingProperties.setAutoFinalize(bl);
            if (this.timelineWizardPage.isTimerframeUsed()) {
                cloneable = this.timelineWizardPage.getFromDate();
                object = this.timelineWizardPage.getToDate();
                object2 = new Date();
                if (cloneable != null && ((Date)cloneable).after((Date)object2)) {
                    this.recordingProperties.setStartDelay(((Date)cloneable).getTime() - ((Date)object2).getTime());
                }
                if (object != null && ((Date)object).after((Date)object2)) {
                    if (cloneable != null && ((Date)cloneable).before((Date)object)) {
                        this.recordingProperties.setRecordDuration(((Date)object).getTime() - ((Date)cloneable).getTime());
                    } else {
                        this.recordingProperties.setRecordDuration(((Date)object).getTime() - ((Date)object2).getTime());
                    }
                }
            }
            if (cmrRepositoryDefinition.getStorageService().getRecordingState() != RecordingState.OFF) return true;
            boolean bl2 = true;
            boolean bl3 = bl2;
            if (!bl3) return true;
            try {
                object = cmrRepositoryDefinition.getStorageService().startOrScheduleRecording(storageData, this.recordingProperties);
                object2 = this.addLabelWizardPage.getLabelsToAdd();
                if (object2.isEmpty()) return true;
                cmrRepositoryDefinition.getStorageService().addLabelsToStorage((StorageData)object, (Collection)object2, true);
                return true;
            }
            catch (BusinessException businessException) {
                InspectIT.getDefault().createErrorDialog("Recording did not start.", businessException, -1);
                return false;
            }
        } else {
            InspectIT.getDefault().createErrorDialog("Recording did not start. Selected CMR repository is currently not available.", -1);
            return false;
        }
    }

    public IWizardPage getNextPage(IWizardPage iWizardPage) {
        if (ObjectUtils.equals((Object)iWizardPage, (Object)((Object)this.newOrExistsingStorageWizardPage))) {
            if (this.newOrExistsingStorageWizardPage.useNewStorage()) {
                return this.defineNewStorageWizzardPage;
            }
            return this.selectStorageWizardPage;
        }
        if (ObjectUtils.equals((Object)iWizardPage, (Object)((Object)this.defineNewStorageWizzardPage))) {
            this.selectAgentsWizardPage.setCmrRepositoryDefinition(this.defineNewStorageWizzardPage.getSelectedRepository());
            this.addLabelWizardPage.setStorageData(this.defineNewStorageWizzardPage.getStorageData());
            return this.selectAgentsWizardPage;
        }
        if (ObjectUtils.equals((Object)iWizardPage, (Object)((Object)this.selectStorageWizardPage))) {
            this.selectAgentsWizardPage.setCmrRepositoryDefinition(this.selectStorageWizardPage.getSelectedRepository());
            this.addLabelWizardPage.setStorageData(this.selectStorageWizardPage.getSelectedStorageData());
            return this.selectAgentsWizardPage;
        }
        return super.getNextPage(iWizardPage);
    }

    public IWizardPage getPreviousPage(IWizardPage iWizardPage) {
        if (ObjectUtils.equals((Object)iWizardPage, (Object)((Object)this.defineNewStorageWizzardPage)) || ObjectUtils.equals((Object)iWizardPage, (Object)((Object)this.selectStorageWizardPage))) {
            return this.newOrExistsingStorageWizardPage;
        }
        if (ObjectUtils.equals((Object)iWizardPage, (Object)((Object)this.selectAgentsWizardPage))) {
            if (this.newOrExistsingStorageWizardPage.useNewStorage()) {
                return this.defineNewStorageWizzardPage;
            }
            return this.selectStorageWizardPage;
        }
        return super.getPreviousPage(iWizardPage);
    }

    public boolean canFinish() {
        if (!this.newOrExistsingStorageWizardPage.isPageComplete()) {
            return false;
        }
        if (this.newOrExistsingStorageWizardPage.useNewStorage() && !this.defineNewStorageWizzardPage.isPageComplete()) {
            return false;
        }
        if (!this.newOrExistsingStorageWizardPage.useNewStorage() && !this.selectStorageWizardPage.isPageComplete()) {
            return false;
        }
        if (!this.selectAgentsWizardPage.isPageComplete()) {
            return false;
        }
        if (!this.defineDataPage.isPageComplete()) {
            return false;
        }
        return this.timelineWizardPage.isPageComplete();
    }

    public RecordingProperties getRecordingProperties() {
        return this.recordingProperties;
    }
}

