/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.wizard;

import info.novatec.inspectit.exception.BusinessException;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import info.novatec.inspectit.rcp.view.impl.StorageManagerView;
import info.novatec.inspectit.rcp.wizard.page.DefineNewStorageWizzardPage;
import info.novatec.inspectit.storage.StorageData;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class CreateStorageWizard
extends Wizard
implements INewWizard {
    private DefineNewStorageWizzardPage defineNewStoragePage;
    private CmrRepositoryDefinition cmrRepositoryDefinition;

    public CreateStorageWizard() {
        this.setWindowTitle("Create Storage Wizard");
        this.setDefaultPageImageDescriptor(InspectIT.getDefault().getImageDescriptor("/icons/eclipse/wizban/storage_wiz.png"));
    }

    public CreateStorageWizard(CmrRepositoryDefinition cmrRepositoryDefinition) {
        this();
        this.cmrRepositoryDefinition = cmrRepositoryDefinition;
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
    }

    public void addPages() {
        this.defineNewStoragePage = new DefineNewStorageWizzardPage(this.cmrRepositoryDefinition, false);
        this.addPage((IWizardPage)this.defineNewStoragePage);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean performFinish() {
        CmrRepositoryDefinition cmrRepositoryDefinition = this.defineNewStoragePage.getSelectedRepository();
        if (cmrRepositoryDefinition.getOnlineStatus() != CmrRepositoryDefinition.OnlineStatus.OFFLINE) {
            StorageData storageData = this.defineNewStoragePage.getStorageData();
            try {
                cmrRepositoryDefinition.getStorageService().createAndOpenStorage(storageData);
                IViewPart iViewPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("info.novatec.inspectit.rcp.view.storageManager");
                if (!(iViewPart instanceof StorageManagerView)) return true;
                ((StorageManagerView)iViewPart).refresh();
                return true;
            }
            catch (BusinessException businessException) {
                InspectIT.getDefault().createErrorDialog("Storage can not be created.", businessException, -1);
                return false;
            }
        } else {
            InspectIT.getDefault().createErrorDialog("Storage can not be created. Selected CMR repository is currently not available.", -1);
            return false;
        }
    }
}

