/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.wizard;

import info.novatec.inspectit.exception.BusinessException;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.provider.IStorageDataProvider;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import info.novatec.inspectit.rcp.wizard.page.AddStorageLabelWizardPage;
import info.novatec.inspectit.storage.StorageData;
import info.novatec.inspectit.storage.label.AbstractStorageLabel;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class AddStorageLabelWizard
extends Wizard
implements INewWizard {
    private StorageData storageData;
    private CmrRepositoryDefinition cmrRepositoryDefinition;
    private AddStorageLabelWizardPage addStorageLabelWizardPage;

    public AddStorageLabelWizard(IStorageDataProvider iStorageDataProvider) {
        Assert.isNotNull((Object)iStorageDataProvider);
        this.setWindowTitle("Add Storage Label Wizard");
        this.setDefaultPageImageDescriptor(InspectIT.getDefault().getImageDescriptor("/icons/eclipse/wizban/label_wiz.png"));
        this.storageData = iStorageDataProvider.getStorageData();
        this.cmrRepositoryDefinition = iStorageDataProvider.getCmrRepositoryDefinition();
    }

    public void addPages() {
        this.addStorageLabelWizardPage = new AddStorageLabelWizardPage(this.storageData, this.cmrRepositoryDefinition);
        this.addPage((IWizardPage)this.addStorageLabelWizardPage);
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
    }

    public boolean performFinish() {
        if (this.cmrRepositoryDefinition.getOnlineStatus() != CmrRepositoryDefinition.OnlineStatus.OFFLINE) {
            List<AbstractStorageLabel<?>> list = this.addStorageLabelWizardPage.getLabelsToAdd();
            try {
                StorageData storageData = this.cmrRepositoryDefinition.getStorageService().addLabelsToStorage(this.storageData, list, true);
                try {
                    InspectIT.getDefault().getInspectITStorageManager().storageRemotelyUpdated(storageData);
                }
                catch (Exception exception) {
                    InspectIT.getDefault().createErrorDialog("Error occurred trying to save local storage data to disk.", exception, -1);
                }
            }
            catch (BusinessException businessException) {
                InspectIT.getDefault().createErrorDialog("Adding label to storage failed.", businessException, -1);
                return false;
            }
        } else {
            InspectIT.getDefault().createErrorDialog("Adding label to storage failed. Selected CMR repository is currently not available.", -1);
            return false;
        }
        return true;
    }
}

