/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.storage.label.composite.impl;

import info.novatec.inspectit.rcp.storage.label.composite.AbstractStorageLabelComposite;
import info.novatec.inspectit.storage.label.AbstractStorageLabel;
import info.novatec.inspectit.storage.label.NumberStorageLabel;
import info.novatec.inspectit.storage.label.type.AbstractStorageLabelType;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class NumberStorageLabelComposite
extends AbstractStorageLabelComposite {
    private AbstractStorageLabelType<Number> numberLabelType;
    private Text textBox;
    private boolean showLabel;

    public NumberStorageLabelComposite(Composite composite, int n, AbstractStorageLabelType<Number> abstractStorageLabelType) {
        this(composite, n, abstractStorageLabelType, true);
    }

    public NumberStorageLabelComposite(Composite composite, int n, AbstractStorageLabelType<Number> abstractStorageLabelType, boolean bl) {
        super(composite, n);
        this.numberLabelType = abstractStorageLabelType;
        this.showLabel = bl;
        this.initComposite();
    }

    private void initComposite() {
        if (this.showLabel) {
            GridLayout gridLayout = new GridLayout(2, false);
            this.setLayout((Layout)gridLayout);
            new Label((Composite)this, 0).setText("Enter number:");
        } else {
            GridLayout gridLayout = new GridLayout(1, false);
            this.setLayout((Layout)gridLayout);
        }
        this.textBox = new Text((Composite)this, 133120);
        this.textBox.setLayoutData((Object)new GridData(4, 4, true, true));
    }

    @Override
    public AbstractStorageLabel<?> getStorageLabel() {
        String string = this.textBox.getText().trim();
        if (string.indexOf(46) != -1) {
            return new NumberStorageLabel((Number)Double.parseDouble(string), this.numberLabelType);
        }
        return new NumberStorageLabel((Number)Integer.parseInt(string), this.numberLabelType);
    }

    @Override
    public boolean isInputValid() {
        String string = this.textBox.getText().trim();
        if (string.isEmpty()) {
            return false;
        }
        if (string.indexOf(46) != -1) {
            try {
                Double.parseDouble(string);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    @Override
    public void addListener(Listener listener) {
        this.textBox.addListener(24, listener);
    }
}

