/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.storage;

import com.esotericsoftware.kryo.io.Input;
import info.novatec.inspectit.cmr.model.PlatformIdent;
import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.exception.BusinessException;
import info.novatec.inspectit.exception.IErrorCode;
import info.novatec.inspectit.exception.enumeration.StorageErrorCodeEnum;
import info.novatec.inspectit.indexing.storage.IStorageTreeComponent;
import info.novatec.inspectit.indexing.storage.impl.ArrayBasedStorageLeaf;
import info.novatec.inspectit.indexing.storage.impl.CombinedStorageBranch;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.repository.CmrRepositoryChangeListener;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import info.novatec.inspectit.rcp.repository.StorageRepositoryDefinition;
import info.novatec.inspectit.rcp.repository.StorageRepositoryDefinitionProvider;
import info.novatec.inspectit.rcp.storage.listener.StorageChangeListener;
import info.novatec.inspectit.rcp.storage.util.DataRetriever;
import info.novatec.inspectit.rcp.storage.util.DataUploader;
import info.novatec.inspectit.storage.IStorageData;
import info.novatec.inspectit.storage.LocalStorageData;
import info.novatec.inspectit.storage.StorageData;
import info.novatec.inspectit.storage.StorageFileType;
import info.novatec.inspectit.storage.StorageManager;
import info.novatec.inspectit.storage.label.AbstractStorageLabel;
import info.novatec.inspectit.storage.label.StringStorageLabel;
import info.novatec.inspectit.storage.label.type.AbstractStorageLabelType;
import info.novatec.inspectit.storage.label.type.impl.ExploredByLabelType;
import info.novatec.inspectit.storage.serializer.ISerializer;
import info.novatec.inspectit.storage.serializer.SerializationException;
import info.novatec.inspectit.storage.serializer.impl.SerializationManager;
import info.novatec.inspectit.util.ObjectUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang.mutable.MutableObject;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.swt.widgets.Display;

public class InspectITStorageManager
extends StorageManager
implements CmrRepositoryChangeListener {
    private Set<LocalStorageData> downloadedStorages = Collections.newSetFromMap(new ConcurrentHashMap(16, 0.75f, 2));
    private Set<LocalStorageData> mountedNotAvailableStorages = Collections.newSetFromMap(new ConcurrentHashMap(16, 0.75f, 2));
    private Map<LocalStorageData, CmrRepositoryDefinition> mountedAvailableStorages = new ConcurrentHashMap<LocalStorageData, CmrRepositoryDefinition>(16, 0.75f, 2);
    private ConcurrentHashMap<CmrRepositoryDefinition, CmrRepositoryDefinition.OnlineStatus> cachedRepositoriesStatus = new ConcurrentHashMap(16, 0.75f, 2);
    private List<StorageChangeListener> storageChangeListeners = new ArrayList<StorageChangeListener>();
    private DataRetriever dataRetriever;
    private DataUploader dataUploader;
    private StorageRepositoryDefinitionProvider storageRepositoryDefinitionProvider;

    public void mountStorage(StorageData storageData, CmrRepositoryDefinition cmrRepositoryDefinition, SubMonitor subMonitor) throws BusinessException, IOException, SerializationException {
        this.mountStorage(storageData, cmrRepositoryDefinition, false, false, subMonitor);
    }

    private void mountStorage(StorageData storageData, CmrRepositoryDefinition cmrRepositoryDefinition, boolean bl, boolean bl2, SubMonitor subMonitor) throws BusinessException, IOException, SerializationException {
        LocalStorageData localStorageData = new LocalStorageData(storageData);
        Path path = this.getStoragePath((IStorageData)localStorageData);
        if (!Files.exists(path, new LinkOption[0])) {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        if (bl) {
            try {
                subMonitor.setTaskName("Downloading storage files for storage '" + storageData.getName() + "'..");
                this.dataRetriever.downloadAndSaveStorageFiles(cmrRepositoryDefinition, storageData, path, bl2, true, subMonitor, StorageFileType.values());
                this.downloadedStorages.add(localStorageData);
                localStorageData.setFullyDownloaded(true);
            }
            catch (Exception exception) {
                this.deleteLocalStorageData(localStorageData, false);
                throw exception;
            }
        }
        try {
            subMonitor.setTaskName("Downloading agent and indexing files for storage '" + storageData.getName() + "'..");
            this.dataRetriever.downloadAndSaveStorageFiles(cmrRepositoryDefinition, storageData, path, bl2, true, subMonitor, StorageFileType.AGENT_FILE, StorageFileType.INDEX_FILE);
        }
        catch (Exception exception) {
            this.deleteLocalStorageData(localStorageData, false);
            throw exception;
        }
        this.writeLocalStorageDataToDisk(localStorageData);
        final String string = this.getSystemUsername();
        try {
            if (string != null) {
                StringStorageLabel stringStorageLabel = new StringStorageLabel(string, (AbstractStorageLabelType)new ExploredByLabelType());
                cmrRepositoryDefinition.getStorageService().addLabelToStorage(storageData, (AbstractStorageLabel)stringStorageLabel, true);
            }
        }
        catch (Exception exception) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    InspectIT.getDefault().createInfoDialog("'Mounted by' label with value '" + string + "'was not added to the storage. Exception message is:\n\n" + exception.getMessage(), -1);
                }
            });
        }
        this.mountedAvailableStorages.put(localStorageData, cmrRepositoryDefinition);
    }

    public boolean isFullyDownloaded(StorageData storageData) {
        for (LocalStorageData localStorageData : this.downloadedStorages) {
            if (!ObjectUtils.equals((Object)localStorageData.getId(), (Object)storageData.getId())) continue;
            return localStorageData.isFullyDownloaded();
        }
        return false;
    }

    public void fullyDownloadStorage(StorageData storageData, CmrRepositoryDefinition cmrRepositoryDefinition, boolean bl, SubMonitor subMonitor) throws BusinessException, IOException, SerializationException {
        Object object3;
        Object object2 = null;
        for (Object object3 : this.mountedAvailableStorages.keySet()) {
            if (!ObjectUtils.equals((Object)object3.getId(), (Object)storageData.getId())) continue;
            object2 = object3;
            break;
        }
        if (object2 == null) {
            this.mountStorage(storageData, cmrRepositoryDefinition, true, bl, subMonitor);
            return;
        }
        if (object2.isFullyDownloaded()) {
            throw new BusinessException("Download the storage " + storageData + ".", (IErrorCode)StorageErrorCodeEnum.STORAGE_ALREADY_DOWNLOADED);
        }
        object3 = this.getStoragePath((IStorageData)object2);
        subMonitor.setTaskName("Downloading storage data files for storage '" + storageData.getName() + "'..");
        this.dataRetriever.downloadAndSaveStorageFiles(cmrRepositoryDefinition, storageData, (Path)object3, bl, true, subMonitor, StorageFileType.DATA_FILE, StorageFileType.CACHED_DATA_FILE);
        this.downloadedStorages.add((LocalStorageData)object2);
        object2.setFullyDownloaded(true);
        this.writeLocalStorageDataToDisk((LocalStorageData)object2);
    }

    public void deleteLocalStorageData(LocalStorageData localStorageData) throws IOException, SerializationException {
        this.deleteLocalStorageData(localStorageData, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteLocalStorageData(LocalStorageData localStorageData, boolean bl) throws IOException, SerializationException {
        localStorageData.setFullyDownloaded(false);
        this.downloadedStorages.remove(localStorageData);
        if (this.mountedAvailableStorages.containsKey(localStorageData) || this.mountedNotAvailableStorages.contains(localStorageData)) {
            super.deleteStorageDataFromDisk((IStorageData)localStorageData, new StorageFileType[]{StorageFileType.DATA_FILE});
            this.writeLocalStorageDataToDisk(localStorageData);
        } else {
            super.deleteCompleteStorageDataFromDisk((IStorageData)localStorageData);
        }
        if (bl) {
            List<StorageChangeListener> list = this.storageChangeListeners;
            synchronized (list) {
                for (StorageChangeListener storageChangeListener : this.storageChangeListeners) {
                    storageChangeListener.storageLocallyDeleted((IStorageData)localStorageData);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storageRemotelyDeleted(StorageData storageData) throws IOException, SerializationException {
        LocalStorageData object = null;
        for (Map.Entry<LocalStorageData, CmrRepositoryDefinition> entry : this.mountedAvailableStorages.entrySet()) {
            if (!ObjectUtils.equals((Object)entry.getKey().getId(), (Object)storageData.getId())) continue;
            object = entry.getKey();
            break;
        }
        if (object != null && !object.isFullyDownloaded()) {
            this.deleteLocalStorageData(object, false);
        } else {
            for (LocalStorageData localStorageData : this.mountedNotAvailableStorages) {
                if (!ObjectUtils.equals((Object)localStorageData.getId(), (Object)storageData.getId())) continue;
                object = localStorageData;
                break;
            }
            if (object != null && !object.isFullyDownloaded()) {
                this.deleteLocalStorageData(object, false);
            }
        }
        List<StorageChangeListener> list = this.storageChangeListeners;
        synchronized (list) {
            for (StorageChangeListener storageChangeListener : this.storageChangeListeners) {
                storageChangeListener.storageRemotelyDeleted((IStorageData)storageData);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storageRemotelyUpdated(StorageData storageData) throws IOException, SerializationException {
        LocalStorageData localStorageData = this.getLocalDataForStorage(storageData);
        if (localStorageData != null) {
            this.updateLocalStorageData(localStorageData, storageData);
        }
        List<StorageChangeListener> list = this.storageChangeListeners;
        synchronized (list) {
            for (StorageChangeListener storageChangeListener : this.storageChangeListeners) {
                storageChangeListener.storageDataUpdated((IStorageData)storageData);
            }
        }
    }

    public Collection<LocalStorageData> getMountedAvailableStorages() {
        return Collections.unmodifiableSet(this.mountedAvailableStorages.keySet());
    }

    public Collection<LocalStorageData> getMountedUnavailableStorages() {
        return Collections.unmodifiableSet(this.mountedNotAvailableStorages);
    }

    public Collection<LocalStorageData> getDownloadedStorages() {
        return Collections.unmodifiableSet(this.downloadedStorages);
    }

    public Path getStoragePath(IStorageData iStorageData) {
        return this.getDefaultStorageDirPath().resolve(iStorageData.getStorageFolder());
    }

    public void startUp() {
        List<Object> list;
        try {
            list = this.getMountedStoragesFromDisk();
        }
        catch (Exception exception) {
            list = Collections.emptyList();
        }
        Map<StorageData, CmrRepositoryDefinition> map = this.getOnlineStorages();
        for (LocalStorageData localStorageData : list) {
            if (localStorageData.isFullyDownloaded()) {
                this.downloadedStorages.add(localStorageData);
            }
            boolean bl = false;
            for (Map.Entry<StorageData, CmrRepositoryDefinition> entry : map.entrySet()) {
                if (!ObjectUtils.equals((Object)entry.getKey().getId(), (Object)localStorageData.getId())) continue;
                bl = true;
                try {
                    this.updateLocalStorageData(localStorageData, entry.getKey());
                }
                catch (Exception exception) {
                    final String string = localStorageData.getName();
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            InspectIT.getDefault().createErrorDialog("Local data for the storage '" + string + "' could not be updated with the online data.", exception, -1);
                        }
                    });
                }
                this.mountedAvailableStorages.put(localStorageData, entry.getValue());
                break;
            }
            if (bl) continue;
            this.mountedNotAvailableStorages.add(localStorageData);
        }
        InspectIT.getDefault().getCmrRepositoryManager().addCmrRepositoryChangeListener(this);
    }

    public StorageRepositoryDefinition getStorageRepositoryDefinition(LocalStorageData localStorageData) throws BusinessException, SerializationException, IOException {
        ArrayBasedStorageLeaf arrayBasedStorageLeaf;
        if (!this.mountedAvailableStorages.keySet().contains(localStorageData) && !this.downloadedStorages.contains(localStorageData)) {
            throw new BusinessException("Create repository definition for the storage " + localStorageData + ".", (IErrorCode)StorageErrorCodeEnum.STORAGE_DOES_NOT_EXIST);
        }
        CmrRepositoryDefinition cmrRepositoryDefinition = null;
        cmrRepositoryDefinition = this.mountedAvailableStorages.get(localStorageData);
        List<Object> list = this.getPlatformIdentsLocally((IStorageData)localStorageData);
        if (list == null) {
            list = Collections.emptyList();
        }
        if ((arrayBasedStorageLeaf = this.getIndexingTree((IStorageData)localStorageData)) == null) {
            arrayBasedStorageLeaf = new ArrayBasedStorageLeaf();
        }
        StorageRepositoryDefinition storageRepositoryDefinition = this.storageRepositoryDefinitionProvider.createStorageRepositoryDefinition();
        storageRepositoryDefinition.setAgents(list);
        storageRepositoryDefinition.setIndexingTree((IStorageTreeComponent<? extends DefaultData>)arrayBasedStorageLeaf);
        storageRepositoryDefinition.setCmrRepositoryDefinition(cmrRepositoryDefinition);
        storageRepositoryDefinition.setLocalStorageData(localStorageData);
        storageRepositoryDefinition.initServices();
        return storageRepositoryDefinition;
    }

    public boolean isStorageMounted(StorageData storageData) {
        return this.getLocalDataForStorage(storageData) != null;
    }

    public LocalStorageData getLocalDataForStorage(StorageData storageData) {
        for (LocalStorageData localStorageData : this.downloadedStorages) {
            if (!ObjectUtils.equals((Object)localStorageData.getId(), (Object)storageData.getId())) continue;
            return localStorageData;
        }
        for (LocalStorageData localStorageData : this.mountedNotAvailableStorages) {
            if (!ObjectUtils.equals((Object)storageData.getId(), (Object)localStorageData.getId())) continue;
            return localStorageData;
        }
        for (LocalStorageData localStorageData : this.mountedAvailableStorages.keySet()) {
            if (!ObjectUtils.equals((Object)storageData.getId(), (Object)localStorageData.getId())) continue;
            return localStorageData;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStorageChangeListener(StorageChangeListener storageChangeListener) {
        List<StorageChangeListener> list = this.storageChangeListeners;
        synchronized (list) {
            if (!this.storageChangeListeners.contains(storageChangeListener)) {
                this.storageChangeListeners.add(storageChangeListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStorageChangeListener(StorageChangeListener storageChangeListener) {
        List<StorageChangeListener> list = this.storageChangeListeners;
        synchronized (list) {
            this.storageChangeListeners.remove(storageChangeListener);
        }
    }

    public void uploadZippedStorage(String string, CmrRepositoryDefinition cmrRepositoryDefinition, SubMonitor subMonitor) throws IOException {
        Path path = Paths.get(string, new String[0]);
        Path path2 = path.getParent();
        String string2 = "tmp" + UUID.randomUUID().hashCode();
        subMonitor.setTaskName("Uploading storage file..");
        this.dataUploader.uploadFileToStorageUploads(path, path2, string2, cmrRepositoryDefinition, subMonitor);
    }

    public void uploadCompleteStorage(LocalStorageData localStorageData, CmrRepositoryDefinition cmrRepositoryDefinition, SubMonitor subMonitor) throws BusinessException, IOException {
        if (!localStorageData.isFullyDownloaded()) {
            throw new BusinessException("Uploading the storage " + localStorageData + ".", (IErrorCode)StorageErrorCodeEnum.STORAGE_IS_NOT_DOWNLOADED);
        }
        String string = "tmp" + UUID.randomUUID().hashCode();
        Path path = this.getStoragePath((IStorageData)localStorageData);
        final ArrayList<Path> arrayList = new ArrayList<Path>();
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                arrayList.add(path);
                return FileVisitResult.CONTINUE;
            }
        });
        subMonitor.setTaskName("Uploading storage files..");
        this.dataUploader.uploadFileToStorageUploads(arrayList, path, string, cmrRepositoryDefinition, subMonitor);
    }

    public void zipStorageData(LocalStorageData localStorageData, String string) throws BusinessException, IOException {
        if (!localStorageData.isFullyDownloaded()) {
            throw new BusinessException("Zip data for the storage " + localStorageData + ".", (IErrorCode)StorageErrorCodeEnum.STORAGE_IS_NOT_DOWNLOADED);
        }
        Path path = Paths.get(string, new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            Files.delete(path);
        }
        try {
            super.zipStorageData((IStorageData)localStorageData, path);
        }
        catch (IOException iOException) {
            Files.deleteIfExists(path);
            throw iOException;
        }
    }

    public void zipStorageData(StorageData storageData, CmrRepositoryDefinition cmrRepositoryDefinition, String string, boolean bl, SubMonitor subMonitor) throws BusinessException, IOException, SerializationException {
        Path path = Paths.get(string, new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            Files.delete(path);
        }
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (ZipOutputStream zipOutputStream = new ZipOutputStream(Files.newOutputStream(path, StandardOpenOption.CREATE, StandardOpenOption.WRITE));){
                subMonitor.setTaskName("Downloading and packing storage files..");
                this.dataRetriever.downloadAndZipStorageFiles(cmrRepositoryDefinition, storageData, zipOutputStream, bl, false, subMonitor, StorageFileType.values());
                LocalStorageData localStorageData = new LocalStorageData(storageData);
                localStorageData.setFullyDownloaded(true);
                String string2 = String.valueOf(localStorageData.getId()) + StorageFileType.LOCAL_STORAGE_FILE.getExtension();
                ZipEntry zipEntry = new ZipEntry(string2);
                zipOutputStream.putNextEntry(zipEntry);
                this.serializeDataToOutputStream(localStorageData, zipOutputStream, false);
                zipOutputStream.closeEntry();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (BusinessException | SerializationException | IOException throwable) {
            Files.deleteIfExists(path);
            throw throwable;
        }
    }

    public IStorageData getStorageDataFromZip(String string) {
        return this.getStorageDataFromZip(Paths.get(string, new String[0]));
    }

    public void unzipStorageData(String string) throws BusinessException, IOException, SerializationException {
        Path path = Paths.get(string, new String[0]);
        IStorageData iStorageData = this.getStorageDataFromZip(path);
        this.unzipStorageData(path, this.getStoragePath(iStorageData));
        List<LocalStorageData> list = this.getMountedStoragesFromDisk();
        block0: for (LocalStorageData localStorageData : list) {
            if (!localStorageData.isFullyDownloaded() || this.downloadedStorages.contains(localStorageData)) continue;
            this.downloadedStorages.add(localStorageData);
            for (StorageData storageData : this.getOnlineStorages().keySet()) {
                if (!ObjectUtils.equals((Object)storageData.getId(), (Object)localStorageData.getId())) continue;
                this.updateLocalStorageData(localStorageData, storageData);
                break block0;
            }
        }
    }

    @Override
    public void repositoryAdded(CmrRepositoryDefinition cmrRepositoryDefinition) {
        this.addMountedStorages(cmrRepositoryDefinition);
    }

    @Override
    public void repositoryRemoved(CmrRepositoryDefinition cmrRepositoryDefinition) {
        this.removeMountedStorages(cmrRepositoryDefinition);
    }

    @Override
    public void repositoryDataUpdated(CmrRepositoryDefinition cmrRepositoryDefinition) {
    }

    @Override
    public void repositoryAgentDeleted(CmrRepositoryDefinition cmrRepositoryDefinition, PlatformIdent platformIdent) {
    }

    @Override
    public void repositoryOnlineStatusUpdated(CmrRepositoryDefinition cmrRepositoryDefinition, CmrRepositoryDefinition.OnlineStatus onlineStatus, CmrRepositoryDefinition.OnlineStatus onlineStatus2) {
        if (onlineStatus2 != CmrRepositoryDefinition.OnlineStatus.CHECKING) {
            CmrRepositoryDefinition.OnlineStatus onlineStatus3 = this.cachedRepositoriesStatus.get(cmrRepositoryDefinition);
            if (!ObjectUtils.equals((Object)((Object)onlineStatus3), (Object)((Object)onlineStatus2))) {
                if (onlineStatus2 == CmrRepositoryDefinition.OnlineStatus.ONLINE) {
                    this.addMountedStorages(cmrRepositoryDefinition);
                } else if (onlineStatus2 == CmrRepositoryDefinition.OnlineStatus.OFFLINE) {
                    this.removeMountedStorages(cmrRepositoryDefinition);
                }
            }
            this.cachedRepositoriesStatus.put(cmrRepositoryDefinition, onlineStatus2);
        }
    }

    private void updateLocalStorageData(LocalStorageData localStorageData, StorageData storageData) throws IOException, SerializationException {
        localStorageData.copyStorageDataInformation(storageData);
        this.writeLocalStorageDataToDisk(localStorageData);
    }

    private void addMountedStorages(CmrRepositoryDefinition cmrRepositoryDefinition) {
        if (cmrRepositoryDefinition.getOnlineStatus() == CmrRepositoryDefinition.OnlineStatus.ONLINE) {
            List list = cmrRepositoryDefinition.getStorageService().getReadableStorages();
            ArrayList<LocalStorageData> arrayList = new ArrayList<LocalStorageData>();
            block2: for (LocalStorageData localStorageData : this.mountedNotAvailableStorages) {
                for (StorageData storageData : list) {
                    if (!ObjectUtils.equals((Object)localStorageData.getId(), (Object)storageData.getId())) continue;
                    arrayList.add(localStorageData);
                    try {
                        this.updateLocalStorageData(localStorageData, storageData);
                    }
                    catch (SerializationException | IOException throwable) {
                        final String string = localStorageData.getName();
                        Display.getDefault().syncExec(new Runnable((Exception)throwable){
                            private final /* synthetic */ Exception val$e;
                            {
                                this.val$e = exception;
                            }

                            @Override
                            public void run() {
                                InspectIT.getDefault().createErrorDialog("Local data for the storage '" + string + "' could not be updated with the online data.", this.val$e, -1);
                            }
                        });
                    }
                    this.mountedAvailableStorages.put(localStorageData, cmrRepositoryDefinition);
                    continue block2;
                }
            }
            if (!arrayList.isEmpty()) {
                this.mountedNotAvailableStorages.removeAll(arrayList);
            }
        }
    }

    private void removeMountedStorages(CmrRepositoryDefinition cmrRepositoryDefinition) {
        ArrayList<LocalStorageData> arrayList = new ArrayList<LocalStorageData>();
        for (Map.Entry<LocalStorageData, CmrRepositoryDefinition> entry : this.mountedAvailableStorages.entrySet()) {
            if (entry.getKey().isFullyDownloaded() || !ObjectUtils.equals((Object)entry.getValue(), (Object)cmrRepositoryDefinition)) continue;
            arrayList.add(entry.getKey());
        }
        if (!arrayList.isEmpty()) {
            this.mountedAvailableStorages.keySet().removeAll(arrayList);
            this.mountedNotAvailableStorages.addAll(arrayList);
        }
    }

    private List<PlatformIdent> getPlatformIdentsLocally(IStorageData iStorageData) throws IOException, SerializationException {
        Path path = this.getStoragePath(iStorageData);
        List<PlatformIdent> list = this.getObjectsByFileTreeWalk(path, StorageFileType.AGENT_FILE.getExtension());
        if (!list.isEmpty()) {
            return list;
        }
        return null;
    }

    private IStorageTreeComponent<DefaultData> getIndexingTree(IStorageData iStorageData) throws IOException, SerializationException {
        Path path = this.getStoragePath(iStorageData);
        List list = this.getObjectsByFileTreeWalk(path, StorageFileType.INDEX_FILE.getExtension());
        if (!list.isEmpty()) {
            if (list.size() == 1) {
                return (IStorageTreeComponent)list.get(0);
            }
            CombinedStorageBranch combinedStorageBranch = new CombinedStorageBranch(list);
            return combinedStorageBranch;
        }
        return null;
    }

    private List<LocalStorageData> getMountedStoragesFromDisk() throws IOException, SerializationException {
        return this.getObjectsByFileTreeWalk(this.getDefaultStorageDirPath(), StorageFileType.LOCAL_STORAGE_FILE.getExtension());
    }

    private <E> List<E> getObjectsByFileTreeWalk(Path path, final String string) throws IOException, SerializationException {
        if (!Files.isDirectory(path, new LinkOption[0])) {
            return Collections.emptyList();
        }
        SerializationManager serializationManager = this.getSerializationManagerProvider().createSerializer();
        MutableObject mutableObject = new MutableObject();
        ArrayList arrayList = new ArrayList();
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>((ISerializer)serializationManager, arrayList, mutableObject){
            private final /* synthetic */ ISerializer val$serializer;
            private final /* synthetic */ List val$returnList;
            private final /* synthetic */ MutableObject val$mutableException;
            {
                this.val$serializer = iSerializer;
                this.val$returnList = list;
                this.val$mutableException = mutableObject;
            }

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                if (path.toString().endsWith(string)) {
                    InputStream inputStream = null;
                    try (Input input = null;){
                        try {
                            inputStream = Files.newInputStream(path, StandardOpenOption.READ);
                            input = new Input(inputStream);
                            Object object = this.val$serializer.deserialize(input);
                            this.val$returnList.add(object);
                        }
                        catch (SerializationException serializationException) {
                            this.val$mutableException.setValue((Object)serializationException);
                            FileVisitResult fileVisitResult = FileVisitResult.TERMINATE;
                            if (input != null) {
                                input.close();
                            }
                            return fileVisitResult;
                        }
                    }
                }
                return FileVisitResult.CONTINUE;
            }
        });
        SerializationException serializationException = (SerializationException)((Object)mutableObject.getValue());
        if (serializationException != null) {
            throw serializationException;
        }
        return arrayList;
    }

    private Map<StorageData, CmrRepositoryDefinition> getOnlineStorages() {
        HashMap<StorageData, CmrRepositoryDefinition> hashMap = new HashMap<StorageData, CmrRepositoryDefinition>();
        List<CmrRepositoryDefinition> list = InspectIT.getDefault().getCmrRepositoryManager().getCmrRepositoryDefinitions();
        for (CmrRepositoryDefinition cmrRepositoryDefinition : list) {
            List list2;
            if (cmrRepositoryDefinition.getOnlineStatus() != CmrRepositoryDefinition.OnlineStatus.ONLINE || (list2 = cmrRepositoryDefinition.getStorageService().getReadableStorages()) == null) continue;
            for (StorageData storageData : list2) {
                hashMap.put(storageData, cmrRepositoryDefinition);
            }
        }
        return hashMap;
    }

    protected Path getDefaultStorageDirPath() {
        return InspectIT.getDefault().getRuntimeDir().resolve(this.getStorageDefaultFolder()).toAbsolutePath();
    }

    private String getSystemUsername() {
        return System.getProperty("user.name");
    }

    public void setDataRetriever(DataRetriever dataRetriever) {
        this.dataRetriever = dataRetriever;
    }

    public void setDataUploader(DataUploader dataUploader) {
        this.dataUploader = dataUploader;
    }

    public void setStorageRepositoryDefinitionProvider(StorageRepositoryDefinitionProvider storageRepositoryDefinitionProvider) {
        this.storageRepositoryDefinitionProvider = storageRepositoryDefinitionProvider;
    }
}

