/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.repository.service.storage;

import info.novatec.inspectit.cmr.service.IHttpTimerDataAccessService;
import info.novatec.inspectit.communication.data.HttpTimerData;
import info.novatec.inspectit.indexing.aggregation.impl.HttpTimerDataAggregator;
import info.novatec.inspectit.indexing.query.factory.impl.HttpTimerDataQueryFactory;
import info.novatec.inspectit.indexing.restriction.impl.IndexQueryRestrictionFactory;
import info.novatec.inspectit.indexing.storage.IStorageTreeComponent;
import info.novatec.inspectit.indexing.storage.impl.StorageIndexQuery;
import info.novatec.inspectit.rcp.repository.service.storage.AbstractStorageService;
import info.novatec.inspectit.util.ObjectUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class StorageHttpTimerDataAccessService
extends AbstractStorageService<HttpTimerData>
implements IHttpTimerDataAccessService {
    private static final Comparator<HttpTimerData> TIMESTAMP_COMPARATOR = new Comparator<HttpTimerData>(){

        @Override
        public int compare(HttpTimerData httpTimerData, HttpTimerData httpTimerData2) {
            return ObjectUtils.compare((Comparable)httpTimerData.getTimeStamp(), (Object)httpTimerData2.getTimeStamp());
        }
    };
    private IStorageTreeComponent<HttpTimerData> indexingTree;
    private HttpTimerDataQueryFactory<StorageIndexQuery> httpDataQueryFactory;

    public List<HttpTimerData> getAggregatedTimerData(HttpTimerData httpTimerData, boolean bl) {
        StorageIndexQuery storageIndexQuery = (StorageIndexQuery)this.httpDataQueryFactory.getFindAllHttpTimersQuery(httpTimerData, null, null);
        return super.executeQuery(storageIndexQuery, new HttpTimerDataAggregator(true, bl));
    }

    public List<HttpTimerData> getAggregatedTimerData(HttpTimerData httpTimerData, boolean bl, Date date, Date date2) {
        StorageIndexQuery storageIndexQuery = (StorageIndexQuery)this.httpDataQueryFactory.getFindAllHttpTimersQuery(httpTimerData, date, date2);
        return super.executeQuery(storageIndexQuery, new HttpTimerDataAggregator(true, bl));
    }

    public List<HttpTimerData> getTaggedAggregatedTimerData(HttpTimerData httpTimerData, boolean bl) {
        StorageIndexQuery storageIndexQuery = (StorageIndexQuery)this.httpDataQueryFactory.getFindAllTaggedHttpTimersQuery(httpTimerData, null, null);
        return super.executeQuery(storageIndexQuery, new HttpTimerDataAggregator(false, bl));
    }

    public List<HttpTimerData> getTaggedAggregatedTimerData(HttpTimerData httpTimerData, boolean bl, Date date, Date date2) {
        StorageIndexQuery storageIndexQuery = (StorageIndexQuery)this.httpDataQueryFactory.getFindAllTaggedHttpTimersQuery(httpTimerData, date, date2);
        return super.executeQuery(storageIndexQuery, new HttpTimerDataAggregator(false, bl));
    }

    public List<HttpTimerData> getChartingHttpTimerDataFromDateToDate(Collection<HttpTimerData> collection, Date date, Date date2, boolean bl) {
        if (CollectionUtils.isNotEmpty(collection)) {
            StorageIndexQuery storageIndexQuery = (StorageIndexQuery)this.httpDataQueryFactory.getFindAllHttpTimersQuery(collection.iterator().next(), date, date2);
            if (!bl) {
                HashSet<String> hashSet = new HashSet<String>();
                for (HttpTimerData httpTimerData : collection) {
                    if ("n.a.".equals(httpTimerData.getHttpInfo().getUri())) continue;
                    hashSet.add(httpTimerData.getHttpInfo().getUri());
                }
                storageIndexQuery.addIndexingRestriction(IndexQueryRestrictionFactory.isInCollection((String)"uri", hashSet));
            } else {
                HashSet<String> hashSet = new HashSet<String>();
                for (HttpTimerData httpTimerData : collection) {
                    if (!httpTimerData.getHttpInfo().hasInspectItTaggingHeader()) continue;
                    hashSet.add(httpTimerData.getHttpInfo().getInspectItTaggingHeaderValue());
                }
                storageIndexQuery.addIndexingRestriction(IndexQueryRestrictionFactory.isInCollection((String)"inspectItTaggingHeaderValue", hashSet));
            }
            return super.executeQuery(storageIndexQuery, TIMESTAMP_COMPARATOR);
        }
        return Collections.emptyList();
    }

    @Override
    protected IStorageTreeComponent<HttpTimerData> getIndexingTree() {
        return this.indexingTree;
    }

    public void setIndexingTree(IStorageTreeComponent<HttpTimerData> iStorageTreeComponent) {
        this.indexingTree = iStorageTreeComponent;
    }

    public void setHttpDataQueryFactory(HttpTimerDataQueryFactory<StorageIndexQuery> httpTimerDataQueryFactory) {
        this.httpDataQueryFactory = httpTimerDataQueryFactory;
    }
}

