/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.repository;

import info.novatec.inspectit.cmr.model.PlatformIdent;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.preferences.PreferencesUtils;
import info.novatec.inspectit.rcp.repository.CmrRepositoryChangeListener;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import info.novatec.inspectit.rcp.util.ListenerList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.CollectionUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.progress.IProgressConstants;

public class CmrRepositoryManager {
    public static final long UPDATE_JOB_REPETITION = 60000L;
    private List<CmrRepositoryDefinition> cmrRepositoryDefinitions = new ArrayList<CmrRepositoryDefinition>();
    private ListenerList<CmrRepositoryChangeListener> cmrRepositoryChangeListeners = new ListenerList();
    private Map<CmrRepositoryDefinition, UpdateRepositoryJob> repositoryUpdateJobMap = new ConcurrentHashMap<CmrRepositoryDefinition, UpdateRepositoryJob>();

    public CmrRepositoryManager() {
        List<CmrRepositoryDefinition> list = PreferencesUtils.getCmrRepositoryDefinitions();
        if (CollectionUtils.isNotEmpty(list)) {
            this.cmrRepositoryDefinitions.addAll(list);
            for (CmrRepositoryDefinition cmrRepositoryDefinition : this.cmrRepositoryDefinitions) {
                Object object2;
                for (Object object2 : this.cmrRepositoryChangeListeners) {
                    cmrRepositoryDefinition.addCmrRepositoryChangeListener((CmrRepositoryChangeListener)object2);
                }
                object2 = new UpdateRepositoryJob(cmrRepositoryDefinition, true);
                object2.schedule();
                this.repositoryUpdateJobMap.put(cmrRepositoryDefinition, (UpdateRepositoryJob)((Object)object2));
            }
        }
    }

    public void addCmrRepositoryDefinition(CmrRepositoryDefinition cmrRepositoryDefinition) {
        if (!this.cmrRepositoryDefinitions.contains(cmrRepositoryDefinition)) {
            Object object2;
            for (Object object2 : this.cmrRepositoryChangeListeners) {
                cmrRepositoryDefinition.addCmrRepositoryChangeListener((CmrRepositoryChangeListener)object2);
            }
            this.cmrRepositoryDefinitions.add(cmrRepositoryDefinition);
            this.savePreference();
            for (Object object2 : this.cmrRepositoryChangeListeners) {
                object2.repositoryAdded(cmrRepositoryDefinition);
            }
            object2 = new UpdateRepositoryJob(cmrRepositoryDefinition, true);
            object2.schedule();
            this.repositoryUpdateJobMap.put(cmrRepositoryDefinition, (UpdateRepositoryJob)((Object)object2));
        }
    }

    public void removeCmrRepositoryDefinition(CmrRepositoryDefinition cmrRepositoryDefinition) {
        Object object2;
        for (Object object2 : this.cmrRepositoryChangeListeners) {
            cmrRepositoryDefinition.removeCmrRepositoryChangeListener((CmrRepositoryChangeListener)object2);
        }
        this.cmrRepositoryDefinitions.remove(cmrRepositoryDefinition);
        this.savePreference();
        for (Object object2 : this.cmrRepositoryChangeListeners) {
            object2.repositoryRemoved(cmrRepositoryDefinition);
        }
        object2 = this.repositoryUpdateJobMap.remove(cmrRepositoryDefinition);
        if (object2 != null) {
            object2.cancel();
        }
    }

    public UpdateRepositoryJob forceCmrRepositoryOnlineStatusUpdate(CmrRepositoryDefinition cmrRepositoryDefinition) {
        UpdateRepositoryJob updateRepositoryJob = this.repositoryUpdateJobMap.get(cmrRepositoryDefinition);
        if (updateRepositoryJob != null && updateRepositoryJob.cancel()) {
            updateRepositoryJob.schedule();
        }
        return updateRepositoryJob;
    }

    public Collection<UpdateRepositoryJob> forceAllCmrRepositoriesOnlineStatusUpdate() {
        ArrayList<UpdateRepositoryJob> arrayList = new ArrayList<UpdateRepositoryJob>();
        for (CmrRepositoryDefinition cmrRepositoryDefinition : this.cmrRepositoryDefinitions) {
            arrayList.add(this.forceCmrRepositoryOnlineStatusUpdate(cmrRepositoryDefinition));
        }
        return arrayList;
    }

    public List<CmrRepositoryDefinition> getCmrRepositoryDefinitions() {
        return Collections.unmodifiableList(this.cmrRepositoryDefinitions);
    }

    public void addCmrRepositoryChangeListener(CmrRepositoryChangeListener cmrRepositoryChangeListener) {
        this.cmrRepositoryChangeListeners.add(cmrRepositoryChangeListener);
        for (CmrRepositoryDefinition cmrRepositoryDefinition : this.cmrRepositoryDefinitions) {
            cmrRepositoryDefinition.addCmrRepositoryChangeListener(cmrRepositoryChangeListener);
        }
    }

    public void removeCmrRepositoryChangeListener(CmrRepositoryChangeListener cmrRepositoryChangeListener) {
        this.cmrRepositoryChangeListeners.remove(cmrRepositoryChangeListener);
        for (CmrRepositoryDefinition cmrRepositoryDefinition : this.cmrRepositoryDefinitions) {
            cmrRepositoryDefinition.removeCmrRepositoryChangeListener(cmrRepositoryChangeListener);
        }
    }

    public void cancelAllUpdateRepositoriesJobs() {
        block2: for (UpdateRepositoryJob updateRepositoryJob : this.repositoryUpdateJobMap.values()) {
            while (!updateRepositoryJob.cancel()) {
                try {
                    updateRepositoryJob.join();
                }
                catch (InterruptedException interruptedException) {
                    continue block2;
                }
            }
        }
    }

    public void updateCmrRepositoryDefinitionData(CmrRepositoryDefinition cmrRepositoryDefinition) {
        this.savePreference();
        for (CmrRepositoryChangeListener cmrRepositoryChangeListener : this.cmrRepositoryChangeListeners) {
            cmrRepositoryChangeListener.repositoryDataUpdated(cmrRepositoryDefinition);
        }
    }

    public void repositoryAgentDeleted(CmrRepositoryDefinition cmrRepositoryDefinition, PlatformIdent platformIdent) {
        for (CmrRepositoryChangeListener cmrRepositoryChangeListener : this.cmrRepositoryChangeListeners) {
            cmrRepositoryChangeListener.repositoryAgentDeleted(cmrRepositoryDefinition, platformIdent);
        }
    }

    private void savePreference() {
        ArrayList<CmrRepositoryDefinition> arrayList = new ArrayList<CmrRepositoryDefinition>();
        for (CmrRepositoryDefinition cmrRepositoryDefinition : this.cmrRepositoryDefinitions) {
            arrayList.add(cmrRepositoryDefinition);
        }
        PreferencesUtils.saveCmrRepositoryDefinitions(arrayList, false);
    }

    public static class UpdateRepositoryJob
    extends Job {
        private CmrRepositoryDefinition cmrRepositoryDefinition;
        private boolean rescheduleJob;

        public UpdateRepositoryJob(CmrRepositoryDefinition cmrRepositoryDefinition, boolean bl) {
            super("Updating online status of CMR repository " + cmrRepositoryDefinition.getIp() + ":" + cmrRepositoryDefinition.getPort());
            this.cmrRepositoryDefinition = cmrRepositoryDefinition;
            this.rescheduleJob = bl;
            this.setUser(false);
            this.setProperty(IProgressConstants.ICON_PROPERTY, InspectIT.getDefault().getImageDescriptor("/icons/selfmade/server_refresh_16x16.png"));
        }

        protected IStatus run(IProgressMonitor iProgressMonitor) {
            try {
                this.cmrRepositoryDefinition.refreshOnlineStatus();
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            finally {
                if (this.rescheduleJob) {
                    this.schedule(60000L);
                }
            }
        }

        public CmrRepositoryDefinition getCmrRepositoryDefinition() {
            return this.cmrRepositoryDefinition;
        }
    }
}

