/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.property.control;

import info.novatec.inspectit.cmr.property.configuration.SingleProperty;
import info.novatec.inspectit.cmr.property.configuration.impl.BooleanProperty;
import info.novatec.inspectit.cmr.property.configuration.impl.ByteProperty;
import info.novatec.inspectit.cmr.property.configuration.impl.LongProperty;
import info.novatec.inspectit.cmr.property.configuration.impl.PercentageProperty;
import info.novatec.inspectit.cmr.property.configuration.impl.StringProperty;
import info.novatec.inspectit.cmr.property.configuration.validation.PropertyValidation;
import info.novatec.inspectit.cmr.property.configuration.validation.PropertyValidationException;
import info.novatec.inspectit.cmr.property.configuration.validation.ValidationError;
import info.novatec.inspectit.cmr.property.update.IPropertyUpdate;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.property.IPropertyUpdateListener;
import info.novatec.inspectit.rcp.property.control.impl.BooleanPropertyControl;
import info.novatec.inspectit.rcp.property.control.impl.BytePropertyControl;
import info.novatec.inspectit.rcp.property.control.impl.LongPropertyControl;
import info.novatec.inspectit.rcp.property.control.impl.PercentagePropertyControl;
import info.novatec.inspectit.rcp.property.control.impl.StringPropertyControl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public abstract class AbstractPropertyControl<E extends SingleProperty<V>, V> {
    protected E property;
    protected IPropertyUpdate<V> propertyUpdate;
    protected IPropertyUpdateListener propertyUpdateListener;
    protected ControlDecoration decoration;
    private boolean decorationDisplayed = false;
    private Control control;
    private List<Control> allControls = new ArrayList<Control>();

    protected AbstractPropertyControl(E e, IPropertyUpdateListener iPropertyUpdateListener) {
        this.property = e;
        this.propertyUpdateListener = iPropertyUpdateListener;
    }

    protected abstract Control createControl(Composite var1);

    protected abstract void showDefaultValue();

    public void showIfAdvanced(boolean bl) {
        if (this.property.isAdvanced()) {
            for (Control control : this.allControls) {
                control.setVisible(bl);
            }
            if (this.decorationDisplayed && bl) {
                this.decoration.show();
            } else {
                this.decoration.hide();
            }
        }
    }

    public void restoreDefault() {
        this.showDefaultValue();
        this.propertyUpdate = this.property.createRestoreDefaultPropertyUpdate();
        this.propertyUpdateListener.propertyUpdated((SingleProperty<?>)this.property, this.propertyUpdate);
    }

    public void displayValidationErrors(Collection<ValidationError> collection) {
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder("Validation errors:");
        for (ValidationError validationError : collection) {
            if (!validationError.getInvolvedProperties().contains(this.property)) continue;
            bl = true;
            stringBuilder.append("\n - ");
            stringBuilder.append(validationError.getMessage());
        }
        if (bl) {
            this.decoration.show();
            this.decoration.setDescriptionText(stringBuilder.toString());
        } else {
            this.decoration.hide();
        }
        this.decorationDisplayed = bl;
    }

    public synchronized void create(Composite composite) {
        if (this.control == null) {
            Label label = new Label(composite, 16384);
            label.setText(String.valueOf(this.property.getName()) + ":");
            label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            this.control = this.createControl(composite);
            GridData gridData = new GridData(4, 0x1000000, true, false);
            gridData.widthHint = 175;
            gridData.horizontalIndent = 10;
            this.control.setLayoutData((Object)gridData);
            this.decoration = new ControlDecoration(this.control, 17408);
            this.decoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage());
            this.decoration.hide();
            Label label2 = new Label(composite, 0x1000000);
            label2.setImage(InspectIT.getDefault().getImage("/icons/eclipse/info_obj.gif"));
            label2.setToolTipText(this.property.getDescription());
            label2.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
            Label label3 = new Label(composite, 0x1000000);
            if (this.property.isServerRestartRequired()) {
                label3.setImage(InspectIT.getDefault().getImage("/icons/eclipse/warning_obj.gif"));
                label3.setToolTipText("Changing this property requires restart of the CMR");
            }
            label3.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
            CollectionUtils.addAll(this.allControls, (Object[])new Object[]{label, this.control, label2, label3});
        }
    }

    protected void sendPropertyUpdateEvent(V v) {
        if (!this.property.getValue().equals(v)) {
            try {
                this.propertyUpdate = this.property.createAndValidatePropertyUpdate(v);
                this.propertyUpdateListener.propertyUpdated((SingleProperty<?>)this.property, this.propertyUpdate);
            }
            catch (PropertyValidationException propertyValidationException) {
                PropertyValidation propertyValidation = propertyValidationException.getPropertyValidation();
                this.propertyUpdateListener.propertyValidationFailed((SingleProperty<?>)this.property, propertyValidation);
            }
        } else {
            this.propertyUpdateListener.propertyUpdateCanceled((SingleProperty<?>)this.property);
            this.propertyUpdate = null;
        }
    }

    protected V getLastCorrectValue() {
        if (this.propertyUpdate != null) {
            return (V)this.propertyUpdate.getUpdateValue();
        }
        return (V)this.property.getValue();
    }

    public static AbstractPropertyControl<?, ?> createFor(SingleProperty<?> singleProperty, IPropertyUpdateListener iPropertyUpdateListener) {
        if (singleProperty instanceof BooleanProperty) {
            return new BooleanPropertyControl((BooleanProperty)singleProperty, iPropertyUpdateListener);
        }
        if (singleProperty instanceof PercentageProperty) {
            return new PercentagePropertyControl((PercentageProperty)singleProperty, iPropertyUpdateListener);
        }
        if (singleProperty instanceof StringProperty) {
            return new StringPropertyControl((StringProperty)singleProperty, iPropertyUpdateListener);
        }
        if (singleProperty instanceof LongProperty) {
            return new LongPropertyControl((LongProperty)singleProperty, iPropertyUpdateListener);
        }
        if (singleProperty instanceof ByteProperty) {
            return new BytePropertyControl((ByteProperty)singleProperty, iPropertyUpdateListener);
        }
        return null;
    }
}

