/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.model.ci;

import com.google.common.base.Objects;
import info.novatec.inspectit.ci.Profile;
import info.novatec.inspectit.rcp.model.Leaf;
import info.novatec.inspectit.rcp.provider.IProfileProvider;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.eclipse.core.runtime.Assert;

public class ProfileLeaf
extends Leaf
implements IProfileProvider {
    private Profile profile;
    private CmrRepositoryDefinition cmrRepositoryDefinition;

    public ProfileLeaf(Profile profile, CmrRepositoryDefinition cmrRepositoryDefinition) {
        Assert.isNotNull((Object)profile);
        Assert.isNotNull((Object)cmrRepositoryDefinition);
        this.profile = profile;
        this.cmrRepositoryDefinition = cmrRepositoryDefinition;
        this.setName(profile.getName());
        this.setTooltip(profile.getName());
    }

    @Override
    public Profile getProfile() {
        return this.profile;
    }

    @Override
    public CmrRepositoryDefinition getCmrRepositoryDefinition() {
        return this.cmrRepositoryDefinition;
    }

    @Override
    public int compareTo(IProfileProvider iProfileProvider) {
        Profile profile = iProfileProvider.getProfile();
        return new CompareToBuilder().append(this.profile.isCommonProfile(), profile.isCommonProfile()).append((Object)this.profile.getName(), (Object)profile.getName()).toComparison();
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.profile, this.cmrRepositoryDefinition});
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        ProfileLeaf profileLeaf = (ProfileLeaf)object;
        return Objects.equal((Object)this.profile, (Object)profileLeaf.profile) && Objects.equal((Object)this.cmrRepositoryDefinition, (Object)profileLeaf.cmrRepositoryDefinition);
    }
}

