/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.model;

import info.novatec.inspectit.cmr.model.JmxSensorTypeIdent;
import info.novatec.inspectit.cmr.model.PlatformIdent;
import info.novatec.inspectit.cmr.model.PlatformSensorTypeIdent;
import info.novatec.inspectit.cmr.model.SensorTypeIdent;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.editor.inputdefinition.EditorPropertiesData;
import info.novatec.inspectit.rcp.editor.inputdefinition.InputDefinition;
import info.novatec.inspectit.rcp.formatter.SensorTypeAvailabilityEnum;
import info.novatec.inspectit.rcp.model.Component;
import info.novatec.inspectit.rcp.model.Composite;
import info.novatec.inspectit.rcp.model.DeferredBrowserComposite;
import info.novatec.inspectit.rcp.model.DeferredJmxBrowserComposite;
import info.novatec.inspectit.rcp.model.FilteredDeferredBrowserComposite;
import info.novatec.inspectit.rcp.model.Leaf;
import info.novatec.inspectit.rcp.model.SensorTypeEnum;
import info.novatec.inspectit.rcp.repository.RepositoryDefinition;
import info.novatec.inspectit.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;

public class TreeModelManager {
    private RepositoryDefinition repositoryDefinition;
    private PlatformIdent platformIdent;
    private boolean hideInactiveInstrumentations;

    public TreeModelManager(RepositoryDefinition repositoryDefinition, PlatformIdent platformIdent, boolean bl) {
        Assert.isNotNull((Object)repositoryDefinition);
        this.repositoryDefinition = repositoryDefinition;
        this.platformIdent = platformIdent;
        this.hideInactiveInstrumentations = bl;
    }

    public Object[] getRootElements() {
        ArrayList<Component> arrayList = new ArrayList<Component>();
        if (this.platformIdent != null) {
            arrayList.add(this.getInstrumentedMethodsTree(this.platformIdent, this.repositoryDefinition));
            arrayList.add(this.getInvocationSequenceTree(this.platformIdent, this.repositoryDefinition));
            arrayList.add(this.getSqlTree(this.platformIdent, this.repositoryDefinition));
            arrayList.add(this.getTimerTree(this.platformIdent, this.repositoryDefinition));
            arrayList.add(this.getHttpTimerTree(this.platformIdent, this.repositoryDefinition));
            arrayList.add(this.getJmxSensorTree(this.platformIdent, this.repositoryDefinition));
            arrayList.add(this.getExceptionSensorTree(this.platformIdent, this.repositoryDefinition));
            arrayList.add(this.getSystemOverviewTree(this.platformIdent, this.repositoryDefinition));
        }
        return arrayList.toArray();
    }

    private Component getJmxSensorTree(PlatformIdent platformIdent, RepositoryDefinition repositoryDefinition) {
        Composite composite = new Composite();
        composite.setName("JMX Data");
        composite.setImage(InspectIT.getDefault().getImage("/icons/fugue/bean.png"));
        composite.setTooltip("With these views, the JMX (Java Management Extension) data objects can be analyzed.");
        boolean bl = false;
        for (SensorTypeIdent sensorTypeIdent : platformIdent.getSensorTypeIdents()) {
            if (!(sensorTypeIdent instanceof JmxSensorTypeIdent)) continue;
            bl = true;
            Leaf leaf = new Leaf();
            leaf.setName("Show All");
            leaf.setImage(InspectIT.getDefault().getImage("/icons/eclipse/all_instances.gif"));
            InputDefinition inputDefinition = new InputDefinition();
            inputDefinition.setRepositoryDefinition(repositoryDefinition);
            inputDefinition.setId(SensorTypeEnum.JMX_SENSOR_DATA);
            EditorPropertiesData editorPropertiesData = new EditorPropertiesData();
            editorPropertiesData.setSensorImage(SensorTypeEnum.JMX_SENSOR_DATA.getImage());
            editorPropertiesData.setSensorName("JMX Data");
            editorPropertiesData.setViewImage(InspectIT.getDefault().getImage("/icons/eclipse/all_instances.gif"));
            editorPropertiesData.setViewName("Show All");
            inputDefinition.setEditorPropertiesData(editorPropertiesData);
            InputDefinition.IdDefinition idDefinition = new InputDefinition.IdDefinition();
            idDefinition.setPlatformId(platformIdent.getId());
            idDefinition.setSensorTypeId(sensorTypeIdent.getId());
            inputDefinition.setIdDefinition(idDefinition);
            leaf.setInputDefinition(inputDefinition);
            DeferredJmxBrowserComposite deferredJmxBrowserComposite = new DeferredJmxBrowserComposite();
            deferredJmxBrowserComposite.setPlatformIdent(platformIdent);
            deferredJmxBrowserComposite.setRepositoryDefinition(this.repositoryDefinition);
            deferredJmxBrowserComposite.setName("Browser");
            deferredJmxBrowserComposite.setSensorTypeIdent(sensorTypeIdent);
            composite.addChild(leaf);
            composite.addChild(deferredJmxBrowserComposite);
        }
        if (!bl) {
            composite.setImage(InspectIT.getDefault().getImage("/icons/eclipse/remove_exc.gif"));
            composite.setTooltip(SensorTypeAvailabilityEnum.JMX_SENSOR_NA.getMessage());
        }
        return composite;
    }

    protected Component getInstrumentedMethodsTree(PlatformIdent platformIdent, RepositoryDefinition repositoryDefinition) {
        DeferredBrowserComposite deferredBrowserComposite = new DeferredBrowserComposite();
        deferredBrowserComposite.setName("Instrumentation Browser");
        deferredBrowserComposite.setImage(InspectIT.getDefault().getImage("/icons/fugue/blue-document-tree.png"));
        deferredBrowserComposite.setPlatformIdent(platformIdent);
        deferredBrowserComposite.setRepositoryDefinition(repositoryDefinition);
        deferredBrowserComposite.setHideInactiveInstrumentations(this.hideInactiveInstrumentations);
        deferredBrowserComposite.setTooltip("In this tree, you can see all methods that were being instrumented since the first launch of the Agent. It does not necessarily mean that these methods are currently instrumented and gathering data.");
        return deferredBrowserComposite;
    }

    protected Component getInvocationSequenceTree(PlatformIdent platformIdent, RepositoryDefinition repositoryDefinition) {
        Composite composite = new Composite();
        composite.setName("Invocation Sequences");
        composite.setImage(InspectIT.getDefault().getImage("/icons/fugue/arrow-switch.png"));
        composite.setTooltip("Invocation Sequences are recorded call trees of the application. Only the starting points (which are defined via the invocation sequence sensor in the agent configuration) are shown in the browser tree.");
        Leaf leaf = new Leaf();
        leaf.setName("Show All");
        leaf.setImage(InspectIT.getDefault().getImage("/icons/eclipse/all_instances.gif"));
        InputDefinition inputDefinition = new InputDefinition();
        inputDefinition.setRepositoryDefinition(repositoryDefinition);
        inputDefinition.setId(SensorTypeEnum.INVOCATION_SEQUENCE);
        EditorPropertiesData editorPropertiesData = new EditorPropertiesData();
        editorPropertiesData.setSensorImage(SensorTypeEnum.INVOCATION_SEQUENCE.getImage());
        editorPropertiesData.setSensorName("Invocation Sequences");
        editorPropertiesData.setViewImage(InspectIT.getDefault().getImage("/icons/eclipse/all_instances.gif"));
        editorPropertiesData.setViewName("Show All");
        inputDefinition.setEditorPropertiesData(editorPropertiesData);
        InputDefinition.IdDefinition idDefinition = new InputDefinition.IdDefinition();
        idDefinition.setPlatformId(platformIdent.getId());
        inputDefinition.setIdDefinition(idDefinition);
        leaf.setInputDefinition(inputDefinition);
        FilteredDeferredBrowserComposite filteredDeferredBrowserComposite = new FilteredDeferredBrowserComposite(SensorTypeEnum.INVOCATION_SEQUENCE);
        filteredDeferredBrowserComposite.setPlatformIdent(platformIdent);
        filteredDeferredBrowserComposite.setRepositoryDefinition(this.repositoryDefinition);
        filteredDeferredBrowserComposite.setName("Browser");
        filteredDeferredBrowserComposite.setImage(InspectIT.getDefault().getImage("/icons/fugue/blue-document-tree.png"));
        filteredDeferredBrowserComposite.setTooltip("Only the starting points of invocation sequences (which are defined via the invocation sequence sensor in the agent configuration) are shown in this tree.");
        filteredDeferredBrowserComposite.setHideInactiveInstrumentations(this.hideInactiveInstrumentations);
        composite.addChild(leaf);
        composite.addChild(filteredDeferredBrowserComposite);
        return composite;
    }

    private Component getSqlTree(PlatformIdent platformIdent, RepositoryDefinition repositoryDefinition) {
        Composite composite = new Composite();
        composite.setName("SQL Statements");
        composite.setImage(InspectIT.getDefault().getImage("/icons/fugue/database-sql.png"));
        composite.setTooltip("All recorded SQL statements can be analyzed here.");
        Leaf leaf = new Leaf();
        leaf.setName("Show All");
        leaf.setImage(InspectIT.getDefault().getImage("/icons/eclipse/all_instances.gif"));
        InputDefinition inputDefinition = new InputDefinition();
        inputDefinition.setRepositoryDefinition(repositoryDefinition);
        inputDefinition.setId(SensorTypeEnum.SQL);
        EditorPropertiesData editorPropertiesData = new EditorPropertiesData();
        editorPropertiesData.setSensorName("SQL Statements");
        editorPropertiesData.setSensorImage(SensorTypeEnum.SQL.getImage());
        editorPropertiesData.setViewName("Show All");
        editorPropertiesData.setViewImage(InspectIT.getDefault().getImage("/icons/eclipse/all_instances.gif"));
        inputDefinition.setEditorPropertiesData(editorPropertiesData);
        InputDefinition.IdDefinition idDefinition = new InputDefinition.IdDefinition();
        idDefinition.setPlatformId(platformIdent.getId());
        inputDefinition.setIdDefinition(idDefinition);
        leaf.setInputDefinition(inputDefinition);
        composite.addChild(leaf);
        return composite;
    }

    private Component getSystemOverviewTree(PlatformIdent platformIdent, RepositoryDefinition repositoryDefinition) {
        Composite composite = new Composite();
        composite.setName("System Overview");
        composite.setImage(InspectIT.getDefault().getImage("/icons/fugue/system-monitor.png"));
        Set set = platformIdent.getSensorTypeIdents();
        ArrayList<PlatformSensorTypeIdent> arrayList = new ArrayList<PlatformSensorTypeIdent>();
        for (SensorTypeIdent sensorTypeIdent : set) {
            if (!(sensorTypeIdent instanceof PlatformSensorTypeIdent)) continue;
            PlatformSensorTypeIdent platformSensorTypeIdent = (PlatformSensorTypeIdent)sensorTypeIdent;
            arrayList.add(platformSensorTypeIdent);
        }
        Collections.sort(arrayList, new Comparator<PlatformSensorTypeIdent>(){

            @Override
            public int compare(PlatformSensorTypeIdent platformSensorTypeIdent, PlatformSensorTypeIdent platformSensorTypeIdent2) {
                return platformSensorTypeIdent.getFullyQualifiedClassName().compareTo(platformSensorTypeIdent2.getFullyQualifiedClassName());
            }
        });
        composite.addChild(this.getPlatformSensorClassesLeaf(platformIdent, arrayList, repositoryDefinition));
        composite.addChild(this.getPlatformSensorCpuLeaf(platformIdent, arrayList, repositoryDefinition));
        composite.addChild(this.getPlatformSensorMemoryLeaf(platformIdent, arrayList, repositoryDefinition));
        composite.addChild(this.getPlatformSensorThreadLeaf(platformIdent, arrayList, repositoryDefinition));
        composite.addChild(this.getPlatformSensorVMSummaryLeaf(platformIdent, arrayList, repositoryDefinition));
        Collections.sort(composite.getChildren(), new Comparator<Component>(){

            @Override
            public int compare(Component component, Component component2) {
                return component.getName().compareTo(component2.getName());
            }
        });
        return composite;
    }

    private Component getPlatformSensorCpuLeaf(PlatformIdent platformIdent, List<PlatformSensorTypeIdent> list, RepositoryDefinition repositoryDefinition) {
        Leaf leaf = new Leaf();
        boolean bl = false;
        leaf.setName("CPU");
        leaf.setImage(InspectIT.getDefault().getImage("/icons/fugue/processor.png"));
        for (PlatformSensorTypeIdent platformSensorTypeIdent : list) {
            if (!platformSensorTypeIdent.getFullyQualifiedClassName().equalsIgnoreCase(SensorTypeEnum.CPU_INFORMATION.getFqn())) continue;
            bl = true;
            InputDefinition inputDefinition = new InputDefinition();
            inputDefinition.setRepositoryDefinition(repositoryDefinition);
            inputDefinition.setId(SensorTypeEnum.CPU_INFORMATION);
            EditorPropertiesData editorPropertiesData = new EditorPropertiesData();
            editorPropertiesData.setSensorImage(InspectIT.getDefault().getImage("/icons/fugue/system-monitor.png"));
            editorPropertiesData.setSensorName("System Overview");
            editorPropertiesData.setViewImage(SensorTypeEnum.CPU_INFORMATION.getImage());
            editorPropertiesData.setViewName("CPU Information");
            editorPropertiesData.setPartImageFlag(EditorPropertiesData.PartType.VIEW);
            inputDefinition.setEditorPropertiesData(editorPropertiesData);
            InputDefinition.IdDefinition idDefinition = new InputDefinition.IdDefinition();
            idDefinition.setPlatformId(platformIdent.getId());
            idDefinition.setSensorTypeId(platformSensorTypeIdent.getId());
            inputDefinition.setIdDefinition(idDefinition);
            leaf.setInputDefinition(inputDefinition);
            break;
        }
        if (!bl) {
            leaf.setImage(InspectIT.getDefault().getImage("/icons/eclipse/remove_exc.gif"));
            leaf.setTooltip(SensorTypeAvailabilityEnum.CPU_INF_NA.getMessage());
        }
        return leaf;
    }

    private Component getPlatformSensorClassesLeaf(PlatformIdent platformIdent, List<PlatformSensorTypeIdent> list, RepositoryDefinition repositoryDefinition) {
        Leaf leaf = new Leaf();
        boolean bl = false;
        leaf.setName("Classes");
        leaf.setImage(InspectIT.getDefault().getImage("/icons/eclipse/class_obj.gif"));
        for (PlatformSensorTypeIdent platformSensorTypeIdent : list) {
            if (!platformSensorTypeIdent.getFullyQualifiedClassName().equalsIgnoreCase(SensorTypeEnum.CLASSLOADING_INFORMATION.getFqn())) continue;
            bl = true;
            InputDefinition inputDefinition = new InputDefinition();
            inputDefinition.setRepositoryDefinition(repositoryDefinition);
            inputDefinition.setId(SensorTypeEnum.CLASSLOADING_INFORMATION);
            EditorPropertiesData editorPropertiesData = new EditorPropertiesData();
            editorPropertiesData.setSensorImage(InspectIT.getDefault().getImage("/icons/fugue/system-monitor.png"));
            editorPropertiesData.setSensorName("System Overview");
            editorPropertiesData.setViewImage(SensorTypeEnum.CLASSLOADING_INFORMATION.getImage());
            editorPropertiesData.setViewName("Class Loading Information");
            editorPropertiesData.setPartImageFlag(EditorPropertiesData.PartType.VIEW);
            inputDefinition.setEditorPropertiesData(editorPropertiesData);
            InputDefinition.IdDefinition idDefinition = new InputDefinition.IdDefinition();
            idDefinition.setPlatformId(platformIdent.getId());
            idDefinition.setSensorTypeId(platformSensorTypeIdent.getId());
            inputDefinition.setIdDefinition(idDefinition);
            leaf.setInputDefinition(inputDefinition);
            break;
        }
        if (!bl) {
            leaf.setImage(InspectIT.getDefault().getImage("/icons/eclipse/remove_exc.gif"));
            leaf.setTooltip(SensorTypeAvailabilityEnum.CLASS_INF_NA.getMessage());
        }
        return leaf;
    }

    private Component getPlatformSensorMemoryLeaf(PlatformIdent platformIdent, List<PlatformSensorTypeIdent> list, RepositoryDefinition repositoryDefinition) {
        Leaf leaf = new Leaf();
        boolean bl = false;
        leaf.setName("Memory");
        leaf.setImage(InspectIT.getDefault().getImage("/icons/fugue/memory.png"));
        for (PlatformSensorTypeIdent platformSensorTypeIdent : list) {
            if (!platformSensorTypeIdent.getFullyQualifiedClassName().equalsIgnoreCase(SensorTypeEnum.MEMORY_INFORMATION.getFqn())) continue;
            bl = true;
            ArrayList<PlatformSensorTypeIdent> arrayList = new ArrayList<PlatformSensorTypeIdent>();
            arrayList.add(platformSensorTypeIdent);
            for (PlatformSensorTypeIdent inputDefinition2 : list) {
                if (!inputDefinition2.getFullyQualifiedClassName().equalsIgnoreCase(SensorTypeEnum.SYSTEM_INFORMATION.getFqn())) continue;
                arrayList.add(inputDefinition2);
            }
            InputDefinition inputDefinition = new InputDefinition();
            inputDefinition.setRepositoryDefinition(repositoryDefinition);
            inputDefinition.setId(SensorTypeEnum.MEMORY_INFORMATION);
            EditorPropertiesData editorPropertiesData = new EditorPropertiesData();
            editorPropertiesData.setSensorImage(InspectIT.getDefault().getImage("/icons/fugue/system-monitor.png"));
            editorPropertiesData.setSensorName("System Overview");
            editorPropertiesData.setViewImage(SensorTypeEnum.MEMORY_INFORMATION.getImage());
            editorPropertiesData.setViewName("Memory Information");
            editorPropertiesData.setPartImageFlag(EditorPropertiesData.PartType.VIEW);
            inputDefinition.setEditorPropertiesData(editorPropertiesData);
            InputDefinition.IdDefinition idDefinition = new InputDefinition.IdDefinition();
            idDefinition.setPlatformId(platformIdent.getId());
            idDefinition.setSensorTypeId(platformSensorTypeIdent.getId());
            inputDefinition.setIdDefinition(idDefinition);
            leaf.setInputDefinition(inputDefinition);
            break;
        }
        if (!bl) {
            leaf.setImage(InspectIT.getDefault().getImage("/icons/eclipse/remove_exc.gif"));
            leaf.setTooltip(SensorTypeAvailabilityEnum.MEMORY_INF_NA.getMessage());
        }
        return leaf;
    }

    private Component getPlatformSensorThreadLeaf(PlatformIdent platformIdent, List<PlatformSensorTypeIdent> list, RepositoryDefinition repositoryDefinition) {
        Leaf leaf = new Leaf();
        boolean bl = false;
        leaf.setName("Threads");
        leaf.setImage(InspectIT.getDefault().getImage("/icons/eclipse/debugt_obj.gif"));
        for (PlatformSensorTypeIdent platformSensorTypeIdent : list) {
            if (!platformSensorTypeIdent.getFullyQualifiedClassName().equalsIgnoreCase(SensorTypeEnum.THREAD_INFORMATION.getFqn())) continue;
            bl = true;
            InputDefinition inputDefinition = new InputDefinition();
            inputDefinition.setRepositoryDefinition(repositoryDefinition);
            inputDefinition.setId(SensorTypeEnum.THREAD_INFORMATION);
            EditorPropertiesData editorPropertiesData = new EditorPropertiesData();
            editorPropertiesData.setSensorImage(InspectIT.getDefault().getImage("/icons/fugue/system-monitor.png"));
            editorPropertiesData.setSensorName("System Overview");
            editorPropertiesData.setViewImage(SensorTypeEnum.THREAD_INFORMATION.getImage());
            editorPropertiesData.setViewName("Thread Information");
            editorPropertiesData.setPartImageFlag(EditorPropertiesData.PartType.VIEW);
            inputDefinition.setEditorPropertiesData(editorPropertiesData);
            InputDefinition.IdDefinition idDefinition = new InputDefinition.IdDefinition();
            idDefinition.setPlatformId(platformIdent.getId());
            idDefinition.setSensorTypeId(platformSensorTypeIdent.getId());
            inputDefinition.setIdDefinition(idDefinition);
            leaf.setInputDefinition(inputDefinition);
            break;
        }
        if (!bl) {
            leaf.setImage(InspectIT.getDefault().getImage("/icons/eclipse/remove_exc.gif"));
            leaf.setTooltip(SensorTypeAvailabilityEnum.THREAD_INF_NA.getMessage());
        }
        return leaf;
    }

    private Component getPlatformSensorVMSummaryLeaf(PlatformIdent platformIdent, List<PlatformSensorTypeIdent> list, RepositoryDefinition repositoryDefinition) {
        Leaf leaf = new Leaf();
        boolean bl = false;
        leaf.setName("VM Summary");
        leaf.setImage(InspectIT.getDefault().getImage("/icons/fugue/resource-monitor.png"));
        if (!list.isEmpty()) {
            bl = true;
            InputDefinition inputDefinition = new InputDefinition();
            inputDefinition.setRepositoryDefinition(repositoryDefinition);
            inputDefinition.setId(SensorTypeEnum.SYSTEM_INFORMATION);
            EditorPropertiesData editorPropertiesData = new EditorPropertiesData();
            editorPropertiesData.setSensorImage(InspectIT.getDefault().getImage("/icons/fugue/system-monitor.png"));
            editorPropertiesData.setSensorName("System Overview");
            editorPropertiesData.setViewImage(InspectIT.getDefault().getImage("/icons/fugue/resource-monitor.png"));
            editorPropertiesData.setViewName("VM Summary");
            editorPropertiesData.setPartImageFlag(EditorPropertiesData.PartType.VIEW);
            inputDefinition.setEditorPropertiesData(editorPropertiesData);
            InputDefinition.IdDefinition idDefinition = new InputDefinition.IdDefinition();
            idDefinition.setPlatformId(platformIdent.getId());
            inputDefinition.setIdDefinition(idDefinition);
            leaf.setInputDefinition(inputDefinition);
        }
        if (!bl) {
            leaf.setImage(InspectIT.getDefault().getImage("/icons/eclipse/remove_exc.gif"));
            leaf.setTooltip(SensorTypeAvailabilityEnum.SENSOR_NA.getMessage());
        }
        return leaf;
    }

    private Component getExceptionSensorTree(PlatformIdent platformIdent, RepositoryDefinition repositoryDefinition) {
        Composite composite = new Composite();
        composite.setName("Exceptions");
        composite.setTooltip("All recorded exceptions can be analyzed here.");
        composite.setImage(InspectIT.getDefault().getImage("/icons/eclipse/exceptiontracer.gif"));
        composite.addChild(this.getUngroupedExceptionOverview(platformIdent, repositoryDefinition));
        composite.addChild(this.getGroupedExceptionOverview(platformIdent, repositoryDefinition));
        return composite;
    }

    private Component getUngroupedExceptionOverview(PlatformIdent platformIdent, RepositoryDefinition repositoryDefinition) {
        Leaf leaf = new Leaf();
        leaf.setName("Show All");
        leaf.setImage(InspectIT.getDefault().getImage("/icons/eclipse/all_instances.gif"));
        InputDefinition inputDefinition = new InputDefinition();
        inputDefinition.setRepositoryDefinition(repositoryDefinition);
        inputDefinition.setId(SensorTypeEnum.EXCEPTION_SENSOR);
        EditorPropertiesData editorPropertiesData = new EditorPropertiesData();
        editorPropertiesData.setSensorImage(SensorTypeEnum.EXCEPTION_SENSOR.getImage());
        editorPropertiesData.setSensorName("Exceptions");
        editorPropertiesData.setViewImage(InspectIT.getDefault().getImage("/icons/eclipse/all_instances.gif"));
        editorPropertiesData.setViewName("Show All");
        inputDefinition.setEditorPropertiesData(editorPropertiesData);
        InputDefinition.IdDefinition idDefinition = new InputDefinition.IdDefinition();
        idDefinition.setPlatformId(platformIdent.getId());
        inputDefinition.setIdDefinition(idDefinition);
        leaf.setInputDefinition(inputDefinition);
        return leaf;
    }

    private Component getGroupedExceptionOverview(PlatformIdent platformIdent, RepositoryDefinition repositoryDefinition) {
        Leaf leaf = new Leaf();
        leaf.setName("Grouped");
        leaf.setImage(InspectIT.getDefault().getImage("/icons/eclipse/filter_ps.gif"));
        InputDefinition inputDefinition = new InputDefinition();
        inputDefinition.setRepositoryDefinition(repositoryDefinition);
        inputDefinition.setId(SensorTypeEnum.EXCEPTION_SENSOR_GROUPED);
        EditorPropertiesData editorPropertiesData = new EditorPropertiesData();
        editorPropertiesData.setSensorImage(SensorTypeEnum.EXCEPTION_SENSOR_GROUPED.getImage());
        editorPropertiesData.setSensorName("Exceptions");
        editorPropertiesData.setViewImage(InspectIT.getDefault().getImage("/icons/eclipse/filter_ps.gif"));
        editorPropertiesData.setViewName("Grouped");
        inputDefinition.setEditorPropertiesData(editorPropertiesData);
        InputDefinition.IdDefinition idDefinition = new InputDefinition.IdDefinition();
        idDefinition.setPlatformId(platformIdent.getId());
        inputDefinition.setIdDefinition(idDefinition);
        leaf.setInputDefinition(inputDefinition);
        return leaf;
    }

    private Component getTimerTree(PlatformIdent platformIdent, RepositoryDefinition repositoryDefinition) {
        Composite composite = new Composite();
        composite.setName("Timer Data");
        composite.setImage(InspectIT.getDefault().getImage("/icons/eclipse/method_time.gif"));
        composite.setTooltip("With these views, the timer data objects can be analyzed to identify e.g. long running methods.");
        Leaf leaf = new Leaf();
        leaf.setName("Show All");
        leaf.setImage(InspectIT.getDefault().getImage("/icons/eclipse/all_instances.gif"));
        InputDefinition inputDefinition = new InputDefinition();
        inputDefinition.setRepositoryDefinition(repositoryDefinition);
        inputDefinition.setId(SensorTypeEnum.TIMER);
        EditorPropertiesData editorPropertiesData = new EditorPropertiesData();
        editorPropertiesData.setSensorImage(SensorTypeEnum.TIMER.getImage());
        editorPropertiesData.setSensorName("Timer Data");
        editorPropertiesData.setViewImage(InspectIT.getDefault().getImage("/icons/eclipse/all_instances.gif"));
        editorPropertiesData.setViewName("Show All");
        inputDefinition.setEditorPropertiesData(editorPropertiesData);
        InputDefinition.IdDefinition idDefinition = new InputDefinition.IdDefinition();
        idDefinition.setPlatformId(platformIdent.getId());
        inputDefinition.setIdDefinition(idDefinition);
        leaf.setInputDefinition(inputDefinition);
        FilteredDeferredBrowserComposite filteredDeferredBrowserComposite = new FilteredDeferredBrowserComposite(SensorTypeEnum.TIMER);
        filteredDeferredBrowserComposite.setPlatformIdent(platformIdent);
        filteredDeferredBrowserComposite.setRepositoryDefinition(this.repositoryDefinition);
        filteredDeferredBrowserComposite.setName("Browser");
        filteredDeferredBrowserComposite.setImage(InspectIT.getDefault().getImage("/icons/fugue/blue-document-tree.png"));
        filteredDeferredBrowserComposite.setHideInactiveInstrumentations(this.hideInactiveInstrumentations);
        composite.addChild(leaf);
        composite.addChild(filteredDeferredBrowserComposite);
        return composite;
    }

    private Component getHttpTimerTree(PlatformIdent platformIdent, RepositoryDefinition repositoryDefinition) {
        Object object2;
        Composite composite = new Composite();
        composite.setName("Http Timer Data");
        composite.setImage(InspectIT.getDefault().getImage("/icons/eclipse/discovery.gif"));
        Leaf leaf = new Leaf();
        leaf.setName("URI Aggregation");
        leaf.setImage(InspectIT.getDefault().getImage("/icons/eclipse/url.gif"));
        leaf.setTooltip("Aggregates all http requests that are currently in the buffer based on its URI");
        InputDefinition inputDefinition = new InputDefinition();
        inputDefinition.setRepositoryDefinition(repositoryDefinition);
        inputDefinition.setId(SensorTypeEnum.HTTP_TIMER_SENSOR);
        EditorPropertiesData editorPropertiesData = new EditorPropertiesData();
        editorPropertiesData.setSensorImage(SensorTypeEnum.HTTP_TIMER_SENSOR.getImage());
        editorPropertiesData.setSensorName("Http Timer Data");
        editorPropertiesData.setViewImage(InspectIT.getDefault().getImage("/icons/eclipse/url.gif"));
        editorPropertiesData.setViewName("URI Aggregation");
        inputDefinition.setEditorPropertiesData(editorPropertiesData);
        InputDefinition.IdDefinition idDefinition = new InputDefinition.IdDefinition();
        idDefinition.setPlatformId(platformIdent.getId());
        for (Object object2 : platformIdent.getSensorTypeIdents()) {
            if (!ObjectUtils.equals((Object)object2.getFullyQualifiedClassName(), (Object)SensorTypeEnum.HTTP_TIMER_SENSOR.getFqn())) continue;
            idDefinition.setSensorTypeId(object2.getId());
            break;
        }
        inputDefinition.setIdDefinition(idDefinition);
        leaf.setInputDefinition(inputDefinition);
        composite.addChild(leaf);
        object2 = new Leaf();
        ((Component)object2).setName("Use Case Aggregation");
        ((Component)object2).setImage(InspectIT.getDefault().getImage("/icons/eclipse/gel_sc_obj.gif"));
        ((Component)object2).setTooltip("Aggregates all http request that are currently in the buffer based on a the concrete value of the inspectIT Tag Header (called \"inspectit\")");
        inputDefinition = new InputDefinition();
        inputDefinition.setRepositoryDefinition(repositoryDefinition);
        inputDefinition.setId(SensorTypeEnum.TAGGED_HTTP_TIMER_SENSOR);
        editorPropertiesData = new EditorPropertiesData();
        editorPropertiesData.setSensorImage(SensorTypeEnum.TAGGED_HTTP_TIMER_SENSOR.getImage());
        editorPropertiesData.setSensorName("Http Timer Data");
        editorPropertiesData.setViewImage(InspectIT.getDefault().getImage("/icons/eclipse/gel_sc_obj.gif"));
        editorPropertiesData.setViewName("Use Case Aggregation");
        inputDefinition.setEditorPropertiesData(editorPropertiesData);
        idDefinition = new InputDefinition.IdDefinition();
        idDefinition.setPlatformId(platformIdent.getId());
        inputDefinition.setIdDefinition(idDefinition);
        ((Component)object2).setInputDefinition(inputDefinition);
        composite.addChild((Component)object2);
        return composite;
    }
}

