/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.model;

import info.novatec.inspectit.cmr.model.MethodIdentToSensorType;
import info.novatec.inspectit.cmr.model.MethodSensorTypeIdent;
import info.novatec.inspectit.rcp.InspectIT;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.graphics.Image;

public enum SensorTypeEnum {
    TIMER("info.novatec.inspectit.agent.sensor.method.timer.TimerSensor", "/icons/eclipse/method_time.gif"),
    AVERAGE_TIMER("info.novatec.inspectit.agent.sensor.method.averagetimer.AverageTimerSensor", "/icons/eclipse/method_time.gif"),
    CHARTING_TIMER("info.novatec.inspectit.agent.sensor.method.averagetimer.ChartingTimer", "/icons/eclipse/method_time.gif"),
    CHARTING_MULTI_TIMER("info.novatec.inspectit.agent.sensor.method.averagetimer.ChartingMultiTimer", "/icons/eclipse/method_time.gif"),
    INVOCATION_SEQUENCE("info.novatec.inspectit.agent.sensor.method.invocationsequence.InvocationSequenceSensor", "/icons/fugue/arrow-switch.png"),
    SQL("info.novatec.inspectit.agent.sensor.method.jdbc.SQLTimerSensor", "/icons/fugue/database-sql.png"),
    JDBC_CONNECTION("info.novatec.inspectit.agent.sensor.method.jdbc.ConnectionSensor", "/icons/fugue/database-sql.png", false),
    JDBC_CONNECTION_META_DATA("info.novatec.inspectit.agent.sensor.method.jdbc.ConnectionMetaDataSensor", "/icons/fugue/database-sql.png", false),
    JDBC_STATEMENT("info.novatec.inspectit.agent.sensor.method.jdbc.StatementSensor", "/icons/fugue/database-sql.png", false),
    JDBC_PREPARED_STATEMENT("info.novatec.inspectit.agent.sensor.method.jdbc.PreparedStatementSensor", "/icons/fugue/database-sql.png", false),
    JDBC_PREPARED_STATEMENT_PARAMETER("info.novatec.inspectit.agent.sensor.method.jdbc.PreparedStatementParameterSensor", "/icons/fugue/database-sql.png", false),
    EXCEPTION_SENSOR("info.novatec.inspectit.agent.sensor.exception.ExceptionSensor", "/icons/eclipse/exceptiontracer.gif"),
    EXCEPTION_SENSOR_GROUPED("info.novatec.inspectit.agent.sensor.exception.ExceptionSensorOverview", "/icons/eclipse/exceptiontracer.gif"),
    MARVIN_WORKFLOW("info.novatec.inspectit.agent.sensor.method.marvintimer.MarvinWorkflowSensor", "/icons/fugue/arrow-switch.png"),
    HTTP_TIMER_SENSOR("info.novatec.inspectit.agent.sensor.method.http.HttpSensor", "/icons/eclipse/discovery.gif"),
    TAGGED_HTTP_TIMER_SENSOR("info.novatec.inspectit.agent.sensor.method.http.HttpSensor", "/icons/eclipse/discovery.gif"),
    CHARTING_HTTP_TIMER_SENSOR("info.novatec.inspectit.agent.sensor.method.http.ChartingHttpSensor", "/icons/eclipse/discovery.gif"),
    CLASSLOADING_INFORMATION("info.novatec.inspectit.agent.sensor.platform.ClassLoadingInformation", "/icons/eclipse/class_obj.gif"),
    COMPILATION_INFORMATION("info.novatec.inspectit.agent.sensor.platform.CompilationInformation", null),
    MEMORY_INFORMATION("info.novatec.inspectit.agent.sensor.platform.MemoryInformation", "/icons/fugue/memory.png"),
    CPU_INFORMATION("info.novatec.inspectit.agent.sensor.platform.CpuInformation", "/icons/fugue/processor.png"),
    RUNTIME_INFORMATION("info.novatec.inspectit.agent.sensor.platform.RuntimeInformation", null),
    SYSTEM_INFORMATION("info.novatec.inspectit.agent.sensor.platform.SystemInformation", "/icons/fugue/system-monitor.png"),
    THREAD_INFORMATION("info.novatec.inspectit.agent.sensor.platform.ThreadInformation", "/icons/eclipse/debugt_obj.gif"),
    NAVIGATION_INVOCATION("info.novatec.inspectit.agent.sensor.method.invocationsequence.NavigationInvocationSequenceSensor", "/icons/fugue/arrow-switch.png"),
    MULTI_INVOC_DATA("info.novatec.inspectit.agent.sensor.method.MultiInvocSensor", "/icons/fugue/arrow-switch.png"),
    LOG4J_LOGGING_DATA("info.novatec.inspectit.agent.sensor.method.logging.Log4JLoggingSensor", "/icons/eclipse/log.gif"),
    JMX_SENSOR_DATA("info.novatec.inspectit.agent.sensor.jmx.JmxSensor", "/icons/fugue/bean.png"),
    CHARTING_JMX_SENSOR_DATA("info.novatec.inspectit.agent.sensor.jmx.JmxSensor", "/icons/fugue/bean.png");

    private static final Map<String, SensorTypeEnum> LOOKUP;
    private String fqn;
    private Image image;
    private boolean openable = true;

    static {
        LOOKUP = new HashMap<String, SensorTypeEnum>();
        for (SensorTypeEnum sensorTypeEnum : EnumSet.allOf(SensorTypeEnum.class)) {
            LOOKUP.put(sensorTypeEnum.getFqn(), sensorTypeEnum);
        }
    }

    private SensorTypeEnum(String string2, String string3) {
        this.fqn = string2;
        this.image = InspectIT.getDefault().getImage(string3);
    }

    private SensorTypeEnum(String string2, String string3, boolean bl) {
        this.fqn = string2;
        this.image = InspectIT.getDefault().getImage(string3);
        this.openable = bl;
    }

    public String getFqn() {
        return this.fqn;
    }

    public static SensorTypeEnum get(String string) {
        return LOOKUP.get(string);
    }

    public static Set<SensorTypeEnum> getAllOf(Set<MethodIdentToSensorType> set) {
        EnumSet<SensorTypeEnum> enumSet = EnumSet.noneOf(SensorTypeEnum.class);
        for (MethodIdentToSensorType methodIdentToSensorType : set) {
            MethodSensorTypeIdent methodSensorTypeIdent = methodIdentToSensorType.getMethodSensorTypeIdent();
            SensorTypeEnum sensorTypeEnum = SensorTypeEnum.get(methodSensorTypeIdent.getFullyQualifiedClassName());
            if (sensorTypeEnum != null) {
                enumSet.add(sensorTypeEnum);
                continue;
            }
            throw new RuntimeException("Lookup for the enum of sensor type " + methodSensorTypeIdent.getFullyQualifiedClassName() + " fails");
        }
        return enumSet;
    }

    public Image getImage() {
        return this.image;
    }

    public String getDisplayName() {
        StringBuilder stringBuilder = new StringBuilder(this.name().toLowerCase().replaceAll("_", " "));
        Character c = Character.valueOf(stringBuilder.charAt(0));
        c = Character.valueOf(Character.toUpperCase(c.charValue()));
        stringBuilder.setCharAt(0, c.charValue());
        int n = 0;
        while (n >= 0) {
            if ((n = stringBuilder.indexOf(" ", n)) < 0) continue;
            c = Character.valueOf(Character.toUpperCase(stringBuilder.charAt(++n)));
            stringBuilder.setCharAt(n, c.charValue());
        }
        return stringBuilder.toString();
    }

    public boolean isOpenable() {
        return this.openable;
    }
}

