/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.menu;

import info.novatec.inspectit.rcp.InspectIT;
import java.util.ArrayList;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;

public class ShowHideMenuManager
extends MenuManager
implements IMenuListener {
    private ColumnViewer columnViewer;
    private Class<?> inputControllerClass;

    public ShowHideMenuManager(ColumnViewer columnViewer, Class<?> clazz) {
        Assert.isNotNull((Object)columnViewer);
        Assert.isNotNull(clazz);
        this.columnViewer = columnViewer;
        this.inputControllerClass = clazz;
        this.addMenuListener(this);
        IAction[] iActionArray = this.getActionItems();
        int n = iActionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAction iAction = iActionArray[n2];
            this.add(iAction);
            ++n2;
        }
    }

    public void menuAboutToShow(IMenuManager iMenuManager) {
        this.removeAll();
        IAction[] iActionArray = this.getActionItems();
        int n = iActionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAction iAction = iActionArray[n2];
            this.add(iAction);
            ++n2;
        }
    }

    private IAction[] getActionItems() {
        ArrayList<ShowHideColumnAction> arrayList;
        block3: {
            TreeColumn[] treeColumnArray;
            block2: {
                TableColumn[] tableColumnArray;
                arrayList = new ArrayList<ShowHideColumnAction>();
                if (!(this.columnViewer instanceof TableViewer)) break block2;
                TableColumn[] tableColumnArray2 = tableColumnArray = ((TableViewer)this.columnViewer).getTable().getColumns();
                int n = tableColumnArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableColumn tableColumn = tableColumnArray2[n2];
                    arrayList.add(new ShowHideColumnAction((Item)tableColumn));
                    ++n2;
                }
                break block3;
            }
            if (!(this.columnViewer instanceof TreeViewer)) break block3;
            TreeColumn[] treeColumnArray2 = treeColumnArray = ((TreeViewer)this.columnViewer).getTree().getColumns();
            int n = treeColumnArray.length;
            int n3 = 0;
            while (n3 < n) {
                TreeColumn treeColumn = treeColumnArray2[n3];
                arrayList.add(new ShowHideColumnAction((Item)treeColumn));
                ++n3;
            }
        }
        return arrayList.toArray(new IAction[arrayList.size()]);
    }

    private class ShowHideColumnAction
    extends Action {
        private Item column;
        private boolean visible;

        public ShowHideColumnAction(Item item) {
            String string;
            Assert.isNotNull((Object)item);
            this.column = item;
            ImageDescriptor imageDescriptor = null;
            int n = 0;
            if (item instanceof TableColumn) {
                n = ((TableColumn)item).getWidth();
            } else if (item instanceof TreeColumn) {
                n = ((TreeColumn)item).getWidth();
            } else {
                RuntimeException runtimeException = new RuntimeException("Unsupported item provided during dynamic columns menu creation. Item class is " + item.getClass().getName() + ".");
                InspectIT.getDefault().createErrorDialog("Error creating dynamic column menu", runtimeException, -1);
                throw runtimeException;
            }
            if (n > 0) {
                this.visible = false;
                string = "Hide column";
                imageDescriptor = InspectIT.getDefault().getImageDescriptor("/icons/eclipse/complete_status.gif");
            } else {
                this.visible = true;
                string = "Show column";
            }
            this.setText(item.getText());
            this.setImageDescriptor(imageDescriptor);
            this.setToolTipText(string);
        }

        public void run() {
            IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IHandlerService iHandlerService = (IHandlerService)iWorkbenchWindow.getService(IHandlerService.class);
            ICommandService iCommandService = (ICommandService)iWorkbenchWindow.getService(ICommandService.class);
            Command command = iCommandService.getCommand("info.novatec.inspectit.rcp.commands.showHideColumn");
            ExecutionEvent executionEvent = iHandlerService.createExecutionEvent(command, new Event());
            IEvaluationContext iEvaluationContext = (IEvaluationContext)executionEvent.getApplicationContext();
            iEvaluationContext.addVariable("info.novatec.inspectit.rcp.commands.showHideColumn.Column", (Object)this.column);
            iEvaluationContext.addVariable("info.novatec.inspectit.rcp.commands.showHideColumn.Visible", (Object)this.visible);
            iEvaluationContext.addVariable("info.novatec.inspectit.rcp.commands.showHideColumn.ControllerClass", (Object)ShowHideMenuManager.this.inputControllerClass);
            try {
                command.executeWithChecks(executionEvent);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }
}

