/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.handlers;

import info.novatec.inspectit.exception.BusinessException;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.dialog.EditNameDescriptionDialog;
import info.novatec.inspectit.rcp.provider.IStorageDataProvider;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import info.novatec.inspectit.storage.StorageData;
import info.novatec.inspectit.storage.serializer.SerializationException;
import java.io.IOException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class EditStorageDataHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        block7: {
            IStorageDataProvider iStorageDataProvider = null;
            Object object = ((StructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)executionEvent)).getFirstElement();
            if (!(object instanceof IStorageDataProvider)) {
                return null;
            }
            iStorageDataProvider = (IStorageDataProvider)object;
            StorageData storageData = iStorageDataProvider.getStorageData();
            EditNameDescriptionDialog editNameDescriptionDialog = new EditNameDescriptionDialog(HandlerUtil.getActiveShell((ExecutionEvent)executionEvent), storageData.getName(), storageData.getDescription());
            editNameDescriptionDialog.open();
            if (editNameDescriptionDialog.getReturnCode() == 0) {
                CmrRepositoryDefinition cmrRepositoryDefinition = iStorageDataProvider.getCmrRepositoryDefinition();
                if (cmrRepositoryDefinition.getOnlineStatus() != CmrRepositoryDefinition.OnlineStatus.OFFLINE) {
                    try {
                        storageData.setName(editNameDescriptionDialog.getName());
                        storageData.setDescription(editNameDescriptionDialog.getDescription());
                        cmrRepositoryDefinition.getStorageService().updateStorageData(storageData);
                        try {
                            InspectIT.getDefault().getInspectITStorageManager().storageRemotelyUpdated(storageData);
                            break block7;
                        }
                        catch (SerializationException | IOException throwable) {
                            throw new ExecutionException("Storage data update failed.", throwable);
                        }
                    }
                    catch (BusinessException businessException) {
                        throw new ExecutionException("Storage data update failed.", (Throwable)businessException);
                    }
                }
                InspectIT.getDefault().createInfoDialog("Storage data can not be updated, because the underlying repository is currently offline.", -1);
            }
        }
        return null;
    }
}

