/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.handlers;

import info.novatec.inspectit.exception.BusinessException;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.handlers.CloseStorageHandler;
import info.novatec.inspectit.rcp.provider.IStorageDataProvider;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import info.novatec.inspectit.rcp.repository.StorageRepositoryDefinition;
import info.novatec.inspectit.rcp.storage.InspectITStorageManager;
import info.novatec.inspectit.rcp.view.impl.DataExplorerView;
import info.novatec.inspectit.rcp.view.impl.StorageManagerView;
import info.novatec.inspectit.storage.StorageData;
import info.novatec.inspectit.storage.serializer.SerializationException;
import java.io.IOException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class CloseAndShowStorageHandler
extends CloseStorageHandler
implements IHandler {
    public static final String COMMAND = "info.novatec.inspectit.rcp.commands.closeAndShowStorage";
    public static final String STORAGE_DATA_PROVIDER = "info.novatec.inspectit.rcp.commands.closeAndShowStorage.param";

    @Override
    public Object execute(final ExecutionEvent executionEvent) throws ExecutionException {
        IStorageDataProvider iStorageDataProvider = (IStorageDataProvider)HandlerUtil.getVariable((ExecutionEvent)executionEvent, (String)STORAGE_DATA_PROVIDER);
        final StorageData storageData = iStorageDataProvider.getStorageData();
        final CmrRepositoryDefinition cmrRepositoryDefinition = iStorageDataProvider.getCmrRepositoryDefinition();
        if (cmrRepositoryDefinition.getOnlineStatus() != CmrRepositoryDefinition.OnlineStatus.OFFLINE) {
            CloseStorageHandler.FinalizeStorageJob finalizeStorageJob = new CloseStorageHandler.FinalizeStorageJob(storageData, cmrRepositoryDefinition);
            finalizeStorageJob.schedule();
            finalizeStorageJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent iJobChangeEvent) {
                    Job job = new Job("Mounting Storage"){

                        protected IStatus run(IProgressMonitor iProgressMonitor) {
                            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor);
                            InspectITStorageManager inspectITStorageManager = InspectIT.getDefault().getInspectITStorageManager();
                            StorageRepositoryDefinition storageRepositoryDefinition = null;
                            try {
                                inspectITStorageManager.mountStorage(storageData, cmrRepositoryDefinition, subMonitor);
                                storageRepositoryDefinition = inspectITStorageManager.getStorageRepositoryDefinition(inspectITStorageManager.getLocalDataForStorage(storageData));
                            }
                            catch (BusinessException | SerializationException | IOException throwable) {
                                return new Status(4, "info.novatec.inspectit.rcp", "There was an exception trying to open the storage.", throwable);
                            }
                            final IWorkbenchPage iWorkbenchPage = HandlerUtil.getActiveSite((ExecutionEvent)executionEvent).getPage();
                            final StorageRepositoryDefinition storageRepositoryDefinition2 = storageRepositoryDefinition;
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    IViewPart iViewPart = iWorkbenchPage.findView("info.novatec.inspectit.rcp.view.dataExplorer");
                                    IViewPart iViewPart2 = iWorkbenchPage.findView("info.novatec.inspectit.rcp.view.storageManager");
                                    if (iViewPart == null) {
                                        try {
                                            iViewPart = iWorkbenchPage.showView("info.novatec.inspectit.rcp.view.dataExplorer");
                                        }
                                        catch (PartInitException partInitException) {
                                            return;
                                        }
                                    }
                                    if (iViewPart instanceof DataExplorerView) {
                                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)iViewPart);
                                        ((DataExplorerView)iViewPart).showRepository(storageRepositoryDefinition2, null);
                                    }
                                    if (iViewPart2 instanceof StorageManagerView) {
                                        ((StorageManagerView)iViewPart2).refresh(cmrRepositoryDefinition);
                                    }
                                }
                            });
                            iProgressMonitor.done();
                            return Status.OK_STATUS;
                        }
                    };
                    job.setUser(true);
                    job.schedule();
                }
            });
        } else {
            InspectIT.getDefault().createInfoDialog("Can not finalize storage, CMR repository is offline.", -1);
        }
        return null;
    }
}

