/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.formatter;

import info.novatec.inspectit.ci.assignment.impl.MethodSensorAssignment;
import info.novatec.inspectit.ci.sensor.ISensorConfig;
import info.novatec.inspectit.ci.sensor.exception.impl.ExceptionSensorConfig;
import info.novatec.inspectit.ci.sensor.method.impl.ConnectionMetaDataSensorConfig;
import info.novatec.inspectit.ci.sensor.method.impl.ConnectionSensorConfig;
import info.novatec.inspectit.ci.sensor.method.impl.HttpSensorConfig;
import info.novatec.inspectit.ci.sensor.method.impl.InvocationSequenceSensorConfig;
import info.novatec.inspectit.ci.sensor.method.impl.Log4jLoggingSensorConfig;
import info.novatec.inspectit.ci.sensor.method.impl.PreparedStatementParameterSensorConfig;
import info.novatec.inspectit.ci.sensor.method.impl.PreparedStatementSensorConfig;
import info.novatec.inspectit.ci.sensor.method.impl.StatementSensorConfig;
import info.novatec.inspectit.ci.sensor.method.impl.TimerSensorConfig;
import info.novatec.inspectit.ci.sensor.platform.impl.ClassLoadingSensorConfig;
import info.novatec.inspectit.ci.sensor.platform.impl.CompilationSensorConfig;
import info.novatec.inspectit.ci.sensor.platform.impl.CpuSensorConfig;
import info.novatec.inspectit.ci.sensor.platform.impl.MemorySensorConfig;
import info.novatec.inspectit.ci.sensor.platform.impl.RuntimeSensorConfig;
import info.novatec.inspectit.ci.sensor.platform.impl.SystemSensorConfig;
import info.novatec.inspectit.ci.sensor.platform.impl.ThreadSensorConfig;
import info.novatec.inspectit.cmr.model.JmxDefinitionDataIdent;
import info.novatec.inspectit.cmr.model.MethodIdent;
import info.novatec.inspectit.cmr.model.PlatformIdent;
import info.novatec.inspectit.communication.data.ExceptionSensorData;
import info.novatec.inspectit.communication.data.HttpTimerData;
import info.novatec.inspectit.communication.data.InvocationAwareData;
import info.novatec.inspectit.communication.data.SqlStatementData;
import info.novatec.inspectit.communication.data.TimerData;
import info.novatec.inspectit.communication.data.cmr.AgentStatusData;
import info.novatec.inspectit.communication.data.cmr.WritingStatus;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.formatter.NumberFormatter;
import info.novatec.inspectit.rcp.model.AgentFolderFactory;
import info.novatec.inspectit.rcp.model.AgentLeaf;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import info.novatec.inspectit.rcp.repository.RepositoryDefinition;
import info.novatec.inspectit.rcp.util.data.RegExAggregatedHttpTimerData;
import info.novatec.inspectit.storage.LocalStorageData;
import info.novatec.inspectit.storage.StorageData;
import info.novatec.inspectit.storage.label.AbstractStorageLabel;
import info.novatec.inspectit.storage.label.BooleanStorageLabel;
import info.novatec.inspectit.storage.label.type.AbstractCustomStorageLabelType;
import info.novatec.inspectit.storage.label.type.AbstractStorageLabelType;
import info.novatec.inspectit.storage.label.type.impl.AssigneeLabelType;
import info.novatec.inspectit.storage.label.type.impl.CreationDateLabelType;
import info.novatec.inspectit.storage.label.type.impl.DataTimeFrameLabelType;
import info.novatec.inspectit.storage.label.type.impl.ExploredByLabelType;
import info.novatec.inspectit.storage.label.type.impl.RatingLabelType;
import info.novatec.inspectit.storage.label.type.impl.StatusLabelType;
import info.novatec.inspectit.storage.label.type.impl.UseCaseLabelType;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.TextStyle;

public final class TextFormatter {
    public static final String FONT_ERROR_MARKER = "de.inspectit.font.errormarker";
    public static final int DEFAULT_FONT_ERROR_SIZE = 10;

    static {
        FontData[] fontDataArray = JFaceResources.getDefaultFontDescriptor().getFontData();
        if (fontDataArray.length > 0) {
            FontData fontData = fontDataArray[0];
            int n = (int)fontData.height;
            JFaceResources.getFontRegistry().put(FONT_ERROR_MARKER, new FontData[]{new FontData("Arial", n, 3)});
        } else {
            JFaceResources.getFontRegistry().put(FONT_ERROR_MARKER, new FontData[]{new FontData("Arial", 10, 3)});
        }
    }

    private TextFormatter() {
    }

    public static StyledString getStyledMethodString(MethodIdent methodIdent) {
        StyledString styledString = new StyledString();
        styledString.append(TextFormatter.getMethodWithParameters(methodIdent));
        String string = methodIdent.getPackageName() != null && !methodIdent.getPackageName().equals("") ? MessageFormat.format("- {0}.{1}", methodIdent.getPackageName(), methodIdent.getClassName()) : MessageFormat.format("- {0}", methodIdent.getClassName());
        styledString.append(string, StyledString.QUALIFIER_STYLER);
        return styledString;
    }

    public static String getMethodWithParameters(MethodIdent methodIdent) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = "";
        if (methodIdent.getParameters() != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string2 : methodIdent.getParameters()) {
                String[] stringArray = string2.split("\\.");
                arrayList.add(stringArray[stringArray.length - 1]);
            }
            string = ((Object)arrayList).toString();
            string = string.substring(1, string.length() - 1);
        }
        stringBuilder.append(methodIdent.getMethodName());
        stringBuilder.append('(');
        stringBuilder.append(string);
        stringBuilder.append(") ");
        return stringBuilder.toString();
    }

    public static String getMethodWithParameters(MethodSensorAssignment methodSensorAssignment) {
        if (methodSensorAssignment.getMethodName() == null && !methodSensorAssignment.isConstructor()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (methodSensorAssignment.isConstructor()) {
            stringBuilder.append("<init>");
        } else {
            stringBuilder.append(methodSensorAssignment.getMethodName());
        }
        if (methodSensorAssignment.getParameters() != null) {
            if (methodSensorAssignment.getParameters().isEmpty()) {
                stringBuilder.append("()");
            } else {
                String string = methodSensorAssignment.getParameters().toString();
                string = string.substring(1, string.length() - 1);
                stringBuilder.append('(');
                stringBuilder.append(string);
                stringBuilder.append(')');
            }
        }
        return stringBuilder.toString();
    }

    public static String getMethodString(MethodIdent methodIdent) {
        return TextFormatter.getStyledMethodString(methodIdent).getString();
    }

    public static String getJmxDefinitionString(JmxDefinitionDataIdent jmxDefinitionDataIdent) {
        return String.format("%1$s - %2$s:%3$s", jmxDefinitionDataIdent.getmBeanAttributeName(), jmxDefinitionDataIdent.getDerivedDomainName(), jmxDefinitionDataIdent.getDerivedTypeName());
    }

    public static StyledString getInvocationAffilliationPercentageString(int n, int n2) {
        StyledString styledString = new StyledString();
        styledString.append(String.valueOf(n), StyledString.QUALIFIER_STYLER);
        styledString.append("% (in ", StyledString.QUALIFIER_STYLER);
        styledString.append(String.valueOf(n2), StyledString.QUALIFIER_STYLER);
        styledString.append(" inv)", StyledString.QUALIFIER_STYLER);
        return styledString;
    }

    public static StyledString getWarningSign() {
        return new StyledString(" !", new StyledString.Styler(){

            public void applyStyles(TextStyle textStyle) {
                textStyle.foreground = JFaceResources.getColorRegistry().get("ERROR_COLOR");
                textStyle.font = JFaceResources.getFont((String)TextFormatter.FONT_ERROR_MARKER);
            }
        });
    }

    public static String getInvocationAwareDataTextualRepresentation(InvocationAwareData invocationAwareData, RepositoryDefinition repositoryDefinition) {
        if (invocationAwareData instanceof SqlStatementData) {
            SqlStatementData sqlStatementData = (SqlStatementData)invocationAwareData;
            return "SQL: " + sqlStatementData.getSql();
        }
        if (invocationAwareData instanceof RegExAggregatedHttpTimerData) {
            return "transformed URI: " + ((RegExAggregatedHttpTimerData)invocationAwareData).getTransformedUri();
        }
        if (invocationAwareData instanceof HttpTimerData) {
            HttpTimerData httpTimerData = (HttpTimerData)invocationAwareData;
            if (!"n.a.".equals(httpTimerData.getHttpInfo().getUri())) {
                return "URI: " + httpTimerData.getHttpInfo().getUri();
            }
            return "Usecase: " + httpTimerData.getHttpInfo().getInspectItTaggingHeaderValue();
        }
        if (invocationAwareData instanceof ExceptionSensorData) {
            ExceptionSensorData exceptionSensorData = (ExceptionSensorData)invocationAwareData;
            return "Exception: " + exceptionSensorData.getThrowableType();
        }
        if (invocationAwareData instanceof TimerData) {
            TimerData timerData = (TimerData)invocationAwareData;
            MethodIdent methodIdent = repositoryDefinition.getCachedDataService().getMethodIdentForId(timerData.getMethodIdent());
            return TextFormatter.getMethodString(methodIdent);
        }
        return "";
    }

    public static StyledString getStyledStorageDataString(StorageData storageData, CmrRepositoryDefinition cmrRepositoryDefinition) {
        StyledString styledString = new StyledString();
        styledString.append(storageData.getName());
        styledString.append(" ");
        styledString.append("[" + cmrRepositoryDefinition.getName() + "]", StyledString.QUALIFIER_STYLER);
        styledString.append(" - ");
        styledString.append(TextFormatter.getStorageStateTextualRepresentation(storageData.getState()), StyledString.DECORATIONS_STYLER);
        if (InspectIT.getDefault().getInspectITStorageManager().isFullyDownloaded(storageData)) {
            styledString.append(", Downloaded", StyledString.DECORATIONS_STYLER);
        }
        styledString.append(", " + NumberFormatter.humanReadableByteCount(storageData.getDiskSize()), StyledString.DECORATIONS_STYLER);
        return styledString;
    }

    public static StyledString getStyledStorageDataString(LocalStorageData localStorageData) {
        StyledString styledString = new StyledString();
        styledString.append(localStorageData.getName());
        styledString.append(" ");
        styledString.append("[Local Disk]", StyledString.QUALIFIER_STYLER);
        styledString.append(" - ");
        styledString.append(NumberFormatter.humanReadableByteCount(localStorageData.getDiskSize()), StyledString.DECORATIONS_STYLER);
        return styledString;
    }

    public static StyledString getStyledAgentLeafString(AgentLeaf agentLeaf) {
        StyledString styledString = new StyledString();
        if (agentLeaf.isInFolder()) {
            styledString.append(AgentFolderFactory.getAgentDisplayNameInFolder(agentLeaf.getPlatformIdent().getAgentName()));
        } else {
            styledString.append(agentLeaf.getPlatformIdent().getAgentName());
        }
        styledString.append(TextFormatter.getStyledAgentDescription(agentLeaf.getPlatformIdent(), agentLeaf.getAgentStatusData()));
        return styledString;
    }

    private static StyledString getStyledAgentDescription(PlatformIdent platformIdent, AgentStatusData agentStatusData) {
        StyledString styledString = new StyledString();
        styledString.append(" ");
        styledString.append("[" + platformIdent.getVersion() + "]", StyledString.QUALIFIER_STYLER);
        styledString.append(" - ");
        if (agentStatusData != null) {
            switch (agentStatusData.getAgentConnection()) {
                case CONNECTED: {
                    if (agentStatusData.getMillisSinceLastData() != null) {
                        long l = agentStatusData.getMillisSinceLastData();
                        if (l > 60000L) {
                            styledString.append("Connected :: Last data sent " + NumberFormatter.humanReadableMillisCount(l, true) + " ago", StyledString.DECORATIONS_STYLER);
                            break;
                        }
                        styledString.append("Connected :: Sending data", StyledString.DECORATIONS_STYLER);
                        break;
                    }
                    styledString.append("Connected :: No data sent", StyledString.DECORATIONS_STYLER);
                    break;
                }
                case NO_KEEP_ALIVE: {
                    long l = System.currentTimeMillis() - agentStatusData.getLastKeepAliveTimestamp();
                    styledString.append("No keep-alive signal for " + NumberFormatter.humanReadableMillisCount(l, true), StyledString.DECORATIONS_STYLER);
                    break;
                }
                case DISCONNECTED: {
                    styledString.append("Disconnected", StyledString.DECORATIONS_STYLER);
                    break;
                }
                default: {
                    styledString.append("Not connected", StyledString.DECORATIONS_STYLER);
                    break;
                }
            }
        } else {
            styledString.append("Not connected", StyledString.DECORATIONS_STYLER);
        }
        return styledString;
    }

    public static String getStorageStateTextualRepresentation(StorageData.StorageState storageState) {
        if (storageState == StorageData.StorageState.CREATED_NOT_OPENED) {
            return "Created";
        }
        if (storageState == StorageData.StorageState.OPENED) {
            return "Writable";
        }
        if (storageState == StorageData.StorageState.CLOSED) {
            return "Readable";
        }
        if (storageState == StorageData.StorageState.RECORDING) {
            return "Recording";
        }
        return "UNKNOWN STATE";
    }

    public static String getLabelName(AbstractStorageLabel<?> abstractStorageLabel) {
        if (abstractStorageLabel == null) {
            return "null";
        }
        return TextFormatter.getLabelName(abstractStorageLabel.getStorageLabelType());
    }

    public static String getLabelName(AbstractStorageLabelType<?> abstractStorageLabelType) {
        if (abstractStorageLabelType == null) {
            return "null";
        }
        if (AssigneeLabelType.class.equals(abstractStorageLabelType.getClass())) {
            return "Assignee";
        }
        if (CreationDateLabelType.class.equals(abstractStorageLabelType.getClass())) {
            return "Creation Date";
        }
        if (ExploredByLabelType.class.equals(abstractStorageLabelType.getClass())) {
            return "Explored By";
        }
        if (RatingLabelType.class.equals(abstractStorageLabelType.getClass())) {
            return "Rating";
        }
        if (StatusLabelType.class.equals(abstractStorageLabelType.getClass())) {
            return "Status";
        }
        if (UseCaseLabelType.class.equals(abstractStorageLabelType.getClass())) {
            return "Use Case";
        }
        if (DataTimeFrameLabelType.class.equals(abstractStorageLabelType.getClass())) {
            return "Data Timeframe";
        }
        if (AbstractCustomStorageLabelType.class.isAssignableFrom(abstractStorageLabelType.getClass())) {
            return ((AbstractCustomStorageLabelType)abstractStorageLabelType).getName();
        }
        return "Unknown Label";
    }

    public static String getLabelValueType(AbstractStorageLabelType<?> abstractStorageLabelType) {
        if (abstractStorageLabelType == null) {
            return "null";
        }
        if (Boolean.class.equals((Object)abstractStorageLabelType.getValueClass())) {
            return "Yes/No";
        }
        if (Date.class.equals((Object)abstractStorageLabelType.getValueClass())) {
            return "Date";
        }
        if (Number.class.equals((Object)abstractStorageLabelType.getValueClass())) {
            return "Number";
        }
        if (String.class.equals((Object)abstractStorageLabelType.getValueClass())) {
            return "Text";
        }
        return "Unknown Label Type";
    }

    public static String getLabelValue(AbstractStorageLabel<?> abstractStorageLabel, boolean bl) {
        if (abstractStorageLabel == null) {
            return "null";
        }
        if (CreationDateLabelType.class.equals(abstractStorageLabel.getStorageLabelType().getClass())) {
            Date date = (Date)abstractStorageLabel.getValue();
            if (bl) {
                return DateFormat.getDateInstance().format(date);
            }
            return DateFormat.getDateTimeInstance().format(date);
        }
        if (BooleanStorageLabel.class.equals(abstractStorageLabel.getClass())) {
            BooleanStorageLabel booleanStorageLabel = (BooleanStorageLabel)abstractStorageLabel;
            if (booleanStorageLabel.getValue().booleanValue()) {
                return "Yes";
            }
            return "No";
        }
        return abstractStorageLabel.getFormatedValue();
    }

    public static String getWritingStatusText(WritingStatus writingStatus) {
        if (writingStatus == null) {
            return "";
        }
        switch (writingStatus) {
            case GOOD: {
                return "[OK] There are no problems.";
            }
            case MEDIUM: {
                return "[WARN] Amount of data tried to be recorded is slightly higer than what CMR can support. However, no data loss should be expected.";
            }
            case BAD: {
                return "[ALERT] Amount of data tried to be recorded is too high for CMR to manage. Data loss should be expected.";
            }
        }
        return "";
    }

    public static String getAgentDescription(PlatformIdent platformIdent) {
        return String.valueOf(platformIdent.getAgentName()) + " [" + platformIdent.getVersion() + "]";
    }

    public static String getAgentDescription(PlatformIdent platformIdent, AgentStatusData agentStatusData) {
        return String.valueOf(platformIdent.getAgentName()) + TextFormatter.getStyledAgentDescription(platformIdent, agentStatusData).getString();
    }

    public static String getCmrRepositoryDescription(CmrRepositoryDefinition cmrRepositoryDefinition) {
        return "Central Management Repository @ http://" + cmrRepositoryDefinition.getIp() + ":" + cmrRepositoryDefinition.getPort();
    }

    public static String getSqlParametersText(List<String> list) {
        if (list == null || list.isEmpty()) {
            return "[]";
        }
        Iterator<String> iterator = list.iterator();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (string != null) {
                stringBuilder.append(string);
            } else {
                stringBuilder.append('?');
            }
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.append(']').toString();
    }

    public static String clearLineBreaks(String string) {
        if (string == null) {
            return string;
        }
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '\r' || c == '\n') {
                if (!bl) {
                    stringBuilder.append(' ');
                    bl = true;
                }
            } else if (Character.isWhitespace(c)) {
                if (!bl) {
                    stringBuilder.append(' ');
                    bl = true;
                }
            } else {
                stringBuilder.append(c);
                bl = false;
            }
            ++n;
        }
        return stringBuilder.toString();
    }

    public static String crop(String string, int n) {
        return StringUtils.abbreviate((String)string, (int)n);
    }

    public static StyledString emptyStyledStringIfNull(String string) {
        return new StyledString(TextFormatter.emptyStringIfNull(string));
    }

    public static String emptyStringIfNull(String string) {
        if (!StringUtils.isEmpty((String)string)) {
            return string;
        }
        return "";
    }

    public static String getSensorConfigName(ISensorConfig iSensorConfig) {
        return TextFormatter.getSensorConfigName(iSensorConfig.getClass());
    }

    public static String getSensorConfigName(Class<? extends ISensorConfig> clazz) {
        if (ObjectUtils.equals(clazz, ExceptionSensorConfig.class)) {
            return "Exception Sensor";
        }
        if (ObjectUtils.equals(clazz, ConnectionMetaDataSensorConfig.class)) {
            return "JDBC Connection Meta-Data Sensor";
        }
        if (ObjectUtils.equals(clazz, ConnectionSensorConfig.class)) {
            return "JDBC Connection Sensor";
        }
        if (ObjectUtils.equals(clazz, HttpSensorConfig.class)) {
            return "HTTP Sensor";
        }
        if (ObjectUtils.equals(clazz, InvocationSequenceSensorConfig.class)) {
            return "Invocation Sequence Sensor";
        }
        if (ObjectUtils.equals(clazz, PreparedStatementParameterSensorConfig.class)) {
            return "JDBC Prepared Statement Parameter Sensor";
        }
        if (ObjectUtils.equals(clazz, PreparedStatementSensorConfig.class)) {
            return "JDBC Prepared Statement Sensor";
        }
        if (ObjectUtils.equals(clazz, StatementSensorConfig.class)) {
            return "JDBC Statement Sensor";
        }
        if (ObjectUtils.equals(clazz, TimerSensorConfig.class)) {
            return "Timer Sensor";
        }
        if (ObjectUtils.equals(clazz, Log4jLoggingSensorConfig.class)) {
            return "Logging Sensor for log4j ";
        }
        if (ObjectUtils.equals(clazz, ClassLoadingSensorConfig.class)) {
            return "Class Loading Information";
        }
        if (ObjectUtils.equals(clazz, CompilationSensorConfig.class)) {
            return "Compilation Information";
        }
        if (ObjectUtils.equals(clazz, CpuSensorConfig.class)) {
            return "CPU Information";
        }
        if (ObjectUtils.equals(clazz, MemorySensorConfig.class)) {
            return "Memory Information";
        }
        if (ObjectUtils.equals(clazz, RuntimeSensorConfig.class)) {
            return "Runtime Information";
        }
        if (ObjectUtils.equals(clazz, SystemSensorConfig.class)) {
            return "System Information";
        }
        if (ObjectUtils.equals(clazz, ThreadSensorConfig.class)) {
            return "Thread Information";
        }
        return null;
    }
}

