/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.filter;

import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.progress.UIJob;

public abstract class FilterComposite
extends Composite {
    private static final int FILTER_KEYRELEASED_DELAY = 300;
    private boolean filterExecuted = false;
    private Text filterText;
    private String defaultText;
    private UIJob filterJob;

    public FilterComposite(Composite composite, int n, String string) {
        super(composite, n);
        this.defaultText = string;
        this.filterJob = new UIJob("Filter"){

            public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
                FilterComposite.this.executeFilterInternal();
                return Status.OK_STATUS;
            }
        };
        this.filterJob.setUser(false);
        this.init();
    }

    protected abstract void executeCancel();

    protected abstract void executeFilter(String var1);

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.filterText.setEnabled(bl);
    }

    private void init() {
        this.setLayout((Layout)new GridLayout(1, false));
        this.filterText = new Text((Composite)this, 2948);
        this.filterText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.setDefaultText();
        this.filterText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                if (selectionEvent.detail == 256 && !Objects.equals(FilterComposite.this.filterText.getText(), FilterComposite.this.defaultText)) {
                    FilterComposite.this.executeCancelInternal();
                }
            }
        });
        this.filterText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                if (Objects.equals(FilterComposite.this.filterText.getText(), FilterComposite.this.defaultText)) {
                    FilterComposite.this.setEmptyText();
                }
            }

            public void focusLost(FocusEvent focusEvent) {
                if (Objects.equals(FilterComposite.this.filterText.getText(), "")) {
                    FilterComposite.this.setDefaultText();
                }
            }
        });
        this.filterText.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent traverseEvent) {
                if (traverseEvent.detail == 2) {
                    FilterComposite.this.filterJob.cancel();
                    FilterComposite.this.executeCancelInternal();
                } else if (traverseEvent.detail == 4) {
                    FilterComposite.this.filterJob.cancel();
                    FilterComposite.this.executeFilterInternal();
                }
            }
        });
        this.filterText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                if (Character.isLetterOrDigit(keyEvent.character) || keyEvent.keyCode == 8 || keyEvent.keyCode == 127) {
                    FilterComposite.this.filterJob.cancel();
                    FilterComposite.this.filterJob.schedule(300L);
                }
            }
        });
    }

    private void executeCancelInternal() {
        if (this.filterExecuted) {
            this.filterJob.cancel();
            this.executeCancel();
            this.filterExecuted = false;
        }
        this.setDefaultText();
        this.forceFocus();
    }

    private void executeFilterInternal() {
        String string = this.filterText.getText().trim();
        this.executeFilter(string);
        this.filterExecuted = true;
    }

    private void setDefaultText() {
        this.filterText.setText(this.defaultText);
        this.filterText.setForeground(Display.getDefault().getSystemColor(15));
    }

    private void setEmptyText() {
        this.filterText.setText("");
        this.filterText.setForeground(Display.getDefault().getSystemColor(2));
    }
}

