/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.editor.text.input;

import info.novatec.inspectit.cmr.service.IGlobalDataAccessService;
import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.communication.data.ClassLoadingInformationData;
import info.novatec.inspectit.communication.data.CompilationInformationData;
import info.novatec.inspectit.communication.data.CpuInformationData;
import info.novatec.inspectit.communication.data.MemoryInformationData;
import info.novatec.inspectit.communication.data.RuntimeInformationData;
import info.novatec.inspectit.communication.data.SystemInformationData;
import info.novatec.inspectit.communication.data.ThreadInformationData;
import info.novatec.inspectit.communication.data.VmArgumentData;
import info.novatec.inspectit.rcp.editor.inputdefinition.InputDefinition;
import info.novatec.inspectit.rcp.editor.text.input.AbstractTextInputController;
import info.novatec.inspectit.rcp.formatter.NumberFormatter;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class VmSummaryInputController
extends AbstractTextInputController {
    public static final String ID = "inspectit.subview.text.vmsummary";
    private static final String SECTION_VM = "VM";
    private static final String SECTION_CLASSES = "Classes";
    private static final String SECTION_MEMORY = "Memory";
    private static final String SECTION_THREADS = "Threads";
    private static final String SECTION_OS = "Operating System";
    private static final String SECTION_CLASSPATH = "Class Path";
    private static final String VM_ARGS = "VM Arguments";
    private static final String NOT_AVAILABLE = "N/A";
    private ScrolledForm scrolledForm;
    private SystemInformationData systemObj;
    private RuntimeInformationData runtimeObj;
    private MemoryInformationData memoryObj;
    private ClassLoadingInformationData classLoadingObj;
    private CpuInformationData cpuObj;
    private CompilationInformationData compilationObj;
    private ThreadInformationData threadObj;
    private Map<String, Composite> minimizedSections = new HashMap<String, Composite>();
    private Label loadedClassCount;
    private Label totalLoadedClassCount;
    private Label unloadedClassCount;
    private Label uptime;
    private Label processCpuTime;
    private Label liveThreadCount;
    private Label daemonThreadCount;
    private Label totalStartedThreadCount;
    private Label peakThreadCount;
    private Label totalCompilationTime;
    private Label freePhysMemory;
    private Label freeSwapSpace;
    private Label committedHeapMemorySize;
    private Label committedNonHeapMemorySize;
    private Label usedHeapMemorySize;
    private Label usedNonHeapMemorySize;
    private IGlobalDataAccessService dataAccessService;

    @Override
    public void setInputDefinition(InputDefinition inputDefinition) {
        super.setInputDefinition(inputDefinition);
        long l = inputDefinition.getIdDefinition().getPlatformId();
        this.systemObj = new SystemInformationData();
        this.systemObj.setPlatformIdent(l);
        this.classLoadingObj = new ClassLoadingInformationData();
        this.classLoadingObj.setPlatformIdent(l);
        this.cpuObj = new CpuInformationData();
        this.cpuObj.setPlatformIdent(l);
        this.compilationObj = new CompilationInformationData();
        this.compilationObj.setPlatformIdent(l);
        this.memoryObj = new MemoryInformationData();
        this.memoryObj.setPlatformIdent(l);
        this.runtimeObj = new RuntimeInformationData();
        this.runtimeObj.setPlatformIdent(l);
        this.threadObj = new ThreadInformationData();
        this.threadObj.setPlatformIdent(l);
        this.dataAccessService = inputDefinition.getRepositoryDefinition().getGlobalDataAccessService();
    }

    @Override
    public void createPartControl(Composite composite, FormToolkit formToolkit) {
        this.scrolledForm = formToolkit.createScrolledForm(composite);
        this.scrolledForm.setLayoutData((Object)new GridData(4, 4, true, true));
        this.scrolledForm.getBody().setLayout((Layout)new GridLayout(1, true));
        this.scrolledForm.getBody().setLayoutData((Object)new GridData(4, 4, true, true));
        this.initializeInput(this.scrolledForm.getBody(), formToolkit);
    }

    private void initializeInput(Composite composite, FormToolkit formToolkit) {
        int n = 16384;
        int n2 = 170;
        int n3 = 230;
        this.addSection(composite, formToolkit, SECTION_VM);
        this.addSection(composite, formToolkit, SECTION_OS);
        this.addSection(composite, formToolkit, SECTION_MEMORY);
        this.addSection(composite, formToolkit, SECTION_CLASSES);
        this.addSection(composite, formToolkit, SECTION_THREADS);
        this.addStaticInformations(composite, formToolkit);
        if (this.sections.containsKey(SECTION_CLASSES)) {
            this.addItemToSection(formToolkit, SECTION_CLASSES, "Current loaded classes: ", n2);
            this.loadedClassCount = formToolkit.createLabel((Composite)this.sections.get(SECTION_CLASSES), NOT_AVAILABLE, n);
            this.loadedClassCount.setLayoutData((Object)new GridData(n3, -1));
            this.addItemToSection(formToolkit, SECTION_CLASSES, "Total loaded classes: ", n2);
            this.totalLoadedClassCount = formToolkit.createLabel((Composite)this.sections.get(SECTION_CLASSES), NOT_AVAILABLE, n);
            this.totalLoadedClassCount.setLayoutData((Object)new GridData(n3, -1));
            this.addItemToSection(formToolkit, SECTION_CLASSES, "Total unloaded classes: ", n2);
            this.unloadedClassCount = formToolkit.createLabel((Composite)this.sections.get(SECTION_CLASSES), NOT_AVAILABLE, n);
            this.unloadedClassCount.setLayoutData((Object)new GridData(n3, -1));
        }
        if (this.sections.containsKey(SECTION_VM)) {
            this.addItemToSection(formToolkit, SECTION_VM, "Total compile time: ", n2);
            this.totalCompilationTime = formToolkit.createLabel((Composite)this.sections.get(SECTION_VM), NOT_AVAILABLE, n);
            this.totalCompilationTime.setLayoutData((Object)new GridData(n3, -1));
            this.addItemToSection(formToolkit, SECTION_VM, "Uptime: ", n2);
            this.uptime = formToolkit.createLabel((Composite)this.sections.get(SECTION_VM), NOT_AVAILABLE, n);
            this.uptime.setLayoutData((Object)new GridData(n3, -1));
            this.addItemToSection(formToolkit, SECTION_VM, "Process Cpu Time: ", n2);
            this.processCpuTime = formToolkit.createLabel((Composite)this.sections.get(SECTION_VM), NOT_AVAILABLE, n);
            this.processCpuTime.setLayoutData((Object)new GridData(n3, -1));
        }
        if (this.sections.containsKey(SECTION_MEMORY)) {
            this.addItemToSection(formToolkit, SECTION_MEMORY, "Free physical memory: ", n2);
            this.freePhysMemory = formToolkit.createLabel((Composite)this.sections.get(SECTION_MEMORY), NOT_AVAILABLE, n);
            this.freePhysMemory.setLayoutData((Object)new GridData(n3, -1));
            this.addItemToSection(formToolkit, SECTION_MEMORY, "Free swap space: ", n2);
            this.freeSwapSpace = formToolkit.createLabel((Composite)this.sections.get(SECTION_MEMORY), NOT_AVAILABLE, n);
            this.freeSwapSpace.setLayoutData((Object)new GridData(n3, -1));
            this.addItemToSection(formToolkit, SECTION_MEMORY, "Committed heap size: ", n2);
            this.committedHeapMemorySize = formToolkit.createLabel((Composite)this.sections.get(SECTION_MEMORY), NOT_AVAILABLE, n);
            this.committedHeapMemorySize.setLayoutData((Object)new GridData(n3, -1));
            this.addItemToSection(formToolkit, SECTION_MEMORY, "Committed non-heap size: ", n2);
            this.committedNonHeapMemorySize = formToolkit.createLabel((Composite)this.sections.get(SECTION_MEMORY), NOT_AVAILABLE, n);
            this.committedNonHeapMemorySize.setLayoutData((Object)new GridData(n3, -1));
            this.addItemToSection(formToolkit, SECTION_MEMORY, "Used heap size: ", n2);
            this.usedHeapMemorySize = formToolkit.createLabel((Composite)this.sections.get(SECTION_MEMORY), NOT_AVAILABLE, n);
            this.usedHeapMemorySize.setLayoutData((Object)new GridData(n3, -1));
            this.addItemToSection(formToolkit, SECTION_MEMORY, "Used non-heap size: ", n2);
            this.usedNonHeapMemorySize = formToolkit.createLabel((Composite)this.sections.get(SECTION_MEMORY), NOT_AVAILABLE, n);
            this.usedNonHeapMemorySize.setLayoutData((Object)new GridData(n3, -1));
        }
        if (this.sections.containsKey(SECTION_THREADS)) {
            this.addItemToSection(formToolkit, SECTION_THREADS, "Live threads: ", n2);
            this.liveThreadCount = formToolkit.createLabel((Composite)this.sections.get(SECTION_THREADS), NOT_AVAILABLE, n);
            this.liveThreadCount.setLayoutData((Object)new GridData(n3, -1));
            this.addItemToSection(formToolkit, SECTION_THREADS, "Daemon threads: ", n2);
            this.daemonThreadCount = formToolkit.createLabel((Composite)this.sections.get(SECTION_THREADS), NOT_AVAILABLE, n);
            this.daemonThreadCount.setLayoutData((Object)new GridData(n3, -1));
            this.addItemToSection(formToolkit, SECTION_THREADS, "Peak: ", n2);
            this.peakThreadCount = formToolkit.createLabel((Composite)this.sections.get(SECTION_THREADS), NOT_AVAILABLE, n);
            this.peakThreadCount.setLayoutData((Object)new GridData(n3, -1));
            this.addItemToSection(formToolkit, SECTION_THREADS, "Total threads started: ", n2);
            this.totalStartedThreadCount = formToolkit.createLabel((Composite)this.sections.get(SECTION_THREADS), NOT_AVAILABLE, n);
            this.totalStartedThreadCount.setLayoutData((Object)new GridData(n3, -1));
        }
    }

    private void addStaticInformations(Composite composite, FormToolkit formToolkit) {
        SystemInformationData systemInformationData = (SystemInformationData)this.dataAccessService.getLastDataObject((DefaultData)this.systemObj);
        int n = 170;
        int n2 = 230;
        String string = NOT_AVAILABLE;
        String string2 = NOT_AVAILABLE;
        if (systemInformationData != null) {
            this.addMinimizedSection(composite, formToolkit, SECTION_CLASSPATH, 1);
            this.addMinimizedSection(composite, formToolkit, VM_ARGS, 2);
            String string3 = systemInformationData.getVmName();
            String[] stringArray = string3.split("@");
            if (stringArray != null && stringArray.length > 1) {
                string = stringArray[0];
                string2 = stringArray[1];
            }
            this.addItemToSection(formToolkit, SECTION_VM, "Vendor: ", n);
            this.addItemToSection(formToolkit, SECTION_VM, systemInformationData.getVmVendor(), n2);
            this.addItemToSection(formToolkit, SECTION_VM, "Version: ", n);
            this.addItemToSection(formToolkit, SECTION_VM, systemInformationData.getVmVersion(), n2);
            this.addItemToSection(formToolkit, SECTION_VM, "Process Id: ", n);
            this.addItemToSection(formToolkit, SECTION_VM, string, n2);
            this.addItemToSection(formToolkit, SECTION_VM, "Pc Name: ", n);
            this.addItemToSection(formToolkit, SECTION_VM, string2, n2);
            this.addItemToSection(formToolkit, SECTION_VM, "Jit Compiler Name: ", n);
            this.addItemToSection(formToolkit, SECTION_VM, systemInformationData.getJitCompilerName(), n2);
            this.addItemToSection(formToolkit, SECTION_VM, "Specification Name: ", n);
            this.addItemToSection(formToolkit, SECTION_VM, systemInformationData.getVmSpecName(), n2);
            this.addItemToSection(formToolkit, SECTION_MEMORY, "Max heap size: ", n);
            if (systemInformationData.getMaxHeapMemorySize() > 0L) {
                this.addItemToSection(formToolkit, SECTION_MEMORY, NumberFormatter.formatBytesToKBytes(systemInformationData.getMaxHeapMemorySize()), n2);
            } else {
                this.addItemToSection(formToolkit, SECTION_MEMORY, NOT_AVAILABLE, n2);
            }
            this.addItemToSection(formToolkit, SECTION_MEMORY, "Max non-heap size: ", n);
            if (systemInformationData.getMaxNonHeapMemorySize() > 0L) {
                this.addItemToSection(formToolkit, SECTION_MEMORY, NumberFormatter.formatBytesToKBytes(systemInformationData.getMaxNonHeapMemorySize()), n2);
            } else {
                this.addItemToSection(formToolkit, SECTION_MEMORY, NOT_AVAILABLE, n2);
            }
            this.addItemToSection(formToolkit, SECTION_MEMORY, "Total physical memory: ", n);
            if (systemInformationData.getTotalPhysMemory() > 0L) {
                this.addItemToSection(formToolkit, SECTION_MEMORY, NumberFormatter.formatBytesToKBytes(systemInformationData.getTotalPhysMemory()), n2);
            } else {
                this.addItemToSection(formToolkit, SECTION_MEMORY, NOT_AVAILABLE, n2);
            }
            this.addItemToSection(formToolkit, SECTION_MEMORY, "Total swap space: ", n);
            if (systemInformationData.getTotalSwapSpace() > 0L) {
                this.addItemToSection(formToolkit, SECTION_MEMORY, NumberFormatter.formatBytesToKBytes(systemInformationData.getTotalSwapSpace()), n2);
            } else {
                this.addItemToSection(formToolkit, SECTION_MEMORY, NOT_AVAILABLE, n2);
            }
            this.addItemToSection(formToolkit, SECTION_OS, "Operating System: ", n);
            this.addItemToSection(formToolkit, SECTION_OS, String.valueOf(systemInformationData.getOsName()) + " " + systemInformationData.getOsVersion(), n2);
            this.addItemToSection(formToolkit, SECTION_OS, "Available processors: ", n);
            if (systemInformationData.getAvailableProcessors() > 0) {
                this.addItemToSection(formToolkit, SECTION_OS, NumberFormatter.formatInteger(systemInformationData.getAvailableProcessors()), n2);
            } else {
                this.addItemToSection(formToolkit, SECTION_OS, NOT_AVAILABLE, n2);
            }
            this.addItemToSection(formToolkit, SECTION_OS, "Architecture: ", n);
            this.addItemToSection(formToolkit, SECTION_OS, systemInformationData.getArchitecture(), n2);
            String string4 = ";";
            String string5 = systemInformationData.getClassPath();
            if (string5.indexOf(string4) == -1) {
                string4 = ":";
            }
            this.addItemToMinimizedSection(formToolkit, SECTION_CLASSPATH, "Class path: ");
            StringTokenizer stringTokenizer = new StringTokenizer(systemInformationData.getClassPath(), string4);
            while (stringTokenizer.hasMoreTokens()) {
                this.addItemToMinimizedSection(formToolkit, SECTION_CLASSPATH, " \t" + stringTokenizer.nextToken());
            }
            this.addItemToMinimizedSection(formToolkit, SECTION_CLASSPATH, "Boot class path: ");
            StringTokenizer stringTokenizer2 = new StringTokenizer(systemInformationData.getBootClassPath(), string4);
            while (stringTokenizer2.hasMoreTokens()) {
                this.addItemToMinimizedSection(formToolkit, SECTION_CLASSPATH, " \t" + stringTokenizer2.nextToken());
            }
            this.addItemToMinimizedSection(formToolkit, SECTION_CLASSPATH, "Library Path: ");
            StringTokenizer stringTokenizer3 = new StringTokenizer(systemInformationData.getLibraryPath(), string4);
            while (stringTokenizer3.hasMoreTokens()) {
                this.addItemToMinimizedSection(formToolkit, SECTION_CLASSPATH, " \t" + stringTokenizer3.nextToken());
            }
            TreeSet<VmArgumentData> treeSet = new TreeSet<VmArgumentData>(new Comparator<VmArgumentData>(){

                @Override
                public int compare(VmArgumentData vmArgumentData, VmArgumentData vmArgumentData2) {
                    return vmArgumentData.getVmName().compareTo(vmArgumentData2.getVmName());
                }
            });
            treeSet.addAll(systemInformationData.getVmSet());
            for (VmArgumentData vmArgumentData : treeSet) {
                if (vmArgumentData.getVmName().endsWith("path") || vmArgumentData.getVmName().endsWith("separator")) continue;
                this.addItemToMinimizedSection(formToolkit, VM_ARGS, String.valueOf(vmArgumentData.getVmName()) + ":");
                this.addItemToMinimizedSection(formToolkit, VM_ARGS, vmArgumentData.getVmValue());
            }
        } else {
            this.addMinimizedSectionNotAvailable(composite, formToolkit, "Class Path (n/a)", 1);
            this.addMinimizedSectionNotAvailable(composite, formToolkit, "VM Arguments (n/a)", 2);
            this.addItemToSection(formToolkit, SECTION_VM, "Vendor: ", n);
            this.addItemToSection(formToolkit, SECTION_VM, NOT_AVAILABLE, n2);
            this.addItemToSection(formToolkit, SECTION_VM, "Version: ", n);
            this.addItemToSection(formToolkit, SECTION_VM, NOT_AVAILABLE, n2);
            this.addItemToSection(formToolkit, SECTION_VM, "Process Id: ", n);
            this.addItemToSection(formToolkit, SECTION_VM, string, n2);
            this.addItemToSection(formToolkit, SECTION_VM, "Pc Name: ", n);
            this.addItemToSection(formToolkit, SECTION_VM, string2, n2);
            this.addItemToSection(formToolkit, SECTION_VM, "Jit Compiler Name: ", n);
            this.addItemToSection(formToolkit, SECTION_VM, NOT_AVAILABLE, n2);
            this.addItemToSection(formToolkit, SECTION_VM, "Specification Name: ", n);
            this.addItemToSection(formToolkit, SECTION_VM, NOT_AVAILABLE, n2);
            this.addItemToSection(formToolkit, SECTION_MEMORY, "Max heap size: ", n);
            this.addItemToSection(formToolkit, SECTION_MEMORY, NOT_AVAILABLE, n2);
            this.addItemToSection(formToolkit, SECTION_MEMORY, "Max non-heap size: ", n);
            this.addItemToSection(formToolkit, SECTION_MEMORY, NOT_AVAILABLE, n2);
            this.addItemToSection(formToolkit, SECTION_MEMORY, "Total physical memory: ", n);
            this.addItemToSection(formToolkit, SECTION_MEMORY, NOT_AVAILABLE, n2);
            this.addItemToSection(formToolkit, SECTION_MEMORY, "Total swap space: ", n);
            this.addItemToSection(formToolkit, SECTION_MEMORY, NOT_AVAILABLE, n2);
            this.addItemToSection(formToolkit, SECTION_OS, "Operating System: ", n);
            this.addItemToSection(formToolkit, SECTION_OS, NOT_AVAILABLE, n2);
            this.addItemToSection(formToolkit, SECTION_OS, "Available processors: ", n);
            this.addItemToSection(formToolkit, SECTION_OS, NOT_AVAILABLE, n2);
            this.addItemToSection(formToolkit, SECTION_OS, "Architecture: ", n);
            this.addItemToSection(formToolkit, SECTION_OS, NOT_AVAILABLE, n2);
        }
    }

    private void addMinimizedSection(Composite composite, FormToolkit formToolkit, String string, int n) {
        Section section = formToolkit.createSection(composite, 258);
        section.setText(string);
        section.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite composite2 = formToolkit.createComposite((Composite)section);
        GridLayout gridLayout = new GridLayout(n, false);
        gridLayout.marginLeft = 5;
        gridLayout.marginTop = 5;
        composite2.setLayout((Layout)gridLayout);
        section.setClient((Control)composite2);
        if (!this.minimizedSections.containsKey(string)) {
            this.minimizedSections.put(string, composite2);
        }
    }

    private void addMinimizedSectionNotAvailable(Composite composite, FormToolkit formToolkit, String string, int n) {
        Section section = formToolkit.createSection(composite, 258);
        section.setText(string);
        section.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite composite2 = formToolkit.createComposite((Composite)section);
        GridLayout gridLayout = new GridLayout(n, false);
        gridLayout.marginLeft = 5;
        gridLayout.marginTop = 5;
        composite2.setLayout((Layout)gridLayout);
        section.setClient((Control)composite2);
        if (!this.minimizedSections.containsKey(string)) {
            this.minimizedSections.put(string, composite2);
        }
    }

    private void addItemToMinimizedSection(FormToolkit formToolkit, String string, String string2) {
        if (this.minimizedSections.containsKey(string)) {
            Label label = formToolkit.createLabel(this.minimizedSections.get(string), string2, 16384);
            label.setLayoutData((Object)new GridData(4, 4, true, false));
        }
    }

    @Override
    public void doRefresh() {
        ClassLoadingInformationData classLoadingInformationData = (ClassLoadingInformationData)this.dataAccessService.getLastDataObject((DefaultData)this.classLoadingObj);
        CpuInformationData cpuInformationData = (CpuInformationData)this.dataAccessService.getLastDataObject((DefaultData)this.cpuObj);
        CompilationInformationData compilationInformationData = (CompilationInformationData)this.dataAccessService.getLastDataObject((DefaultData)this.compilationObj);
        MemoryInformationData memoryInformationData = (MemoryInformationData)this.dataAccessService.getLastDataObject((DefaultData)this.memoryObj);
        RuntimeInformationData runtimeInformationData = (RuntimeInformationData)this.dataAccessService.getLastDataObject((DefaultData)this.runtimeObj);
        ThreadInformationData threadInformationData = (ThreadInformationData)this.dataAccessService.getLastDataObject((DefaultData)this.threadObj);
        this.updateLabels(classLoadingInformationData, cpuInformationData, compilationInformationData, memoryInformationData, runtimeInformationData, threadInformationData);
    }

    private void updateLabels(final ClassLoadingInformationData classLoadingInformationData, final CpuInformationData cpuInformationData, final CompilationInformationData compilationInformationData, final MemoryInformationData memoryInformationData, final RuntimeInformationData runtimeInformationData, final ThreadInformationData threadInformationData) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                int n;
                if (classLoadingInformationData != null) {
                    n = classLoadingInformationData.getCount();
                    VmSummaryInputController.this.loadedClassCount.setText(NumberFormatter.formatInteger(classLoadingInformationData.getTotalLoadedClassCount() / n));
                    VmSummaryInputController.this.totalLoadedClassCount.setText(NumberFormatter.formatLong(classLoadingInformationData.getTotalTotalLoadedClassCount() / (long)n));
                    VmSummaryInputController.this.unloadedClassCount.setText(NumberFormatter.formatLong(classLoadingInformationData.getTotalUnloadedClassCount() / (long)n));
                }
                if (cpuInformationData != null) {
                    if (cpuInformationData.getProcessCpuTime() > 0L) {
                        VmSummaryInputController.this.processCpuTime.setText(NumberFormatter.formatNanosToSeconds(cpuInformationData.getProcessCpuTime()));
                    } else {
                        VmSummaryInputController.this.processCpuTime.setText(VmSummaryInputController.NOT_AVAILABLE);
                    }
                }
                if (compilationInformationData != null) {
                    VmSummaryInputController.this.totalCompilationTime.setText(NumberFormatter.formatMillisToSeconds(compilationInformationData.getTotalTotalCompilationTime() / (long)compilationInformationData.getCount()));
                }
                if (memoryInformationData != null) {
                    n = memoryInformationData.getCount();
                    if (memoryInformationData.getTotalFreePhysMemory() > 0L) {
                        VmSummaryInputController.this.freePhysMemory.setText(NumberFormatter.formatBytesToKBytes(memoryInformationData.getTotalFreePhysMemory() / (long)n));
                    } else {
                        VmSummaryInputController.this.freePhysMemory.setText(VmSummaryInputController.NOT_AVAILABLE);
                    }
                    if (memoryInformationData.getTotalFreeSwapSpace() > 0L) {
                        VmSummaryInputController.this.freeSwapSpace.setText(NumberFormatter.formatBytesToKBytes(memoryInformationData.getTotalFreeSwapSpace() / (long)n));
                    } else {
                        VmSummaryInputController.this.freeSwapSpace.setText(VmSummaryInputController.NOT_AVAILABLE);
                    }
                    if (memoryInformationData.getTotalComittedHeapMemorySize() > 0L) {
                        VmSummaryInputController.this.committedHeapMemorySize.setText(NumberFormatter.formatBytesToKBytes(memoryInformationData.getTotalComittedHeapMemorySize() / (long)n));
                    } else {
                        VmSummaryInputController.this.committedHeapMemorySize.setText(VmSummaryInputController.NOT_AVAILABLE);
                    }
                    if (memoryInformationData.getTotalComittedNonHeapMemorySize() > 0L) {
                        VmSummaryInputController.this.committedNonHeapMemorySize.setText(NumberFormatter.formatBytesToKBytes(memoryInformationData.getTotalComittedNonHeapMemorySize() / (long)n));
                    } else {
                        VmSummaryInputController.this.committedNonHeapMemorySize.setText(VmSummaryInputController.NOT_AVAILABLE);
                    }
                    if (memoryInformationData.getTotalUsedHeapMemorySize() > 0L) {
                        VmSummaryInputController.this.usedHeapMemorySize.setText(NumberFormatter.formatBytesToKBytes(memoryInformationData.getTotalUsedHeapMemorySize() / (long)n));
                    } else {
                        VmSummaryInputController.this.usedHeapMemorySize.setText(VmSummaryInputController.NOT_AVAILABLE);
                    }
                    if (memoryInformationData.getTotalUsedNonHeapMemorySize() > 0L) {
                        VmSummaryInputController.this.usedNonHeapMemorySize.setText(NumberFormatter.formatBytesToKBytes(memoryInformationData.getTotalUsedNonHeapMemorySize() / (long)n));
                    } else {
                        VmSummaryInputController.this.usedNonHeapMemorySize.setText(VmSummaryInputController.NOT_AVAILABLE);
                    }
                }
                if (runtimeInformationData != null) {
                    VmSummaryInputController.this.uptime.setText(NumberFormatter.millisecondsToString(runtimeInformationData.getTotalUptime() / (long)runtimeInformationData.getCount()));
                }
                if (threadInformationData != null) {
                    n = threadInformationData.getCount();
                    VmSummaryInputController.this.liveThreadCount.setText(NumberFormatter.formatInteger(threadInformationData.getTotalThreadCount() / n));
                    VmSummaryInputController.this.daemonThreadCount.setText(NumberFormatter.formatInteger(threadInformationData.getTotalDaemonThreadCount() / n));
                    VmSummaryInputController.this.peakThreadCount.setText(NumberFormatter.formatInteger(threadInformationData.getTotalPeakThreadCount() / n));
                    VmSummaryInputController.this.totalStartedThreadCount.setText(NumberFormatter.formatLong(threadInformationData.getTotalTotalStartedThreadCount() / (long)n));
                }
            }
        });
    }

    @Override
    public void dispose() {
    }
}

