/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.editor.text.input;

import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.rcp.editor.inputdefinition.InputDefinition;
import info.novatec.inspectit.rcp.editor.text.input.TextInputController;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public abstract class AbstractTextInputController
implements TextInputController {
    private InputDefinition inputDefinition;
    protected Map<String, Composite> sections = new HashMap<String, Composite>();

    @Override
    public void setInputDefinition(InputDefinition inputDefinition) {
        Assert.isNotNull((Object)inputDefinition);
        this.inputDefinition = inputDefinition;
    }

    protected InputDefinition getInputDefinition() {
        Assert.isNotNull((Object)this.inputDefinition);
        return this.inputDefinition;
    }

    protected void addSection(Composite composite, FormToolkit formToolkit, String string) {
        Section section = formToolkit.createSection(composite, 256);
        section.setText(string);
        section.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite composite2 = formToolkit.createComposite((Composite)section);
        GridLayout gridLayout = new GridLayout(4, false);
        gridLayout.marginLeft = 5;
        gridLayout.marginTop = 5;
        composite2.setLayout((Layout)gridLayout);
        section.setClient((Control)composite2);
        if (!this.sections.containsKey(string)) {
            this.sections.put(string, composite2);
        }
    }

    protected void addItemToSection(FormToolkit formToolkit, String string, String string2) {
        this.addItemToSection(formToolkit, string, string2, null);
    }

    protected void addItemToSection(FormToolkit formToolkit, String string, String string2, Image image) {
        if (this.sections.containsKey(string)) {
            FormText formText = formToolkit.createFormText(this.sections.get(string), false);
            if (image != null) {
                formText.setText("<form><p><img href=\"img\"/> " + string2 + "</p></form>", true, false);
                formText.setImage("img", image);
            } else {
                formText.setText("<form><p>" + string2 + "</p></form>", true, false);
            }
            formText.setLayoutData((Object)new GridData(256));
        }
    }

    protected void addItemToSection(FormToolkit formToolkit, String string, String string2, int n) {
        if (this.sections.containsKey(string)) {
            Label label = formToolkit.createLabel(this.sections.get(string), string2, 16384);
            label.setLayoutData((Object)new GridData(n, -1));
        }
    }

    @Override
    public void createPartControl(Composite composite, FormToolkit formToolkit) {
    }

    @Override
    public void doRefresh() {
    }

    @Override
    public void dispose() {
    }

    @Override
    public void setDataInput(List<? extends DefaultData> list) {
    }
}

