/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.editor.table.input;

import info.novatec.inspectit.cmr.model.MethodIdent;
import info.novatec.inspectit.cmr.service.ICachedDataService;
import info.novatec.inspectit.cmr.service.ITimerDataAccessService;
import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.communication.comparator.IDataComparator;
import info.novatec.inspectit.communication.comparator.InvocationAwareDataComparatorEnum;
import info.novatec.inspectit.communication.comparator.MethodSensorDataComparatorEnum;
import info.novatec.inspectit.communication.comparator.ResultComparator;
import info.novatec.inspectit.communication.comparator.TimerDataComparatorEnum;
import info.novatec.inspectit.communication.data.TimerData;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.editor.inputdefinition.InputDefinition;
import info.novatec.inspectit.rcp.editor.preferences.PreferenceEventCallback;
import info.novatec.inspectit.rcp.editor.preferences.PreferenceId;
import info.novatec.inspectit.rcp.editor.root.IRootEditor;
import info.novatec.inspectit.rcp.editor.table.TableViewerComparator;
import info.novatec.inspectit.rcp.editor.table.input.AbstractTableInputController;
import info.novatec.inspectit.rcp.editor.viewers.StyledCellIndexLabelProvider;
import info.novatec.inspectit.rcp.formatter.NumberFormatter;
import info.novatec.inspectit.rcp.formatter.TextFormatter;
import info.novatec.inspectit.rcp.preferences.PreferencesUtils;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;

public class TimerDataInputController
extends AbstractTableInputController {
    public static final String ID = "inspectit.subview.table.aggregatedtimerdata";
    private ITimerDataAccessService timerDataAccessService;
    private ICachedDataService cachedDataService;
    private List<TimerData> timerDataList = new ArrayList<TimerData>();
    private TimerData template;
    private final StyledString emptyStyledString = new StyledString();
    private Date fromDate = null;
    private Date toDate = null;
    private boolean autoUpdate = false;
    private int timeDecimalPlaces = PreferencesUtils.getIntValue("DECIMAL_PLACES");

    @Override
    public void setInputDefinition(InputDefinition inputDefinition) {
        super.setInputDefinition(inputDefinition);
        this.template = new TimerData();
        this.template.setPlatformIdent(inputDefinition.getIdDefinition().getPlatformId());
        this.template.setMethodIdent(inputDefinition.getIdDefinition().getMethodId());
        this.timerDataAccessService = inputDefinition.getRepositoryDefinition().getTimerDataAccessService();
        this.cachedDataService = inputDefinition.getRepositoryDefinition().getCachedDataService();
    }

    @Override
    public void createColumns(TableViewer tableViewer) {
        Column[] columnArray = Column.values();
        int n = columnArray.length;
        int n2 = 0;
        while (n2 < n) {
            Column column = columnArray[n2];
            TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, 0);
            tableViewerColumn.getColumn().setMoveable(true);
            tableViewerColumn.getColumn().setResizable(true);
            tableViewerColumn.getColumn().setText(column.name);
            tableViewerColumn.getColumn().setWidth(column.width);
            if (Column.EXCLUSIVEAVERAGE.equals((Object)column) || Column.EXCLUSIVESUM.equals((Object)column) || Column.EXCLUSIVEMIN.equals((Object)column) || Column.EXCLUSIVEMAX.equals((Object)column)) {
                tableViewerColumn.getColumn().setToolTipText("Exclusive times can only be calculated correctly if the timer is within an invocation sequence. A warning marker is provided if not all timers are run within an invocation sequence. Please be aware that avg, sum, min and max calculations are reflecting only the timers inside an invocation sequence.");
            }
            if (column.image != null) {
                tableViewerColumn.getColumn().setImage(column.image);
            }
            this.mapTableViewerColumn(column, tableViewerColumn);
            ++n2;
        }
    }

    @Override
    public Set<PreferenceId> getPreferenceIds() {
        EnumSet<PreferenceId> enumSet = EnumSet.noneOf(PreferenceId.class);
        if (this.getInputDefinition().getRepositoryDefinition() instanceof CmrRepositoryDefinition) {
            enumSet.add(PreferenceId.CLEAR_BUFFER);
            enumSet.add(PreferenceId.LIVEMODE);
        }
        enumSet.add(PreferenceId.UPDATE);
        enumSet.add(PreferenceId.TIME_RESOLUTION);
        enumSet.add(PreferenceId.TIMELINE);
        return enumSet;
    }

    @Override
    public void preferenceEventFired(PreferenceEventCallback.PreferenceEvent preferenceEvent) {
        switch (preferenceEvent.getPreferenceId()) {
            case TIMELINE: {
                if (preferenceEvent.getPreferenceMap().containsKey(PreferenceId.TimeLine.FROM_DATE_ID)) {
                    this.fromDate = (Date)preferenceEvent.getPreferenceMap().get(PreferenceId.TimeLine.FROM_DATE_ID);
                }
                if (!preferenceEvent.getPreferenceMap().containsKey(PreferenceId.TimeLine.TO_DATE_ID)) break;
                this.toDate = (Date)preferenceEvent.getPreferenceMap().get(PreferenceId.TimeLine.TO_DATE_ID);
                break;
            }
            case LIVEMODE: {
                if (!preferenceEvent.getPreferenceMap().containsKey(PreferenceId.LiveMode.BUTTON_LIVE_ID)) break;
                this.autoUpdate = (Boolean)preferenceEvent.getPreferenceMap().get(PreferenceId.LiveMode.BUTTON_LIVE_ID);
                break;
            }
            case TIME_RESOLUTION: {
                if (!preferenceEvent.getPreferenceMap().containsKey(PreferenceId.TimeResolution.TIME_DECIMAL_PLACES_ID)) break;
                this.timeDecimalPlaces = (Integer)preferenceEvent.getPreferenceMap().get(PreferenceId.TimeResolution.TIME_DECIMAL_PLACES_ID);
                break;
            }
        }
    }

    @Override
    public boolean canOpenInput(List<? extends DefaultData> list) {
        return list != null;
    }

    @Override
    public Object getTableInput() {
        return this.timerDataList;
    }

    @Override
    public void doRefresh(IProgressMonitor iProgressMonitor, IRootEditor iRootEditor) {
        iProgressMonitor.beginTask("Getting timer data information", -1);
        List list = this.autoUpdate ? this.timerDataAccessService.getAggregatedTimerData(this.template) : this.timerDataAccessService.getAggregatedTimerData(this.template, this.fromDate, this.toDate);
        this.timerDataList.clear();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            this.timerDataList.addAll(list);
        }
        iProgressMonitor.done();
    }

    @Override
    public IContentProvider getContentProvider() {
        return new TimerDataContentProvider();
    }

    @Override
    public IBaseLabelProvider getLabelProvider() {
        return new TimerDataLabelProvider();
    }

    @Override
    public ViewerComparator getComparator() {
        TableViewerComparator tableViewerComparator = new TableViewerComparator();
        Column[] columnArray = Column.values();
        int n = columnArray.length;
        int n2 = 0;
        while (n2 < n) {
            Column column = columnArray[n2];
            ResultComparator resultComparator = new ResultComparator(column.dataComparator, this.cachedDataService);
            tableViewerComparator.addColumn(this.getMappedTableViewerColumn(column).getColumn(), resultComparator);
            ++n2;
        }
        return tableViewerComparator;
    }

    @Override
    public String getReadableString(Object object) {
        if (object instanceof TimerData) {
            TimerData timerData = (TimerData)object;
            StringBuilder stringBuilder = new StringBuilder();
            MethodIdent methodIdent = this.cachedDataService.getMethodIdentForId(timerData.getMethodIdent());
            Column[] columnArray = Column.values();
            int n = columnArray.length;
            int n2 = 0;
            while (n2 < n) {
                Column column = columnArray[n2];
                stringBuilder.append(this.getStyledTextForColumn(timerData, methodIdent, column).toString());
                stringBuilder.append('\t');
                ++n2;
            }
            return stringBuilder.toString();
        }
        throw new RuntimeException("Could not create the human readable string!");
    }

    @Override
    public List<String> getColumnValues(Object object) {
        if (object instanceof TimerData) {
            TimerData timerData = (TimerData)object;
            MethodIdent methodIdent = this.cachedDataService.getMethodIdentForId(timerData.getMethodIdent());
            ArrayList<String> arrayList = new ArrayList<String>();
            Column[] columnArray = Column.values();
            int n = columnArray.length;
            int n2 = 0;
            while (n2 < n) {
                Column column = columnArray[n2];
                arrayList.add(this.getStyledTextForColumn(timerData, methodIdent, column).toString());
                ++n2;
            }
            return arrayList;
        }
        throw new RuntimeException("Could not create the column values!");
    }

    private StyledString getStyledTextForColumn(TimerData timerData, MethodIdent methodIdent, Column column) {
        switch (column) {
            case CHARTING: {
                return this.emptyStyledString;
            }
            case PACKAGE: {
                if (methodIdent.getPackageName() != null && !methodIdent.getPackageName().equals("")) {
                    return new StyledString(methodIdent.getPackageName());
                }
                return new StyledString("(default)");
            }
            case CLASS: {
                return new StyledString(methodIdent.getClassName());
            }
            case METHOD: {
                return new StyledString(TextFormatter.getMethodWithParameters(methodIdent));
            }
            case INVOCATION_AFFILLIATION: {
                int n = (int)(timerData.getInvocationAffiliationPercentage() * 100.0);
                int n2 = 0;
                if (timerData.getInvocationParentsIdSet() != null) {
                    n2 = timerData.getInvocationParentsIdSet().size();
                }
                return TextFormatter.getInvocationAffilliationPercentageString(n, n2);
            }
            case COUNT: {
                return new StyledString(String.valueOf(timerData.getCount()));
            }
            case AVERAGE: {
                if (timerData.isTimeDataAvailable()) {
                    return new StyledString(NumberFormatter.formatDouble(timerData.getAverage(), this.timeDecimalPlaces));
                }
                return this.emptyStyledString;
            }
            case MIN: {
                if (timerData.isTimeDataAvailable()) {
                    return new StyledString(NumberFormatter.formatDouble(timerData.getMin(), this.timeDecimalPlaces));
                }
                return this.emptyStyledString;
            }
            case MAX: {
                if (timerData.isTimeDataAvailable()) {
                    return new StyledString(NumberFormatter.formatDouble(timerData.getMax(), this.timeDecimalPlaces));
                }
                return this.emptyStyledString;
            }
            case DURATION: {
                if (timerData.isTimeDataAvailable()) {
                    return new StyledString(NumberFormatter.formatDouble(timerData.getDuration(), this.timeDecimalPlaces));
                }
                return this.emptyStyledString;
            }
            case CPUAVERAGE: {
                if (timerData.isCpuMetricDataAvailable()) {
                    return new StyledString(NumberFormatter.formatDouble(timerData.getCpuAverage(), this.timeDecimalPlaces));
                }
                return this.emptyStyledString;
            }
            case CPUMIN: {
                if (timerData.isCpuMetricDataAvailable()) {
                    return new StyledString(NumberFormatter.formatDouble(timerData.getCpuMin(), this.timeDecimalPlaces));
                }
                return this.emptyStyledString;
            }
            case CPUMAX: {
                if (timerData.isCpuMetricDataAvailable()) {
                    return new StyledString(NumberFormatter.formatDouble(timerData.getCpuMax(), this.timeDecimalPlaces));
                }
                return this.emptyStyledString;
            }
            case CPUDURATION: {
                if (timerData.isCpuMetricDataAvailable()) {
                    return new StyledString(NumberFormatter.formatDouble(timerData.getCpuDuration(), this.timeDecimalPlaces));
                }
                return this.emptyStyledString;
            }
            case EXCLUSIVEAVERAGE: {
                if (timerData.isExclusiveTimeDataAvailable()) {
                    return new StyledString(NumberFormatter.formatDouble(timerData.getExclusiveAverage(), this.timeDecimalPlaces));
                }
                return this.emptyStyledString;
            }
            case EXCLUSIVEMAX: {
                if (timerData.isExclusiveTimeDataAvailable()) {
                    return new StyledString(NumberFormatter.formatDouble(timerData.getExclusiveMax(), this.timeDecimalPlaces));
                }
                return this.emptyStyledString;
            }
            case EXCLUSIVEMIN: {
                if (timerData.isExclusiveTimeDataAvailable()) {
                    return new StyledString(NumberFormatter.formatDouble(timerData.getExclusiveMin(), this.timeDecimalPlaces));
                }
                return this.emptyStyledString;
            }
            case EXCLUSIVESUM: {
                if (timerData.isExclusiveTimeDataAvailable()) {
                    return new StyledString(NumberFormatter.formatDouble(timerData.getExclusiveDuration(), this.timeDecimalPlaces));
                }
                return this.emptyStyledString;
            }
        }
        return new StyledString("error");
    }

    public List<TimerData> getTimerDataList() {
        return this.timerDataList;
    }

    public ITimerDataAccessService getTimerDataAccessService() {
        return this.timerDataAccessService;
    }

    private static enum Column {
        CHARTING("Charting", 20, null, (IDataComparator<? super TimerData>)TimerDataComparatorEnum.CHARTING),
        PACKAGE("Package", 200, "/icons/eclipse/package_obj.gif", (IDataComparator<? super TimerData>)MethodSensorDataComparatorEnum.PACKAGE),
        CLASS("Class", 200, "/icons/eclipse/class_obj.gif", (IDataComparator<? super TimerData>)MethodSensorDataComparatorEnum.CLASS),
        METHOD("Method", 300, "/icons/eclipse/method.gif", (IDataComparator<? super TimerData>)MethodSensorDataComparatorEnum.METHOD),
        INVOCATION_AFFILLIATION("In Invocations", 120, "/icons/fugue/arrow-switch.png", (IDataComparator<? super TimerData>)InvocationAwareDataComparatorEnum.INVOCATION_AFFILIATION),
        COUNT("Count", 60, null, (IDataComparator<? super TimerData>)TimerDataComparatorEnum.COUNT),
        AVERAGE("Avg (ms)", 60, null, (IDataComparator<? super TimerData>)TimerDataComparatorEnum.AVERAGE),
        MIN("Min (ms)", 60, null, (IDataComparator<? super TimerData>)TimerDataComparatorEnum.MIN),
        MAX("Max (ms)", 60, null, (IDataComparator<? super TimerData>)TimerDataComparatorEnum.MAX),
        DURATION("Duration (ms)", 70, null, (IDataComparator<? super TimerData>)TimerDataComparatorEnum.DURATION),
        EXCLUSIVEAVERAGE("Exc. Avg (ms)", 80, null, (IDataComparator<? super TimerData>)TimerDataComparatorEnum.EXCLUSIVEAVERAGE),
        EXCLUSIVEMIN("Exc. Min (ms)", 80, null, (IDataComparator<? super TimerData>)TimerDataComparatorEnum.EXCLUSIVEMIN),
        EXCLUSIVEMAX("Exc. Max (ms)", 80, null, (IDataComparator<? super TimerData>)TimerDataComparatorEnum.EXCLUSIVEMAX),
        EXCLUSIVESUM("Exc. duration (ms)", 80, null, (IDataComparator<? super TimerData>)TimerDataComparatorEnum.EXCLUSIVEDURATION),
        CPUAVERAGE("Cpu Avg (ms)", 60, null, (IDataComparator<? super TimerData>)TimerDataComparatorEnum.CPUAVERAGE),
        CPUMIN("Cpu Min (ms)", 60, null, (IDataComparator<? super TimerData>)TimerDataComparatorEnum.CPUMIN),
        CPUMAX("Cpu Max (ms)", 60, null, (IDataComparator<? super TimerData>)TimerDataComparatorEnum.CPUMAX),
        CPUDURATION("Cpu Duration (ms)", 70, null, (IDataComparator<? super TimerData>)TimerDataComparatorEnum.CPUDURATION);

        private String name;
        private int width;
        private Image image;
        private IDataComparator<? super TimerData> dataComparator;

        private Column(String string2, int n2, String string3, IDataComparator<? super TimerData> iDataComparator) {
            this.name = string2;
            this.width = n2;
            this.image = InspectIT.getDefault().getImage(string3);
            this.dataComparator = iDataComparator;
        }

        public static Column fromOrd(int n) {
            if (n < 0 || n >= Column.values().length) {
                throw new IndexOutOfBoundsException("Invalid ordinal");
            }
            return Column.values()[n];
        }
    }

    private static final class TimerDataContentProvider
    implements IStructuredContentProvider {
        private TimerDataContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }

        public Object[] getElements(Object object) {
            return ((List)object).toArray();
        }
    }

    private final class TimerDataLabelProvider
    extends StyledCellIndexLabelProvider {
        private TimerDataLabelProvider() {
        }

        @Override
        public StyledString getStyledText(Object object, int n) {
            TimerData timerData = (TimerData)object;
            MethodIdent methodIdent = TimerDataInputController.this.cachedDataService.getMethodIdentForId(timerData.getMethodIdent());
            Column column = Column.fromOrd(n);
            StyledString styledString = TimerDataInputController.this.getStyledTextForColumn(timerData, methodIdent, column);
            if (this.addWarnSign(timerData, column)) {
                styledString.append(TextFormatter.getWarningSign());
            }
            return styledString;
        }

        private boolean addWarnSign(TimerData timerData, Column column) {
            switch (column) {
                case EXCLUSIVEAVERAGE: 
                case EXCLUSIVEMIN: 
                case EXCLUSIVEMAX: 
                case EXCLUSIVESUM: {
                    int n = (int)(timerData.getInvocationAffiliationPercentage() * 100.0);
                    return timerData.isExclusiveTimeDataAvailable() && n < 100;
                }
            }
            return false;
        }

        @Override
        protected Image getColumnImage(Object object, int n) {
            TimerData timerData = (TimerData)object;
            Column column = Column.fromOrd(n);
            switch (column) {
                case CHARTING: {
                    if (!timerData.isCharting()) break;
                    return InspectIT.getDefault().getImage("/icons/eclipse/graph_pie.gif");
                }
            }
            return super.getColumnImage(object, n);
        }

        @Override
        public String getToolTipText(Object object, int n) {
            TimerData timerData = (TimerData)object;
            Column column = Column.fromOrd(n);
            switch (column) {
                case CHARTING: {
                    if (!timerData.isCharting()) break;
                    return "Duration chart can be displayed for this timer data.";
                }
            }
            return super.getToolTipText(object, n);
        }
    }
}

