/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.editor.table.input;

import info.novatec.inspectit.communication.comparator.ResultComparator;
import info.novatec.inspectit.communication.data.InvocationAwareData;
import info.novatec.inspectit.rcp.editor.inputdefinition.InputDefinition;
import info.novatec.inspectit.rcp.editor.inputdefinition.extra.InputDefinitionExtrasMarkerFactory;
import info.novatec.inspectit.rcp.editor.preferences.PreferenceId;
import info.novatec.inspectit.rcp.editor.root.IRootEditor;
import info.novatec.inspectit.rcp.editor.table.TableViewerComparator;
import info.novatec.inspectit.rcp.editor.table.input.InvocOverviewInputController;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ViewerComparator;

public class NavigationInvocOverviewInputController
extends InvocOverviewInputController {
    public static final String ID = "inspectit.subview.table.navigationinvocoverview";
    private List<InvocationAwareData> invocationAwareDataList;

    @Override
    public void setInputDefinition(InputDefinition inputDefinition) {
        if (inputDefinition.hasInputDefinitionExtra(InputDefinitionExtrasMarkerFactory.NAVIGATION_STEPPING_EXTRAS_MARKER)) {
            this.invocationAwareDataList = inputDefinition.getInputDefinitionExtra(InputDefinitionExtrasMarkerFactory.NAVIGATION_STEPPING_EXTRAS_MARKER).getInvocationAwareDataList();
        }
        super.setInputDefinition(inputDefinition);
    }

    @Override
    public Set<PreferenceId> getPreferenceIds() {
        EnumSet<PreferenceId> enumSet = EnumSet.noneOf(PreferenceId.class);
        if (this.getInputDefinition().getRepositoryDefinition() instanceof CmrRepositoryDefinition) {
            enumSet.add(PreferenceId.CLEAR_BUFFER);
        }
        enumSet.add(PreferenceId.ITEMCOUNT);
        return enumSet;
    }

    @Override
    public ViewerComparator getComparator() {
        TableViewerComparator tableViewerComparator = new TableViewerComparator();
        InvocOverviewInputController.Column[] columnArray = InvocOverviewInputController.Column.values();
        int n = columnArray.length;
        int n2 = 0;
        while (n2 < n) {
            InvocOverviewInputController.Column column = columnArray[n2];
            ResultComparator resultComparator = new ResultComparator(column.dataComparator, this.getCachedDataService());
            tableViewerComparator.addColumn(this.getMappedTableViewerColumn(column).getColumn(), resultComparator);
            ++n2;
        }
        return tableViewerComparator;
    }

    @Override
    public void doRefresh(IProgressMonitor iProgressMonitor, IRootEditor iRootEditor) {
        iProgressMonitor.beginTask("Updating Invocation Overview", -1);
        iProgressMonitor.subTask("Retrieving the Invocation Overview from the CMR");
        HashSet hashSet = new HashSet();
        for (InvocationAwareData invocationAwareData : this.invocationAwareDataList) {
            if (invocationAwareData.getInvocationParentsIdSet() == null) continue;
            hashSet.addAll(invocationAwareData.getInvocationParentsIdSet());
        }
        long l = this.getInputDefinition().getIdDefinition().getPlatformId();
        List list = this.getDataAccessService().getInvocationSequenceOverview(l, hashSet, this.getLimit(), this.getResultComparator());
        this.getInvocationSequenceData().clear();
        if (!list.isEmpty()) {
            iProgressMonitor.subTask("Displaying the Invocation Overview");
            this.getInvocationSequenceData().addAll(list);
        }
        iProgressMonitor.done();
    }
}

