/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.editor.table.input;

import info.novatec.inspectit.cmr.service.ICachedDataService;
import info.novatec.inspectit.cmr.service.IExceptionDataAccessService;
import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.communication.comparator.AggregatedExceptionSensorDataComparatorEnum;
import info.novatec.inspectit.communication.comparator.ExceptionSensorDataComparatorEnum;
import info.novatec.inspectit.communication.comparator.IDataComparator;
import info.novatec.inspectit.communication.comparator.InvocationAwareDataComparatorEnum;
import info.novatec.inspectit.communication.comparator.ResultComparator;
import info.novatec.inspectit.communication.data.AggregatedExceptionSensorData;
import info.novatec.inspectit.communication.data.ExceptionSensorData;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.editor.inputdefinition.InputDefinition;
import info.novatec.inspectit.rcp.editor.inputdefinition.extra.InputDefinitionExtrasMarkerFactory;
import info.novatec.inspectit.rcp.editor.preferences.IPreferenceGroup;
import info.novatec.inspectit.rcp.editor.preferences.PreferenceEventCallback;
import info.novatec.inspectit.rcp.editor.preferences.PreferenceId;
import info.novatec.inspectit.rcp.editor.root.IRootEditor;
import info.novatec.inspectit.rcp.editor.table.TableViewerComparator;
import info.novatec.inspectit.rcp.editor.table.input.AbstractTableInputController;
import info.novatec.inspectit.rcp.editor.viewers.StyledCellIndexLabelProvider;
import info.novatec.inspectit.rcp.formatter.TextFormatter;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class GroupedExceptionOverviewInputController
extends AbstractTableInputController {
    public static final String ID = "inspectit.subview.table.groupedexceptionoverview";
    private ExceptionSensorData template;
    private Date fromDate;
    private Date toDate;
    private List<AggregatedExceptionSensorData> exceptionSensorDataList = new ArrayList<AggregatedExceptionSensorData>();
    private Map<String, List<AggregatedExceptionSensorData>> overviewMap;
    private IExceptionDataAccessService dataAccessService;

    @Override
    public void setInputDefinition(InputDefinition inputDefinition) {
        super.setInputDefinition(inputDefinition);
        this.template = new ExceptionSensorData();
        this.template.setPlatformIdent(inputDefinition.getIdDefinition().getPlatformId());
        this.template.setSensorTypeIdent(inputDefinition.getIdDefinition().getSensorTypeId());
        this.template.setMethodIdent(inputDefinition.getIdDefinition().getMethodId());
        if (inputDefinition.hasInputDefinitionExtra(InputDefinitionExtrasMarkerFactory.EXCEPTION_TYPE_EXTRAS_MARKER)) {
            String string = inputDefinition.getInputDefinitionExtra(InputDefinitionExtrasMarkerFactory.EXCEPTION_TYPE_EXTRAS_MARKER).getThrowableType();
            this.template.setThrowableType(string);
        }
        this.dataAccessService = inputDefinition.getRepositoryDefinition().getExceptionDataAccessService();
    }

    @Override
    public void createColumns(TableViewer tableViewer) {
        Column[] columnArray = Column.values();
        int n = columnArray.length;
        int n2 = 0;
        while (n2 < n) {
            Column column = columnArray[n2];
            TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, 0);
            tableViewerColumn.getColumn().setMoveable(true);
            tableViewerColumn.getColumn().setResizable(true);
            tableViewerColumn.getColumn().setText(column.name);
            tableViewerColumn.getColumn().setWidth(column.width);
            if (column.image != null) {
                tableViewerColumn.getColumn().setImage(column.image);
            }
            this.mapTableViewerColumn(column, tableViewerColumn);
            ++n2;
        }
    }

    @Override
    public Object getTableInput() {
        return this.exceptionSensorDataList;
    }

    @Override
    public IContentProvider getContentProvider() {
        return new GroupedExceptionOverviewContentProvider();
    }

    @Override
    public IBaseLabelProvider getLabelProvider() {
        return new GroupedExceptionOverviewLabelProvider();
    }

    @Override
    public ViewerComparator getComparator() {
        ICachedDataService iCachedDataService = this.getInputDefinition().getRepositoryDefinition().getCachedDataService();
        TableViewerComparator tableViewerComparator = new TableViewerComparator();
        Column[] columnArray = Column.values();
        int n = columnArray.length;
        int n2 = 0;
        while (n2 < n) {
            Column column = columnArray[n2];
            ResultComparator resultComparator = new ResultComparator(column.dataComparator, iCachedDataService);
            tableViewerComparator.addColumn(this.getMappedTableViewerColumn(column).getColumn(), resultComparator);
            ++n2;
        }
        return tableViewerComparator;
    }

    @Override
    public Set<PreferenceId> getPreferenceIds() {
        EnumSet<PreferenceId> enumSet = EnumSet.noneOf(PreferenceId.class);
        if (this.getInputDefinition().getRepositoryDefinition() instanceof CmrRepositoryDefinition) {
            enumSet.add(PreferenceId.CLEAR_BUFFER);
            enumSet.add(PreferenceId.LIVEMODE);
        }
        enumSet.add(PreferenceId.UPDATE);
        enumSet.add(PreferenceId.TIMELINE);
        return enumSet;
    }

    @Override
    public boolean canOpenInput(List<? extends DefaultData> list) {
        return list.isEmpty();
    }

    @Override
    public void preferenceEventFired(PreferenceEventCallback.PreferenceEvent preferenceEvent) {
        switch (preferenceEvent.getPreferenceId()) {
            case TIMELINE: {
                Map<IPreferenceGroup, Object> map = preferenceEvent.getPreferenceMap();
                if (map.containsKey(PreferenceId.TimeLine.FROM_DATE_ID)) {
                    this.fromDate = (Date)map.get(PreferenceId.TimeLine.FROM_DATE_ID);
                }
                if (!map.containsKey(PreferenceId.TimeLine.TO_DATE_ID)) break;
                this.toDate = (Date)map.get(PreferenceId.TimeLine.TO_DATE_ID);
                break;
            }
        }
    }

    @Override
    public void doRefresh(IProgressMonitor iProgressMonitor, IRootEditor iRootEditor) {
        List<AggregatedExceptionSensorData> list;
        iProgressMonitor.beginTask("Updating Grouped Exception Overview", -1);
        iProgressMonitor.subTask("Retrieving the Grouped Exception Overview");
        List list2 = null;
        list2 = this.fromDate != null && this.toDate != null ? this.dataAccessService.getDataForGroupedExceptionOverview(this.template, this.fromDate, this.toDate) : this.dataAccessService.getDataForGroupedExceptionOverview(this.template);
        ArrayList<AggregatedExceptionSensorData> arrayList = new ArrayList<AggregatedExceptionSensorData>();
        this.overviewMap = new HashMap<String, List<AggregatedExceptionSensorData>>();
        for (AggregatedExceptionSensorData object : list2) {
            list = Collections.EMPTY_LIST;
            if (!this.overviewMap.containsKey(object.getThrowableType())) {
                list = new ArrayList();
                list.add(object);
                this.overviewMap.put(object.getThrowableType(), list);
                continue;
            }
            list = this.overviewMap.get(object.getThrowableType());
            list.add(object);
        }
        for (Map.Entry entry : this.overviewMap.entrySet()) {
            list = (String)entry.getKey();
            AggregatedExceptionSensorData aggregatedExceptionSensorData = this.createObjectForOverview((String)((Object)list), (List)entry.getValue());
            arrayList.add(aggregatedExceptionSensorData);
        }
        if (arrayList != null) {
            this.exceptionSensorDataList.clear();
            iProgressMonitor.subTask("Displaying the Exception Overview");
            this.exceptionSensorDataList.addAll(arrayList);
        }
        iProgressMonitor.done();
    }

    private AggregatedExceptionSensorData createObjectForOverview(String string, List<AggregatedExceptionSensorData> list) {
        AggregatedExceptionSensorData aggregatedExceptionSensorData = new AggregatedExceptionSensorData();
        aggregatedExceptionSensorData.setThrowableType(string);
        for (AggregatedExceptionSensorData aggregatedExceptionSensorData2 : list) {
            if (aggregatedExceptionSensorData.getPlatformIdent() == 0L) {
                aggregatedExceptionSensorData.setPlatformIdent(aggregatedExceptionSensorData2.getPlatformIdent());
            }
            aggregatedExceptionSensorData.aggregateExceptionData(aggregatedExceptionSensorData2);
        }
        return aggregatedExceptionSensorData;
    }

    @Override
    public void doubleClick(DoubleClickEvent doubleClickEvent) {
        final StructuredSelection structuredSelection = (StructuredSelection)doubleClickEvent.getSelection();
        if (!structuredSelection.isEmpty()) {
            try {
                PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                    public void run(IProgressMonitor iProgressMonitor) {
                        iProgressMonitor.beginTask("Retrieving Exception Messages", -1);
                        AggregatedExceptionSensorData aggregatedExceptionSensorData = (AggregatedExceptionSensorData)structuredSelection.getFirstElement();
                        final List list = (List)GroupedExceptionOverviewInputController.this.overviewMap.get(aggregatedExceptionSensorData.getThrowableType());
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                                IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
                                IRootEditor iRootEditor = (IRootEditor)iWorkbenchPage.getActiveEditor();
                                iRootEditor.setDataInput(list);
                            }
                        });
                        iProgressMonitor.done();
                    }
                });
            }
            catch (InvocationTargetException invocationTargetException) {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell().getShell(), (String)"Error", (String)invocationTargetException.getCause().toString());
            }
            catch (InterruptedException interruptedException) {
                MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell().getShell(), (String)"Cancelled", (String)interruptedException.getCause().toString());
            }
        }
    }

    private StyledString getStyledTextForColumn(AggregatedExceptionSensorData aggregatedExceptionSensorData, Column column) {
        switch (column) {
            case FQN: {
                return new StyledString(aggregatedExceptionSensorData.getThrowableType());
            }
            case INVOCATION_AFFILLIATION: {
                int n = (int)(aggregatedExceptionSensorData.getInvocationAffiliationPercentage() * 100.0);
                int n2 = 0;
                if (aggregatedExceptionSensorData.getInvocationParentsIdSet() != null) {
                    n2 = aggregatedExceptionSensorData.getInvocationParentsIdSet().size();
                }
                return TextFormatter.getInvocationAffilliationPercentageString(n, n2);
            }
            case CREATED: {
                return new StyledString(String.valueOf(aggregatedExceptionSensorData.getCreated()));
            }
            case RETHROWN: {
                return new StyledString(String.valueOf(aggregatedExceptionSensorData.getPassed()));
            }
            case HANDLED: {
                return new StyledString(String.valueOf(aggregatedExceptionSensorData.getHandled()));
            }
        }
        return new StyledString("error");
    }

    @Override
    public String getReadableString(Object object) {
        if (object instanceof AggregatedExceptionSensorData) {
            AggregatedExceptionSensorData aggregatedExceptionSensorData = (AggregatedExceptionSensorData)object;
            StringBuilder stringBuilder = new StringBuilder();
            Column[] columnArray = Column.values();
            int n = columnArray.length;
            int n2 = 0;
            while (n2 < n) {
                Column column = columnArray[n2];
                stringBuilder.append(this.getStyledTextForColumn(aggregatedExceptionSensorData, column).toString());
                stringBuilder.append('\t');
                ++n2;
            }
            return stringBuilder.toString();
        }
        throw new RuntimeException("Could not create the human readable string!");
    }

    @Override
    public List<String> getColumnValues(Object object) {
        if (object instanceof AggregatedExceptionSensorData) {
            AggregatedExceptionSensorData aggregatedExceptionSensorData = (AggregatedExceptionSensorData)object;
            ArrayList<String> arrayList = new ArrayList<String>();
            Column[] columnArray = Column.values();
            int n = columnArray.length;
            int n2 = 0;
            while (n2 < n) {
                Column column = columnArray[n2];
                arrayList.add(this.getStyledTextForColumn(aggregatedExceptionSensorData, column).toString());
                ++n2;
            }
            return arrayList;
        }
        throw new RuntimeException("Could not create the column values!");
    }

    private static enum Column {
        FQN("Fully-Qualified Name", 450, "/icons/eclipse/class_obj.gif", (IDataComparator<? super AggregatedExceptionSensorData>)ExceptionSensorDataComparatorEnum.FQN),
        INVOCATION_AFFILLIATION("In Invocations", 120, "/icons/fugue/arrow-switch.png", (IDataComparator<? super AggregatedExceptionSensorData>)InvocationAwareDataComparatorEnum.INVOCATION_AFFILIATION),
        CREATED("Created", 70, null, (IDataComparator<? super AggregatedExceptionSensorData>)AggregatedExceptionSensorDataComparatorEnum.CREATED),
        RETHROWN("Rethrown", 70, null, (IDataComparator<? super AggregatedExceptionSensorData>)AggregatedExceptionSensorDataComparatorEnum.RETHROWN),
        HANDLED("Handled", 70, null, (IDataComparator<? super AggregatedExceptionSensorData>)AggregatedExceptionSensorDataComparatorEnum.HANDLED);

        private String name;
        private int width;
        private Image image;
        private IDataComparator<? super AggregatedExceptionSensorData> dataComparator;

        private Column(String string2, int n2, String string3, IDataComparator<? super AggregatedExceptionSensorData> iDataComparator) {
            this.name = string2;
            this.width = n2;
            this.image = InspectIT.getDefault().getImage(string3);
            this.dataComparator = iDataComparator;
        }

        public static Column fromOrd(int n) {
            if (n < 0 || n >= Column.values().length) {
                throw new IndexOutOfBoundsException("Invalid ordinal");
            }
            return Column.values()[n];
        }
    }

    private static final class GroupedExceptionOverviewContentProvider
    implements IStructuredContentProvider {
        private GroupedExceptionOverviewContentProvider() {
        }

        public Object[] getElements(Object object) {
            List list = (List)object;
            return list.toArray();
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }

        public void dispose() {
        }
    }

    private final class GroupedExceptionOverviewLabelProvider
    extends StyledCellIndexLabelProvider {
        private GroupedExceptionOverviewLabelProvider() {
        }

        @Override
        protected StyledString getStyledText(Object object, int n) {
            AggregatedExceptionSensorData aggregatedExceptionSensorData = (AggregatedExceptionSensorData)object;
            Column column = Column.fromOrd(n);
            return GroupedExceptionOverviewInputController.this.getStyledTextForColumn(aggregatedExceptionSensorData, column);
        }
    }
}

