/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.editor.table.input;

import info.novatec.inspectit.cmr.service.IHttpTimerDataAccessService;
import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.communication.data.HttpTimerData;
import info.novatec.inspectit.rcp.editor.inputdefinition.InputDefinition;
import info.novatec.inspectit.rcp.editor.preferences.PreferenceEventCallback;
import info.novatec.inspectit.rcp.editor.preferences.PreferenceId;
import info.novatec.inspectit.rcp.editor.table.input.AbstractTableInputController;
import info.novatec.inspectit.rcp.preferences.PreferencesUtils;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StyledString;

public abstract class AbstractHttpInputController
extends AbstractTableInputController {
    protected IHttpTimerDataAccessService httptimerDataAccessService;
    protected List<HttpTimerData> timerDataList = new ArrayList<HttpTimerData>();
    protected HttpTimerData template;
    protected final StyledString emptyStyledString = new StyledString();
    protected Date fromDate = null;
    protected Date toDate = null;
    protected boolean autoUpdate = false;
    protected int timeDecimalPlaces = PreferencesUtils.getIntValue("DECIMAL_PLACES");
    protected boolean httpCatorizationOnRequestMethodActive = false;

    @Override
    public void setInputDefinition(InputDefinition inputDefinition) {
        super.setInputDefinition(inputDefinition);
        this.template = new HttpTimerData();
        this.template.setPlatformIdent(inputDefinition.getIdDefinition().getPlatformId());
        this.httptimerDataAccessService = inputDefinition.getRepositoryDefinition().getHttpTimerDataAccessService();
    }

    @Override
    public boolean canOpenInput(List<? extends DefaultData> list) {
        return list != null;
    }

    @Override
    public Object getTableInput() {
        return this.timerDataList;
    }

    @Override
    public void preferenceEventFired(PreferenceEventCallback.PreferenceEvent preferenceEvent) {
        if (preferenceEvent == null) {
            return;
        }
        switch (preferenceEvent.getPreferenceId()) {
            case TIMELINE: {
                if (preferenceEvent.getPreferenceMap().containsKey(PreferenceId.TimeLine.FROM_DATE_ID)) {
                    this.fromDate = (Date)preferenceEvent.getPreferenceMap().get(PreferenceId.TimeLine.FROM_DATE_ID);
                }
                if (!preferenceEvent.getPreferenceMap().containsKey(PreferenceId.TimeLine.TO_DATE_ID)) break;
                this.toDate = (Date)preferenceEvent.getPreferenceMap().get(PreferenceId.TimeLine.TO_DATE_ID);
                break;
            }
            case LIVEMODE: {
                if (!preferenceEvent.getPreferenceMap().containsKey(PreferenceId.LiveMode.BUTTON_LIVE_ID)) break;
                this.autoUpdate = (Boolean)preferenceEvent.getPreferenceMap().get(PreferenceId.LiveMode.BUTTON_LIVE_ID);
                break;
            }
            case TIME_RESOLUTION: {
                if (!preferenceEvent.getPreferenceMap().containsKey(PreferenceId.TimeResolution.TIME_DECIMAL_PLACES_ID)) break;
                this.timeDecimalPlaces = (Integer)preferenceEvent.getPreferenceMap().get(PreferenceId.TimeResolution.TIME_DECIMAL_PLACES_ID);
                break;
            }
            case HTTP_AGGREGATION_REQUESTMETHOD: {
                if (!preferenceEvent.getPreferenceMap().containsKey(PreferenceId.HttpAggregationRequestMethod.BUTTON_HTTP_AGGREGATION_REQUESTMETHOD_ID)) break;
                this.httpCatorizationOnRequestMethodActive = (Boolean)preferenceEvent.getPreferenceMap().get(PreferenceId.HttpAggregationRequestMethod.BUTTON_HTTP_AGGREGATION_REQUESTMETHOD_ID);
                break;
            }
        }
    }

    @Override
    public Set<PreferenceId> getPreferenceIds() {
        EnumSet<PreferenceId> enumSet = EnumSet.noneOf(PreferenceId.class);
        if (this.getInputDefinition().getRepositoryDefinition() instanceof CmrRepositoryDefinition) {
            enumSet.add(PreferenceId.CLEAR_BUFFER);
            enumSet.add(PreferenceId.LIVEMODE);
        }
        enumSet.add(PreferenceId.UPDATE);
        enumSet.add(PreferenceId.TIMELINE);
        enumSet.add(PreferenceId.HTTP_AGGREGATION_REQUESTMETHOD);
        enumSet.add(PreferenceId.TIME_RESOLUTION);
        return enumSet;
    }

    @Override
    public IContentProvider getContentProvider() {
        return new ArrayContentProvider();
    }
}

