/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.editor.search.helper;

import info.novatec.inspectit.rcp.editor.search.ISearchExecutor;
import info.novatec.inspectit.rcp.editor.search.criteria.SearchCriteria;
import info.novatec.inspectit.rcp.editor.search.criteria.SearchResult;
import info.novatec.inspectit.rcp.editor.search.factory.SearchFactory;
import info.novatec.inspectit.rcp.repository.RepositoryDefinition;
import info.novatec.inspectit.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;

public abstract class AbstractSearchHelper
implements ISearchExecutor {
    private int currentOccurrence;
    private int totalOccurrences;
    private SearchCriteria lastSearchCriteria;
    private Object[] allObjects;
    private List<Object> foundObjects = Collections.emptyList();
    private final RepositoryDefinition repositoryDefinition;
    private int oldInputHash;
    private SelectionAdapter columnSortingListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            AbstractSearchHelper.this.clearSearch();
        }
    };
    private boolean cleared;

    public AbstractSearchHelper(RepositoryDefinition repositoryDefinition) {
        this.repositoryDefinition = repositoryDefinition;
    }

    public abstract void selectElement(Object var1);

    public abstract Object[] getAllObjects();

    public abstract StructuredViewer getViewer();

    @Override
    public SearchResult executeSearch(SearchCriteria searchCriteria) {
        if (!this.cleared && ObjectUtils.equals((Object)this.lastSearchCriteria, (Object)searchCriteria)) {
            return this.next();
        }
        if (!this.checkInput()) {
            this.loadAllObjects();
        }
        this.updateFoundObjects(searchCriteria);
        if (this.totalOccurrences > 0) {
            this.currentOccurrence = 1;
            this.displayOccurence(this.currentOccurrence);
        } else {
            this.currentOccurrence = 0;
        }
        this.lastSearchCriteria = searchCriteria;
        this.cleared = false;
        return this.getSearchResult();
    }

    @Override
    public SearchResult next() {
        if (this.cleared) {
            return this.executeSearch(this.lastSearchCriteria);
        }
        if (!this.checkInput()) {
            this.loadAllObjects();
            this.updateFoundObjects(this.lastSearchCriteria);
        } else {
            this.sortAsInViewer(this.foundObjects);
        }
        if (this.totalOccurrences > 1) {
            ++this.currentOccurrence;
            if (this.currentOccurrence > this.totalOccurrences) {
                this.currentOccurrence = 1;
            }
            this.displayOccurence(this.currentOccurrence);
        } else {
            this.currentOccurrence = this.totalOccurrences;
            if (this.currentOccurrence > 0) {
                this.displayOccurence(this.currentOccurrence);
            }
        }
        return this.getSearchResult();
    }

    @Override
    public SearchResult previous() {
        if (this.cleared) {
            return this.executeSearch(this.lastSearchCriteria);
        }
        if (!this.checkInput()) {
            this.loadAllObjects();
            this.updateFoundObjects(this.lastSearchCriteria);
        } else {
            this.sortAsInViewer(this.foundObjects);
        }
        if (this.totalOccurrences > 1) {
            --this.currentOccurrence;
            if (this.currentOccurrence == 0) {
                this.currentOccurrence = this.totalOccurrences;
            }
            this.displayOccurence(this.currentOccurrence);
        } else {
            this.currentOccurrence = this.totalOccurrences;
            if (this.currentOccurrence > 0) {
                this.displayOccurence(this.currentOccurrence);
            }
        }
        return this.getSearchResult();
    }

    @Override
    public void clearSearch() {
        this.cleared = true;
    }

    private SearchResult getSearchResult() {
        if (this.totalOccurrences > 1) {
            return new SearchResult(this.currentOccurrence, this.totalOccurrences, true, true);
        }
        return new SearchResult(this.currentOccurrence, this.totalOccurrences, false, false);
    }

    private boolean checkInput() {
        int n = Arrays.hashCode(this.getAllObjects());
        if (this.oldInputHash != n) {
            this.oldInputHash = n;
            return false;
        }
        this.oldInputHash = n;
        return true;
    }

    private void loadAllObjects() {
        this.allObjects = this.getAllObjects();
    }

    private void updateFoundObjects(SearchCriteria searchCriteria) {
        this.foundObjects = new ArrayList<Object>();
        Object[] objectArray = this.allObjects;
        int n = this.allObjects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (SearchFactory.isSearchCompatible(object, searchCriteria, this.repositoryDefinition) && this.areFiltersPassed(object, this.getViewer().getFilters())) {
                this.foundObjects.add(object);
            }
            ++n2;
        }
        this.sortAsInViewer(this.foundObjects);
        this.totalOccurrences = this.foundObjects.size();
    }

    private void sortAsInViewer(List<Object> list) {
        if (this.getViewer().getComparator() != null) {
            Collections.sort(list, new Comparator<Object>(){

                @Override
                public int compare(Object object, Object object2) {
                    return AbstractSearchHelper.this.getViewer().getComparator().compare((Viewer)AbstractSearchHelper.this.getViewer(), object, object2);
                }
            });
        }
    }

    private boolean areFiltersPassed(Object object, ViewerFilter[] viewerFilterArray) {
        if (viewerFilterArray != null) {
            ViewerFilter[] viewerFilterArray2 = viewerFilterArray;
            int n = viewerFilterArray.length;
            int n2 = 0;
            while (n2 < n) {
                ViewerFilter viewerFilter = viewerFilterArray2[n2];
                if (!viewerFilter.select((Viewer)this.getViewer(), null, object)) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    private void displayOccurence(int n) {
        if (this.totalOccurrences >= n && this.foundObjects.size() >= n) {
            Object object = this.foundObjects.get(n - 1);
            this.selectElement(object);
        }
    }

    protected SelectionAdapter getColumnSortingListener() {
        return this.columnSortingListener;
    }
}

