/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.editor.root;

import info.novatec.inspectit.rcp.editor.ISubView;
import info.novatec.inspectit.rcp.editor.root.AbstractRootEditor;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;

public class MultiSubViewSelectionProvider
implements IPostSelectionProvider {
    private ListenerList listeners = new ListenerList();
    private ListenerList postListeners = new ListenerList();
    private AbstractRootEditor rootEditor;

    public MultiSubViewSelectionProvider(AbstractRootEditor abstractRootEditor) {
        Assert.isNotNull((Object)abstractRootEditor);
        this.rootEditor = abstractRootEditor;
    }

    public void addPostSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.postListeners.add((Object)iSelectionChangedListener);
    }

    public void removePostSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.postListeners.remove((Object)iSelectionChangedListener);
    }

    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.listeners.add((Object)iSelectionChangedListener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.listeners.remove((Object)iSelectionChangedListener);
    }

    public ISelection getSelection() {
        ISelectionProvider iSelectionProvider;
        ISubView iSubView = this.rootEditor.getActiveSubView();
        if (iSubView != null && (iSelectionProvider = iSubView.getSelectionProvider()) != null) {
            return iSelectionProvider.getSelection();
        }
        return StructuredSelection.EMPTY;
    }

    public void setSelection(ISelection iSelection) {
        ISelectionProvider iSelectionProvider;
        ISubView iSubView = this.rootEditor.getActiveSubView();
        if (iSubView != null && (iSelectionProvider = iSubView.getSelectionProvider()) != null) {
            iSelectionProvider.setSelection(iSelection);
        }
    }

    public void fireSelectionChanged(SelectionChangedEvent selectionChangedEvent) {
        Object[] objectArray = this.listeners.getListeners();
        this.fireEventChange(selectionChangedEvent, objectArray);
    }

    public void firePostSelectionChanged(SelectionChangedEvent selectionChangedEvent) {
        Object[] objectArray = this.postListeners.getListeners();
        this.fireEventChange(selectionChangedEvent, objectArray);
    }

    private void fireEventChange(final SelectionChangedEvent selectionChangedEvent, Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            final ISelectionChangedListener iSelectionChangedListener = (ISelectionChangedListener)objectArray[n];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    iSelectionChangedListener.selectionChanged(selectionChangedEvent);
                }
            });
            ++n;
        }
    }
}

