/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.editor.root;

import info.novatec.inspectit.cmr.model.PlatformIdent;
import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.editor.ISubView;
import info.novatec.inspectit.rcp.editor.SubViewFactory;
import info.novatec.inspectit.rcp.editor.composite.AbstractCompositeSubView;
import info.novatec.inspectit.rcp.editor.inputdefinition.InputDefinition;
import info.novatec.inspectit.rcp.editor.preferences.IPreferencePanel;
import info.novatec.inspectit.rcp.editor.preferences.PreferenceEventCallback;
import info.novatec.inspectit.rcp.editor.preferences.PreferenceId;
import info.novatec.inspectit.rcp.editor.root.IRootEditor;
import info.novatec.inspectit.rcp.editor.root.MultiSubViewSelectionProvider;
import info.novatec.inspectit.rcp.editor.root.RootEditorInput;
import info.novatec.inspectit.rcp.formatter.ImageFormatter;
import info.novatec.inspectit.rcp.provider.IInputDefinitionProvider;
import info.novatec.inspectit.rcp.repository.CmrRepositoryChangeListener;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import info.novatec.inspectit.rcp.repository.RepositoryDefinition;
import info.novatec.inspectit.rcp.repository.StorageRepositoryDefinition;
import info.novatec.inspectit.rcp.storage.listener.StorageChangeListener;
import info.novatec.inspectit.storage.IStorageData;
import info.novatec.inspectit.storage.LocalStorageData;
import info.novatec.inspectit.util.ObjectUtils;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;

public abstract class AbstractRootEditor
extends EditorPart
implements IRootEditor,
IInputDefinitionProvider,
CmrRepositoryChangeListener,
StorageChangeListener {
    private Timer updateTimer;
    private IPreferencePanel preferencePanel;
    private ISubView subView;
    private ISubView activeSubView;
    private ISelectionChangedListener selectionChangedListener = null;
    private ISelectionChangedListener postSelectionChangedListener = null;
    private ISelection selection;
    private boolean isMaximizedMode = false;
    private ResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());

    @Override
    public void doRefresh() {
        this.subView.doRefresh();
    }

    @Override
    public InputDefinition getInputDefinition() {
        InputDefinition inputDefinition = (InputDefinition)this.getEditorInput().getAdapter(InputDefinition.class);
        Assert.isNotNull((Object)inputDefinition);
        return inputDefinition;
    }

    protected void startUpdateTimer() {
        if (this.updateTimer == null) {
            this.updateTimer = new Timer();
            this.updateTimer.schedule((TimerTask)new UpdateTimerTask(), 0L, this.getInputDefinition().getUpdateRate());
        }
    }

    protected void stopUpdateTimer() {
        if (this.updateTimer != null) {
            this.updateTimer.cancel();
            this.updateTimer = null;
        }
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        if (!(iEditorInput instanceof RootEditorInput)) {
            throw new PartInitException("Invalid Input: Must be RootEditorInput");
        }
        this.setSite((IWorkbenchPartSite)iEditorSite);
        this.setInput(iEditorInput);
        this.setTitleImage(ImageFormatter.getOverlayedEditorImage(this.getInputDefinition().getEditorPropertiesData().getPartImage(), this.getInputDefinition().getRepositoryDefinition(), this.resourceManager));
        this.subView = SubViewFactory.createSubView(this.getInputDefinition().getId());
        this.subView.setRootEditor(this);
        this.subView.init();
        iEditorSite.setSelectionProvider((ISelectionProvider)new MultiSubViewSelectionProvider(this));
        InspectIT.getDefault().getCmrRepositoryManager().addCmrRepositoryChangeListener(this);
        InspectIT.getDefault().getInspectITStorageManager().addStorageChangeListener(this);
    }

    public final void createPartControl(Composite composite) {
        Object object;
        this.setPartName(this.getInputDefinition().getEditorPropertiesData().getPartName());
        this.setTitleToolTip(this.getInputDefinition().getEditorPropertiesData().getPartTooltip());
        this.createView(composite);
        if (this.getInputDefinition().isAutomaticUpdate()) {
            this.startUpdateTimer();
        } else {
            object = new Timer();
            ((Timer)object).schedule((TimerTask)new UpdateTimerTask(), 0L);
        }
        if (this.preferencePanel != null) {
            object = new PreferenceEventCallback(){

                @Override
                public void eventFired(PreferenceEventCallback.PreferenceEvent preferenceEvent) {
                    if (PreferenceId.LIVEMODE.equals((Object)preferenceEvent.getPreferenceId())) {
                        boolean bl = false;
                        if (AbstractRootEditor.this.updateTimer != null) {
                            AbstractRootEditor.this.stopUpdateTimer();
                            bl = true;
                        }
                        if (preferenceEvent.getPreferenceMap().containsKey(PreferenceId.LiveMode.REFRESH_RATE)) {
                            long l = (Long)preferenceEvent.getPreferenceMap().get(PreferenceId.LiveMode.REFRESH_RATE);
                            AbstractRootEditor.this.getInputDefinition().setUpdateRate(l);
                        }
                        if (preferenceEvent.getPreferenceMap().containsKey(PreferenceId.LiveMode.BUTTON_LIVE_ID)) {
                            bl = (Boolean)preferenceEvent.getPreferenceMap().get(PreferenceId.LiveMode.BUTTON_LIVE_ID);
                        }
                        if (bl) {
                            AbstractRootEditor.this.startUpdateTimer();
                        } else {
                            AbstractRootEditor.this.stopUpdateTimer();
                        }
                    } else if (PreferenceId.UPDATE.equals((Object)preferenceEvent.getPreferenceId())) {
                        AbstractRootEditor.this.doRefresh();
                    }
                    AbstractRootEditor.this.getSubView().preferenceEventFired(preferenceEvent);
                }
            };
            this.preferencePanel.registerCallback((PreferenceEventCallback)object);
        }
    }

    protected abstract void createView(Composite var1);

    protected void setPreferencePanel(IPreferencePanel iPreferencePanel) {
        Assert.isNotNull((Object)iPreferencePanel);
        this.preferencePanel = iPreferencePanel;
    }

    @Override
    public IPreferencePanel getPreferencePanel() {
        return this.preferencePanel;
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void setFocus() {
        if (this.getActiveSubView() != null && this.getActiveSubView().getControl() != null) {
            this.getActiveSubView().getControl().setFocus();
        } else if (this.subView != null && this.subView.getControl() != null) {
            this.subView.getControl().setFocus();
        }
    }

    @Override
    public ISubView getSubView() {
        return this.subView;
    }

    @Override
    public void setActiveSubView(ISubView iSubView) {
        Assert.isNotNull((Object)iSubView);
        if (!ObjectUtils.equals((Object)this.activeSubView, (Object)iSubView)) {
            ISelectionProvider iSelectionProvider;
            this.activeSubView = iSubView;
            ISelectionProvider iSelectionProvider2 = this.activeSubView.getSelectionProvider();
            if (iSelectionProvider2 != null && (iSelectionProvider = this.getSite().getSelectionProvider()) instanceof MultiSubViewSelectionProvider) {
                SelectionChangedEvent selectionChangedEvent;
                ISelection iSelection = iSelectionProvider2.getSelection();
                MultiSubViewSelectionProvider multiSubViewSelectionProvider = (MultiSubViewSelectionProvider)iSelectionProvider;
                if (ObjectUtils.equals((Object)this.selection, (Object)iSelection)) {
                    selectionChangedEvent = new SelectionChangedEvent(iSelectionProvider2, (ISelection)StructuredSelection.EMPTY);
                    multiSubViewSelectionProvider.fireSelectionChanged(selectionChangedEvent);
                    multiSubViewSelectionProvider.firePostSelectionChanged(selectionChangedEvent);
                }
                this.selection = iSelection;
                selectionChangedEvent = new SelectionChangedEvent(iSelectionProvider2, this.selection);
                multiSubViewSelectionProvider.fireSelectionChanged(selectionChangedEvent);
                multiSubViewSelectionProvider.firePostSelectionChanged(selectionChangedEvent);
            }
        }
    }

    @Override
    public ISubView getActiveSubView() {
        return this.activeSubView;
    }

    @Override
    public void setDataInput(List<? extends DefaultData> list) {
        this.subView.setDataInput(list);
    }

    public ISelectionChangedListener getSelectionChangedListener() {
        if (this.selectionChangedListener == null) {
            this.selectionChangedListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                    AbstractRootEditor.this.handleSelectionChanged(selectionChangedEvent);
                }
            };
        }
        return this.selectionChangedListener;
    }

    public ISelectionChangedListener getPostSelectionChangedListener() {
        if (this.postSelectionChangedListener == null) {
            this.postSelectionChangedListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                    AbstractRootEditor.this.handlePostSelectionChanged(selectionChangedEvent);
                }
            };
        }
        return this.postSelectionChangedListener;
    }

    protected void handleSelectionChanged(SelectionChangedEvent selectionChangedEvent) {
        ISelectionProvider iSelectionProvider = this.getSite().getSelectionProvider();
        if (iSelectionProvider instanceof MultiSubViewSelectionProvider) {
            SelectionChangedEvent selectionChangedEvent2 = new SelectionChangedEvent(iSelectionProvider, selectionChangedEvent.getSelection());
            MultiSubViewSelectionProvider multiSubViewSelectionProvider = (MultiSubViewSelectionProvider)iSelectionProvider;
            multiSubViewSelectionProvider.fireSelectionChanged(selectionChangedEvent2);
        }
    }

    protected void handlePostSelectionChanged(SelectionChangedEvent selectionChangedEvent) {
        ISelectionProvider iSelectionProvider = this.getSite().getSelectionProvider();
        if (iSelectionProvider instanceof MultiSubViewSelectionProvider) {
            SelectionChangedEvent selectionChangedEvent2 = new SelectionChangedEvent(iSelectionProvider, selectionChangedEvent.getSelection());
            MultiSubViewSelectionProvider multiSubViewSelectionProvider = (MultiSubViewSelectionProvider)iSelectionProvider;
            multiSubViewSelectionProvider.firePostSelectionChanged(selectionChangedEvent2);
        }
    }

    public void setSelection(ISelection iSelection) {
        this.selection = iSelection;
    }

    public boolean canMaximizeActiveSubView() {
        AbstractCompositeSubView abstractCompositeSubView;
        List<ISubView> list;
        if (this.isMaximizedMode) {
            return false;
        }
        return this.subView instanceof AbstractCompositeSubView && (list = (abstractCompositeSubView = (AbstractCompositeSubView)this.subView).getSubViews()) != null && list.size() > 1;
    }

    public boolean canMinimizeActiveSubView() {
        return this.isMaximizedMode;
    }

    public void maximizeActiveSubView() {
        if (this.canMaximizeActiveSubView()) {
            this.maximizeSubView((AbstractCompositeSubView)this.subView, this.activeSubView);
            this.isMaximizedMode = true;
            ISelectionProvider iSelectionProvider = this.getSite().getSelectionProvider();
            iSelectionProvider.setSelection((ISelection)StructuredSelection.EMPTY);
        }
    }

    private boolean maximizeSubView(AbstractCompositeSubView abstractCompositeSubView, ISubView iSubView) {
        if (iSubView == null) {
            abstractCompositeSubView.maximizeSubView(null);
            return true;
        }
        if (abstractCompositeSubView.getSubViews().contains(iSubView)) {
            abstractCompositeSubView.maximizeSubView(iSubView);
            return true;
        }
        for (ISubView iSubView2 : abstractCompositeSubView.getSubViews()) {
            boolean bl;
            if (!(iSubView2 instanceof AbstractCompositeSubView) || !(bl = this.maximizeSubView((AbstractCompositeSubView)iSubView2, iSubView))) continue;
            abstractCompositeSubView.maximizeSubView(iSubView2);
            return true;
        }
        return false;
    }

    public void minimizeActiveSubView() {
        if (this.canMinimizeActiveSubView()) {
            this.restoreMaximization((AbstractCompositeSubView)this.subView);
            this.isMaximizedMode = false;
            ISelectionProvider iSelectionProvider = this.getSite().getSelectionProvider();
            iSelectionProvider.setSelection((ISelection)StructuredSelection.EMPTY);
        }
    }

    private void restoreMaximization(AbstractCompositeSubView abstractCompositeSubView) {
        abstractCompositeSubView.restoreMaximization();
        for (ISubView iSubView : abstractCompositeSubView.getSubViews()) {
            if (!(iSubView instanceof AbstractCompositeSubView)) continue;
            this.restoreMaximization((AbstractCompositeSubView)iSubView);
        }
    }

    public boolean isActiveViewMaximized() {
        return this.isMaximizedMode;
    }

    public void updateEditorName(String string) {
        if (StringUtils.isNotEmpty((String)string)) {
            this.setPartName(string);
        }
    }

    @Override
    public void repositoryOnlineStatusUpdated(CmrRepositoryDefinition cmrRepositoryDefinition, CmrRepositoryDefinition.OnlineStatus onlineStatus, CmrRepositoryDefinition.OnlineStatus onlineStatus2) {
    }

    @Override
    public void repositoryAdded(CmrRepositoryDefinition cmrRepositoryDefinition) {
    }

    @Override
    public void repositoryRemoved(CmrRepositoryDefinition cmrRepositoryDefinition) {
        StorageRepositoryDefinition storageRepositoryDefinition;
        if (ObjectUtils.equals((Object)cmrRepositoryDefinition, (Object)this.getInputDefinition().getRepositoryDefinition())) {
            this.close();
        } else if (this.getInputDefinition().getRepositoryDefinition() instanceof StorageRepositoryDefinition && ObjectUtils.equals((Object)cmrRepositoryDefinition, (Object)(storageRepositoryDefinition = (StorageRepositoryDefinition)this.getInputDefinition().getRepositoryDefinition()).getCmrRepositoryDefinition()) && !storageRepositoryDefinition.getLocalStorageData().isFullyDownloaded()) {
            this.close();
        }
    }

    @Override
    public void repositoryDataUpdated(CmrRepositoryDefinition cmrRepositoryDefinition) {
    }

    @Override
    public void repositoryAgentDeleted(CmrRepositoryDefinition cmrRepositoryDefinition, PlatformIdent platformIdent) {
        if (ObjectUtils.equals((Object)cmrRepositoryDefinition, (Object)this.getInputDefinition().getRepositoryDefinition()) && platformIdent.getId().longValue() == this.getInputDefinition().getIdDefinition().getPlatformId()) {
            this.close();
        }
    }

    @Override
    public void storageDataUpdated(IStorageData iStorageData) {
    }

    @Override
    public void storageRemotelyDeleted(IStorageData iStorageData) {
        LocalStorageData localStorageData;
        RepositoryDefinition repositoryDefinition = this.getInputDefinition().getRepositoryDefinition();
        if (repositoryDefinition instanceof StorageRepositoryDefinition && !(localStorageData = ((StorageRepositoryDefinition)repositoryDefinition).getLocalStorageData()).isFullyDownloaded() && ObjectUtils.equals((Object)localStorageData.getId(), (Object)iStorageData.getId())) {
            this.close();
        }
    }

    @Override
    public void storageLocallyDeleted(IStorageData iStorageData) {
        LocalStorageData localStorageData;
        RepositoryDefinition repositoryDefinition = this.getInputDefinition().getRepositoryDefinition();
        if (repositoryDefinition instanceof StorageRepositoryDefinition && ObjectUtils.equals((Object)(localStorageData = ((StorageRepositoryDefinition)repositoryDefinition).getLocalStorageData()).getId(), (Object)iStorageData.getId()) && !InspectIT.getDefault().getInspectITStorageManager().getMountedAvailableStorages().contains(iStorageData)) {
            this.close();
        }
    }

    protected void close() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                AbstractRootEditor.this.getEditorSite().getPage().closeEditor((IEditorPart)AbstractRootEditor.this, false);
            }
        });
    }

    public void dispose() {
        InspectIT.getDefault().getCmrRepositoryManager().removeCmrRepositoryChangeListener(this);
        InspectIT.getDefault().getInspectITStorageManager().removeStorageChangeListener(this);
        this.stopUpdateTimer();
        this.resourceManager.dispose();
        super.dispose();
        if (this.preferencePanel != null) {
            this.preferencePanel.dispose();
        }
        if (this.subView != null) {
            this.subView.dispose();
        }
    }

    private final class UpdateTimerTask
    extends TimerTask {
        private UpdateTimerTask() {
        }

        @Override
        public void run() {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        AbstractRootEditor.this.doRefresh();
                    }
                    catch (Exception exception) {
                        InspectIT.getDefault().createErrorDialog("The update mechanism on the view failed!", exception, -1);
                    }
                }
            });
        }
    }
}

