/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.editor.preferences;

import info.novatec.inspectit.cmr.model.JmxDefinitionDataIdent;
import info.novatec.inspectit.communication.data.ExceptionSensorData;
import info.novatec.inspectit.communication.data.HttpTimerData;
import info.novatec.inspectit.communication.data.InvocationSequenceData;
import info.novatec.inspectit.communication.data.SqlStatementData;
import info.novatec.inspectit.communication.data.TimerData;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.action.MenuAction;
import info.novatec.inspectit.rcp.editor.graph.plot.datasolver.PlotDataSolver;
import info.novatec.inspectit.rcp.editor.inputdefinition.InputDefinition;
import info.novatec.inspectit.rcp.editor.preferences.IPreferenceGroup;
import info.novatec.inspectit.rcp.editor.preferences.IPreferencePanel;
import info.novatec.inspectit.rcp.editor.preferences.PreferenceControlFactory;
import info.novatec.inspectit.rcp.editor.preferences.PreferenceEventCallback;
import info.novatec.inspectit.rcp.editor.preferences.PreferenceId;
import info.novatec.inspectit.rcp.editor.preferences.control.IPreferenceControl;
import info.novatec.inspectit.rcp.preferences.PreferencesUtils;
import info.novatec.inspectit.util.ObjectUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.internal.menus.CommandMessages;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.services.IServiceLocator;

public class FormPreferencePanel
implements IPreferencePanel {
    private String id;
    private final FormToolkit toolkit;
    private List<PreferenceEventCallback> callbacks = new ArrayList<PreferenceEventCallback>();
    private Action switchLiveMode;
    private Action switchPreferences;
    private Action switchSteppingControl;
    private List<IPreferenceControl> preferenceControlList = new ArrayList<IPreferenceControl>();
    private Section section;

    public FormPreferencePanel(FormToolkit formToolkit) {
        Assert.isNotNull((Object)formToolkit);
        this.toolkit = formToolkit;
        this.id = UUID.randomUUID().toString();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void registerCallback(PreferenceEventCallback preferenceEventCallback) {
        Assert.isNotNull((Object)preferenceEventCallback);
        this.callbacks.add(preferenceEventCallback);
    }

    @Override
    public void removeCallback(PreferenceEventCallback preferenceEventCallback) {
        Assert.isNotNull((Object)preferenceEventCallback);
        this.callbacks.remove(preferenceEventCallback);
    }

    @Override
    public void fireEvent(PreferenceEventCallback.PreferenceEvent preferenceEvent) {
        for (PreferenceEventCallback preferenceEventCallback : this.callbacks) {
            preferenceEventCallback.eventFired(preferenceEvent);
        }
    }

    @Override
    public void createPartControl(Composite composite, Set<PreferenceId> set, InputDefinition inputDefinition, IToolBarManager iToolBarManager) {
        this.section = this.toolkit.createSection(composite, 4096);
        this.section.setText("Preferences");
        this.section.setLayout((Layout)new GridLayout(1, false));
        this.section.setLayoutData((Object)new GridData(4, 4, true, false));
        this.section.setVisible(false);
        Composite composite2 = this.toolkit.createComposite((Composite)this.section);
        composite2.setLayout((Layout)new GridLayout(1, false));
        composite2.setLayoutData((Object)new GridData(4, 4, true, false));
        if (set != null && !set.isEmpty()) {
            if (iToolBarManager != null) {
                this.createButtons(set, iToolBarManager, inputDefinition);
            }
            this.createPreferenceControls(composite2, set);
        }
        this.section.setClient((Control)composite2);
        this.section.setExpanded(false);
    }

    @Override
    public void setVisible(boolean bl) {
        this.section.setVisible(bl);
        this.section.setExpanded(bl);
    }

    @Override
    public void disableLiveMode() {
        if (this.switchLiveMode.isChecked()) {
            this.switchLiveMode.setChecked(false);
            this.createLiveModeEvent();
        }
    }

    @Override
    public void update() {
        if (this.switchPreferences.isChecked()) {
            for (IPreferenceControl iPreferenceControl : this.preferenceControlList) {
                PreferenceEventCallback.PreferenceEvent preferenceEvent = new PreferenceEventCallback.PreferenceEvent(iPreferenceControl.getControlGroupId());
                preferenceEvent.setPreferenceMap(iPreferenceControl.eventFired());
                this.fireEvent(preferenceEvent);
            }
        }
        this.fireEvent(new PreferenceEventCallback.PreferenceEvent(PreferenceId.UPDATE));
    }

    @Override
    public void bufferCleared() {
        this.fireEvent(new PreferenceEventCallback.PreferenceEvent(PreferenceId.CLEAR_BUFFER));
    }

    @Override
    public void setSteppingControlChecked(boolean bl) {
        if (this.switchSteppingControl != null) {
            this.switchSteppingControl.setChecked(bl);
        }
    }

    private void createPreferenceControls(Composite composite, Set<PreferenceId> set) {
        for (PreferenceId preferenceId : set) {
            IPreferenceControl iPreferenceControl = PreferenceControlFactory.createPreferenceControls(composite, this.toolkit, preferenceId, this);
            if (iPreferenceControl == null) continue;
            this.preferenceControlList.add(iPreferenceControl);
        }
    }

    private void createButtons(Set<PreferenceId> set, IToolBarManager iToolBarManager, InputDefinition inputDefinition) {
        Object object;
        Object object2;
        this.switchLiveMode = new SwitchLiveMode("Live");
        this.switchPreferences = new SwitchPreferences("Additional options");
        MenuAction menuAction = new MenuAction();
        menuAction.setImageDescriptor(InspectIT.getDefault().getImageDescriptor("/icons/eclipse/build.gif"));
        menuAction.setToolTipText("Preferences");
        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("info.novatec.inspectit.rcp.commands.maximizeActiveView.preferencePanelId", this.id);
        CommandContributionItemParameter commandContributionItemParameter = new CommandContributionItemParameter((IServiceLocator)iWorkbenchWindow, null, "info.novatec.inspectit.rcp.commands.maximizeActiveView", hashMap, InspectIT.getDefault().getImageDescriptor("/icons/eclipse/defaultview_misc.gif"), null, null, null, null, this.getTooltipTextForMaximizeContributionItem(), 32, null, true);
        CommandContributionItem commandContributionItem = new CommandContributionItem(commandContributionItemParameter);
        iToolBarManager.add((IContributionItem)commandContributionItem);
        if (set.contains((Object)PreferenceId.HTTP_AGGREGATION_REQUESTMETHOD)) {
            iToolBarManager.add((IAction)new SwitchHttpCategorizationRequestMethod("Include Request Method in Categorization"));
        }
        if (set.contains((Object)PreferenceId.HTTP_URI_TRANSFORMING)) {
            iToolBarManager.add((IAction)new SwitchHttpUriTransformation("Apply sensor regular expression on URI"));
        }
        if (set.contains((Object)PreferenceId.INVOCATION_SUBVIEW_MODE)) {
            iToolBarManager.add((IAction)new SwitchInvocationSubviewMode("Switch the tabbed views mode from/to aggregated/raw"));
        }
        iToolBarManager.add((IContributionItem)new Separator());
        if (set.contains((Object)PreferenceId.SAMPLINGRATE) || set.contains((Object)PreferenceId.TIMELINE)) {
            iToolBarManager.add((IAction)this.switchPreferences);
        }
        if (set.contains((Object)PreferenceId.STEPPABLE_CONTROL)) {
            this.switchSteppingControl = new SwitchSteppingControl("Stepping control");
            iToolBarManager.add((IAction)this.switchSteppingControl);
        }
        if (set.contains((Object)PreferenceId.LIVEMODE)) {
            iToolBarManager.add((IAction)this.switchLiveMode);
            object2 = new MenuManager("Refresh rate");
            long l = PreferencesUtils.getLongValue("REFRESH_RATE");
            object2.add((IAction)new SetRefreshRateAction("5 (s)", 5000L, l));
            object2.add((IAction)new SetRefreshRateAction("10 (s)", 10000L, l));
            object2.add((IAction)new SetRefreshRateAction("30 (s)", 30000L, l));
            object2.add((IAction)new SetRefreshRateAction("60 (s)", 60000L, l));
            menuAction.addContributionItem((IContributionItem)object2);
        }
        if (set.contains((Object)PreferenceId.UPDATE)) {
            iToolBarManager.add((IAction)new UpdateAction("Update"));
        }
        if (set.contains((Object)PreferenceId.ITEMCOUNT)) {
            int n = PreferencesUtils.getIntValue("ITEMS_COUNT_TO_SHOW");
            MenuManager menuManager = new MenuManager("Item count to show");
            menuManager.add((IAction)new SetItemCountAction("10", 10, n));
            menuManager.add((IAction)new SetItemCountAction("20", 20, n));
            menuManager.add((IAction)new SetItemCountAction("50", 50, n));
            menuManager.add((IAction)new SetItemCountAction("100", 100, n));
            menuManager.add((IAction)new SetItemCountAction("200", 200, n));
            menuManager.add((IAction)new SetItemCountAction("500", 500, n));
            menuManager.add((IAction)new SetItemCountAction("All...", -1, n));
            menuAction.addContributionItem((IContributionItem)menuManager);
        }
        if (set.contains((Object)PreferenceId.FILTERDATATYPE)) {
            object2 = (Set)PreferencesUtils.getObject("INVOCATION_FILTER_DATA_TYPES");
            MenuManager menuManager = new MenuManager("Filter by DataType");
            menuManager.add((IAction)new FilterByDataTypeAction("Invocation Sequence Data", InvocationSequenceData.class, (Set<Class<?>>)object2));
            menuManager.add((IAction)new FilterByDataTypeAction("Timer Data", TimerData.class, (Set<Class<?>>)object2));
            menuManager.add((IAction)new FilterByDataTypeAction("Sql Statement Data", SqlStatementData.class, (Set<Class<?>>)object2));
            menuManager.add((IAction)new FilterByDataTypeAction("Http Timer Data", HttpTimerData.class, (Set<Class<?>>)object2));
            menuManager.add((IAction)new FilterByDataTypeAction("Exception Sensor Data", ExceptionSensorData.class, (Set<Class<?>>)object2));
            menuAction.addContributionItem((IContributionItem)menuManager);
        }
        if (set.contains((Object)PreferenceId.INVOCFILTEREXCLUSIVETIME)) {
            double d = PreferencesUtils.getDoubleValue("INVOCATION_FILTER_EXCLUSIVE_TIME");
            object = new MenuManager("Filter Details by Exclusive Time");
            object.add((IAction)new FilterByExclusiveTimeAction("No filter", Double.NaN, d));
            object.add((IAction)new FilterByExclusiveTimeAction("0.1 ms", 0.1, d));
            object.add((IAction)new FilterByExclusiveTimeAction("0.2 ms", 0.2, d));
            object.add((IAction)new FilterByExclusiveTimeAction("0.5 ms", 0.5, d));
            object.add((IAction)new FilterByExclusiveTimeAction("1 ms", 1.0, d));
            object.add((IAction)new FilterByExclusiveTimeAction("2 ms", 2.0, d));
            object.add((IAction)new FilterByExclusiveTimeAction("5 ms", 5.0, d));
            object.add((IAction)new FilterByExclusiveTimeAction("10 ms", 10.0, d));
            object.add((IAction)new FilterByExclusiveTimeAction("50 ms", 50.0, d));
            object.add((IAction)new FilterByExclusiveTimeAction("100 ms", 100.0, d));
            object.add((IAction)new FilterByExclusiveTimeAction("200 ms", 200.0, d));
            object.add((IAction)new FilterByExclusiveTimeAction("500 ms", 500.0, d));
            object.add((IAction)new FilterByExclusiveTimeAction("1 s", 1000.0, d));
            object.add((IAction)new FilterByExclusiveTimeAction("1.5 s", 1500.0, d));
            object.add((IAction)new FilterByExclusiveTimeAction("2 s", 2000.0, d));
            object.add((IAction)new FilterByExclusiveTimeAction("5 s", 5000.0, d));
            menuAction.addContributionItem((IContributionItem)object);
        }
        if (set.contains((Object)PreferenceId.INVOCFILTERTOTALTIME)) {
            double d = PreferencesUtils.getDoubleValue("INVOCATION_FILTER_TOTAL_TIME");
            object = new MenuManager("Filter Details by Total Time");
            object.add((IAction)new FilterByTotalTimeAction("No filter", Double.NaN, d));
            object.add((IAction)new FilterByTotalTimeAction("0.1 ms", 0.1, d));
            object.add((IAction)new FilterByTotalTimeAction("0.2 ms", 0.2, d));
            object.add((IAction)new FilterByTotalTimeAction("0.5 ms", 0.5, d));
            object.add((IAction)new FilterByTotalTimeAction("1 ms", 1.0, d));
            object.add((IAction)new FilterByTotalTimeAction("2 ms", 2.0, d));
            object.add((IAction)new FilterByTotalTimeAction("5 ms", 5.0, d));
            object.add((IAction)new FilterByTotalTimeAction("10 ms", 10.0, d));
            object.add((IAction)new FilterByTotalTimeAction("50 ms", 50.0, d));
            object.add((IAction)new FilterByTotalTimeAction("100 ms", 100.0, d));
            object.add((IAction)new FilterByTotalTimeAction("200 ms", 200.0, d));
            object.add((IAction)new FilterByTotalTimeAction("500 ms", 500.0, d));
            object.add((IAction)new FilterByTotalTimeAction("1 s", 1000.0, d));
            object.add((IAction)new FilterByTotalTimeAction("1.5 s", 1500.0, d));
            object.add((IAction)new FilterByTotalTimeAction("2 s", 2000.0, d));
            object.add((IAction)new FilterByTotalTimeAction("5 s", 5000.0, d));
            menuAction.addContributionItem((IContributionItem)object);
        }
        if (set.contains((Object)PreferenceId.TIME_RESOLUTION)) {
            MenuManager menuManager = new MenuManager("Time Decimal Places");
            int n = PreferencesUtils.getIntValue("DECIMAL_PLACES");
            menuManager.add((IAction)new SetTimeDecimalPlaces("0", 0, n));
            menuManager.add((IAction)new SetTimeDecimalPlaces("1", 1, n));
            menuManager.add((IAction)new SetTimeDecimalPlaces("2", 2, n));
            menuManager.add((IAction)new SetTimeDecimalPlaces("3", 3, n));
            menuAction.addContributionItem((IContributionItem)menuManager);
        }
        if (set.contains((Object)PreferenceId.JMX_PLOTDATASOLVER)) {
            JmxDefinitionDataIdent jmxDefinitionDataIdent = inputDefinition.getRepositoryDefinition().getCachedDataService().getJmxDefinitionDataIdentForId(inputDefinition.getIdDefinition().getJmxDefinitionId());
            object = (Map)PreferencesUtils.getObject("JMX_PLOT_DATA_SOLVER");
            PlotDataSolver plotDataSolver = object.containsKey(jmxDefinitionDataIdent.getDerivedFullName()) ? PlotDataSolver.valueOf((String)object.get(jmxDefinitionDataIdent.getDerivedFullName())) : PlotDataSolver.DEFAULT;
            MenuManager menuManager = new MenuManager("Plot as..");
            PlotDataSolver[] plotDataSolverArray = PlotDataSolver.values();
            int n = plotDataSolverArray.length;
            int n2 = 0;
            while (n2 < n) {
                PlotDataSolver plotDataSolver2 = plotDataSolverArray[n2];
                menuManager.add((IAction)new SetJmxPlotDataSolver(plotDataSolver2.getTitle(), plotDataSolver2, plotDataSolver));
                ++n2;
            }
            menuAction.addContributionItem((IContributionItem)menuManager);
        }
        if (menuAction.getSize() > 0) {
            iToolBarManager.add((IAction)menuAction);
        }
        iToolBarManager.update(true);
    }

    private String getTooltipTextForMaximizeContributionItem() {
        Object object;
        Binding[] bindingArray;
        String string = "Maximize Active Sub-View";
        IBindingService iBindingService = (IBindingService)PlatformUI.getWorkbench().getService(IBindingService.class);
        TriggerSequence triggerSequence = null;
        Binding[] bindingArray2 = bindingArray = iBindingService.getBindings();
        int n = bindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2;
            object = bindingArray2[n2];
            ParameterizedCommand parameterizedCommand = object.getParameterizedCommand();
            if (parameterizedCommand != null && ObjectUtils.equals((Object)(string2 = parameterizedCommand.getId()), (Object)"info.novatec.inspectit.rcp.commands.maximizeActiveView")) {
                triggerSequence = object.getTriggerSequence();
                break;
            }
            ++n2;
        }
        if (triggerSequence != null && !triggerSequence.isEmpty() && (object = triggerSequence.format()) != null && ((String)object).length() != 0) {
            string = NLS.bind((String)CommandMessages.Tooltip_Accelerator, (Object)string, (Object)object);
        }
        return string;
    }

    private void createLiveModeEvent() {
        HashMap<IPreferenceGroup, Object> hashMap = new HashMap<IPreferenceGroup, Object>();
        hashMap.put(PreferenceId.LiveMode.BUTTON_LIVE_ID, this.switchLiveMode.isChecked());
        PreferenceEventCallback.PreferenceEvent preferenceEvent = new PreferenceEventCallback.PreferenceEvent(PreferenceId.LIVEMODE);
        preferenceEvent.setPreferenceMap(hashMap);
        this.fireEvent(preferenceEvent);
    }

    @Override
    public void dispose() {
        for (IPreferenceControl iPreferenceControl : this.preferenceControlList) {
            iPreferenceControl.dispose();
        }
        this.switchLiveMode = null;
    }

    private final class FilterByDataTypeAction
    extends Action {
        private Class<?> dataClass;

        public FilterByDataTypeAction(String string, Class<?> clazz, Set<Class<?>> set) {
            super(string, 2);
            this.dataClass = clazz;
            this.setChecked(set.contains(clazz));
        }

        public void run() {
            Set set = (Set)PreferencesUtils.getObject("INVOCATION_FILTER_DATA_TYPES");
            if (this.isChecked() && !set.contains(this.dataClass)) {
                set.add(this.dataClass);
                PreferencesUtils.saveObject("INVOCATION_FILTER_DATA_TYPES", set, false);
            } else if (!this.isChecked() && set.contains(this.dataClass)) {
                set.remove(this.dataClass);
                PreferencesUtils.saveObject("INVOCATION_FILTER_DATA_TYPES", set, false);
            }
            HashMap<IPreferenceGroup, Object> hashMap = new HashMap<IPreferenceGroup, Object>();
            hashMap.put(PreferenceId.DataTypeSelection.SENSOR_DATA_SELECTION_ID, this.dataClass);
            PreferenceEventCallback.PreferenceEvent preferenceEvent = new PreferenceEventCallback.PreferenceEvent(PreferenceId.FILTERDATATYPE);
            preferenceEvent.setPreferenceMap(hashMap);
            FormPreferencePanel.this.fireEvent(preferenceEvent);
        }
    }

    private final class FilterByExclusiveTimeAction
    extends Action {
        private double time;

        public FilterByExclusiveTimeAction(String string, double d, double d2) {
            super(string, 8);
            this.time = d;
            this.setChecked(d2 == d || Double.isNaN(d) && Double.isNaN(d2));
        }

        public void run() {
            if (this.isChecked()) {
                PreferencesUtils.saveDoubleValue("INVOCATION_FILTER_EXCLUSIVE_TIME", this.time, false);
                HashMap<IPreferenceGroup, Object> hashMap = new HashMap<IPreferenceGroup, Object>();
                hashMap.put(PreferenceId.InvocExclusiveTimeSelection.TIME_SELECTION_ID, new Double(this.time));
                PreferenceEventCallback.PreferenceEvent preferenceEvent = new PreferenceEventCallback.PreferenceEvent(PreferenceId.INVOCFILTEREXCLUSIVETIME);
                preferenceEvent.setPreferenceMap(hashMap);
                FormPreferencePanel.this.fireEvent(preferenceEvent);
            }
        }
    }

    private final class FilterByTotalTimeAction
    extends Action {
        private double time;

        public FilterByTotalTimeAction(String string, double d, double d2) {
            super(string, 8);
            this.time = d;
            this.setChecked(d2 == d || Double.isNaN(d) && Double.isNaN(d2));
        }

        public void run() {
            if (this.isChecked()) {
                PreferencesUtils.saveDoubleValue("INVOCATION_FILTER_TOTAL_TIME", this.time, false);
                HashMap<IPreferenceGroup, Object> hashMap = new HashMap<IPreferenceGroup, Object>();
                hashMap.put(PreferenceId.InvocTotalTimeSelection.TIME_SELECTION_ID, new Double(this.time));
                PreferenceEventCallback.PreferenceEvent preferenceEvent = new PreferenceEventCallback.PreferenceEvent(PreferenceId.INVOCFILTERTOTALTIME);
                preferenceEvent.setPreferenceMap(hashMap);
                FormPreferencePanel.this.fireEvent(preferenceEvent);
            }
        }
    }

    private final class SetItemCountAction
    extends Action {
        private int limit;

        public SetItemCountAction(String string, int n, int n2) {
            super(string, 8);
            this.limit = n;
            this.setChecked(n2 == n);
        }

        public void run() {
            if (this.isChecked()) {
                PreferencesUtils.saveIntValue("ITEMS_COUNT_TO_SHOW", this.limit, false);
                HashMap<IPreferenceGroup, Object> hashMap = new HashMap<IPreferenceGroup, Object>();
                hashMap.put(PreferenceId.ItemCount.COUNT_SELECTION_ID, this.limit);
                PreferenceEventCallback.PreferenceEvent preferenceEvent = new PreferenceEventCallback.PreferenceEvent(PreferenceId.ITEMCOUNT);
                preferenceEvent.setPreferenceMap(hashMap);
                FormPreferencePanel.this.fireEvent(preferenceEvent);
            }
        }
    }

    private final class SetJmxPlotDataSolver
    extends Action {
        private PlotDataSolver dataSolver;

        public SetJmxPlotDataSolver(String string, PlotDataSolver plotDataSolver, PlotDataSolver plotDataSolver2) {
            super(string, 8);
            this.dataSolver = plotDataSolver;
            this.setChecked(plotDataSolver.equals((Object)plotDataSolver2));
        }

        public void run() {
            if (this.isChecked()) {
                PreferenceEventCallback.PreferenceEvent preferenceEvent = new PreferenceEventCallback.PreferenceEvent(PreferenceId.JMX_PLOTDATASOLVER);
                HashMap<IPreferenceGroup, Object> hashMap = new HashMap<IPreferenceGroup, Object>();
                hashMap.put(PreferenceId.JmxPlotDataSolver.DATA_SOLVER, (Object)this.dataSolver);
                preferenceEvent.setPreferenceMap(hashMap);
                FormPreferencePanel.this.fireEvent(preferenceEvent);
            }
            FormPreferencePanel.this.update();
        }
    }

    private final class SetRefreshRateAction
    extends Action {
        private long rate;

        public SetRefreshRateAction(String string, long l, long l2) {
            super(string, 8);
            this.rate = l;
            this.setChecked(l == l2);
        }

        public void run() {
            if (this.isChecked()) {
                PreferencesUtils.saveLongValue("REFRESH_RATE", this.rate, false);
                HashMap<IPreferenceGroup, Object> hashMap = new HashMap<IPreferenceGroup, Object>();
                hashMap.put(PreferenceId.LiveMode.REFRESH_RATE, this.rate);
                PreferenceEventCallback.PreferenceEvent preferenceEvent = new PreferenceEventCallback.PreferenceEvent(PreferenceId.LIVEMODE);
                preferenceEvent.setPreferenceMap(hashMap);
                FormPreferencePanel.this.fireEvent(preferenceEvent);
            }
        }
    }

    private final class SetTimeDecimalPlaces
    extends Action {
        private int decimalPlaces;

        public SetTimeDecimalPlaces(String string, int n, int n2) {
            super(string, 8);
            this.decimalPlaces = n;
            this.setChecked(n == n2);
        }

        public void run() {
            if (this.isChecked()) {
                PreferencesUtils.saveIntValue("DECIMAL_PLACES", this.decimalPlaces, false);
                HashMap<IPreferenceGroup, Object> hashMap = new HashMap<IPreferenceGroup, Object>();
                hashMap.put(PreferenceId.TimeResolution.TIME_DECIMAL_PLACES_ID, this.decimalPlaces);
                PreferenceEventCallback.PreferenceEvent preferenceEvent = new PreferenceEventCallback.PreferenceEvent(PreferenceId.TIME_RESOLUTION);
                preferenceEvent.setPreferenceMap(hashMap);
                FormPreferencePanel.this.fireEvent(preferenceEvent);
            }
        }
    }

    private final class SwitchHttpCategorizationRequestMethod
    extends Action {
        public SwitchHttpCategorizationRequestMethod(String string) {
            super(string, 2);
            this.setImageDescriptor(InspectIT.getDefault().getImageDescriptor("/icons/eclipse/showcat_co.gif"));
        }

        public void run() {
            PreferenceEventCallback.PreferenceEvent preferenceEvent = new PreferenceEventCallback.PreferenceEvent(PreferenceId.HTTP_AGGREGATION_REQUESTMETHOD);
            HashMap<IPreferenceGroup, Object> hashMap = new HashMap<IPreferenceGroup, Object>();
            hashMap.put(PreferenceId.HttpAggregationRequestMethod.BUTTON_HTTP_AGGREGATION_REQUESTMETHOD_ID, this.isChecked());
            preferenceEvent.setPreferenceMap(hashMap);
            FormPreferencePanel.this.fireEvent(preferenceEvent);
            FormPreferencePanel.this.update();
        }
    }

    private final class SwitchHttpUriTransformation
    extends Action {
        public SwitchHttpUriTransformation(String string) {
            super(string, 2);
            this.setImageDescriptor(InspectIT.getDefault().getImageDescriptor("/icons/eclipse/transform.gif"));
        }

        public void run() {
            PreferenceEventCallback.PreferenceEvent preferenceEvent = new PreferenceEventCallback.PreferenceEvent(PreferenceId.HTTP_URI_TRANSFORMING);
            HashMap<IPreferenceGroup, Object> hashMap = new HashMap<IPreferenceGroup, Object>();
            hashMap.put(PreferenceId.HttpUriTransformation.URI_TRANSFORMATION_ACTIVE, this.isChecked());
            preferenceEvent.setPreferenceMap(hashMap);
            FormPreferencePanel.this.fireEvent(preferenceEvent);
            FormPreferencePanel.this.update();
        }
    }

    private final class SwitchInvocationSubviewMode
    extends Action {
        public SwitchInvocationSubviewMode(String string) {
            super(string, 2);
            this.setImageDescriptor(InspectIT.getDefault().getImageDescriptor("/icons/eclipse/showcat_co.gif"));
        }

        public void run() {
            PreferenceEventCallback.PreferenceEvent preferenceEvent = new PreferenceEventCallback.PreferenceEvent(PreferenceId.INVOCATION_SUBVIEW_MODE);
            HashMap<IPreferenceGroup, Object> hashMap = new HashMap<IPreferenceGroup, Object>();
            hashMap.put(PreferenceId.InvocationSubviewMode.RAW, this.isChecked());
            preferenceEvent.setPreferenceMap(hashMap);
            FormPreferencePanel.this.fireEvent(preferenceEvent);
        }
    }

    private final class SwitchLiveMode
    extends Action {
        public SwitchLiveMode(String string) {
            super(string);
            this.setImageDescriptor(InspectIT.getDefault().getImageDescriptor("/icons/eclipse/start_task.gif"));
            this.setChecked(false);
        }

        public void run() {
            FormPreferencePanel.this.createLiveModeEvent();
        }
    }

    private final class SwitchPreferences
    extends Action {
        private SwitchPreferences(String string) {
            super(string, 2);
            this.setImageDescriptor(InspectIT.getDefault().getImageDescriptor("/icons/eclipse/preferences.gif"));
        }

        public void run() {
            FormPreferencePanel.this.setVisible(this.isChecked());
        }
    }

    private final class SwitchSteppingControl
    extends Action {
        public SwitchSteppingControl(String string) {
            super(string, 2);
            this.setImageDescriptor(InspectIT.getDefault().getImageDescriptor("/icons/eclipse/locate_in_hierarchy.gif"));
        }

        public void run() {
            PreferenceEventCallback.PreferenceEvent preferenceEvent = new PreferenceEventCallback.PreferenceEvent(PreferenceId.STEPPABLE_CONTROL);
            HashMap<IPreferenceGroup, Object> hashMap = new HashMap<IPreferenceGroup, Object>();
            hashMap.put(PreferenceId.SteppableControl.BUTTON_STEPPABLE_CONTROL_ID, this.isChecked());
            preferenceEvent.setPreferenceMap(hashMap);
            FormPreferencePanel.this.fireEvent(preferenceEvent);
        }
    }

    private final class UpdateAction
    extends Action {
        private UpdateAction(String string) {
            super(string);
            this.setImageDescriptor(InspectIT.getDefault().getImageDescriptor("/icons/eclipse/refresh.gif"));
        }

        public void run() {
            FormPreferencePanel.this.update();
        }
    }
}

