/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.editor.inputdefinition;

import com.google.common.base.Objects;
import info.novatec.inspectit.rcp.editor.inputdefinition.EditorPropertiesData;
import info.novatec.inspectit.rcp.editor.inputdefinition.extra.IInputDefinitionExtra;
import info.novatec.inspectit.rcp.editor.inputdefinition.extra.InputDefinitionExtrasMarkerFactory;
import info.novatec.inspectit.rcp.model.SensorTypeEnum;
import info.novatec.inspectit.rcp.preferences.PreferencesUtils;
import info.novatec.inspectit.rcp.repository.RepositoryDefinition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;

public class InputDefinition {
    public static final String GLOBAL_ID = "inspectit.subview.global";
    private long updateRate = PreferencesUtils.getLongValue("REFRESH_RATE");
    private boolean automaticUpdate = false;
    private RepositoryDefinition repositoryDefinition;
    private Map<String, List<IdDefinition>> idMappings = new HashMap<String, List<IdDefinition>>();
    private SensorTypeEnum id;
    private EditorPropertiesData editorPropertiesData = new EditorPropertiesData();
    private Map<InputDefinitionExtrasMarkerFactory.InputDefinitionExtraMarker<? extends IInputDefinitionExtra>, IInputDefinitionExtra> inputDefintionExtras = new HashMap<InputDefinitionExtrasMarkerFactory.InputDefinitionExtraMarker<? extends IInputDefinitionExtra>, IInputDefinitionExtra>();

    public RepositoryDefinition getRepositoryDefinition() {
        return this.repositoryDefinition;
    }

    public void setRepositoryDefinition(RepositoryDefinition repositoryDefinition) {
        Assert.isNotNull((Object)repositoryDefinition);
        this.repositoryDefinition = repositoryDefinition;
    }

    public long getUpdateRate() {
        return this.updateRate;
    }

    public void setUpdateRate(long l) {
        this.updateRate = l;
    }

    public boolean isAutomaticUpdate() {
        return this.automaticUpdate;
    }

    public void setAutomaticUpdate(boolean bl) {
        this.automaticUpdate = bl;
    }

    public SensorTypeEnum getId() {
        return this.id;
    }

    public void setId(SensorTypeEnum sensorTypeEnum) {
        this.id = sensorTypeEnum;
    }

    public EditorPropertiesData getEditorPropertiesData() {
        return this.editorPropertiesData;
    }

    public void setEditorPropertiesData(EditorPropertiesData editorPropertiesData) {
        this.editorPropertiesData = editorPropertiesData;
    }

    public void setIdDefinition(IdDefinition idDefinition) {
        if (this.idMappings.containsKey(GLOBAL_ID)) {
            throw new RuntimeException("Already defined an input definition!");
        }
        this.idMappings.put(GLOBAL_ID, new ArrayList());
        this.idMappings.get(GLOBAL_ID).add(idDefinition);
    }

    public IdDefinition getIdDefinition() {
        if (!this.idMappings.containsKey(GLOBAL_ID)) {
            throw new RuntimeException("No unique id definition is set!");
        }
        return this.idMappings.get(GLOBAL_ID).get(0);
    }

    public void addIdMapping(String string, IdDefinition idDefinition) {
        if (!this.idMappings.containsKey(string)) {
            this.idMappings.put(string, new ArrayList());
        }
        this.idMappings.get(string).add(idDefinition);
    }

    public IdDefinition getAndRemoveIdDefinition(String string) {
        if (!this.idMappings.containsKey(string)) {
            throw new RuntimeException("Key not found for ID definitions: " + string);
        }
        IdDefinition idDefinition = this.idMappings.get(string).remove(0);
        if (this.idMappings.get(string).isEmpty()) {
            this.idMappings.remove(string);
        }
        return idDefinition;
    }

    public <E extends IInputDefinitionExtra> void addInputDefinitonExtra(InputDefinitionExtrasMarkerFactory.InputDefinitionExtraMarker<E> inputDefinitionExtraMarker, E e) {
        this.inputDefintionExtras.put(inputDefinitionExtraMarker, e);
    }

    public <E extends IInputDefinitionExtra> E getInputDefinitionExtra(InputDefinitionExtrasMarkerFactory.InputDefinitionExtraMarker<E> inputDefinitionExtraMarker) {
        return (E)this.inputDefintionExtras.get(inputDefinitionExtraMarker);
    }

    public boolean hasInputDefinitionExtra(InputDefinitionExtrasMarkerFactory.InputDefinitionExtraMarker<?> inputDefinitionExtraMarker) {
        return this.inputDefintionExtras.containsKey(inputDefinitionExtraMarker);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.updateRate, this.automaticUpdate, this.repositoryDefinition, this.idMappings, this.id, this.editorPropertiesData, this.inputDefintionExtras});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        InputDefinition inputDefinition = (InputDefinition)object;
        return Objects.equal((Object)this.updateRate, (Object)inputDefinition.updateRate) && Objects.equal((Object)this.automaticUpdate, (Object)inputDefinition.automaticUpdate) && Objects.equal((Object)this.repositoryDefinition, (Object)inputDefinition.repositoryDefinition) && Objects.equal(this.idMappings, inputDefinition.idMappings) && Objects.equal((Object)((Object)this.id), (Object)((Object)inputDefinition.id)) && Objects.equal((Object)this.editorPropertiesData, (Object)inputDefinition.editorPropertiesData) && Objects.equal(this.inputDefintionExtras, inputDefinition.inputDefintionExtras);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("updateRate", this.updateRate).add("automaticUpdate", this.automaticUpdate).add("repositoryDefinition", (Object)this.repositoryDefinition).add("idMappings", this.idMappings).add("id", (Object)this.id).add("editorPropertiesData", (Object)this.editorPropertiesData).add("inputDefintionExtras", this.inputDefintionExtras).toString();
    }

    public static final class IdDefinition {
        public static final long ID_NOT_USED = 0L;
        private long platformId = 0L;
        private long sensorTypeId = 0L;
        private long methodId = 0L;
        private long jmxDefinitionId = 0L;

        public long getPlatformId() {
            return this.platformId;
        }

        public void setPlatformId(long l) {
            this.platformId = l;
        }

        public long getSensorTypeId() {
            return this.sensorTypeId;
        }

        public void setSensorTypeId(long l) {
            this.sensorTypeId = l;
        }

        public long getMethodId() {
            return this.methodId;
        }

        public void setMethodId(long l) {
            this.methodId = l;
        }

        public long getJmxDefinitionId() {
            return this.jmxDefinitionId;
        }

        public void setJmxDefinitionId(long l) {
            this.jmxDefinitionId = l;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.platformId, this.sensorTypeId, this.methodId, this.jmxDefinitionId});
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            IdDefinition idDefinition = (IdDefinition)object;
            return Objects.equal((Object)this.platformId, (Object)idDefinition.platformId) && Objects.equal((Object)this.sensorTypeId, (Object)idDefinition.sensorTypeId) && Objects.equal((Object)this.methodId, (Object)idDefinition.methodId) && Objects.equal((Object)this.jmxDefinitionId, (Object)idDefinition.jmxDefinitionId);
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("platformId", this.platformId).add("sensorTypeId", this.sensorTypeId).add("methodId", this.methodId).add("jmxDefinitionId", this.jmxDefinitionId).toString();
        }
    }
}

