/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.editor.graph.plot;

import info.novatec.inspectit.cmr.service.IGlobalDataAccessService;
import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.communication.data.ThreadInformationData;
import info.novatec.inspectit.indexing.aggregation.IAggregator;
import info.novatec.inspectit.indexing.aggregation.impl.ThreadInformationDataAggregator;
import info.novatec.inspectit.rcp.editor.graph.plot.AbstractPlotController;
import info.novatec.inspectit.rcp.editor.graph.plot.YIntervalSeriesImproved;
import info.novatec.inspectit.rcp.editor.inputdefinition.InputDefinition;
import info.novatec.inspectit.rcp.editor.preferences.PreferenceId;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.widgets.Display;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.DeviationRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.RangeType;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.YIntervalSeries;
import org.jfree.data.xy.YIntervalSeriesCollection;
import org.jfree.ui.RectangleInsets;

public class DefaultThreadsPlotController
extends AbstractPlotController {
    public static final String ID = "inspectit.subview.graph.threads";
    private ThreadInformationData template;
    private static final int WEIGHT_UPPER_PLOT = 1;
    private static final int WEIGHT_LOWER_PLOT = 1;
    private XYPlot upperPlot;
    private XYPlot lowerPlot;
    private Map<XYPlot, Integer> weights = new HashMap<XYPlot, Integer>();
    private YIntervalSeriesImproved liveThreads;
    private YIntervalSeriesImproved peakThreads;
    private YIntervalSeriesImproved daemonThreads;
    private IGlobalDataAccessService dataAccessService;
    private List<ThreadInformationData> oldData = Collections.emptyList();
    private Date oldFromDate = new Date(Long.MAX_VALUE);
    private Date oldToDate = new Date(0L);
    private Date newestDate = new Date(0L);
    IAggregator<ThreadInformationData> aggregator = new ThreadInformationDataAggregator();

    @Override
    public void setInputDefinition(InputDefinition inputDefinition) {
        super.setInputDefinition(inputDefinition);
        this.template = new ThreadInformationData();
        this.template.setPlatformIdent(inputDefinition.getIdDefinition().getPlatformId());
        this.template.setSensorTypeIdent(inputDefinition.getIdDefinition().getSensorTypeId());
        this.template.setId(-1L);
        this.dataAccessService = inputDefinition.getRepositoryDefinition().getGlobalDataAccessService();
    }

    @Override
    public List<XYPlot> getPlots() {
        this.upperPlot = this.initializeUpperPlot();
        this.lowerPlot = this.initializeLowerPlot();
        ArrayList<XYPlot> arrayList = new ArrayList<XYPlot>(2);
        arrayList.add(this.upperPlot);
        arrayList.add(this.lowerPlot);
        this.weights.put(this.upperPlot, 1);
        this.weights.put(this.lowerPlot, 1);
        return arrayList;
    }

    private XYPlot initializeUpperPlot() {
        this.liveThreads = new YIntervalSeriesImproved((Comparable<?>)((Object)"live"));
        this.peakThreads = new YIntervalSeriesImproved((Comparable<?>)((Object)"peak"));
        YIntervalSeriesCollection yIntervalSeriesCollection = new YIntervalSeriesCollection();
        yIntervalSeriesCollection.addSeries((YIntervalSeries)this.liveThreads);
        yIntervalSeriesCollection.addSeries((YIntervalSeries)this.peakThreads);
        DeviationRenderer deviationRenderer = new DeviationRenderer(true, false);
        deviationRenderer.setBaseShapesVisible(true);
        deviationRenderer.setSeriesStroke(0, (Stroke)new BasicStroke(3.0f, 1, 1));
        deviationRenderer.setSeriesFillPaint(0, (Paint)new Color(255, 200, 200));
        deviationRenderer.setSeriesOutlineStroke(0, (Stroke)new BasicStroke(2.0f));
        deviationRenderer.setSeriesShape(0, (Shape)new Ellipse2D.Double(-2.5, -2.5, 5.0, 5.0));
        deviationRenderer.setBaseToolTipGenerator((XYToolTipGenerator)new StandardXYToolTipGenerator("{0}: ({1}, {2})", DateFormat.getDateTimeInstance(), NumberFormat.getNumberInstance()));
        NumberAxis numberAxis = new NumberAxis("Threads");
        numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        numberAxis.setAutoRangeMinimumSize(10.0, false);
        numberAxis.setRangeType(RangeType.POSITIVE);
        XYPlot xYPlot = new XYPlot((XYDataset)yIntervalSeriesCollection, null, (ValueAxis)numberAxis, (XYItemRenderer)deviationRenderer);
        xYPlot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        xYPlot.setRangeAxisLocation(AxisLocation.TOP_OR_LEFT);
        xYPlot.setRangeCrosshairVisible(true);
        return xYPlot;
    }

    private void addUpperPlotData(List<ThreadInformationData> list) {
        for (ThreadInformationData threadInformationData : list) {
            float f = (float)threadInformationData.getTotalThreadCount() / (float)threadInformationData.getCount();
            float f2 = (float)threadInformationData.getTotalPeakThreadCount() / (float)threadInformationData.getCount();
            this.liveThreads.add(threadInformationData.getTimeStamp().getTime(), f, threadInformationData.getMinThreadCount(), threadInformationData.getMaxThreadCount(), false);
            this.peakThreads.add(threadInformationData.getTimeStamp().getTime(), f2, threadInformationData.getMinPeakThreadCount(), threadInformationData.getMaxPeakThreadCount(), false);
        }
        this.liveThreads.fireSeriesChanged();
        this.peakThreads.fireSeriesChanged();
    }

    private void setUpperPlotData(List<ThreadInformationData> list) {
        this.liveThreads.clear();
        this.peakThreads.clear();
        this.addUpperPlotData(list);
    }

    private XYPlot initializeLowerPlot() {
        this.daemonThreads = new YIntervalSeriesImproved((Comparable<?>)((Object)"daemon"));
        YIntervalSeriesCollection yIntervalSeriesCollection = new YIntervalSeriesCollection();
        yIntervalSeriesCollection.addSeries((YIntervalSeries)this.daemonThreads);
        DeviationRenderer deviationRenderer = new DeviationRenderer(true, false);
        deviationRenderer.setBaseShapesVisible(true);
        deviationRenderer.setSeriesStroke(0, (Stroke)new BasicStroke(3.0f));
        deviationRenderer.setSeriesOutlineStroke(0, (Stroke)new BasicStroke(2.0f));
        deviationRenderer.setSeriesShape(0, (Shape)new Ellipse2D.Double(-2.5, -2.5, 5.0, 5.0));
        deviationRenderer.setBaseToolTipGenerator((XYToolTipGenerator)new StandardXYToolTipGenerator("{0}: ({1}, {2})", DateFormat.getDateTimeInstance(), NumberFormat.getNumberInstance()));
        NumberAxis numberAxis = new NumberAxis("Daemon threads");
        numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        numberAxis.setAutoRangeMinimumSize(10.0, false);
        numberAxis.setRangeType(RangeType.POSITIVE);
        XYPlot xYPlot = new XYPlot((XYDataset)yIntervalSeriesCollection, null, (ValueAxis)numberAxis, (XYItemRenderer)deviationRenderer);
        xYPlot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        xYPlot.setRangeAxisLocation(AxisLocation.TOP_OR_LEFT);
        xYPlot.setRangeCrosshairVisible(true);
        return xYPlot;
    }

    private void addLowerPlotData(List<ThreadInformationData> list) {
        for (ThreadInformationData threadInformationData : list) {
            float f = (float)threadInformationData.getTotalDaemonThreadCount() / (float)threadInformationData.getCount();
            this.daemonThreads.add(threadInformationData.getTimeStamp().getTime(), f, threadInformationData.getMinDaemonThreadCount(), threadInformationData.getMaxDaemonThreadCount(), false);
        }
        this.daemonThreads.fireSeriesChanged();
    }

    private void setLowerPlotData(List<ThreadInformationData> list) {
        this.daemonThreads.clear();
        this.addLowerPlotData(list);
    }

    @Override
    public void update(Date date, Date date2) {
        Object object;
        Date date3 = new Date(0L);
        if (!this.oldData.isEmpty()) {
            date3 = this.oldData.get(this.oldData.size() - 1).getTimeStamp();
        }
        boolean bl = date.before(this.oldFromDate);
        boolean bl2 = date2.after(this.newestDate) || this.oldToDate.before(date2);
        List<Object> list = Collections.emptyList();
        if (this.oldData.isEmpty() || date2.before(this.oldFromDate) || date.after(date3)) {
            object = this.dataAccessService.getDataObjectsFromToDate((DefaultData)this.template, date, date2);
            if (!object.isEmpty()) {
                list = this.adjustSamplingRate(object, date, date2, this.aggregator);
                this.oldFromDate = (Date)date.clone();
                this.oldToDate = (Date)date2.clone();
                if (this.newestDate.before(((ThreadInformationData)object.get(object.size() - 1)).getTimeStamp())) {
                    this.newestDate = new Date(((ThreadInformationData)object.get(object.size() - 1)).getTimeStamp().getTime());
                }
            }
            this.oldData = object;
        } else if (bl && bl2) {
            object = new Date(this.newestDate.getTime() + 1L);
            Date date4 = new Date(this.oldFromDate.getTime() - 1L);
            List list2 = this.dataAccessService.getDataObjectsFromToDate((DefaultData)this.template, (Date)object, date2);
            List list3 = this.dataAccessService.getDataObjectsFromToDate((DefaultData)this.template, date, date4);
            if (!list3.isEmpty()) {
                this.oldData.addAll(0, list3);
                this.oldFromDate = (Date)date.clone();
            }
            if (!list2.isEmpty()) {
                this.oldData.addAll(list2);
                this.oldToDate = (Date)date2.clone();
                if (this.newestDate.before(((ThreadInformationData)list2.get(list2.size() - 1)).getTimeStamp())) {
                    this.newestDate = new Date(((ThreadInformationData)list2.get(list2.size() - 1)).getTimeStamp().getTime());
                }
            }
            list = this.adjustSamplingRate(this.oldData, date, date2, this.aggregator);
        } else if (bl2) {
            object = new Date(this.newestDate.getTime() + 1L);
            List list4 = this.dataAccessService.getDataObjectsFromToDate((DefaultData)this.template, (Date)object, date2);
            if (!list4.isEmpty()) {
                this.oldData.addAll(list4);
                this.oldToDate = (Date)date2.clone();
                if (this.newestDate.before(((ThreadInformationData)list4.get(list4.size() - 1)).getTimeStamp())) {
                    this.newestDate = new Date(((ThreadInformationData)list4.get(list4.size() - 1)).getTimeStamp().getTime());
                }
            }
            list = this.adjustSamplingRate(this.oldData, date, date2, this.aggregator);
        } else if (bl) {
            object = new Date(this.oldFromDate.getTime() - 1L);
            List list5 = this.dataAccessService.getDataObjectsFromToDate((DefaultData)this.template, date, (Date)object);
            if (!list5.isEmpty()) {
                this.oldData.addAll(list5);
                this.oldFromDate = (Date)date.clone();
            }
            list = this.adjustSamplingRate(this.oldData, date, date2, this.aggregator);
        } else {
            list = this.adjustSamplingRate(this.oldData, date, date2, this.aggregator);
        }
        object = list;
        Display.getDefault().asyncExec(new Runnable((List)object){
            private final /* synthetic */ List val$finalAdjustedThreadData;
            {
                this.val$finalAdjustedThreadData = list;
            }

            @Override
            public void run() {
                DefaultThreadsPlotController.this.setUpperPlotData(this.val$finalAdjustedThreadData);
                DefaultThreadsPlotController.this.setLowerPlotData(this.val$finalAdjustedThreadData);
            }
        });
    }

    @Override
    public Set<PreferenceId> getPreferenceIds() {
        EnumSet<PreferenceId> enumSet = EnumSet.noneOf(PreferenceId.class);
        if (this.getInputDefinition().getRepositoryDefinition() instanceof CmrRepositoryDefinition) {
            enumSet.add(PreferenceId.LIVEMODE);
        }
        enumSet.add(PreferenceId.TIMELINE);
        enumSet.add(PreferenceId.SAMPLINGRATE);
        enumSet.add(PreferenceId.UPDATE);
        return enumSet;
    }

    @Override
    public int getWeight(XYPlot xYPlot) {
        return this.weights.get(xYPlot);
    }

    @Override
    public void dispose() {
    }
}

