/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.editor.graph.plot;

import info.novatec.inspectit.communication.data.TimerData;
import info.novatec.inspectit.rcp.editor.graph.plot.AbstractPlotController;
import info.novatec.inspectit.rcp.editor.graph.plot.YIntervalSeriesImproved;
import info.novatec.inspectit.rcp.editor.preferences.PreferenceId;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.DeviationRenderer;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.RangeType;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYBarDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.YIntervalSeries;
import org.jfree.data.xy.YIntervalSeriesCollection;
import org.jfree.ui.RectangleInsets;

public abstract class AbstractTimerDataPlotController<E extends TimerData>
extends AbstractPlotController {
    private static final int[] SERIES_COLORS = new int[]{3, 9, 6, 8, 16, 2, 14, 10};
    private Map<XYPlot, Integer> weights = new HashMap<XYPlot, Integer>();
    private XYPlot durationPlot;
    private XYPlot countPlot;
    private List<YIntervalSeriesImproved> durationSeries;
    private List<TimeSeries> countSeries;

    protected abstract Comparable<?> getSeriesKey(E var1);

    protected abstract List<E> getTemplates();

    @Override
    public Set<PreferenceId> getPreferenceIds() {
        EnumSet<PreferenceId> enumSet = EnumSet.noneOf(PreferenceId.class);
        if (this.getInputDefinition().getRepositoryDefinition() instanceof CmrRepositoryDefinition) {
            enumSet.add(PreferenceId.LIVEMODE);
        }
        enumSet.add(PreferenceId.TIMELINE);
        enumSet.add(PreferenceId.SAMPLINGRATE);
        enumSet.add(PreferenceId.UPDATE);
        return enumSet;
    }

    @Override
    public List<XYPlot> getPlots() {
        this.durationPlot = this.initializeDurationPlot();
        this.countPlot = this.initializeCountPlot();
        this.weights.put(this.durationPlot, 2);
        this.weights.put(this.countPlot, 1);
        ArrayList<XYPlot> arrayList = new ArrayList<XYPlot>();
        Collections.addAll(arrayList, this.durationPlot, this.countPlot);
        return arrayList;
    }

    @Override
    public int getWeight(XYPlot xYPlot) {
        return this.weights.get(xYPlot);
    }

    protected void setDurationPlotData(Map<Object, List<E>> map) {
        for (YIntervalSeriesImproved yIntervalSeriesImproved : this.durationSeries) {
            yIntervalSeriesImproved.clear();
            for (Map.Entry<Object, List<E>> entry : map.entrySet()) {
                if (!yIntervalSeriesImproved.getKey().equals(entry.getKey())) continue;
                for (TimerData timerData : entry.getValue()) {
                    yIntervalSeriesImproved.add(timerData.getTimeStamp().getTime(), timerData.getAverage(), timerData.getMin(), timerData.getMax(), false);
                }
            }
            yIntervalSeriesImproved.fireSeriesChanged();
        }
    }

    protected void setCountPlotData(Map<Object, List<E>> map) {
        for (TimeSeries timeSeries : this.countSeries) {
            timeSeries.clear();
            timeSeries.setNotify(false);
            for (Map.Entry<Object, List<E>> entry : map.entrySet()) {
                if (!timeSeries.getKey().equals(entry.getKey())) continue;
                for (TimerData timerData : entry.getValue()) {
                    timeSeries.addOrUpdate((RegularTimePeriod)new Millisecond((Date)timerData.getTimeStamp()), (double)timerData.getCount());
                }
            }
            timeSeries.setNotify(true);
            timeSeries.fireSeriesChanged();
        }
    }

    private XYPlot initializeDurationPlot() {
        YIntervalSeriesImproved yIntervalSeriesImproved;
        TimerData timerData2;
        HashSet hashSet = new HashSet();
        this.durationSeries = new ArrayList<YIntervalSeriesImproved>();
        YIntervalSeriesCollection yIntervalSeriesCollection = new YIntervalSeriesCollection();
        for (TimerData timerData2 : this.getTemplates()) {
            Comparable<?> comparable = this.getSeriesKey(timerData2);
            if (!hashSet.add(comparable)) continue;
            yIntervalSeriesImproved = new YIntervalSeriesImproved(comparable);
            yIntervalSeriesCollection.addSeries((YIntervalSeries)yIntervalSeriesImproved);
            this.durationSeries.add(yIntervalSeriesImproved);
        }
        timerData2 = new DeviationRenderer(true, false);
        timerData2.setBaseToolTipGenerator((XYToolTipGenerator)new StandardXYToolTipGenerator("{0}: ({1}, {2})", DateFormat.getDateTimeInstance(), NumberFormat.getNumberInstance()));
        timerData2.setBaseShapesVisible(true);
        timerData2.setAlpha(0.1f);
        Display display = Display.getDefault();
        int n = 0;
        while (n < this.durationSeries.size()) {
            int n2 = SERIES_COLORS[n % SERIES_COLORS.length];
            RGB rGB = display.getSystemColor(n2).getRGB();
            timerData2.setSeriesStroke(n, (Stroke)new BasicStroke(3.0f, 1, 1));
            timerData2.setSeriesFillPaint(n, (Paint)new Color(rGB.red, rGB.green, rGB.blue));
            timerData2.setSeriesOutlineStroke(n, (Stroke)new BasicStroke(2.0f));
            timerData2.setSeriesShape(n, (Shape)new Ellipse2D.Double(-2.5, -2.5, 5.0, 5.0));
            ++n;
        }
        NumberAxis numberAxis = new NumberAxis("ms");
        numberAxis.setAutoRangeMinimumSize(100.0);
        numberAxis.setRangeType(RangeType.POSITIVE);
        numberAxis.setAutoRangeIncludesZero(true);
        yIntervalSeriesImproved = new XYPlot((XYDataset)yIntervalSeriesCollection, null, (ValueAxis)numberAxis, (XYItemRenderer)timerData2);
        yIntervalSeriesImproved.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        yIntervalSeriesImproved.setRangeAxisLocation(AxisLocation.TOP_OR_LEFT, false);
        yIntervalSeriesImproved.setRangeCrosshairVisible(true);
        return yIntervalSeriesImproved;
    }

    private XYPlot initializeCountPlot() {
        Display display;
        TimerData timerData2;
        HashSet<Display> hashSet = new HashSet<Display>();
        this.countSeries = new ArrayList<TimeSeries>();
        TimeSeriesCollection timeSeriesCollection = new TimeSeriesCollection();
        for (TimerData timerData2 : this.getTemplates()) {
            display = this.getSeriesKey(timerData2);
            if (!hashSet.add(display)) continue;
            TimeSeries timeSeries = new TimeSeries(display);
            this.countSeries.add(timeSeries);
            timeSeriesCollection.addSeries(timeSeries);
        }
        timerData2 = new XYBarDataset((XYDataset)timeSeriesCollection, 30.0);
        XYBarRenderer xYBarRenderer = new XYBarRenderer();
        xYBarRenderer.setBaseToolTipGenerator((XYToolTipGenerator)new StandardXYToolTipGenerator("{0}: ({1}, {2})", DateFormat.getDateTimeInstance(), NumberFormat.getNumberInstance()));
        xYBarRenderer.setShadowVisible(false);
        xYBarRenderer.setMargin(0.1);
        display = Display.getDefault();
        int n = 0;
        while (n < this.countSeries.size()) {
            int n2 = SERIES_COLORS[n % SERIES_COLORS.length];
            RGB rGB = display.getSystemColor(n2).getRGB();
            xYBarRenderer.setSeriesPaint(n, (Paint)new Color(rGB.red, rGB.green, rGB.blue));
            xYBarRenderer.setSeriesVisibleInLegend(n, Boolean.FALSE);
            ++n;
        }
        NumberAxis numberAxis = new NumberAxis("Count");
        numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        numberAxis.setAutoRange(true);
        numberAxis.setRangeType(RangeType.POSITIVE);
        XYPlot xYPlot = new XYPlot((XYDataset)timerData2, null, (ValueAxis)numberAxis, (XYItemRenderer)xYBarRenderer);
        xYPlot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        xYPlot.setRangeAxisLocation(AxisLocation.TOP_OR_LEFT);
        return xYPlot;
    }
}

