/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.details.generator.impl;

import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.communication.IAggregatedData;
import info.novatec.inspectit.communication.data.TimerData;
import info.novatec.inspectit.rcp.details.DetailsCellContent;
import info.novatec.inspectit.rcp.details.DetailsTable;
import info.novatec.inspectit.rcp.details.generator.IDetailsGenerator;
import info.novatec.inspectit.rcp.formatter.NumberFormatter;
import info.novatec.inspectit.rcp.repository.RepositoryDefinition;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class AggregatedDurationDetailsGenerator
implements IDetailsGenerator {
    @Override
    public boolean canGenerateFor(DefaultData defaultData) {
        return defaultData instanceof TimerData && defaultData instanceof IAggregatedData;
    }

    @Override
    public DetailsTable generate(DefaultData defaultData, RepositoryDefinition repositoryDefinition, Composite composite, FormToolkit formToolkit) {
        DetailsCellContent[] detailsCellContentArray;
        TimerData timerData = (TimerData)defaultData;
        DetailsTable detailsTable = new DetailsTable(composite, formToolkit, "Duration Info", 4);
        detailsTable.addContentRow("", null, new DetailsCellContent("Count"), new DetailsCellContent("Avg (ms)"), new DetailsCellContent("Min (ms)"), new DetailsCellContent("Max (ms)"));
        DetailsCellContent[] detailsCellContentArray2 = new DetailsCellContent[]{new DetailsCellContent(NumberFormatter.formatLong(timerData.getCount())), new DetailsCellContent(NumberFormatter.formatDouble(timerData.getAverage())), new DetailsCellContent(NumberFormatter.formatDouble(timerData.getMin())), new DetailsCellContent(NumberFormatter.formatDouble(timerData.getMax()))};
        detailsTable.addContentRow("Total:", null, detailsCellContentArray2);
        if (timerData.isCpuMetricDataAvailable()) {
            detailsCellContentArray = new DetailsCellContent[]{new DetailsCellContent(NumberFormatter.formatLong(timerData.getCount())), new DetailsCellContent(NumberFormatter.formatDouble(timerData.getCpuAverage())), new DetailsCellContent(NumberFormatter.formatDouble(timerData.getCpuMin())), new DetailsCellContent(NumberFormatter.formatDouble(timerData.getCpuMax()))};
            detailsTable.addContentRow("CPU:", null, detailsCellContentArray);
        }
        if (timerData.isExclusiveTimeDataAvailable()) {
            detailsCellContentArray = new DetailsCellContent[]{new DetailsCellContent(NumberFormatter.formatLong(timerData.getCount())), new DetailsCellContent(NumberFormatter.formatDouble(timerData.getExclusiveAverage())), new DetailsCellContent(NumberFormatter.formatDouble(timerData.getExclusiveMin())), new DetailsCellContent(NumberFormatter.formatDouble(timerData.getExclusiveMax()))};
            detailsTable.addContentRow("Exclusive:", null, detailsCellContentArray);
        }
        return detailsTable;
    }
}

