/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.composite;

import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.formatter.NumberFormatter;
import info.novatec.inspectit.storage.IStorageData;
import info.novatec.inspectit.storage.LocalStorageData;
import info.novatec.inspectit.storage.StorageData;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;

public class StorageInfoComposite
extends Composite {
    private static final String NOT_AVAILABLE = "N/A";
    private static final int MAX_DESCRIPTION_LENGTH = 100;
    private IStorageData storageData;
    private Label name;
    private FormText description;
    private Label size;
    private Label downloaded;
    private Label cmrVersion;
    private boolean showDataDownloaded;

    public StorageInfoComposite(Composite composite, int n, boolean bl) {
        super(composite, n);
        this.showDataDownloaded = bl;
        this.init();
    }

    public StorageInfoComposite(Composite composite, int n, boolean bl, IStorageData iStorageData) {
        this(composite, n, bl);
        this.displayStorageData(iStorageData);
    }

    private void init() {
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.setLayout((Layout)gridLayout);
        Group group = new Group((Composite)this, 0);
        group.setText("Storage Info");
        GridLayout gridLayout2 = new GridLayout(2, false);
        gridLayout2.marginHeight = 10;
        gridLayout2.marginWidth = 10;
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setLayout((Layout)gridLayout2);
        Label label = new Label((Composite)group, 0);
        label.setText("Name:");
        label.setLayoutData((Object)new GridData(4, 128, false, false));
        this.name = new Label((Composite)group, 64);
        this.name.setLayoutData((Object)new GridData(4, 128, true, false));
        label = new Label((Composite)group, 0);
        label.setText("Description:");
        label.setLayoutData((Object)new GridData(4, 128, false, false));
        this.description = new FormText((Composite)group, 524352);
        GridData gridData = new GridData(4, 128, true, false);
        gridData.widthHint = 400;
        this.description.setLayoutData((Object)gridData);
        this.description.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent hyperlinkEvent) {
                StorageInfoComposite.this.showStorageDescriptionBox();
            }
        });
        label = new Label((Composite)group, 0);
        label.setText("Size on disk:");
        label.setLayoutData((Object)new GridData(4, 128, false, false));
        this.size = new Label((Composite)group, 64);
        this.size.setLayoutData((Object)new GridData(4, 128, true, false));
        label = new Label((Composite)group, 0);
        label.setText("CMR version:");
        label.setLayoutData((Object)new GridData(4, 128, false, false));
        this.cmrVersion = new Label((Composite)group, 64);
        this.cmrVersion.setLayoutData((Object)new GridData(4, 128, true, false));
        if (this.showDataDownloaded) {
            label = new Label((Composite)group, 0);
            label.setText("Data downloaded:");
            label.setLayoutData((Object)new GridData(4, 128, false, false));
            this.downloaded = new Label((Composite)group, 64);
            this.downloaded.setLayoutData((Object)new GridData(4, 128, true, false));
        }
    }

    public final void displayStorageData(IStorageData iStorageData) {
        this.storageData = iStorageData;
        if (iStorageData != null) {
            this.name.setText(iStorageData.getName());
            if (iStorageData.getDescription() != null) {
                if (iStorageData.getDescription().length() > 100) {
                    this.description.setText("<form><p>" + iStorageData.getDescription().substring(0, 100) + ".. <a href=\"More\">[More]</a></p></form>", true, false);
                } else {
                    this.description.setText(iStorageData.getDescription(), false, false);
                }
            } else {
                this.description.setText("", false, false);
            }
            this.size.setText(NumberFormatter.humanReadableByteCount(iStorageData.getDiskSize()));
            if (StringUtils.isNotEmpty((String)iStorageData.getCmrVersion())) {
                this.cmrVersion.setText(iStorageData.getCmrVersion());
            }
            if (this.showDataDownloaded) {
                boolean bl;
                LocalStorageData localStorageData = null;
                if (iStorageData instanceof LocalStorageData) {
                    localStorageData = (LocalStorageData)iStorageData;
                } else if (iStorageData instanceof StorageData) {
                    localStorageData = InspectIT.getDefault().getInspectITStorageManager().getLocalDataForStorage((StorageData)iStorageData);
                }
                boolean bl2 = bl = localStorageData == null || !localStorageData.isFullyDownloaded();
                if (bl) {
                    this.downloaded.setText("No");
                } else {
                    this.downloaded.setText("Yes");
                }
            }
        } else {
            this.showDataUnavailable();
        }
        this.layout(true, true);
    }

    public final void showDataUnavailable() {
        this.name.setText(NOT_AVAILABLE);
        this.description.setText(NOT_AVAILABLE, false, false);
        this.size.setText(NOT_AVAILABLE);
        this.cmrVersion.setText(NOT_AVAILABLE);
        if (this.showDataDownloaded) {
            this.downloaded.setText(NOT_AVAILABLE);
        }
    }

    private void showStorageDescriptionBox() {
        int n = 67696;
        PopupDialog popupDialog = new PopupDialog(this.getShell(), n, true, false, false, false, false, "Storage description", "Storage description"){
            private static final int CURSOR_SIZE = 15;

            protected Control createDialogArea(Composite composite) {
                Composite composite2 = (Composite)super.createDialogArea(composite);
                Text text = new Text(composite, 842);
                GridData gridData = new GridData(1809);
                gridData.horizontalIndent = 3;
                gridData.verticalIndent = 3;
                text.setLayoutData((Object)gridData);
                text.setText(StorageInfoComposite.this.storageData.getDescription());
                return composite2;
            }

            protected Point getInitialLocation(Point point) {
                Display display = this.getShell().getDisplay();
                Point point2 = display.getCursorLocation();
                point2.x += 15;
                point2.y += 15;
                return point2;
            }

            protected Point getInitialSize() {
                return new Point(400, 200);
            }
        };
        popupDialog.open();
    }
}

