/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.rcp.ci.job;

import info.novatec.inspectit.ci.Environment;
import info.novatec.inspectit.exception.BusinessException;
import info.novatec.inspectit.rcp.InspectIT;
import info.novatec.inspectit.rcp.ci.form.input.EnvironmentEditorInput;
import info.novatec.inspectit.rcp.repository.CmrRepositoryDefinition;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;

public class OpenEnvironmentJob
extends Job {
    private CmrRepositoryDefinition cmrRepositoryDefinition;
    private String environmentId;
    private IWorkbenchPage page;

    public OpenEnvironmentJob(CmrRepositoryDefinition cmrRepositoryDefinition, String string, IWorkbenchPage iWorkbenchPage) {
        super("Loading environment..");
        this.cmrRepositoryDefinition = cmrRepositoryDefinition;
        this.environmentId = string;
        this.page = iWorkbenchPage;
        this.setUser(true);
    }

    protected IStatus run(IProgressMonitor iProgressMonitor) {
        if (this.cmrRepositoryDefinition.getOnlineStatus() == CmrRepositoryDefinition.OnlineStatus.OFFLINE) {
            return Status.CANCEL_STATUS;
        }
        try {
            Environment environment = this.cmrRepositoryDefinition.getConfigurationInterfaceService().getEnvironment(this.environmentId);
            List list = this.cmrRepositoryDefinition.getConfigurationInterfaceService().getAllProfiles();
            final EnvironmentEditorInput environmentEditorInput = new EnvironmentEditorInput(environment, list, this.cmrRepositoryDefinition);
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        OpenEnvironmentJob.this.page.openEditor((IEditorInput)environmentEditorInput, "info.novatec.inspectit.rcp.ci.editor.environmentEditor", true);
                    }
                    catch (PartInitException partInitException) {
                        InspectIT.getDefault().createErrorDialog("Exception occurred opening the Environment editor.", partInitException, -1);
                    }
                }
            });
            return Status.OK_STATUS;
        }
        catch (BusinessException businessException) {
            return new Status(4, "info.novatec.inspectit.rcp", "Exception occurred loading the environment from the CMR.", (Throwable)businessException);
        }
    }
}

